-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.7.29-log


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


--
-- Create schema dbschl
--

CREATE DATABASE IF NOT EXISTS dbschl;
USE dbschl;

--
-- Definition of table `accyear`
--

DROP TABLE IF EXISTS `accyear`;
CREATE TABLE `accyear` (
  `yrs` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`yrs`)
) ENGINE=InnoDB AUTO_INCREMENT=2024 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `accyear`
--

/*!40000 ALTER TABLE `accyear` DISABLE KEYS */;
INSERT INTO `accyear` (`yrs`) VALUES 
 (2022),
 (2023);
/*!40000 ALTER TABLE `accyear` ENABLE KEYS */;


--
-- Definition of table `asset`
--

DROP TABLE IF EXISTS `asset`;
CREATE TABLE `asset` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` varchar(45) NOT NULL,
  `Descr` varchar(45) NOT NULL,
  `DrAmount` double DEFAULT NULL,
  `CrAmount` double DEFAULT NULL,
  `TK` varchar(10) DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `asset`
--

/*!40000 ALTER TABLE `asset` DISABLE KEYS */;
/*!40000 ALTER TABLE `asset` ENABLE KEYS */;


--
-- Definition of table `assetclass`
--

DROP TABLE IF EXISTS `assetclass`;
CREATE TABLE `assetclass` (
  `ASCID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Descr` text NOT NULL,
  `category` varchar(45) NOT NULL,
  PRIMARY KEY (`ASCID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `assetclass`
--

/*!40000 ALTER TABLE `assetclass` DISABLE KEYS */;
/*!40000 ALTER TABLE `assetclass` ENABLE KEYS */;


--
-- Definition of table `assetevaluation`
--

DROP TABLE IF EXISTS `assetevaluation`;
CREATE TABLE `assetevaluation` (
  `TrDate` date DEFAULT NULL,
  `DRAmount` double DEFAULT '0',
  `description` varchar(45) DEFAULT NULL,
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `AsId` int(10) unsigned DEFAULT NULL,
  `CRAmount` double DEFAULT NULL,
  `TK` varchar(25) DEFAULT NULL,
  `TKNO` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `assetevaluation`
--

/*!40000 ALTER TABLE `assetevaluation` DISABLE KEYS */;
/*!40000 ALTER TABLE `assetevaluation` ENABLE KEYS */;


--
-- Definition of table `assetint`
--

DROP TABLE IF EXISTS `assetint`;
CREATE TABLE `assetint` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` varchar(45) NOT NULL,
  `Descr` varchar(45) NOT NULL,
  `DrAmount` double DEFAULT NULL,
  `CrAmount` double DEFAULT NULL,
  `TK` varchar(10) DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `assetint`
--

/*!40000 ALTER TABLE `assetint` DISABLE KEYS */;
/*!40000 ALTER TABLE `assetint` ENABLE KEYS */;


--
-- Definition of table `assettrans`
--

DROP TABLE IF EXISTS `assettrans`;
CREATE TABLE `assettrans` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` varchar(45) NOT NULL,
  `Description` varchar(45) NOT NULL,
  `DrAmount` double DEFAULT NULL,
  `CrAmount` double DEFAULT NULL,
  `TK` varchar(10) DEFAULT NULL,
  `TKNO` int(10) unsigned DEFAULT NULL,
  `AsId` int(10) unsigned DEFAULT NULL,
  `TRANSNO` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `assettrans`
--

/*!40000 ALTER TABLE `assettrans` DISABLE KEYS */;
/*!40000 ALTER TABLE `assettrans` ENABLE KEYS */;


--
-- Definition of table `bank`
--

DROP TABLE IF EXISTS `bank`;
CREATE TABLE `bank` (
  `code` char(15) NOT NULL DEFAULT '0',
  `descr` char(30) NOT NULL DEFAULT '0',
  `created_by` char(30) DEFAULT NULL,
  `last_updated_by` char(30) DEFAULT NULL,
  `bid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`bid`),
  UNIQUE KEY `Index_code` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `bank`
--

/*!40000 ALTER TABLE `bank` DISABLE KEYS */;
INSERT INTO `bank` (`code`,`descr`,`created_by`,`last_updated_by`,`bid`) VALUES 
 ('789','KCB',NULL,NULL,9),
 ('002','Equity',NULL,NULL,10),
 ('003','Jamii Bora',NULL,NULL,11),
 ('004','Coop Bank',NULL,NULL,12),
 ('006','POST BANK',NULL,NULL,13);
/*!40000 ALTER TABLE `bank` ENABLE KEYS */;


--
-- Definition of table `board`
--

DROP TABLE IF EXISTS `board`;
CREATE TABLE `board` (
  `br_id` int(11) NOT NULL AUTO_INCREMENT,
  `nea` varchar(300) NOT NULL,
  `br_no` varchar(300) NOT NULL,
  `m_no` varchar(300) NOT NULL,
  `pitsa` varchar(300) NOT NULL,
  `imp_dept` varchar(300) NOT NULL,
  `content` varchar(300) NOT NULL,
  `venue` varchar(300) NOT NULL,
  `category` varchar(300) NOT NULL,
  PRIMARY KEY (`br_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `board`
--

/*!40000 ALTER TABLE `board` DISABLE KEYS */;
/*!40000 ALTER TABLE `board` ENABLE KEYS */;


--
-- Definition of table `bookbill`
--

DROP TABLE IF EXISTS `bookbill`;
CREATE TABLE `bookbill` (
  `membId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Amount` double NOT NULL,
  `PayDate` datetime DEFAULT NULL,
  `PayType` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`membId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `bookbill`
--

/*!40000 ALTER TABLE `bookbill` DISABLE KEYS */;
/*!40000 ALTER TABLE `bookbill` ENABLE KEYS */;


--
-- Definition of table `bookissue`
--

DROP TABLE IF EXISTS `bookissue`;
CREATE TABLE `bookissue` (
  `BkId` int(10) unsigned DEFAULT NULL,
  `MembId` varchar(45) DEFAULT NULL,
  `IssDate` datetime DEFAULT NULL,
  `RetDate` datetime DEFAULT NULL,
  `ExpDate` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `bookissue`
--

/*!40000 ALTER TABLE `bookissue` DISABLE KEYS */;
/*!40000 ALTER TABLE `bookissue` ENABLE KEYS */;


--
-- Definition of table `books`
--

DROP TABLE IF EXISTS `books`;
CREATE TABLE `books` (
  `BkId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Book` varchar(80) DEFAULT NULL,
  `Author` varchar(80) DEFAULT NULL,
  `Publisher` varchar(45) DEFAULT NULL,
  `Price` double DEFAULT NULL,
  `Edition` varchar(45) DEFAULT NULL,
  `Subject` varchar(45) DEFAULT NULL,
  `Branch` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`BkId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `books`
--

/*!40000 ALTER TABLE `books` DISABLE KEYS */;
/*!40000 ALTER TABLE `books` ENABLE KEYS */;


--
-- Definition of table `branch`
--

DROP TABLE IF EXISTS `branch`;
CREATE TABLE `branch` (
  `code` char(15) NOT NULL DEFAULT '0',
  `descr` char(30) NOT NULL DEFAULT '0',
  `created_by` char(30) DEFAULT NULL,
  `last_updated_by` char(30) DEFAULT NULL,
  `brid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Bid` int(10) unsigned NOT NULL,
  PRIMARY KEY (`brid`),
  KEY `FK_branch_Bid` (`Bid`),
  CONSTRAINT `FK_branch_Bid` FOREIGN KEY (`Bid`) REFERENCES `bank` (`bid`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `branch`
--

/*!40000 ALTER TABLE `branch` DISABLE KEYS */;
INSERT INTO `branch` (`code`,`descr`,`created_by`,`last_updated_by`,`brid`,`Bid`) VALUES 
 ('6433','Masii',NULL,NULL,11,9),
 ('002','Machakos',NULL,NULL,12,9),
 ('001','Machakos',NULL,NULL,13,12),
 ('003','Machakos',NULL,NULL,14,10),
 ('001','Machakos',NULL,NULL,15,11),
 ('003','Machakos',NULL,NULL,16,13);
/*!40000 ALTER TABLE `branch` ENABLE KEYS */;


--
-- Definition of table `capital`
--

DROP TABLE IF EXISTS `capital`;
CREATE TABLE `capital` (
  `inv` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` datetime DEFAULT NULL,
  `Descr` varchar(45) DEFAULT NULL,
  `DRAmount` double DEFAULT NULL,
  `CRAmount` double DEFAULT NULL,
  `TK` varchar(10) DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`inv`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `capital`
--

/*!40000 ALTER TABLE `capital` DISABLE KEYS */;
/*!40000 ALTER TABLE `capital` ENABLE KEYS */;


--
-- Definition of table `capitalacc`
--

DROP TABLE IF EXISTS `capitalacc`;
CREATE TABLE `capitalacc` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` varchar(45) NOT NULL,
  `Description` varchar(45) NOT NULL,
  `DrAmount` double DEFAULT NULL,
  `CrAmount` double DEFAULT NULL,
  `TK` varchar(10) DEFAULT NULL,
  `TKNO` int(10) unsigned DEFAULT NULL,
  `TransNo` varchar(45) DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `capitalacc`
--

/*!40000 ALTER TABLE `capitalacc` DISABLE KEYS */;
/*!40000 ALTER TABLE `capitalacc` ENABLE KEYS */;


--
-- Definition of table `cash`
--

DROP TABLE IF EXISTS `cash`;
CREATE TABLE `cash` (
  `inv` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` datetime DEFAULT NULL,
  `Descr` varchar(45) DEFAULT NULL,
  `DRAmount` double DEFAULT NULL,
  `CRAmount` double DEFAULT NULL,
  `TK` varchar(10) DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`inv`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `cash`
--

/*!40000 ALTER TABLE `cash` DISABLE KEYS */;
/*!40000 ALTER TABLE `cash` ENABLE KEYS */;


--
-- Definition of table `cashacct`
--

DROP TABLE IF EXISTS `cashacct`;
CREATE TABLE `cashacct` (
  `AcctNbr` char(30) CHARACTER SET utf8 NOT NULL,
  `Cash` varchar(10) DEFAULT NULL,
  `BankAcct` char(10) CHARACTER SET utf8 DEFAULT NULL,
  `Bank` char(10) CHARACTER SET utf8 DEFAULT NULL,
  `Branch` char(24) CHARACTER SET utf8 DEFAULT NULL,
  `Descr` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Balance` double NOT NULL DEFAULT '0',
  `AccId` int(11) NOT NULL AUTO_INCREMENT,
  `AsOn` datetime NOT NULL,
  `AccName` varchar(45) DEFAULT NULL,
  `code` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`AccId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `cashacct`
--

/*!40000 ALTER TABLE `cashacct` DISABLE KEYS */;
/*!40000 ALTER TABLE `cashacct` ENABLE KEYS */;


--
-- Definition of table `cashtrans`
--

DROP TABLE IF EXISTS `cashtrans`;
CREATE TABLE `cashtrans` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` varchar(45) NOT NULL,
  `Description` varchar(45) NOT NULL,
  `DrAmount` double DEFAULT NULL,
  `CrAmount` double DEFAULT NULL,
  `TK` varchar(10) DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  `AccId` int(10) unsigned DEFAULT NULL,
  `TransNo` varchar(45) DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  `Yr` int(10) unsigned NOT NULL DEFAULT '0',
  `Qtr` int(10) unsigned NOT NULL DEFAULT '0',
  `TR` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `cashtrans`
--

/*!40000 ALTER TABLE `cashtrans` DISABLE KEYS */;
/*!40000 ALTER TABLE `cashtrans` ENABLE KEYS */;


--
-- Definition of table `classes`
--

DROP TABLE IF EXISTS `classes`;
CREATE TABLE `classes` (
  `CLID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Class` varchar(45) NOT NULL,
  PRIMARY KEY (`CLID`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `classes`
--

/*!40000 ALTER TABLE `classes` DISABLE KEYS */;
INSERT INTO `classes` (`CLID`,`Class`) VALUES 
 (1,'PP 1'),
 (2,'PP 2'),
 (3,'GRADE 1'),
 (4,'GRADE 2');
/*!40000 ALTER TABLE `classes` ENABLE KEYS */;


--
-- Definition of table `clasubject`
--

DROP TABLE IF EXISTS `clasubject`;
CREATE TABLE `clasubject` (
  `CSID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `SUBID` int(10) unsigned DEFAULT NULL,
  `CLID` int(10) unsigned DEFAULT NULL,
  `CoreSubj` varchar(45) DEFAULT 'True',
  `selct` varchar(45) DEFAULT 'False',
  `LSNS` int(10) unsigned NOT NULL DEFAULT '0',
  `EQU` int(10) unsigned NOT NULL DEFAULT '0',
  `DBL` int(10) unsigned NOT NULL DEFAULT '0',
  `Mand` varchar(5) NOT NULL DEFAULT 'T',
  PRIMARY KEY (`CSID`),
  KEY `FK_clasubject_SUBID` (`SUBID`),
  KEY `FK_clasubject_CLID` (`CLID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `clasubject`
--

/*!40000 ALTER TABLE `clasubject` DISABLE KEYS */;
/*!40000 ALTER TABLE `clasubject` ENABLE KEYS */;


--
-- Definition of table `clstream`
--

DROP TABLE IF EXISTS `clstream`;
CREATE TABLE `clstream` (
  `cl` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `strid` int(10) unsigned NOT NULL,
  `clid` varchar(45) NOT NULL,
  PRIMARY KEY (`cl`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `clstream`
--

/*!40000 ALTER TABLE `clstream` DISABLE KEYS */;
INSERT INTO `clstream` (`cl`,`strid`,`clid`) VALUES 
 (4,3,'2'),
 (5,3,'3'),
 (6,4,'4'),
 (18,3,'1'),
 (22,4,'1'),
 (23,4,'2'),
 (26,4,'3'),
 (29,3,'4'),
 (30,5,'1'),
 (31,5,'2'),
 (32,5,'3'),
 (33,5,'4');
/*!40000 ALTER TABLE `clstream` ENABLE KEYS */;


--
-- Definition of table `clsubgrade`
--

DROP TABLE IF EXISTS `clsubgrade`;
CREATE TABLE `clsubgrade` (
  `GID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `CSID` int(10) unsigned DEFAULT NULL,
  `GFrom` double DEFAULT NULL,
  `GTo` double DEFAULT NULL,
  `G` varchar(5) DEFAULT NULL,
  `Remarks` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`GID`),
  KEY `clsubgrade_CSID` (`CSID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `clsubgrade`
--

/*!40000 ALTER TABLE `clsubgrade` DISABLE KEYS */;
/*!40000 ALTER TABLE `clsubgrade` ENABLE KEYS */;


--
-- Definition of table `companybranch`
--

DROP TABLE IF EXISTS `companybranch`;
CREATE TABLE `companybranch` (
  `COID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `POBOX` varchar(45) NOT NULL,
  `CITY` varchar(45) NOT NULL,
  `PHYSICALADD` text NOT NULL,
  `LOGO` longblob,
  `PIN` varchar(45) DEFAULT NULL,
  `NSSF` varchar(45) DEFAULT NULL,
  `NHIF` varchar(45) DEFAULT NULL,
  `LASK` varchar(45) DEFAULT NULL,
  `PENSIONREG` varchar(45) NOT NULL DEFAULT 'True',
  `PRSIGN` longblob,
  `EMAIL` varchar(45) DEFAULT NULL,
  `WEB` varchar(45) DEFAULT NULL,
  `PHONE1` varchar(45) DEFAULT NULL,
  `PHONE2` varchar(45) DEFAULT NULL,
  `COMPANYNAME` varchar(135) DEFAULT NULL,
  `VAT` varchar(45) DEFAULT NULL,
  `HELB` varchar(45) DEFAULT NULL,
  `PENSIONNO` varchar(45) DEFAULT NULL,
  `Reportinf` text,
  `regno` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`COID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `companybranch`
--

/*!40000 ALTER TABLE `companybranch` DISABLE KEYS */;
INSERT INTO `companybranch` (`COID`,`POBOX`,`CITY`,`PHYSICALADD`,`LOGO`,`PIN`,`NSSF`,`NHIF`,`LASK`,`PENSIONREG`,`PRSIGN`,`EMAIL`,`WEB`,`PHONE1`,`PHONE2`,`COMPANYNAME`,`VAT`,`HELB`,`PENSIONNO`,`Reportinf`,`regno`) VALUES 
 (2,'','','',NULL,'','','','','',NULL,'','','','','Company 1','','','','png',''),
 (3,'','','',NULL,'','','','','',NULL,'','','','','Company 2','','','',NULL,'');
/*!40000 ALTER TABLE `companybranch` ENABLE KEYS */;


--
-- Definition of table `companyinfo`
--

DROP TABLE IF EXISTS `companyinfo`;
CREATE TABLE `companyinfo` (
  `COID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `POBOX` varchar(45) NOT NULL,
  `CITY` varchar(45) NOT NULL,
  `PHYSICALADD` text NOT NULL,
  `LOGO` longblob,
  `PIN` varchar(45) DEFAULT NULL,
  `NSSF` varchar(45) DEFAULT NULL,
  `NHIF` varchar(45) DEFAULT NULL,
  `LASK` varchar(45) DEFAULT NULL,
  `PENSIONREG` varchar(45) NOT NULL DEFAULT 'True',
  `PRSIGN` longblob,
  `EMAIL` varchar(45) DEFAULT NULL,
  `WEB` varchar(45) DEFAULT NULL,
  `PHONE1` varchar(45) DEFAULT NULL,
  `PHONE2` varchar(45) DEFAULT NULL,
  `COMPANYNAME` varchar(135) DEFAULT NULL,
  `VAT` varchar(45) DEFAULT NULL,
  `HELB` varchar(45) DEFAULT NULL,
  `PENSIONNO` varchar(45) DEFAULT NULL,
  `Reportinf` text,
  `regno` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`COID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `companyinfo`
--

/*!40000 ALTER TABLE `companyinfo` DISABLE KEYS */;
INSERT INTO `companyinfo` (`COID`,`POBOX`,`CITY`,`PHYSICALADD`,`LOGO`,`PIN`,`NSSF`,`NHIF`,`LASK`,`PENSIONREG`,`PRSIGN`,`EMAIL`,`WEB`,`PHONE1`,`PHONE2`,`COMPANYNAME`,`VAT`,`HELB`,`PENSIONNO`,`Reportinf`,`regno`) VALUES 
 (1,'1000','KCPE','P.O. BOX.  KISII',0x424D36030000000000003600000028000000100000001000000001001800000000000003000000000000000000000000000000000000FFFFFFFFFFFFFCFBFBFFFCFFFFFFFFFFFEFFF7FDF9E0FCEADFFCEAF4FDF8FFFEFFFFFEFFFFFEFFFEFBFBFEFEFEFBFBFBFFFFFFFBFBFCFFFFFFF7FEF8B8FBC979F69883F4A19DF8B6A2FBBA8CF9AA82F7A0C0FACEF9FEFAFFFBFFFFFFFFFCFEFEFEFCFDFFFEFFE5FCED8AF0A565E57D71E2847DE98F8FF39F95F5A589EE9A7CE88E6FE98A92F1AFE9FCF0FFFDFFFDFCFEFFFEFFF8FDFC83EB9F42D25953D26166DE7877E88A82EC9485EC987FEB9170E1815BD76E4ED9658DEDA6F8FFFCFFFCFFFFFFFFB7F6C82AC94338C64851D36260DA726ADF7C70E28471E4866FE27F68DC795AD76C44CB5232CE4CBFF6D0FFFFFFFFFFFF3FDC5E12B22138C84746CE5751D26459D76C5FDA7261DB745DD97056D5684DD26041CB501EBD2F42CE60FFFFFFFFFFFF00B5021AB42730C24038C74942CC5348D05B4DD25F50D3614BD25E45CE573DCB4F36C54526BC3400A800FFFFFFFFFFFF009C0013B42322BA322BBF3B33C34239C8493DCA4C3DC94E3BC94B35C5462DC13C26BD351CB62C00A200FFFFFFFFFFFF00900005AF1412B4211BB82B22BA3328BE382DC03B31C04034C24332C14028BC3515B62309AF1A009100FFFFFFFFFFFF00870000A60505AD120BB01A11B32219B62921BB302CBD3A33BF403AC1463ABF4528BB3605AA0E009200FFFFFFFFFFFF2BB73D008B0000A60501A70B06AC1512B1231FB82D2ABB3733BC3E3ABE4540C04C49C2551BB01F48CA5DFFFFFFFFFFFFB5EEC3008C0000970000A40603A81111AE1E1EB32929B73433BA3D3ABB4441BD4D46BC4D3DBE4ACFF5D8FFFFFFFFFDFFFBFFFD6DD179009700009F000EAB1C1CB02726B43131B83B3BBA4345C04E47C14F4BC356A1E5ACFEFEFEFFFFFFFDFCFDFFFFFFF3FCF67CD78B00A40E009E0010A71714A91F20AD2C37B53E3CB3414BBE58A4E7B3F6FEF9FFFFFFFFFFFFFFFFFFFBFBFBFFFFFFFDFFFEC7F0D263D77B4FD66181E6868BE89067DF7B7EDD95D1F0DDFDFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFCFBFBFFFDFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFBFBFEFBFBFBFFFFFF,'',' ',' ','','True',0x424DAE4B00000000000036000000280000005B000000460000000100180000000000784B000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFF000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000FFFFFF000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000FFFFFF000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000FFFFFF000000FFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFF000000FFFFFF000000000000FFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000FFFFFF000000000000FFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFF000000FFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFF000000000000000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFF000000FFFFFF000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFF000000FFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000FFFFFFFFFFFF000000FFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000FFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000FFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000,'paseschool@gmail.com',' ',' ','','PACE PRIMARY SCHOOL','','','',' ','');
/*!40000 ALTER TABLE `companyinfo` ENABLE KEYS */;


--
-- Definition of table `consumeditems`
--

DROP TABLE IF EXISTS `consumeditems`;
CREATE TABLE `consumeditems` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` datetime DEFAULT NULL,
  `Descr` varchar(45) DEFAULT NULL,
  `DrAmount` double DEFAULT NULL,
  `CrAmount` double DEFAULT NULL,
  `TK` varchar(10) DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `consumeditems`
--

/*!40000 ALTER TABLE `consumeditems` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumeditems` ENABLE KEYS */;


--
-- Definition of table `curclass`
--

DROP TABLE IF EXISTS `curclass`;
CREATE TABLE `curclass` (
  `STCID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `STNO` int(10) unsigned DEFAULT NULL,
  `cl` int(10) unsigned DEFAULT NULL,
  `yrs` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`STCID`),
  KEY `FK_studentclass_STNO` (`STNO`),
  KEY `FK_studentclass_CID` (`cl`) USING BTREE,
  KEY `FK_studentclass_YRS` (`yrs`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `curclass`
--

/*!40000 ALTER TABLE `curclass` DISABLE KEYS */;
/*!40000 ALTER TABLE `curclass` ENABLE KEYS */;


--
-- Definition of table `curclassold`
--

DROP TABLE IF EXISTS `curclassold`;
CREATE TABLE `curclassold` (
  `STCID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `STNO` int(10) unsigned DEFAULT NULL,
  `cl` int(10) unsigned DEFAULT NULL,
  `yrs` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`STCID`)
) ENGINE=InnoDB AUTO_INCREMENT=5278 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `curclassold`
--

/*!40000 ALTER TABLE `curclassold` DISABLE KEYS */;
INSERT INTO `curclassold` (`STCID`,`STNO`,`cl`,`yrs`) VALUES 
 (777,1,30,2018),
 (778,2,30,2018),
 (779,3,30,2018),
 (780,4,30,2018),
 (781,5,30,2018),
 (782,6,30,2018),
 (783,7,30,2018),
 (784,8,30,2018),
 (785,9,30,2018),
 (786,10,30,2018),
 (787,11,30,2018),
 (788,12,30,2018),
 (790,14,30,2018),
 (791,15,30,2018),
 (792,16,30,2018),
 (793,17,30,2018),
 (794,18,30,2018),
 (795,19,30,2018),
 (796,20,30,2018),
 (797,21,30,2018),
 (798,22,30,2018),
 (799,23,30,2018),
 (800,24,30,2018),
 (801,25,30,2018),
 (802,26,30,2018),
 (803,27,30,2018),
 (804,28,30,2018),
 (805,29,30,2018),
 (806,30,30,2018),
 (807,31,30,2018),
 (808,32,30,2018),
 (809,33,30,2018),
 (810,34,30,2018),
 (811,35,30,2018),
 (812,36,30,2018),
 (813,37,30,2018),
 (814,38,30,2018),
 (815,39,30,2018),
 (816,40,30,2018),
 (817,41,30,2018),
 (818,42,30,2018),
 (819,43,30,2018),
 (820,44,30,2018),
 (821,45,30,2018),
 (822,46,30,2018),
 (823,47,30,2018),
 (824,48,30,2018),
 (825,49,30,2018),
 (826,50,30,2018),
 (827,51,30,2018),
 (828,52,30,2018),
 (829,53,30,2018),
 (830,54,30,2018),
 (831,55,30,2018),
 (832,56,30,2018),
 (833,57,30,2018),
 (834,58,30,2018),
 (835,59,30,2018),
 (836,60,30,2018),
 (837,61,30,2018),
 (838,62,30,2018),
 (839,63,30,2018),
 (840,64,30,2018),
 (841,65,30,2018),
 (842,66,30,2018),
 (843,67,30,2018),
 (844,68,30,2018),
 (845,69,30,2018),
 (846,70,30,2018),
 (847,71,30,2018),
 (848,72,30,2018),
 (849,73,30,2018),
 (850,74,30,2018),
 (851,75,30,2018),
 (852,76,30,2018),
 (853,77,30,2018),
 (854,78,30,2018),
 (855,79,30,2018),
 (856,80,30,2018),
 (857,81,30,2018),
 (858,82,30,2018),
 (859,83,30,2018),
 (860,84,30,2018),
 (861,85,30,2018),
 (862,86,30,2018),
 (863,87,30,2018),
 (864,88,30,2018),
 (865,89,30,2018),
 (866,90,30,2018),
 (867,91,30,2018),
 (868,92,30,2018),
 (869,93,30,2018),
 (870,94,18,2018),
 (871,95,18,2018),
 (872,96,18,2018),
 (873,97,18,2018),
 (874,98,18,2018),
 (875,99,18,2018),
 (876,100,18,2018),
 (877,101,18,2018),
 (878,102,18,2018),
 (879,103,18,2018),
 (880,104,18,2018),
 (881,105,18,2018),
 (882,106,18,2018),
 (883,107,18,2018),
 (886,110,18,2018),
 (887,111,18,2018),
 (888,112,18,2018),
 (889,113,18,2018),
 (890,114,18,2018),
 (891,115,18,2018),
 (892,116,18,2018),
 (894,118,18,2018),
 (896,120,18,2018),
 (897,121,18,2018),
 (899,123,18,2018),
 (901,125,18,2018),
 (902,126,18,2018),
 (903,127,18,2018),
 (904,128,18,2018),
 (905,129,18,2018),
 (906,130,18,2018),
 (907,131,18,2018),
 (908,132,18,2018),
 (909,133,18,2018),
 (910,134,18,2018),
 (911,135,18,2018),
 (912,136,18,2018),
 (913,137,18,2018),
 (914,138,18,2018),
 (915,139,18,2018),
 (916,140,18,2018),
 (917,141,18,2018),
 (918,142,18,2018),
 (919,143,18,2018),
 (920,144,18,2018),
 (921,145,18,2018),
 (922,146,18,2018),
 (923,147,18,2018),
 (925,149,18,2018),
 (926,150,18,2018),
 (927,151,18,2018),
 (930,154,18,2018),
 (931,155,18,2018),
 (932,156,18,2018),
 (933,157,18,2018),
 (934,158,18,2018),
 (935,159,18,2018),
 (936,160,18,2018),
 (937,161,18,2018),
 (939,163,18,2018),
 (940,164,18,2018),
 (941,165,18,2018),
 (942,166,18,2018),
 (943,167,18,2018),
 (944,168,18,2018),
 (945,169,18,2018),
 (946,170,18,2018),
 (947,171,18,2018),
 (948,172,18,2018),
 (949,173,18,2018),
 (950,174,18,2018),
 (951,175,18,2018),
 (952,176,18,2018),
 (953,177,18,2018),
 (954,178,18,2018),
 (955,179,18,2018),
 (956,180,18,2018),
 (957,181,18,2018),
 (958,182,18,2018),
 (959,183,18,2018),
 (960,184,18,2018),
 (961,185,18,2018),
 (963,187,22,2018),
 (964,188,22,2018),
 (965,189,22,2018),
 (966,190,22,2018),
 (967,191,22,2018),
 (968,192,22,2018),
 (971,195,22,2018),
 (972,196,22,2018),
 (973,197,22,2018),
 (974,198,22,2018),
 (975,199,22,2018),
 (976,200,22,2018),
 (977,201,22,2018),
 (978,202,22,2018),
 (979,203,22,2018),
 (980,204,22,2018),
 (981,205,22,2018),
 (982,206,22,2018),
 (983,207,22,2018),
 (984,208,22,2018),
 (985,209,22,2018),
 (986,210,22,2018),
 (987,211,22,2018),
 (988,212,22,2018),
 (989,213,22,2018),
 (990,214,22,2018),
 (991,215,22,2018),
 (992,216,22,2018),
 (993,217,22,2018),
 (994,218,22,2018),
 (995,219,22,2018),
 (996,220,22,2018),
 (997,221,22,2018),
 (998,222,22,2018),
 (999,223,22,2018),
 (1000,224,22,2018),
 (1001,225,22,2018),
 (1002,226,22,2018),
 (1003,227,22,2018),
 (1004,228,22,2018),
 (1005,229,22,2018),
 (1006,230,22,2018),
 (1007,231,22,2018),
 (1008,232,22,2018),
 (1009,233,22,2018),
 (1010,234,22,2018),
 (1012,236,22,2018),
 (1013,237,22,2018),
 (1014,238,22,2018),
 (1015,239,22,2018),
 (1016,240,22,2018),
 (1017,241,22,2018),
 (1018,242,22,2018),
 (1019,243,22,2018),
 (1020,244,22,2018),
 (1021,245,22,2018),
 (1022,246,22,2018),
 (1023,247,22,2018),
 (1024,248,22,2018),
 (1025,249,22,2018),
 (1026,250,22,2018),
 (1027,251,22,2018),
 (1028,252,22,2018),
 (1029,253,22,2018),
 (1030,254,22,2018),
 (1031,255,22,2018),
 (1032,256,22,2018),
 (1033,257,22,2018),
 (1034,258,22,2018),
 (1035,259,22,2018),
 (1036,260,22,2018),
 (1037,261,22,2018),
 (1038,262,22,2018),
 (1039,263,22,2018),
 (1040,264,22,2018),
 (1041,265,22,2018),
 (1042,266,22,2018),
 (1043,267,22,2018),
 (1044,268,22,2018),
 (1045,269,22,2018),
 (1046,270,22,2018),
 (1047,271,22,2018),
 (1048,272,22,2018),
 (1049,273,22,2018),
 (1050,274,22,2018),
 (1051,275,22,2018),
 (1052,276,22,2018),
 (1053,277,22,2018),
 (1054,278,22,2018),
 (1055,279,4,2018),
 (1056,280,4,2018),
 (1057,281,4,2018),
 (1058,282,4,2018),
 (1059,283,4,2018),
 (1060,284,4,2018),
 (1061,285,4,2018),
 (1062,286,4,2018),
 (1063,287,4,2018),
 (1064,288,4,2018),
 (1065,289,4,2018),
 (1066,290,4,2018),
 (1067,291,4,2018),
 (1068,292,4,2018),
 (1069,293,4,2018),
 (1070,294,4,2018),
 (1071,295,4,2018),
 (1072,296,4,2018),
 (1073,297,4,2018),
 (1074,298,4,2018),
 (1075,299,4,2018),
 (1076,300,4,2018),
 (1077,301,4,2018),
 (1078,302,4,2018),
 (1079,303,4,2018),
 (1080,304,4,2018),
 (1081,305,4,2018),
 (1082,306,4,2018),
 (1083,307,4,2018),
 (1084,308,4,2018),
 (1086,310,4,2018),
 (1087,311,4,2018),
 (1088,312,4,2018),
 (1089,313,4,2018),
 (1090,314,4,2018),
 (1091,315,4,2018),
 (1092,316,4,2018),
 (1093,317,4,2018),
 (1094,318,4,2018),
 (1095,319,4,2018),
 (1096,320,4,2018),
 (1097,321,4,2018),
 (1098,322,4,2018),
 (1099,323,4,2018),
 (1100,324,4,2018),
 (1101,325,4,2018),
 (1102,326,4,2018),
 (1103,327,4,2018),
 (1104,328,4,2018),
 (1105,329,4,2018),
 (1106,330,4,2018),
 (1107,331,4,2018),
 (1108,332,4,2018),
 (1109,333,4,2018),
 (1110,334,4,2018),
 (1111,335,4,2018),
 (1112,336,4,2018),
 (1113,337,4,2018),
 (1114,338,4,2018),
 (1115,339,4,2018),
 (1116,340,4,2018),
 (1117,341,4,2018),
 (1118,342,4,2018),
 (1119,343,4,2018),
 (1120,344,4,2018),
 (1121,345,4,2018),
 (1122,346,4,2018),
 (1124,348,4,2018),
 (1125,349,4,2018),
 (1126,350,4,2018),
 (1127,351,4,2018),
 (1128,352,4,2018),
 (1129,353,4,2018),
 (1130,354,4,2018),
 (1132,356,4,2018),
 (1133,357,4,2018),
 (1134,358,4,2018),
 (1135,359,4,2018),
 (1136,360,4,2018),
 (1137,361,4,2018),
 (1138,362,4,2018),
 (1139,363,4,2018),
 (1140,364,23,2018),
 (1141,365,23,2018),
 (1142,366,23,2018),
 (1143,367,23,2018),
 (1144,368,23,2018),
 (1145,369,23,2018),
 (1146,370,23,2018),
 (1147,371,23,2018),
 (1148,372,23,2018),
 (1149,373,23,2018),
 (1150,374,23,2018),
 (1151,375,23,2018),
 (1152,376,23,2018),
 (1153,377,23,2018),
 (1154,378,23,2018),
 (1155,379,23,2018),
 (1156,380,23,2018),
 (1157,381,23,2018),
 (1158,382,23,2018),
 (1159,383,23,2018),
 (1160,384,23,2018),
 (1161,385,23,2018),
 (1162,386,23,2018),
 (1163,387,23,2018),
 (1164,388,23,2018),
 (1165,389,23,2018),
 (1166,390,23,2018),
 (1167,391,23,2018),
 (1168,392,23,2018),
 (1169,393,23,2018),
 (1170,394,23,2018),
 (1171,395,23,2018),
 (1172,396,23,2018),
 (1173,397,23,2018),
 (1174,398,23,2018),
 (1175,399,23,2018),
 (1176,400,23,2018),
 (1177,401,23,2018),
 (1178,402,23,2018),
 (1179,403,23,2018),
 (1180,404,23,2018),
 (1181,405,23,2018),
 (1182,406,23,2018),
 (1183,407,23,2018),
 (1184,408,23,2018),
 (1185,409,23,2018),
 (1186,410,23,2018),
 (1187,411,23,2018),
 (1188,412,23,2018),
 (1189,413,23,2018),
 (1190,414,23,2018),
 (1191,415,23,2018),
 (1192,416,23,2018),
 (1193,417,23,2018),
 (1194,418,23,2018),
 (1195,419,23,2018),
 (1196,420,23,2018),
 (1197,421,23,2018),
 (1198,422,23,2018),
 (1199,423,23,2018),
 (1200,424,23,2018),
 (1201,425,23,2018),
 (1202,426,23,2018),
 (1203,427,23,2018),
 (1204,428,23,2018),
 (1205,429,23,2018),
 (1206,430,23,2018),
 (1207,431,23,2018),
 (1208,432,23,2018),
 (1209,433,23,2018),
 (1210,434,23,2018),
 (1211,435,23,2018),
 (1212,436,23,2018),
 (1213,437,23,2018),
 (1214,438,23,2018),
 (1215,439,23,2018),
 (1216,440,23,2018),
 (1217,441,23,2018),
 (1218,442,23,2018),
 (1219,443,23,2018),
 (1220,444,23,2018),
 (1221,445,23,2018),
 (1222,446,23,2018),
 (1223,447,23,2018),
 (1224,448,23,2018),
 (1225,449,23,2018),
 (1226,450,23,2018),
 (1227,451,23,2018),
 (1228,452,5,2018),
 (1229,453,5,2018),
 (1230,454,5,2018),
 (1231,455,5,2018),
 (1232,456,5,2018),
 (1234,458,5,2018),
 (1235,459,5,2018),
 (1237,461,5,2018),
 (1239,463,5,2018),
 (1240,464,5,2018),
 (1242,466,5,2018),
 (1243,467,5,2018),
 (1244,468,5,2018),
 (1245,469,5,2018),
 (1247,471,5,2018),
 (1249,473,5,2018),
 (1251,475,5,2018),
 (1252,476,5,2018),
 (1254,478,5,2018),
 (1255,479,5,2018),
 (1256,480,5,2018),
 (1258,482,5,2018),
 (1259,483,5,2018),
 (1261,485,5,2018),
 (1263,487,5,2018),
 (1264,488,5,2018),
 (1266,490,5,2018),
 (1267,491,5,2018),
 (1270,494,5,2018),
 (1271,495,5,2018),
 (1272,496,5,2018),
 (1273,497,5,2018),
 (1275,499,5,2018),
 (1277,501,5,2018),
 (1279,503,5,2018),
 (1280,504,5,2018),
 (1281,505,5,2018),
 (1282,506,5,2018),
 (1283,507,5,2018),
 (1285,509,5,2018),
 (1286,510,5,2018),
 (1287,511,5,2018),
 (1288,512,5,2018),
 (1289,513,5,2018),
 (1290,514,5,2018),
 (1291,515,5,2018),
 (1294,518,5,2018),
 (1295,519,5,2018),
 (1296,520,5,2018),
 (1297,521,5,2018),
 (1298,522,5,2018),
 (1299,523,5,2018),
 (1300,524,5,2018),
 (1301,525,5,2018),
 (1302,526,5,2018),
 (1303,527,5,2018),
 (1304,528,5,2018),
 (1305,529,5,2018),
 (1306,530,5,2018),
 (1307,531,5,2018),
 (1308,532,5,2018),
 (1309,533,5,2018),
 (1310,534,5,2018),
 (1311,535,5,2018),
 (1312,536,5,2018),
 (1313,537,5,2018),
 (1314,538,5,2018),
 (1315,539,5,2018),
 (1317,541,5,2018),
 (1319,543,5,2018),
 (1320,544,5,2018),
 (1322,546,5,2018),
 (1323,547,5,2018),
 (1344,568,26,2018),
 (1345,569,26,2018),
 (1346,570,26,2018),
 (1347,571,26,2018),
 (1348,572,26,2018),
 (1350,574,26,2018),
 (1351,575,26,2018),
 (1353,577,26,2018),
 (1356,580,26,2018),
 (1357,581,26,2018),
 (1358,582,26,2018),
 (1359,583,26,2018),
 (1360,584,26,2018),
 (1361,585,26,2018),
 (1364,588,26,2018),
 (1366,590,26,2018),
 (1368,592,26,2018),
 (1369,593,26,2018),
 (1370,594,26,2018),
 (1372,596,26,2018),
 (1373,597,26,2018),
 (1375,599,26,2018),
 (1376,600,26,2018),
 (1377,601,26,2018),
 (1378,602,26,2018),
 (1381,605,26,2018),
 (1382,606,26,2018),
 (1383,607,26,2018),
 (1384,608,26,2018),
 (1387,611,26,2018),
 (1388,612,26,2018),
 (1389,613,26,2018),
 (1390,614,26,2018),
 (1391,615,26,2018),
 (1393,617,26,2018),
 (1394,618,26,2018),
 (1395,619,26,2018),
 (1399,623,26,2018),
 (1400,624,26,2018),
 (1401,625,26,2018),
 (1402,626,26,2018),
 (1404,628,26,2018),
 (1405,629,26,2018),
 (1406,630,26,2018),
 (1407,631,26,2018),
 (1408,632,26,2018),
 (1409,633,26,2018),
 (1410,634,26,2018),
 (1411,635,26,2018),
 (1412,636,26,2018),
 (1413,637,26,2018),
 (1415,639,26,2018),
 (1416,640,26,2018),
 (1417,641,26,2018),
 (1419,643,6,2018),
 (1420,644,6,2018),
 (1421,645,6,2018),
 (1422,646,6,2018),
 (1423,647,6,2018),
 (1424,648,6,2018),
 (1425,649,6,2018),
 (1426,650,6,2018),
 (1427,651,6,2018),
 (1428,652,6,2018),
 (1429,653,6,2018),
 (1430,654,6,2018),
 (1431,655,6,2018),
 (1432,656,6,2018),
 (1433,657,6,2018),
 (1434,658,6,2018),
 (1435,659,6,2018),
 (1437,661,6,2018),
 (1438,662,6,2018),
 (1439,663,6,2018),
 (1440,664,6,2018),
 (1441,665,6,2018),
 (1442,666,6,2018),
 (1443,667,6,2018),
 (1444,668,6,2018),
 (1445,669,6,2018),
 (1446,670,6,2018),
 (1447,671,6,2018),
 (1448,672,6,2018),
 (1449,673,6,2018),
 (1450,674,6,2018),
 (1451,675,6,2018),
 (1452,676,6,2018),
 (1453,677,6,2018),
 (1454,678,6,2018),
 (1455,679,6,2018),
 (1456,680,6,2018),
 (1457,681,6,2018),
 (1458,682,6,2018),
 (1460,684,6,2018),
 (1461,685,6,2018),
 (1462,686,6,2018),
 (1463,687,6,2018),
 (1464,688,6,2018),
 (1465,689,6,2018),
 (1466,690,6,2018),
 (1467,691,6,2018),
 (1468,692,6,2018),
 (1469,693,6,2018),
 (1470,694,6,2018),
 (1471,695,6,2018),
 (1472,696,6,2018),
 (1473,697,6,2018),
 (1474,698,6,2018),
 (1475,699,6,2018),
 (1476,700,6,2018),
 (1477,701,6,2018),
 (1478,702,6,2018),
 (1479,703,6,2018),
 (1480,704,6,2018),
 (1481,705,6,2018),
 (1482,706,6,2018),
 (1483,707,6,2018),
 (1484,708,6,2018),
 (1485,709,6,2018),
 (1486,710,6,2018),
 (1487,711,6,2018),
 (1488,712,6,2018),
 (1489,713,6,2018),
 (1490,714,6,2018),
 (1491,715,6,2018),
 (1492,716,6,2018),
 (1493,717,6,2018),
 (1494,718,6,2018),
 (1495,719,6,2018),
 (1496,720,6,2018),
 (1497,721,6,2018),
 (1498,722,6,2018),
 (1499,723,6,2018),
 (1500,724,6,2018),
 (1501,725,6,2018),
 (1502,726,6,2018),
 (1503,727,6,2018),
 (1504,728,6,2018),
 (1505,729,6,2018),
 (1506,730,6,2018),
 (1507,731,6,2018),
 (1508,732,6,2018),
 (1801,621,26,2018),
 (1802,13,30,2018),
 (1806,683,6,2018),
 (1808,355,4,2018),
 (1809,500,5,2018),
 (1814,660,6,2018),
 (1815,542,5,2018),
 (1816,309,4,2018),
 (1817,4700,4,2018),
 (1818,4701,4,2018),
 (1819,4702,23,2018),
 (1831,4712,18,2018),
 (1832,4713,26,2018),
 (1834,4714,26,2018),
 (1836,4715,4,2018),
 (1837,4716,26,2018),
 (1838,4717,26,2018),
 (1839,4718,26,2018),
 (1840,4719,26,2018),
 (1842,4720,26,2018),
 (1843,548,26,2018),
 (1844,549,26,2018),
 (1845,550,26,2018),
 (1846,551,26,2018),
 (1848,553,26,2018),
 (1849,554,26,2018),
 (1851,556,26,2018),
 (1852,557,26,2018),
 (1853,558,26,2018),
 (1854,559,26,2018),
 (1855,560,26,2018),
 (1857,562,26,2018),
 (1858,564,26,2018),
 (1859,563,26,2018),
 (1861,565,26,2018),
 (1862,566,26,2018),
 (1864,4721,18,2018),
 (1866,4722,23,2018),
 (1869,4723,4,2018),
 (1872,4724,4,2018),
 (1873,452,29,2019),
 (1874,453,29,2019),
 (1875,454,29,2019),
 (1876,455,29,2019),
 (1877,456,29,2019),
 (1879,458,29,2019),
 (1880,459,29,2019),
 (1882,461,29,2019),
 (1884,463,29,2019),
 (1885,464,29,2019),
 (1887,466,29,2019),
 (1888,467,29,2019),
 (1889,468,29,2019),
 (1890,469,29,2019),
 (1892,471,29,2019),
 (1893,473,29,2019),
 (1895,475,29,2019),
 (1896,476,29,2019),
 (1898,478,29,2019),
 (1899,479,29,2019),
 (1900,480,29,2019),
 (1902,482,29,2019),
 (1903,483,29,2019),
 (1905,485,29,2019),
 (1907,487,29,2019),
 (1908,488,29,2019),
 (1910,490,29,2019),
 (1911,491,29,2019),
 (1914,494,29,2019),
 (1915,495,29,2019),
 (1916,496,29,2019),
 (1917,497,29,2019),
 (1919,499,29,2019),
 (1920,501,29,2019),
 (1922,503,29,2019),
 (1923,504,29,2019),
 (1924,505,29,2019),
 (1925,506,29,2019),
 (1926,507,29,2019),
 (1928,509,29,2019),
 (1929,510,29,2019),
 (1930,511,29,2019),
 (1931,512,29,2019),
 (1932,513,29,2019),
 (1933,514,29,2019),
 (1934,515,29,2019),
 (1937,518,29,2019),
 (1938,519,29,2019),
 (1939,520,29,2019),
 (1940,521,29,2019),
 (1941,522,29,2019),
 (1942,523,29,2019),
 (1943,524,29,2019),
 (1944,525,29,2019),
 (1945,526,29,2019),
 (1946,527,29,2019),
 (1947,528,29,2019),
 (1948,529,29,2019),
 (1949,530,29,2019),
 (1950,531,29,2019),
 (1951,532,29,2019),
 (1952,533,29,2019),
 (1953,534,29,2019),
 (1954,535,29,2019),
 (1955,536,29,2019),
 (1956,537,29,2019),
 (1957,538,29,2019),
 (1958,539,29,2019),
 (1960,541,29,2019),
 (1961,543,29,2019),
 (1962,544,29,2019),
 (1964,546,29,2019),
 (1965,547,29,2019),
 (1967,500,29,2019),
 (1968,542,29,2019),
 (1970,568,6,2019),
 (1971,569,6,2019),
 (1972,570,6,2019),
 (1973,571,6,2019),
 (1974,572,6,2019),
 (1976,574,6,2019),
 (1977,575,6,2019),
 (1979,577,6,2019),
 (1982,580,6,2019),
 (1983,581,6,2019),
 (1984,582,6,2019),
 (1985,583,6,2019),
 (1986,584,6,2019),
 (1987,585,6,2019),
 (1990,588,6,2019),
 (1992,590,6,2019),
 (1994,592,6,2019),
 (1995,593,6,2019),
 (1996,594,6,2019),
 (1998,596,6,2019),
 (1999,597,6,2019),
 (2001,599,6,2019),
 (2002,600,6,2019),
 (2003,601,6,2019),
 (2004,602,6,2019),
 (2007,605,6,2019),
 (2008,606,6,2019),
 (2009,607,6,2019),
 (2010,608,6,2019),
 (2013,611,6,2019),
 (2014,612,6,2019),
 (2015,613,6,2019),
 (2016,614,6,2019),
 (2017,615,6,2019),
 (2019,617,6,2019),
 (2020,618,6,2019),
 (2021,619,6,2019),
 (2024,623,6,2019),
 (2025,624,6,2019),
 (2026,625,6,2019),
 (2027,626,6,2019),
 (2029,628,6,2019),
 (2030,629,6,2019),
 (2031,630,6,2019),
 (2032,631,6,2019),
 (2033,632,6,2019),
 (2034,633,6,2019),
 (2035,634,6,2019),
 (2036,635,6,2019),
 (2037,636,6,2019),
 (2038,637,6,2019),
 (2040,639,6,2019),
 (2041,640,6,2019),
 (2042,641,6,2019),
 (2044,621,6,2019),
 (2046,4714,6,2019),
 (2047,4720,6,2019),
 (2048,548,6,2019),
 (2049,549,6,2019),
 (2050,550,6,2019),
 (2051,551,6,2019),
 (2053,553,6,2019),
 (2054,554,6,2019),
 (2056,556,6,2019),
 (2057,557,6,2019),
 (2058,558,6,2019),
 (2059,559,6,2019),
 (2060,560,6,2019),
 (2062,562,6,2019),
 (2063,564,6,2019),
 (2064,563,6,2019),
 (2065,565,6,2019),
 (2066,566,6,2019),
 (2128,279,5,2019),
 (2130,281,5,2019),
 (2131,282,5,2019),
 (2132,283,5,2019),
 (2133,284,5,2019),
 (2135,286,5,2019),
 (2136,287,5,2019),
 (2139,290,5,2019),
 (2140,291,5,2019),
 (2141,292,5,2019),
 (2142,293,5,2019),
 (2144,295,5,2019),
 (2148,299,5,2019),
 (2149,300,5,2019),
 (2150,301,5,2019),
 (2152,303,5,2019),
 (2153,304,5,2019),
 (2154,305,5,2019),
 (2155,306,5,2019),
 (2156,307,5,2019),
 (2159,311,5,2019),
 (2160,312,5,2019),
 (2161,313,5,2019),
 (2162,314,5,2019),
 (2163,315,5,2019),
 (2166,318,5,2019),
 (2168,320,5,2019),
 (2169,321,5,2019),
 (2170,322,5,2019),
 (2171,323,5,2019),
 (2172,324,5,2019),
 (2175,327,5,2019),
 (2176,328,5,2019),
 (2177,329,5,2019),
 (2178,330,5,2019),
 (2179,331,5,2019),
 (2180,332,5,2019),
 (2181,333,5,2019),
 (2182,334,5,2019),
 (2183,335,5,2019),
 (2186,338,5,2019),
 (2187,339,5,2019),
 (2189,341,5,2019),
 (2190,342,5,2019),
 (2191,343,5,2019),
 (2192,344,5,2019),
 (2193,345,5,2019),
 (2194,346,5,2019),
 (2196,349,5,2019),
 (2197,350,5,2019),
 (2198,351,5,2019),
 (2199,352,5,2019),
 (2200,353,5,2019),
 (2201,354,5,2019),
 (2204,358,5,2019),
 (2205,359,5,2019),
 (2211,355,5,2019),
 (2212,309,5,2019),
 (2213,4700,5,2019),
 (2214,4701,5,2019),
 (2216,4723,5,2019),
 (2217,4724,5,2019),
 (2218,364,26,2019),
 (2219,365,26,2019),
 (2220,366,26,2019),
 (2221,367,26,2019),
 (2222,368,26,2019),
 (2223,369,26,2019),
 (2224,370,26,2019),
 (2226,372,26,2019),
 (2227,373,26,2019),
 (2228,374,26,2019),
 (2230,376,26,2019),
 (2231,377,26,2019),
 (2232,378,26,2019),
 (2233,379,26,2019),
 (2234,380,26,2019),
 (2235,381,26,2019),
 (2236,382,26,2019),
 (2237,383,26,2019),
 (2238,384,26,2019),
 (2239,385,26,2019),
 (2240,386,26,2019),
 (2241,387,26,2019),
 (2243,389,26,2019),
 (2244,390,26,2019),
 (2245,391,26,2019),
 (2246,392,26,2019),
 (2248,394,26,2019),
 (2249,395,26,2019),
 (2250,396,26,2019),
 (2252,398,26,2019),
 (2253,399,26,2019),
 (2254,400,26,2019),
 (2255,401,26,2019),
 (2257,403,26,2019),
 (2258,404,26,2019),
 (2259,405,26,2019),
 (2260,406,26,2019),
 (2261,407,26,2019),
 (2263,409,26,2019),
 (2264,410,26,2019),
 (2268,414,26,2019),
 (2269,415,26,2019),
 (2270,416,26,2019),
 (2271,417,26,2019),
 (2272,418,26,2019),
 (2273,419,26,2019),
 (2274,420,26,2019),
 (2275,421,26,2019),
 (2276,422,26,2019),
 (2278,424,26,2019),
 (2279,425,26,2019),
 (2280,426,26,2019),
 (2281,427,26,2019),
 (2282,428,26,2019),
 (2283,429,26,2019),
 (2284,430,26,2019),
 (2285,431,26,2019),
 (2286,432,26,2019),
 (2287,433,26,2019),
 (2288,434,26,2019),
 (2289,435,26,2019),
 (2290,436,26,2019),
 (2291,437,26,2019),
 (2292,438,26,2019),
 (2293,439,26,2019),
 (2294,440,26,2019),
 (2295,441,26,2019),
 (2296,442,26,2019),
 (2297,443,26,2019),
 (2298,444,26,2019),
 (2299,445,26,2019),
 (2301,447,26,2019),
 (2304,450,26,2019),
 (2305,451,26,2019),
 (4008,94,4,2019),
 (4009,95,4,2019),
 (4010,96,4,2019),
 (4011,97,4,2019),
 (4012,98,4,2019),
 (4013,99,4,2019),
 (4014,100,4,2019),
 (4015,101,4,2019),
 (4016,102,4,2019),
 (4017,103,4,2019),
 (4018,104,4,2019),
 (4019,105,4,2019),
 (4020,106,4,2019),
 (4021,107,4,2019),
 (4024,110,4,2019),
 (4025,111,4,2019),
 (4026,112,4,2019),
 (4027,113,4,2019),
 (4028,114,4,2019),
 (4029,115,4,2019),
 (4030,116,4,2019),
 (4032,118,4,2019),
 (4034,120,4,2019),
 (4035,121,4,2019),
 (4037,123,4,2019),
 (4039,125,4,2019),
 (4040,126,4,2019),
 (4041,127,4,2019),
 (4042,128,4,2019),
 (4043,129,4,2019),
 (4044,130,4,2019),
 (4045,131,4,2019),
 (4046,132,4,2019),
 (4047,133,4,2019),
 (4048,134,4,2019),
 (4049,135,4,2019),
 (4050,136,4,2019),
 (4051,137,4,2019),
 (4052,138,4,2019),
 (4053,139,4,2019),
 (4054,140,4,2019),
 (4055,141,4,2019),
 (4056,142,4,2019),
 (4057,143,4,2019),
 (4058,144,4,2019),
 (4059,145,4,2019),
 (4060,146,4,2019),
 (4061,147,4,2019),
 (4063,149,4,2019),
 (4064,150,4,2019),
 (4065,151,4,2019),
 (4068,154,4,2019),
 (4069,155,4,2019),
 (4070,156,4,2019),
 (4071,157,4,2019),
 (4072,158,4,2019),
 (4073,159,4,2019),
 (4074,160,4,2019),
 (4075,161,4,2019),
 (4077,163,4,2019),
 (4078,164,4,2019),
 (4079,165,4,2019),
 (4080,166,4,2019),
 (4081,167,4,2019),
 (4082,168,4,2019),
 (4083,169,4,2019),
 (4084,170,4,2019),
 (4085,171,4,2019),
 (4086,172,4,2019),
 (4087,173,4,2019),
 (4088,174,4,2019),
 (4089,175,4,2019),
 (4090,176,4,2019),
 (4091,177,4,2019),
 (4092,178,4,2019),
 (4093,179,4,2019),
 (4094,180,4,2019),
 (4095,181,4,2019),
 (4096,182,4,2019),
 (4097,183,4,2019),
 (4098,184,4,2019),
 (4099,185,4,2019),
 (4101,187,23,2019),
 (4102,188,23,2019),
 (4103,189,23,2019),
 (4104,190,23,2019),
 (4105,191,23,2019),
 (4106,192,23,2019),
 (4109,195,23,2019),
 (4110,196,23,2019),
 (4111,197,23,2019),
 (4112,198,23,2019),
 (4113,199,23,2019),
 (4114,200,23,2019),
 (4115,201,23,2019),
 (4116,202,23,2019),
 (4117,203,23,2019),
 (4118,204,23,2019),
 (4119,205,23,2019),
 (4120,206,23,2019),
 (4121,207,23,2019),
 (4122,208,23,2019),
 (4123,209,23,2019),
 (4124,210,23,2019),
 (4125,211,23,2019),
 (4126,212,23,2019),
 (4127,213,23,2019),
 (4128,214,23,2019),
 (4129,215,23,2019),
 (4130,216,23,2019),
 (4131,217,23,2019),
 (4132,218,23,2019),
 (4133,219,23,2019),
 (4134,220,23,2019),
 (4135,221,23,2019),
 (4136,222,23,2019),
 (4137,223,23,2019),
 (4138,224,23,2019),
 (4139,225,23,2019),
 (4140,226,23,2019),
 (4141,227,23,2019),
 (4142,228,23,2019),
 (4143,229,23,2019),
 (4144,230,23,2019),
 (4145,231,23,2019),
 (4146,232,23,2019),
 (4147,233,23,2019),
 (4148,234,23,2019),
 (4150,236,23,2019),
 (4151,237,23,2019),
 (4152,238,23,2019),
 (4153,239,23,2019),
 (4154,240,23,2019),
 (4155,241,23,2019),
 (4156,242,23,2019),
 (4157,243,23,2019),
 (4158,244,23,2019),
 (4159,245,23,2019),
 (4160,246,23,2019),
 (4161,247,23,2019),
 (4162,248,23,2019),
 (4163,249,23,2019),
 (4164,250,23,2019),
 (4165,251,23,2019),
 (4166,252,23,2019),
 (4167,253,23,2019),
 (4168,254,23,2019),
 (4169,255,23,2019),
 (4170,256,23,2019),
 (4171,257,23,2019),
 (4172,258,23,2019),
 (4173,259,23,2019),
 (4174,260,23,2019),
 (4175,261,23,2019),
 (4176,262,23,2019),
 (4177,263,23,2019),
 (4178,264,23,2019),
 (4179,265,23,2019),
 (4180,266,23,2019),
 (4181,267,23,2019),
 (4182,268,23,2019),
 (4183,269,23,2019),
 (4184,270,23,2019),
 (4185,271,23,2019),
 (4186,272,23,2019),
 (4187,273,23,2019),
 (4188,274,23,2019),
 (4189,275,23,2019),
 (4190,276,23,2019),
 (4191,277,23,2019),
 (4192,278,23,2019),
 (4195,4721,4,2019),
 (4682,1,31,2019),
 (4683,2,31,2019),
 (4684,3,31,2019),
 (4685,4,31,2019),
 (4686,5,31,2019),
 (4687,6,31,2019),
 (4688,7,31,2019),
 (4689,8,31,2019),
 (4690,9,31,2019),
 (4691,10,31,2019),
 (4692,11,31,2019),
 (4693,12,31,2019),
 (4694,14,31,2019),
 (4695,15,31,2019),
 (4696,16,31,2019),
 (4697,17,31,2019),
 (4698,18,31,2019),
 (4699,19,31,2019),
 (4700,20,31,2019),
 (4701,21,31,2019),
 (4702,22,31,2019),
 (4703,23,31,2019),
 (4704,24,31,2019),
 (4705,25,31,2019),
 (4706,26,31,2019),
 (4707,27,31,2019),
 (4708,28,31,2019),
 (4709,29,31,2019),
 (4710,30,31,2019),
 (4711,31,31,2019),
 (4712,32,31,2019),
 (4713,33,31,2019),
 (4714,34,31,2019),
 (4715,35,31,2019),
 (4716,36,31,2019),
 (4717,37,31,2019),
 (4718,38,31,2019),
 (4719,39,31,2019),
 (4720,40,31,2019),
 (4721,41,31,2019),
 (4722,42,31,2019),
 (4723,43,31,2019),
 (4724,44,31,2019),
 (4725,45,31,2019),
 (4726,46,31,2019),
 (4727,47,31,2019),
 (4728,48,31,2019),
 (4729,49,31,2019),
 (4730,50,31,2019),
 (4731,51,31,2019),
 (4732,52,31,2019),
 (4733,53,31,2019),
 (4734,54,31,2019),
 (4735,55,31,2019),
 (4736,56,31,2019),
 (4737,57,31,2019),
 (4738,58,31,2019),
 (4739,59,31,2019),
 (4740,60,31,2019),
 (4741,61,31,2019),
 (4742,62,31,2019),
 (4743,63,31,2019),
 (4744,64,31,2019),
 (4745,65,31,2019),
 (4746,66,31,2019),
 (4747,67,31,2019),
 (4748,68,31,2019),
 (4749,69,31,2019),
 (4750,70,31,2019),
 (4751,71,31,2019),
 (4752,72,31,2019),
 (4753,73,31,2019),
 (4754,74,31,2019),
 (4755,75,31,2019),
 (4756,76,31,2019),
 (4757,77,31,2019),
 (4758,78,31,2019),
 (4759,79,31,2019),
 (4760,80,31,2019),
 (4761,81,31,2019),
 (4762,82,31,2019),
 (4763,83,31,2019),
 (4764,84,31,2019),
 (4765,85,31,2019),
 (4766,86,31,2019),
 (4767,87,31,2019),
 (4768,88,31,2019),
 (4769,89,31,2019),
 (4770,90,31,2019),
 (4771,91,31,2019),
 (4772,92,31,2019),
 (4773,93,31,2019),
 (4774,13,31,2019),
 (4810,4727,30,2019),
 (4811,4728,30,2019),
 (4812,4729,30,2019),
 (4814,4731,30,2019),
 (4815,4732,30,2019),
 (4816,4733,30,2019),
 (4817,4734,30,2019),
 (4818,4735,30,2019),
 (4819,4736,30,2019),
 (4820,4737,30,2019),
 (4821,4738,30,2019),
 (4822,4739,30,2019),
 (4823,4740,30,2019),
 (4824,4741,30,2019),
 (4825,4742,30,2019),
 (4826,4743,30,2019),
 (4827,4744,30,2019),
 (4828,4745,30,2019),
 (4829,4746,30,2019),
 (4830,4747,30,2019),
 (4831,4748,30,2019),
 (4832,4749,30,2019),
 (4833,4750,30,2019),
 (4834,4751,30,2019),
 (4835,4752,30,2019),
 (4836,4753,30,2019),
 (4837,4754,30,2019),
 (4838,4755,30,2019),
 (4839,4756,30,2019),
 (4840,4757,30,2019),
 (4841,4758,30,2019),
 (4842,4759,30,2019),
 (4843,4760,30,2019),
 (4844,4761,30,2019),
 (4845,4762,30,2019),
 (4846,4763,30,2019),
 (4847,4764,30,2019),
 (4848,4765,30,2019),
 (4849,4766,30,2019),
 (4850,4767,30,2019),
 (4851,4768,30,2019),
 (4852,4769,30,2019),
 (4853,4770,30,2019),
 (4854,4771,30,2019),
 (4855,4772,30,2019),
 (4856,4773,30,2019),
 (4857,4774,30,2019),
 (4858,4775,30,2019),
 (4859,4776,30,2019),
 (4860,4777,30,2019),
 (4861,4778,30,2019),
 (4862,4779,30,2019),
 (4863,4780,30,2019),
 (4872,4781,22,2019),
 (4873,4782,22,2019),
 (4874,4783,22,2019),
 (4875,4784,22,2019),
 (4876,4785,22,2019),
 (4877,4786,22,2019),
 (4878,4787,22,2019),
 (4879,4788,22,2019),
 (4880,4789,22,2019),
 (4881,4790,22,2019),
 (4882,4791,22,2019),
 (4883,4792,22,2019),
 (4884,4793,22,2019),
 (4885,4794,22,2019),
 (4886,4795,22,2019),
 (4887,4796,22,2019),
 (4888,4797,22,2019),
 (4889,4798,22,2019),
 (4890,4799,22,2019),
 (4891,4800,22,2019),
 (4892,4801,22,2019),
 (4893,4802,22,2019),
 (4894,4803,22,2019),
 (4895,4804,22,2019),
 (4896,4805,22,2019),
 (4897,4806,22,2019),
 (4898,4807,22,2019),
 (4899,4808,22,2019),
 (4900,4809,22,2019),
 (4901,4810,22,2019),
 (4902,4811,22,2019),
 (4903,4812,22,2019),
 (4904,4813,22,2019),
 (4905,4814,22,2019),
 (4906,4815,22,2019),
 (4907,4816,22,2019),
 (4908,4817,22,2019),
 (4909,4818,22,2019),
 (4910,4819,22,2019),
 (4911,4820,22,2019),
 (4912,4821,22,2019),
 (4913,4822,22,2019),
 (4914,4823,22,2019),
 (4915,4824,22,2019),
 (4916,4825,22,2019),
 (4917,4826,22,2019),
 (4918,4827,22,2019),
 (4919,4828,22,2019),
 (4920,4829,22,2019),
 (4921,4830,22,2019),
 (4922,4831,22,2019),
 (4923,4832,22,2019),
 (4924,4833,22,2019),
 (4925,4834,22,2019),
 (4926,4835,22,2019),
 (4927,4836,22,2019),
 (4928,4837,22,2019),
 (4929,4838,22,2019),
 (4930,4839,22,2019),
 (4931,4840,22,2019),
 (4932,4841,22,2019),
 (4933,4842,22,2019),
 (4934,4843,22,2019),
 (4935,4844,22,2019),
 (4936,4845,22,2019),
 (4937,4846,22,2019),
 (4938,4847,22,2019),
 (4939,4848,22,2019),
 (4940,4849,22,2019),
 (4941,4850,22,2019),
 (4942,4851,22,2019),
 (4943,4852,22,2019),
 (4944,4853,22,2019),
 (4945,4854,22,2019),
 (4946,4855,22,2019),
 (4947,4856,22,2019),
 (4948,4857,22,2019),
 (4949,4858,22,2019),
 (4950,4859,22,2019),
 (4999,4860,18,2019),
 (5000,4861,18,2019),
 (5001,4862,18,2019),
 (5002,4863,18,2019),
 (5003,4864,18,2019),
 (5004,4865,18,2019),
 (5005,4866,18,2019),
 (5006,4867,18,2019),
 (5007,4868,18,2019),
 (5008,4869,18,2019),
 (5009,4870,18,2019),
 (5010,4871,18,2019),
 (5011,4872,18,2019),
 (5012,4873,18,2019),
 (5013,4874,18,2019),
 (5014,4875,18,2019),
 (5015,4876,18,2019),
 (5016,4877,18,2019),
 (5017,4878,18,2019),
 (5018,4879,18,2019),
 (5019,4880,18,2019),
 (5020,4881,18,2019),
 (5021,4882,18,2019),
 (5022,4883,18,2019),
 (5023,4884,18,2019),
 (5024,4885,18,2019),
 (5025,4886,18,2019),
 (5026,4887,18,2019),
 (5027,4888,18,2019),
 (5028,4889,18,2019),
 (5029,4890,18,2019),
 (5030,4891,18,2019),
 (5031,4892,18,2019),
 (5032,4893,18,2019),
 (5033,4894,18,2019),
 (5034,4895,18,2019),
 (5035,4896,18,2019),
 (5036,4897,18,2019),
 (5037,4898,18,2019),
 (5038,4899,18,2019),
 (5039,4900,18,2019),
 (5040,4901,18,2019),
 (5041,4902,18,2019),
 (5042,4903,18,2019),
 (5043,4904,18,2019),
 (5044,4905,18,2019),
 (5045,4906,18,2019),
 (5046,4907,18,2019),
 (5047,4908,18,2019),
 (5048,4909,18,2019),
 (5049,4910,18,2019),
 (5050,4911,18,2019),
 (5051,4912,18,2019),
 (5052,4913,18,2019),
 (5053,4914,18,2019),
 (5054,4915,18,2019),
 (5055,4916,18,2019),
 (5064,4917,23,2019),
 (5066,4918,23,2019),
 (5069,4920,23,2019),
 (5071,4921,23,2019),
 (5073,4922,23,2019),
 (5075,4923,5,2019),
 (5077,4924,4,2019),
 (5079,4925,4,2019),
 (5081,4926,4,2019),
 (5083,4927,22,2019),
 (5085,4928,5,2019),
 (5091,4931,5,2019),
 (5093,4932,5,2019),
 (5095,4933,5,2019),
 (5097,4934,5,2019),
 (5104,4937,26,2019),
 (5109,4940,26,2019),
 (5111,4941,26,2019),
 (5113,4942,26,2019),
 (5115,4943,26,2019),
 (5117,4944,26,2019),
 (5119,4945,6,2019),
 (5121,4946,6,2019),
 (5123,4947,6,2019),
 (5127,4950,6,2019),
 (5129,4951,6,2019),
 (5133,4953,29,2019),
 (5136,4954,29,2019),
 (5138,4955,23,2019),
 (5141,4957,31,2019),
 (5142,4958,30,2019),
 (5149,4960,30,2019),
 (5151,4961,26,2019),
 (5153,4962,30,2019),
 (5161,4965,4,2019),
 (5179,4956,4,2019),
 (5181,4967,5,2019),
 (5183,4968,5,2019),
 (5185,4969,5,2019),
 (5187,4970,5,2019),
 (5189,4971,26,2019),
 (5191,4972,26,2019),
 (5193,4973,26,2019),
 (5195,4974,26,2019),
 (5198,4976,30,2019),
 (5200,4977,30,2019),
 (5202,4978,30,2019),
 (5204,4979,30,2019),
 (5207,4980,30,2019),
 (5209,4981,30,2019),
 (5211,4982,23,2019),
 (5213,4983,23,2019),
 (5215,4984,31,2019),
 (5217,4985,31,2019),
 (5219,4986,31,2019),
 (5221,4987,31,2019),
 (5223,4988,18,2019),
 (5226,4989,18,2019),
 (5228,4990,18,2019),
 (5230,4991,18,2019),
 (5232,4992,18,2019),
 (5235,4994,29,2019),
 (5236,4995,29,2019),
 (5249,5001,30,2019),
 (5252,5004,18,2019),
 (5255,5005,31,2019),
 (5258,5007,18,2019),
 (5267,5010,18,2019),
 (5269,5011,5,2019),
 (5271,5012,5,2019),
 (5276,5015,5,2019),
 (5277,5016,6,2019);
/*!40000 ALTER TABLE `curclassold` ENABLE KEYS */;


--
-- Definition of table `curpyroll`
--

DROP TABLE IF EXISTS `curpyroll`;
CREATE TABLE `curpyroll` (
  `EmpId` int(10) unsigned NOT NULL,
  `KLGROSSINCOME` double DEFAULT NULL,
  `KLDEDUCTIONS` double DEFAULT NULL,
  `KLNETTAX` double DEFAULT NULL,
  `KLTAX` double DEFAULT NULL,
  `KLTOTALRELIEF` double DEFAULT NULL,
  `KLNETPAY` double DEFAULT NULL,
  `KLPOSTTAXABLEINCOMESH` double DEFAULT NULL,
  `KLAPPINSURAMOUNT` double DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `curpyroll`
--

/*!40000 ALTER TABLE `curpyroll` DISABLE KEYS */;
/*!40000 ALTER TABLE `curpyroll` ENABLE KEYS */;


--
-- Definition of table `customer`
--

DROP TABLE IF EXISTS `customer`;
CREATE TABLE `customer` (
  `CustId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Addr1` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `City` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `EMailAddr` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Fax` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `Name` char(50) CHARACTER SET utf8 DEFAULT NULL,
  `Phone` char(30) CHARACTER SET utf8 DEFAULT NULL,
  `State` char(1) CHARACTER SET utf8 DEFAULT NULL,
  `Zip` char(10) CHARACTER SET utf8 DEFAULT NULL,
  `PinNbr` varchar(45) DEFAULT NULL,
  `VatNbr` varchar(45) DEFAULT NULL,
  `PhyAddr` varchar(85) DEFAULT NULL,
  `contName` varchar(45) DEFAULT NULL,
  `Balance` double DEFAULT NULL,
  `code` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`CustId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `customer`
--

/*!40000 ALTER TABLE `customer` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer` ENABLE KEYS */;


--
-- Definition of table `custpay`
--

DROP TABLE IF EXISTS `custpay`;
CREATE TABLE `custpay` (
  `Pid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` datetime DEFAULT NULL,
  `Descr` varchar(45) DEFAULT NULL,
  `cid` int(10) unsigned DEFAULT NULL,
  `Amount` double DEFAULT NULL,
  `TransNo` varchar(45) DEFAULT NULL,
  `AccId` int(10) unsigned DEFAULT NULL,
  `Paidby` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`Pid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `custpay`
--

/*!40000 ALTER TABLE `custpay` DISABLE KEYS */;
/*!40000 ALTER TABLE `custpay` ENABLE KEYS */;


--
-- Definition of table `custtrans`
--

DROP TABLE IF EXISTS `custtrans`;
CREATE TABLE `custtrans` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` varchar(45) NOT NULL,
  `Description` varchar(45) NOT NULL,
  `DrAmount` double DEFAULT NULL,
  `CrAmount` double DEFAULT NULL,
  `TK` varchar(10) DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  `CustId` int(10) unsigned DEFAULT NULL,
  `TransNo` varchar(45) DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  `Paidby` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `custtrans`
--

/*!40000 ALTER TABLE `custtrans` DISABLE KEYS */;
/*!40000 ALTER TABLE `custtrans` ENABLE KEYS */;


--
-- Definition of table `dailyactiv`
--

DROP TABLE IF EXISTS `dailyactiv`;
CREATE TABLE `dailyactiv` (
  `TrId` double NOT NULL AUTO_INCREMENT,
  `Cld` int(10) unsigned DEFAULT NULL,
  `EmpId` int(10) unsigned DEFAULT NULL,
  `TrDate` datetime NOT NULL,
  `TrDate2` datetime NOT NULL,
  `TrDate3` datetime NOT NULL,
  `TrDate4` datetime NOT NULL,
  `TrDate5` datetime NOT NULL,
  `TK` varchar(4) DEFAULT NULL,
  `TR` varchar(5) DEFAULT NULL,
  `RefId` int(10) unsigned DEFAULT NULL,
  `RefId2` int(10) unsigned DEFAULT NULL,
  `RefId3` int(10) unsigned DEFAULT NULL,
  `RefId4` int(10) unsigned DEFAULT NULL,
  `RefId5` int(10) unsigned DEFAULT NULL,
  `REfId6` int(10) unsigned DEFAULT NULL,
  `Details` text,
  `Details2` text,
  `Details3` text,
  `Details4` text,
  `Details5` text,
  `Charges` double DEFAULT NULL,
  PRIMARY KEY (`TrId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `dailyactiv`
--

/*!40000 ALTER TABLE `dailyactiv` DISABLE KEYS */;
/*!40000 ALTER TABLE `dailyactiv` ENABLE KEYS */;


--
-- Definition of table `dailytrans`
--

DROP TABLE IF EXISTS `dailytrans`;
CREATE TABLE `dailytrans` (
  `drId` double NOT NULL AUTO_INCREMENT,
  `StNo` int(10) unsigned DEFAULT NULL,
  `EmpId` int(10) unsigned DEFAULT NULL,
  `TrDate` datetime NOT NULL,
  `TrDate2` datetime NOT NULL,
  `TrDate3` datetime NOT NULL,
  `TrDate4` datetime NOT NULL,
  `TrDate5` datetime NOT NULL,
  `TK` varchar(4) DEFAULT NULL,
  `TR` varchar(5) DEFAULT NULL,
  `RefId` int(10) unsigned DEFAULT NULL,
  `RefId2` int(10) unsigned DEFAULT NULL,
  `RefId3` int(10) unsigned DEFAULT NULL,
  `RefId4` int(10) unsigned DEFAULT NULL,
  `RefId5` int(10) unsigned DEFAULT NULL,
  `REfId6` int(10) unsigned DEFAULT NULL,
  `Details` text,
  `Details2` text,
  `Details3` text,
  `Details4` text,
  `Details5` text,
  `Charges` double DEFAULT NULL,
  PRIMARY KEY (`drId`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `dailytrans`
--

/*!40000 ALTER TABLE `dailytrans` DISABLE KEYS */;
INSERT INTO `dailytrans` (`drId`,`StNo`,`EmpId`,`TrDate`,`TrDate2`,`TrDate3`,`TrDate4`,`TrDate5`,`TK`,`TR`,`RefId`,`RefId2`,`RefId3`,`RefId4`,`RefId5`,`REfId6`,`Details`,`Details2`,`Details3`,`Details4`,`Details5`,`Charges`) VALUES 
 (1,1,NULL,'2015-10-09 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','ATT','Tr',6,NULL,NULL,NULL,NULL,NULL,'Was missing during preps',NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `dailytrans` ENABLE KEYS */;


--
-- Definition of table `dailytree`
--

DROP TABLE IF EXISTS `dailytree`;
CREATE TABLE `dailytree` (
  `DId` int(10) unsigned DEFAULT NULL,
  `Nos` int(10) unsigned DEFAULT NULL,
  `Knd` varchar(4) DEFAULT NULL,
  `optvalues` text,
  `kDId` int(10) unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `dailytree`
--

/*!40000 ALTER TABLE `dailytree` DISABLE KEYS */;
INSERT INTO `dailytree` (`DId`,`Nos`,`Knd`,`optvalues`,`kDId`) VALUES 
 (1,4,'PRS',NULL,2),
 (1,2,'OPTN','0*3',NULL);
/*!40000 ALTER TABLE `dailytree` ENABLE KEYS */;


--
-- Definition of table `dailytype`
--

DROP TABLE IF EXISTS `dailytype`;
CREATE TABLE `dailytype` (
  `DId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `dtype` varchar(45) DEFAULT NULL,
  `Main` varchar(4) NOT NULL DEFAULT 'F',
  PRIMARY KEY (`DId`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `dailytype`
--

/*!40000 ALTER TABLE `dailytype` DISABLE KEYS */;
INSERT INTO `dailytype` (`DId`,`dtype`,`Main`) VALUES 
 (1,'Attendance','T'),
 (2,'sickness','T'),
 (3,'Purnishment','T');
/*!40000 ALTER TABLE `dailytype` ENABLE KEYS */;


--
-- Definition of table `dailyvals`
--

DROP TABLE IF EXISTS `dailyvals`;
CREATE TABLE `dailyvals` (
  `IdVal` double NOT NULL AUTO_INCREMENT,
  `dId` double DEFAULT NULL,
  `txtval` varchar(45) DEFAULT NULL,
  `sel` varchar(5) DEFAULT '0',
  `optnval` text,
  `sctv` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`IdVal`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `dailyvals`
--

/*!40000 ALTER TABLE `dailyvals` DISABLE KEYS */;
INSERT INTO `dailyvals` (`IdVal`,`dId`,`txtval`,`sel`,`optnval`,`sctv`) VALUES 
 (21,1,'Field 1','1',' Yes,No,Any','Yes'),
 (22,1,'Another 1','0',' ',''),
 (23,2,'Helper','1',' Parent,Matron,Teacher',''),
 (24,2,'Sickness','0',' ',''),
 (25,2,'Hospital','0',' ',''),
 (26,2,'Condition','1',' Serious,Minor,Middle level',''),
 (27,3,'Reason For purnishment','0',' ','');
/*!40000 ALTER TABLE `dailyvals` ENABLE KEYS */;


--
-- Definition of table `defgrades`
--

DROP TABLE IF EXISTS `defgrades`;
CREATE TABLE `defgrades` (
  `GID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `GFrom` double DEFAULT NULL,
  `GTo` double DEFAULT NULL,
  `G` varchar(2) DEFAULT NULL,
  `Remarks` varchar(100) DEFAULT NULL,
  `MKS` int(10) unsigned NOT NULL,
  `TRemarks` text,
  PRIMARY KEY (`GID`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `defgrades`
--

/*!40000 ALTER TABLE `defgrades` DISABLE KEYS */;
INSERT INTO `defgrades` (`GID`,`GFrom`,`GTo`,`G`,`Remarks`,`MKS`,`TRemarks`) VALUES 
 (3,80,100,'A','EXCELLENT',12,'EXCELLENT'),
 (4,70,74,'B+','VERY GOOD',10,'VERY GOOD'),
 (5,75,79,'A-','EXCELLENT',11,'EXCELLENT'),
 (6,65,69,'B','VERY GOOD',9,'VERY GOOD'),
 (7,60,64,'B-','VERY GOOD',8,'VERY GOOD'),
 (8,55,59,'C+','FAIR',7,'FAIR'),
 (9,50,54,'C','FAIR',6,'FAIR'),
 (11,45,49,'C-','FAIR',5,'FAIR'),
 (14,40,44,'D+','WORK HARD',4,'WORK HARD'),
 (16,0,29,'E','WORK HARDER',1,'WORK HARDER'),
 (17,35,39,'D','WORK HARD',3,'WORK HARD'),
 (18,30,34,'D-','WORK HARD',2,'WORK HARD');
/*!40000 ALTER TABLE `defgrades` ENABLE KEYS */;


--
-- Definition of table `empadvance`
--

DROP TABLE IF EXISTS `empadvance`;
CREATE TABLE `empadvance` (
  `aid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `advance` varchar(45) NOT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`aid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empadvance`
--

/*!40000 ALTER TABLE `empadvance` DISABLE KEYS */;
/*!40000 ALTER TABLE `empadvance` ENABLE KEYS */;


--
-- Definition of table `empadvancetrans`
--

DROP TABLE IF EXISTS `empadvancetrans`;
CREATE TABLE `empadvancetrans` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `aid` int(10) unsigned NOT NULL,
  `EmpId` int(10) unsigned NOT NULL,
  `Amount` double NOT NULL,
  `trdate` datetime NOT NULL,
  `act` varchar(5) NOT NULL DEFAULT 'F',
  `PRID` int(10) unsigned DEFAULT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  `balance` double DEFAULT NULL,
  `comments` text,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empadvancetrans`
--

/*!40000 ALTER TABLE `empadvancetrans` DISABLE KEYS */;
/*!40000 ALTER TABLE `empadvancetrans` ENABLE KEYS */;


--
-- Definition of table `empadvancetranspr`
--

DROP TABLE IF EXISTS `empadvancetranspr`;
CREATE TABLE `empadvancetranspr` (
  `KId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Id` int(10) unsigned NOT NULL,
  `Amount` double NOT NULL,
  `trdate` datetime NOT NULL,
  `act` varchar(5) NOT NULL DEFAULT 'F',
  `PRID` int(10) unsigned DEFAULT NULL,
  `empId` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`KId`)
) ENGINE=InnoDB AUTO_INCREMENT=174 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empadvancetranspr`
--

/*!40000 ALTER TABLE `empadvancetranspr` DISABLE KEYS */;
INSERT INTO `empadvancetranspr` (`KId`,`Id`,`Amount`,`trdate`,`act`,`PRID`,`empId`) VALUES 
 (155,1,3000,'0000-00-00 00:00:00','F',33,10),
 (171,3,5000,'0000-00-00 00:00:00','F',48,37),
 (172,4,4000,'0000-00-00 00:00:00','F',48,38),
 (173,2,4333,'0000-00-00 00:00:00','F',48,51);
/*!40000 ALTER TABLE `empadvancetranspr` ENABLE KEYS */;


--
-- Definition of table `empallow`
--

DROP TABLE IF EXISTS `empallow`;
CREATE TABLE `empallow` (
  `aid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `allowance` varchar(45) NOT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`aid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empallow`
--

/*!40000 ALTER TABLE `empallow` DISABLE KEYS */;
/*!40000 ALTER TABLE `empallow` ENABLE KEYS */;


--
-- Definition of table `empallowtrans`
--

DROP TABLE IF EXISTS `empallowtrans`;
CREATE TABLE `empallowtrans` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `aid` int(10) unsigned NOT NULL,
  `EmpId` int(10) unsigned NOT NULL,
  `Amount` double NOT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  `comment` text,
  `TXBL` varchar(5) NOT NULL DEFAULT 'T',
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empallowtrans`
--

/*!40000 ALTER TABLE `empallowtrans` DISABLE KEYS */;
/*!40000 ALTER TABLE `empallowtrans` ENABLE KEYS */;


--
-- Definition of table `empallowtranspr`
--

DROP TABLE IF EXISTS `empallowtranspr`;
CREATE TABLE `empallowtranspr` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `aid` int(10) unsigned NOT NULL,
  `EmpId` int(10) unsigned NOT NULL,
  `PRID` int(10) unsigned NOT NULL,
  `Amount` double NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empallowtranspr`
--

/*!40000 ALTER TABLE `empallowtranspr` DISABLE KEYS */;
/*!40000 ALTER TABLE `empallowtranspr` ENABLE KEYS */;


--
-- Definition of table `empappdeduct`
--

DROP TABLE IF EXISTS `empappdeduct`;
CREATE TABLE `empappdeduct` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `EmpId` int(10) unsigned NOT NULL,
  `payee` varchar(4) DEFAULT 'T',
  `nhif` varchar(4) DEFAULT 'T',
  `nssfstaff` varchar(4) DEFAULT 'T',
  `nssfemp` varchar(4) DEFAULT 'T',
  `helb` varchar(4) DEFAULT 'F',
  `helbAmnt` double DEFAULT NULL,
  `LASC` varchar(4) DEFAULT 'F',
  `TITHE` varchar(5) DEFAULT NULL,
  `nssfyee` double DEFAULT NULL,
  `nssfyer` double DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empappdeduct`
--

/*!40000 ALTER TABLE `empappdeduct` DISABLE KEYS */;
/*!40000 ALTER TABLE `empappdeduct` ENABLE KEYS */;


--
-- Definition of table `emparrearstrans`
--

DROP TABLE IF EXISTS `emparrearstrans`;
CREATE TABLE `emparrearstrans` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Amount` double NOT NULL,
  `EmpId` int(10) unsigned NOT NULL,
  `act` varchar(4) NOT NULL DEFAULT 'F',
  `PRID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `emparrearstrans`
--

/*!40000 ALTER TABLE `emparrearstrans` DISABLE KEYS */;
/*!40000 ALTER TABLE `emparrearstrans` ENABLE KEYS */;


--
-- Definition of table `empbenef`
--

DROP TABLE IF EXISTS `empbenef`;
CREATE TABLE `empbenef` (
  `bid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `benefit` varchar(45) NOT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`bid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empbenef`
--

/*!40000 ALTER TABLE `empbenef` DISABLE KEYS */;
/*!40000 ALTER TABLE `empbenef` ENABLE KEYS */;


--
-- Definition of table `empbeneftrans`
--

DROP TABLE IF EXISTS `empbeneftrans`;
CREATE TABLE `empbeneftrans` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bid` int(10) unsigned NOT NULL,
  `EmpId` int(10) unsigned NOT NULL,
  `Amount` double NOT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  `comment` text,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empbeneftrans`
--

/*!40000 ALTER TABLE `empbeneftrans` DISABLE KEYS */;
/*!40000 ALTER TABLE `empbeneftrans` ENABLE KEYS */;


--
-- Definition of table `empbeneftranspr`
--

DROP TABLE IF EXISTS `empbeneftranspr`;
CREATE TABLE `empbeneftranspr` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bid` int(10) unsigned NOT NULL,
  `EmpId` int(10) unsigned NOT NULL,
  `PRID` int(10) unsigned NOT NULL,
  `Amount` double NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empbeneftranspr`
--

/*!40000 ALTER TABLE `empbeneftranspr` DISABLE KEYS */;
/*!40000 ALTER TABLE `empbeneftranspr` ENABLE KEYS */;


--
-- Definition of table `empchildrn`
--

DROP TABLE IF EXISTS `empchildrn`;
CREATE TABLE `empchildrn` (
  `EmpId` int(10) unsigned DEFAULT NULL,
  `childnm` varchar(45) DEFAULT NULL,
  `childbd` varchar(45) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empchildrn`
--

/*!40000 ALTER TABLE `empchildrn` DISABLE KEYS */;
INSERT INTO `empchildrn` (`EmpId`,`childnm`,`childbd`) VALUES 
 (17,'','--'),
 (18,'','--'),
 (19,'','--'),
 (20,'','--'),
 (22,'','--'),
 (23,'','--'),
 (24,'','--'),
 (25,'','--'),
 (26,'','--'),
 (27,'','--'),
 (28,'','--'),
 (29,'','--'),
 (30,'','--'),
 (31,'','--'),
 (32,'','--'),
 (33,'','--'),
 (65,'','--'),
 (66,'','--'),
 (67,'','--'),
 (68,'','--'),
 (71,'','--'),
 (73,'','--'),
 (74,'','--'),
 (75,'','--'),
 (76,'','--'),
 (3,'','--'),
 (42,'','--'),
 (5,'','--'),
 (16,'','--'),
 (34,'','--'),
 (35,'','--'),
 (36,'','--'),
 (37,'','--'),
 (38,'','--'),
 (39,'','--'),
 (40,'','--'),
 (41,'ESTHER','--'),
 (43,'','--'),
 (44,'','--'),
 (1,'','--'),
 (2,'','--'),
 (4,'Kimn','2014-05-14'),
 (7,'','--'),
 (8,'','--'),
 (9,'','--'),
 (10,'','--'),
 (11,'','--'),
 (12,'','--'),
 (13,'','--'),
 (14,'','--'),
 (15,'','--'),
 (48,'','--'),
 (6,'','--'),
 (51,'','--'),
 (50,'','--');
/*!40000 ALTER TABLE `empchildrn` ENABLE KEYS */;


--
-- Definition of table `empdeduct`
--

DROP TABLE IF EXISTS `empdeduct`;
CREATE TABLE `empdeduct` (
  `ded` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `deduct` varchar(45) NOT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`ded`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empdeduct`
--

/*!40000 ALTER TABLE `empdeduct` DISABLE KEYS */;
/*!40000 ALTER TABLE `empdeduct` ENABLE KEYS */;


--
-- Definition of table `empdeductrans`
--

DROP TABLE IF EXISTS `empdeductrans`;
CREATE TABLE `empdeductrans` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ded` int(10) unsigned NOT NULL,
  `EmpId` int(10) unsigned NOT NULL,
  `Amount` double NOT NULL,
  `trdate` datetime NOT NULL,
  `repeats` varchar(5) DEFAULT NULL,
  `act` varchar(5) NOT NULL DEFAULT 'F',
  `PRID` int(10) unsigned DEFAULT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  `units` double DEFAULT NULL,
  `comments` text,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empdeductrans`
--

/*!40000 ALTER TABLE `empdeductrans` DISABLE KEYS */;
/*!40000 ALTER TABLE `empdeductrans` ENABLE KEYS */;


--
-- Definition of table `empdepartment`
--

DROP TABLE IF EXISTS `empdepartment`;
CREATE TABLE `empdepartment` (
  `Department` varchar(45) NOT NULL,
  `DepId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`DepId`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empdepartment`
--

/*!40000 ALTER TABLE `empdepartment` DISABLE KEYS */;
INSERT INTO `empdepartment` (`Department`,`DepId`,`Conby`,`Initby`,`Rvsby`) VALUES 
 ('TEACHING STAFF',1,0,0,NULL),
 ('SUPPORT STAFF',5,0,0,NULL);
/*!40000 ALTER TABLE `empdepartment` ENABLE KEYS */;


--
-- Definition of table `empdocs`
--

DROP TABLE IF EXISTS `empdocs`;
CREATE TABLE `empdocs` (
  `br_id` int(11) NOT NULL AUTO_INCREMENT,
  `EmpId` int(11) DEFAULT NULL,
  `descr` varchar(300) NOT NULL,
  `content` varchar(300) NOT NULL,
  PRIMARY KEY (`br_id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empdocs`
--

/*!40000 ALTER TABLE `empdocs` DISABLE KEYS */;
INSERT INTO `empdocs` (`br_id`,`EmpId`,`descr`,`content`) VALUES 
 (7,1,'four document','br/1_Ipn_Setup_Ammended.docx');
/*!40000 ALTER TABLE `empdocs` ENABLE KEYS */;


--
-- Definition of table `empearnings`
--

DROP TABLE IF EXISTS `empearnings`;
CREATE TABLE `empearnings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `EmpId` varchar(45) NOT NULL,
  `Basic` double NOT NULL DEFAULT '0',
  `Housed` varchar(4) NOT NULL DEFAULT 'F',
  `HAmount` double DEFAULT NULL,
  `comment` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empearnings`
--

/*!40000 ALTER TABLE `empearnings` DISABLE KEYS */;
/*!40000 ALTER TABLE `empearnings` ENABLE KEYS */;


--
-- Definition of table `empextloan`
--

DROP TABLE IF EXISTS `empextloan`;
CREATE TABLE `empextloan` (
  `lid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company` varchar(45) NOT NULL,
  `cocode` varchar(45) DEFAULT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`lid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empextloan`
--

/*!40000 ALTER TABLE `empextloan` DISABLE KEYS */;
/*!40000 ALTER TABLE `empextloan` ENABLE KEYS */;


--
-- Definition of table `empextloantrans`
--

DROP TABLE IF EXISTS `empextloantrans`;
CREATE TABLE `empextloantrans` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lid` int(10) unsigned NOT NULL,
  `Instalment` double NOT NULL,
  `balance` double NOT NULL,
  `EmpId` int(10) unsigned NOT NULL,
  `coopno` varchar(45) DEFAULT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  `comments` text,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empextloantrans`
--

/*!40000 ALTER TABLE `empextloantrans` DISABLE KEYS */;
/*!40000 ALTER TABLE `empextloantrans` ENABLE KEYS */;


--
-- Definition of table `empextloantranspr`
--

DROP TABLE IF EXISTS `empextloantranspr`;
CREATE TABLE `empextloantranspr` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lid` int(10) unsigned NOT NULL,
  `PRID` int(10) unsigned NOT NULL,
  `Instalment` double NOT NULL,
  `balance` double NOT NULL,
  `EmpId` int(10) unsigned NOT NULL,
  `coopno` varchar(45) DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empextloantranspr`
--

/*!40000 ALTER TABLE `empextloantranspr` DISABLE KEYS */;
/*!40000 ALTER TABLE `empextloantranspr` ENABLE KEYS */;


--
-- Definition of table `emploanconst`
--

DROP TABLE IF EXISTS `emploanconst`;
CREATE TABLE `emploanconst` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `instal` double NOT NULL,
  `months` int(10) unsigned NOT NULL,
  `AccId` int(10) unsigned DEFAULT NULL,
  `applic` double DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `emploanconst`
--

/*!40000 ALTER TABLE `emploanconst` DISABLE KEYS */;
/*!40000 ALTER TABLE `emploanconst` ENABLE KEYS */;


--
-- Definition of table `emploans`
--

DROP TABLE IF EXISTS `emploans`;
CREATE TABLE `emploans` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lid` int(10) unsigned NOT NULL,
  `salary` double DEFAULT NULL,
  `EPrincipal` double DEFAULT NULL,
  `TransNo` varchar(45) DEFAULT NULL,
  `Principal` double NOT NULL,
  `lnDate` datetime DEFAULT NULL,
  `DeductionAmount` double DEFAULT NULL,
  `NetAmount` double DEFAULT NULL,
  `FiscalMonth` varchar(45) DEFAULT NULL,
  `AccId` int(10) unsigned DEFAULT NULL,
  `Fomula` varchar(45) NOT NULL,
  `months` int(10) unsigned DEFAULT NULL,
  `empmonths` int(10) unsigned DEFAULT NULL,
  `tyloan` double DEFAULT NULL,
  `paymonth` int(10) unsigned DEFAULT NULL,
  `Intrest` double DEFAULT NULL,
  `EmpId` int(10) unsigned NOT NULL,
  `LNINST` int(10) unsigned DEFAULT NULL,
  `FormNo` varchar(45) DEFAULT NULL,
  `AppAmount` double DEFAULT NULL,
  `TrDate` datetime DEFAULT NULL,
  `Progress` varchar(45) NOT NULL DEFAULT 'Applied',
  `DateApproved` datetime DEFAULT NULL,
  `approved` varchar(45) DEFAULT NULL,
  `Reason` text,
  `MaxLoan` double DEFAULT NULL,
  `MaxInst` int(10) unsigned DEFAULT NULL,
  `PSalary` double DEFAULT NULL,
  `stDate` datetime DEFAULT NULL,
  `acv` varchar(45) DEFAULT NULL,
  `PrdPassed` int(10) unsigned NOT NULL DEFAULT '0',
  `Conby` int(10) unsigned DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `emploans`
--

/*!40000 ALTER TABLE `emploans` DISABLE KEYS */;
/*!40000 ALTER TABLE `emploans` ENABLE KEYS */;


--
-- Definition of table `emploantrans`
--

DROP TABLE IF EXISTS `emploantrans`;
CREATE TABLE `emploantrans` (
  `TrId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` date DEFAULT NULL,
  `Id` int(10) unsigned NOT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  `Tk` varchar(10) DEFAULT NULL,
  `Descr` varchar(45) DEFAULT NULL,
  `DRAmount` double DEFAULT NULL,
  `CRAmount` double DEFAULT NULL,
  `PaidBy` varchar(45) DEFAULT NULL,
  `TransNo` varchar(45) DEFAULT NULL,
  `Qt` varchar(45) NOT NULL DEFAULT 'F',
  `An` varchar(45) NOT NULL DEFAULT 'F',
  `empid` double DEFAULT NULL,
  `PRID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`TrId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `emploantrans`
--

/*!40000 ALTER TABLE `emploantrans` DISABLE KEYS */;
/*!40000 ALTER TABLE `emploantrans` ENABLE KEYS */;


--
-- Definition of table `employees`
--

DROP TABLE IF EXISTS `employees`;
CREATE TABLE `employees` (
  `EmpId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `EmpNo` varchar(45) NOT NULL,
  `SurName` varchar(45) NOT NULL,
  `FirstName` varchar(45) NOT NULL,
  `OtherNames` varchar(55) DEFAULT NULL,
  `Gender` varchar(45) NOT NULL,
  `JoinDate` datetime NOT NULL,
  `Address` varchar(65) DEFAULT NULL,
  `Phone` varchar(45) DEFAULT NULL,
  `Email` varchar(45) DEFAULT NULL,
  `exts` varchar(45) DEFAULT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `code` varchar(45) DEFAULT NULL,
  `estate` varchar(45) DEFAULT NULL,
  `plot` varchar(45) DEFAULT NULL,
  `district` varchar(45) DEFAULT NULL,
  `division` varchar(45) DEFAULT NULL,
  `location` varchar(45) DEFAULT NULL,
  `sublocation` varchar(45) DEFAULT NULL,
  `village` varchar(45) DEFAULT NULL,
  `town` varchar(45) DEFAULT NULL,
  `PhysicalAdd` text,
  PRIMARY KEY (`EmpId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `employees`
--

/*!40000 ALTER TABLE `employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `employees` ENABLE KEYS */;


--
-- Definition of table `employment`
--

DROP TABLE IF EXISTS `employment`;
CREATE TABLE `employment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `EmpId` int(10) unsigned NOT NULL,
  `DepId` int(10) unsigned DEFAULT NULL,
  `BrId` int(10) unsigned DEFAULT NULL,
  `OvId` int(10) unsigned DEFAULT NULL,
  `Account` varchar(45) DEFAULT NULL,
  `Terminate` varchar(45) DEFAULT NULL,
  `TDate` datetime DEFAULT NULL,
  `TId` int(10) unsigned DEFAULT NULL,
  `PID` varchar(5) DEFAULT 'B',
  `DIRECTOR` varchar(5) DEFAULT NULL,
  `techr` varchar(4) DEFAULT NULL,
  `reason` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `employment`
--

/*!40000 ALTER TABLE `employment` DISABLE KEYS */;
/*!40000 ALTER TABLE `employment` ENABLE KEYS */;


--
-- Definition of table `empotherearn`
--

DROP TABLE IF EXISTS `empotherearn`;
CREATE TABLE `empotherearn` (
  `oid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `otherearn` varchar(45) NOT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empotherearn`
--

/*!40000 ALTER TABLE `empotherearn` DISABLE KEYS */;
/*!40000 ALTER TABLE `empotherearn` ENABLE KEYS */;


--
-- Definition of table `empotherearntrans`
--

DROP TABLE IF EXISTS `empotherearntrans`;
CREATE TABLE `empotherearntrans` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `oid` int(10) unsigned NOT NULL,
  `EmpId` int(10) unsigned NOT NULL,
  `Amount` double NOT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  `comments` text,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empotherearntrans`
--

/*!40000 ALTER TABLE `empotherearntrans` DISABLE KEYS */;
/*!40000 ALTER TABLE `empotherearntrans` ENABLE KEYS */;


--
-- Definition of table `empotherearntranspr`
--

DROP TABLE IF EXISTS `empotherearntranspr`;
CREATE TABLE `empotherearntranspr` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `oid` int(10) unsigned NOT NULL,
  `EmpId` int(10) unsigned NOT NULL,
  `PRID` int(10) unsigned NOT NULL,
  `Amount` double NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empotherearntranspr`
--

/*!40000 ALTER TABLE `empotherearntranspr` DISABLE KEYS */;
/*!40000 ALTER TABLE `empotherearntranspr` ENABLE KEYS */;


--
-- Definition of table `empovertime`
--

DROP TABLE IF EXISTS `empovertime`;
CREATE TABLE `empovertime` (
  `OvId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Overtime` varchar(45) NOT NULL,
  `Amount` double NOT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`OvId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empovertime`
--

/*!40000 ALTER TABLE `empovertime` DISABLE KEYS */;
/*!40000 ALTER TABLE `empovertime` ENABLE KEYS */;


--
-- Definition of table `empoverttrans`
--

DROP TABLE IF EXISTS `empoverttrans`;
CREATE TABLE `empoverttrans` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `activity` varchar(50) NOT NULL,
  `hrs` double NOT NULL,
  `rate` double NOT NULL,
  `EmpId` int(10) unsigned NOT NULL,
  `act` varchar(4) NOT NULL DEFAULT 'F',
  `trdate` datetime NOT NULL,
  `PRID` int(10) unsigned DEFAULT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  `OvId` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empoverttrans`
--

/*!40000 ALTER TABLE `empoverttrans` DISABLE KEYS */;
/*!40000 ALTER TABLE `empoverttrans` ENABLE KEYS */;


--
-- Definition of table `emppayment`
--

DROP TABLE IF EXISTS `emppayment`;
CREATE TABLE `emppayment` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `PRID` int(10) unsigned NOT NULL,
  `EmpId` double NOT NULL,
  `PTYPE` varchar(4) NOT NULL DEFAULT 'C',
  `trDate` datetime NOT NULL,
  `Amount` double DEFAULT NULL,
  `TransNo` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `emppayment`
--

/*!40000 ALTER TABLE `emppayment` DISABLE KEYS */;
/*!40000 ALTER TABLE `emppayment` ENABLE KEYS */;


--
-- Definition of table `emppaymentarr`
--

DROP TABLE IF EXISTS `emppaymentarr`;
CREATE TABLE `emppaymentarr` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `PRID` int(10) unsigned NOT NULL,
  `EmpId` double NOT NULL,
  `PTYPE` varchar(4) NOT NULL DEFAULT 'C',
  `trDate` datetime NOT NULL,
  `Amount` double DEFAULT NULL,
  `TransNo` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `emppaymentarr`
--

/*!40000 ALTER TABLE `emppaymentarr` DISABLE KEYS */;
/*!40000 ALTER TABLE `emppaymentarr` ENABLE KEYS */;


--
-- Definition of table `emppaymentcumu`
--

DROP TABLE IF EXISTS `emppaymentcumu`;
CREATE TABLE `emppaymentcumu` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `PRID` int(10) unsigned NOT NULL,
  `TrType` int(10) DEFAULT NULL,
  `TRNO` int(10) DEFAULT NULL,
  `PTYPE` varchar(4) NOT NULL DEFAULT 'C',
  `trDate` datetime NOT NULL,
  `Amount` double DEFAULT NULL,
  `TransNo` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `emppaymentcumu`
--

/*!40000 ALTER TABLE `emppaymentcumu` DISABLE KEYS */;
/*!40000 ALTER TABLE `emppaymentcumu` ENABLE KEYS */;


--
-- Definition of table `emppersonal`
--

DROP TABLE IF EXISTS `emppersonal`;
CREATE TABLE `emppersonal` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `EmpId` int(10) unsigned NOT NULL,
  `PinNo` varchar(45) DEFAULT NULL,
  `IdNo` varchar(45) DEFAULT NULL,
  `NHIFNo` varchar(45) DEFAULT NULL,
  `NSSFNo` varchar(45) DEFAULT NULL,
  `HELBNO` varchar(45) DEFAULT NULL,
  `BloodGroup` varchar(45) DEFAULT NULL,
  `MaritalStatus` varchar(45) NOT NULL DEFAULT 'S',
  `spousName` varchar(45) DEFAULT NULL,
  `Hobbies` text,
  `Bdate` datetime DEFAULT NULL,
  `LASCNO` varchar(45) DEFAULT NULL,
  `TSCNO` varchar(45) DEFAULT NULL,
  `Tel` varchar(45) DEFAULT NULL,
  `occup` varchar(45) DEFAULT NULL,
  `spidno` varchar(45) DEFAULT NULL,
  `church` varchar(45) DEFAULT NULL,
  `spemail` varchar(45) DEFAULT NULL,
  `religion` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `emppersonal`
--

/*!40000 ALTER TABLE `emppersonal` DISABLE KEYS */;
/*!40000 ALTER TABLE `emppersonal` ENABLE KEYS */;


--
-- Definition of table `empqualgrade`
--

DROP TABLE IF EXISTS `empqualgrade`;
CREATE TABLE `empqualgrade` (
  `grid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `qid` int(10) unsigned NOT NULL,
  `grade` varchar(45) NOT NULL,
  PRIMARY KEY (`grid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empqualgrade`
--

/*!40000 ALTER TABLE `empqualgrade` DISABLE KEYS */;
/*!40000 ALTER TABLE `empqualgrade` ENABLE KEYS */;


--
-- Definition of table `empqualifcgrade`
--

DROP TABLE IF EXISTS `empqualifcgrade`;
CREATE TABLE `empqualifcgrade` (
  `grid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `QId` int(10) unsigned NOT NULL,
  `grade` varchar(45) NOT NULL,
  `marks` varchar(45) NOT NULL,
  `interview` varchar(45) NOT NULL,
  PRIMARY KEY (`grid`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empqualifcgrade`
--

/*!40000 ALTER TABLE `empqualifcgrade` DISABLE KEYS */;
INSERT INTO `empqualifcgrade` (`grid`,`QId`,`grade`,`marks`,`interview`) VALUES 
 (3,1,'A','12','5'),
 (4,1,'B','10','4'),
 (5,1,'C','9','3'),
 (6,1,'D','6','2'),
 (7,2,'A','12','5'),
 (8,2,'B','10','4'),
 (9,2,'C','6','3'),
 (10,2,'D','4','2'),
 (11,2,'E','2','1');
/*!40000 ALTER TABLE `empqualifcgrade` ENABLE KEYS */;


--
-- Definition of table `empqualific`
--

DROP TABLE IF EXISTS `empqualific`;
CREATE TABLE `empqualific` (
  `QId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `levels` varchar(45) DEFAULT NULL,
  `award` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`QId`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empqualific`
--

/*!40000 ALTER TABLE `empqualific` DISABLE KEYS */;
INSERT INTO `empqualific` (`QId`,`levels`,`award`) VALUES 
 (2,'University','Degree'),
 (3,'College','Diploma'),
 (4,'College','P1 Certificate');
/*!40000 ALTER TABLE `empqualific` ENABLE KEYS */;


--
-- Definition of table `empqualify`
--

DROP TABLE IF EXISTS `empqualify`;
CREATE TABLE `empqualify` (
  `qid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `qualification` varchar(45) NOT NULL,
  PRIMARY KEY (`qid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empqualify`
--

/*!40000 ALTER TABLE `empqualify` DISABLE KEYS */;
/*!40000 ALTER TABLE `empqualify` ENABLE KEYS */;


--
-- Definition of table `empqualifyexper`
--

DROP TABLE IF EXISTS `empqualifyexper`;
CREATE TABLE `empqualifyexper` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `EmpId` int(10) unsigned NOT NULL,
  `Institution` varchar(45) DEFAULT NULL,
  `positions` varchar(45) DEFAULT NULL,
  `responsibility` text,
  `yrFro` int(10) unsigned DEFAULT NULL,
  `yrto` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empqualifyexper`
--

/*!40000 ALTER TABLE `empqualifyexper` DISABLE KEYS */;
INSERT INTO `empqualifyexper` (`Id`,`EmpId`,`Institution`,`positions`,`responsibility`,`yrFro`,`yrto`) VALUES 
 (1,1,'Namanga primary school','Teacher','Teach',2010,2011);
/*!40000 ALTER TABLE `empqualifyexper` ENABLE KEYS */;


--
-- Definition of table `empqualifytrans`
--

DROP TABLE IF EXISTS `empqualifytrans`;
CREATE TABLE `empqualifytrans` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `EmpId` int(10) unsigned NOT NULL,
  `Institution` varchar(45) DEFAULT NULL,
  `Qid` int(10) unsigned DEFAULT NULL,
  `grid` int(10) unsigned DEFAULT NULL,
  `yrFro` int(10) unsigned DEFAULT NULL,
  `yrto` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empqualifytrans`
--

/*!40000 ALTER TABLE `empqualifytrans` DISABLE KEYS */;
/*!40000 ALTER TABLE `empqualifytrans` ENABLE KEYS */;


--
-- Definition of table `emprefundtrans`
--

DROP TABLE IF EXISTS `emprefundtrans`;
CREATE TABLE `emprefundtrans` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `refund` varchar(50) NOT NULL,
  `Amount` double NOT NULL,
  `EmpId` int(10) unsigned NOT NULL,
  `act` varchar(4) NOT NULL DEFAULT 'F',
  `trdate` datetime NOT NULL,
  `PRID` int(10) unsigned DEFAULT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  `comment` text,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `emprefundtrans`
--

/*!40000 ALTER TABLE `emprefundtrans` DISABLE KEYS */;
/*!40000 ALTER TABLE `emprefundtrans` ENABLE KEYS */;


--
-- Definition of table `empstafflns`
--

DROP TABLE IF EXISTS `empstafflns`;
CREATE TABLE `empstafflns` (
  `lid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Descr` varchar(45) NOT NULL,
  `Fomula` varchar(4) NOT NULL,
  `Interest` double NOT NULL,
  `Period` int(10) unsigned NOT NULL,
  `startp` int(10) unsigned NOT NULL,
  `Loan` double NOT NULL,
  `ltyp` varchar(45) NOT NULL,
  PRIMARY KEY (`lid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empstafflns`
--

/*!40000 ALTER TABLE `empstafflns` DISABLE KEYS */;
/*!40000 ALTER TABLE `empstafflns` ENABLE KEYS */;


--
-- Definition of table `emptaxrelief`
--

DROP TABLE IF EXISTS `emptaxrelief`;
CREATE TABLE `emptaxrelief` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `EmpId` int(10) unsigned NOT NULL,
  `taxrelef` varchar(4) DEFAULT 'T',
  `insrelief` varchar(4) DEFAULT 'F',
  `insreliefAmnt` double DEFAULT NULL,
  `hospapplic` varchar(4) DEFAULT 'F',
  `hospAmount` double DEFAULT NULL,
  `ownerapp` varchar(4) DEFAULT 'F',
  `ownerappAmnt` double DEFAULT NULL,
  `employeePen` double DEFAULT NULL,
  `employerPen` double DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `emptaxrelief`
--

/*!40000 ALTER TABLE `emptaxrelief` DISABLE KEYS */;
/*!40000 ALTER TABLE `emptaxrelief` ENABLE KEYS */;


--
-- Definition of table `emptitle`
--

DROP TABLE IF EXISTS `emptitle`;
CREATE TABLE `emptitle` (
  `Tid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Title` varchar(45) NOT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  `Descr` text,
  `Spec` text,
  `Note` text,
  PRIMARY KEY (`Tid`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `emptitle`
--

/*!40000 ALTER TABLE `emptitle` DISABLE KEYS */;
INSERT INTO `emptitle` (`Tid`,`Title`,`Conby`,`Initby`,`Rvsby`,`Descr`,`Spec`,`Note`) VALUES 
 (1,'Director',0,0,NULL,NULL,NULL,NULL),
 (3,'Accounts Asst',0,0,NULL,'Accs','docs/jobtittle3_','Notes'),
 (4,'Secretary',0,0,NULL,NULL,NULL,NULL),
 (5,'Administrator',0,0,NULL,'','docs/jobtittle5_',''),
 (6,'Teacher',NULL,NULL,NULL,'Teacher','docs/jobtittle6_',''),
 (7,'Cook',NULL,NULL,NULL,'Cook','docs/jobtittle7_',''),
 (9,'Security',NULL,NULL,NULL,'Security','docs/jobtittle9_',''),
 (10,'GroundsMen',NULL,NULL,NULL,'GM','docs/jobtittle10_',''),
 (11,'Matron',NULL,NULL,NULL,'Matron','docs/jobtittle11_',''),
 (13,'Driver',NULL,NULL,NULL,'Driver','docs/jobtittle13_',''),
 (14,'Stores Asst',NULL,NULL,NULL,'','docs/jobtittle14_',''),
 (15,'Cleaning Asst',NULL,NULL,NULL,'','docs/jobtittle15_',''),
 (16,'Class Asst',NULL,NULL,NULL,'','docs/jobtittle16_','');
/*!40000 ALTER TABLE `emptitle` ENABLE KEYS */;


--
-- Definition of table `empunion`
--

DROP TABLE IF EXISTS `empunion`;
CREATE TABLE `empunion` (
  `uid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `unions` varchar(45) NOT NULL,
  `ucode` varchar(45) DEFAULT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empunion`
--

/*!40000 ALTER TABLE `empunion` DISABLE KEYS */;
/*!40000 ALTER TABLE `empunion` ENABLE KEYS */;


--
-- Definition of table `empuniontrans`
--

DROP TABLE IF EXISTS `empuniontrans`;
CREATE TABLE `empuniontrans` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL,
  `Amount` double NOT NULL,
  `EmpId` int(10) unsigned NOT NULL,
  `unionno` varchar(45) DEFAULT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  `comments` text,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empuniontrans`
--

/*!40000 ALTER TABLE `empuniontrans` DISABLE KEYS */;
/*!40000 ALTER TABLE `empuniontrans` ENABLE KEYS */;


--
-- Definition of table `empuniontranspr`
--

DROP TABLE IF EXISTS `empuniontranspr`;
CREATE TABLE `empuniontranspr` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL,
  `Amount` double NOT NULL,
  `EmpId` int(10) unsigned NOT NULL,
  `PRID` int(10) unsigned NOT NULL,
  `unionno` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empuniontranspr`
--

/*!40000 ALTER TABLE `empuniontranspr` DISABLE KEYS */;
/*!40000 ALTER TABLE `empuniontranspr` ENABLE KEYS */;


--
-- Definition of table `exams`
--

DROP TABLE IF EXISTS `exams`;
CREATE TABLE `exams` (
  `EXMID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `DESCRIPTION` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`EXMID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `exams`
--

/*!40000 ALTER TABLE `exams` DISABLE KEYS */;
/*!40000 ALTER TABLE `exams` ENABLE KEYS */;


--
-- Definition of table `examsdone`
--

DROP TABLE IF EXISTS `examsdone`;
CREATE TABLE `examsdone` (
  `exId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TId` int(10) unsigned DEFAULT NULL,
  `clid` int(10) unsigned DEFAULT NULL,
  `EXMID` int(10) unsigned DEFAULT NULL,
  `Perc` double DEFAULT '100',
  `Report` varchar(6) DEFAULT 'False',
  `EntryMord` varchar(45) DEFAULT 'max',
  `DateFro` datetime DEFAULT NULL,
  `DateTo` datetime DEFAULT NULL,
  PRIMARY KEY (`exId`),
  KEY `de1_EXMID` (`EXMID`),
  KEY `de1_clid` (`clid`),
  KEY `de1_TId` (`TId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsdone`
--

/*!40000 ALTER TABLE `examsdone` DISABLE KEYS */;
/*!40000 ALTER TABLE `examsdone` ENABLE KEYS */;


--
-- Definition of table `examsdoneold`
--

DROP TABLE IF EXISTS `examsdoneold`;
CREATE TABLE `examsdoneold` (
  `exId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TId` int(10) unsigned DEFAULT NULL,
  `clid` int(10) unsigned DEFAULT NULL,
  `EXMID` int(10) unsigned DEFAULT NULL,
  `Perc` double DEFAULT '100',
  `Report` varchar(6) DEFAULT 'False',
  `EntryMord` varchar(45) DEFAULT 'max',
  `DateFro` datetime DEFAULT NULL,
  `DateTo` datetime DEFAULT NULL,
  PRIMARY KEY (`exId`),
  KEY `de1_EXMID` (`EXMID`),
  KEY `de1_clid` (`clid`),
  KEY `de1_TId` (`TId`)
) ENGINE=InnoDB AUTO_INCREMENT=134 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsdoneold`
--

/*!40000 ALTER TABLE `examsdoneold` DISABLE KEYS */;
INSERT INTO `examsdoneold` (`exId`,`TId`,`clid`,`EXMID`,`Perc`,`Report`,`EntryMord`,`DateFro`,`DateTo`) VALUES 
 (56,13,2,1,15,'True','max','2018-07-31 00:00:00','2018-07-31 00:00:00'),
 (57,13,2,2,15,'True','max','2018-07-31 00:00:00','2018-07-31 00:00:00'),
 (58,13,2,3,70,'True','max','2018-07-31 00:00:00','2018-07-31 00:00:00'),
 (59,13,1,1,15,'True','max','2018-07-31 00:00:00','2018-07-31 00:00:00'),
 (60,13,1,2,15,'True','max','2018-07-31 00:00:00','2018-07-31 00:00:00'),
 (61,13,1,3,70,'True','max','2018-07-31 00:00:00','2018-07-31 00:00:00'),
 (62,13,4,1,15,'False','max','2018-07-31 00:00:00','2018-07-31 00:00:00'),
 (63,13,4,2,15,'False','max','2018-07-31 00:00:00','2018-07-31 00:00:00'),
 (64,13,4,3,70,'False','max','2018-07-31 00:00:00','2018-07-31 00:00:00'),
 (65,13,3,1,15,'True','max','2018-08-01 00:00:00','2018-08-01 00:00:00'),
 (66,13,3,2,15,'True','max','2018-08-01 00:00:00','2018-08-01 00:00:00'),
 (67,13,3,3,70,'True','max','2018-08-01 00:00:00','2018-08-01 00:00:00'),
 (69,14,1,1,15,'True','max','2018-09-20 00:00:00','2018-09-20 00:00:00'),
 (70,14,2,1,15,'True','max','2018-09-28 00:00:00','2018-09-28 00:00:00'),
 (71,14,3,1,15,'True','max','2018-09-28 00:00:00','2018-09-28 00:00:00'),
 (72,14,3,2,15,'True','max','2018-09-28 00:00:00','2018-09-28 00:00:00'),
 (74,14,1,2,15,'True','max','2018-10-02 00:00:00','2018-10-02 00:00:00'),
 (75,14,2,2,15,'True','max','2018-10-15 00:00:00','2018-10-15 00:00:00'),
 (77,14,2,3,70,'True','max','2018-10-23 00:00:00','2018-10-23 00:00:00'),
 (78,14,3,3,70,'True','max','2018-10-23 00:00:00','2018-10-23 00:00:00'),
 (79,14,1,3,70,'True','max','2018-10-23 00:00:00','2018-10-23 00:00:00'),
 (80,15,2,1,15,'True','max','2019-03-27 00:00:00','2019-03-27 00:00:00'),
 (81,15,2,2,15,'True','max','2019-03-28 00:00:00','2019-03-28 00:00:00'),
 (82,15,2,3,70,'True','max','2019-03-28 00:00:00','2019-03-28 00:00:00'),
 (83,15,3,1,15,'True','max','2019-03-28 00:00:00','2019-03-28 00:00:00'),
 (84,15,3,2,15,'True','max','2019-03-28 00:00:00','2019-03-28 00:00:00'),
 (85,15,3,3,70,'True','max','2019-03-28 00:00:00','2019-03-28 00:00:00'),
 (86,15,1,1,15,'True','max','2019-03-29 00:00:00','2019-03-29 00:00:00'),
 (87,15,1,2,15,'True','max','2019-03-29 00:00:00','2019-03-29 00:00:00'),
 (88,15,4,7,100,'True','max','2019-04-02 00:00:00','2019-04-02 00:00:00'),
 (89,15,4,1,15,'False','max','2019-04-02 00:00:00','2019-04-02 00:00:00'),
 (92,15,1,3,70,'True','max','2019-04-02 00:00:00','2019-04-02 00:00:00'),
 (93,15,4,9,100,'True','max','2019-04-29 00:00:00','2019-04-30 00:00:00'),
 (94,16,1,1,15,'True','max','2019-07-11 00:00:00','2019-07-11 00:00:00'),
 (95,16,1,2,15,'True','max','2019-07-11 00:00:00','2019-07-11 00:00:00'),
 (96,16,1,3,70,'True','max','2019-07-11 00:00:00','2019-07-11 00:00:00'),
 (97,16,2,1,15,'True','max','2019-07-17 00:00:00','2019-07-17 00:00:00'),
 (98,16,2,2,15,'True','max','2019-07-17 00:00:00','2019-07-17 00:00:00'),
 (99,16,2,3,70,'True','max','2019-07-17 00:00:00','2019-07-17 00:00:00'),
 (100,16,3,1,15,'True','max','2019-07-18 00:00:00','2019-07-18 00:00:00'),
 (101,16,3,2,15,'True','max','2019-07-18 00:00:00','2019-07-18 00:00:00'),
 (102,16,3,3,70,'True','max','2019-07-18 00:00:00','2019-07-18 00:00:00'),
 (103,16,4,10,100,'True','max','2019-07-26 00:00:00','2019-07-26 00:00:00'),
 (104,16,4,7,100,'True','max','2019-07-29 00:00:00','2019-07-29 00:00:00'),
 (105,16,4,9,100,'False','max','2019-08-01 00:00:00','2019-08-01 00:00:00'),
 (106,11,1,1,15,'True','max','2019-10-21 00:00:00','2019-10-21 00:00:00'),
 (107,11,1,2,15,'True','max','2019-10-21 00:00:00','2019-10-21 00:00:00'),
 (108,11,1,3,70,'True','max','2019-10-21 00:00:00','2019-10-21 00:00:00'),
 (109,17,1,1,15,'True','max','2019-10-21 00:00:00','2019-10-21 00:00:00'),
 (110,17,1,2,15,'True','max','2019-10-21 00:00:00','2019-10-21 00:00:00'),
 (111,17,1,3,70,'True','max','2019-10-21 00:00:00','2019-10-21 00:00:00'),
 (112,17,2,1,15,'True','max','2019-10-21 00:00:00','2019-10-21 00:00:00'),
 (113,17,2,2,15,'True','max','2019-10-21 00:00:00','2019-10-21 00:00:00'),
 (114,17,2,3,70,'True','max','2019-10-21 00:00:00','2019-10-21 00:00:00'),
 (115,17,3,1,15,'True','max','2019-10-21 00:00:00','2019-10-22 00:00:00'),
 (116,17,3,2,15,'True','max','2019-10-22 00:00:00','2019-10-22 00:00:00'),
 (117,17,3,3,70,'True','max','2019-10-22 00:00:00','2019-10-22 00:00:00'),
 (118,17,3,9,15,'False','max','2019-10-22 00:00:00','2019-10-22 00:00:00'),
 (119,17,3,7,15,'False','max','2019-10-22 00:00:00','2019-10-22 00:00:00'),
 (120,18,2,1,15,'True','max','2020-02-03 00:00:00','2020-02-03 00:00:00'),
 (121,18,2,2,15,'True','max','2020-02-03 00:00:00','2020-02-03 00:00:00'),
 (122,18,2,3,70,'True','max','2020-02-03 00:00:00','2020-02-03 00:00:00'),
 (123,18,3,1,15,'True','max','2020-02-03 00:00:00','2020-02-03 00:00:00'),
 (124,18,3,2,15,'True','max','2020-02-03 00:00:00','2020-02-03 00:00:00'),
 (125,18,3,3,70,'True','max','2020-02-03 00:00:00','2020-02-03 00:00:00'),
 (126,18,4,1,15,'True','max','2020-02-03 00:00:00','2020-02-03 00:00:00'),
 (127,18,4,2,15,'True','max','2020-02-03 00:00:00','2020-02-03 00:00:00'),
 (128,18,4,3,70,'True','max','2020-02-03 00:00:00','2020-02-03 00:00:00'),
 (129,18,1,1,15,'True','max','2020-02-04 00:00:00','2020-02-04 00:00:00'),
 (130,18,1,2,15,'True','max','2020-02-04 00:00:00','2020-02-04 00:00:00'),
 (131,18,1,3,70,'True','max','2020-02-04 00:00:00','2020-02-04 00:00:00'),
 (132,18,1,10,100,'True','max','2021-01-25 00:00:00','2021-01-25 00:00:00'),
 (133,18,4,10,100,'True','max','2021-01-26 00:00:00','2021-01-26 00:00:00');
/*!40000 ALTER TABLE `examsdoneold` ENABLE KEYS */;


--
-- Definition of table `examsdoneresults`
--

DROP TABLE IF EXISTS `examsdoneresults`;
CREATE TABLE `examsdoneresults` (
  `exid` int(10) unsigned NOT NULL,
  `stno` int(10) unsigned NOT NULL,
  `score` double NOT NULL,
  `remarks` text,
  `outof` double DEFAULT NULL,
  `pnts` double DEFAULT NULL,
  `tpnts` double DEFAULT NULL,
  `GRD` varchar(5) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsdoneresults`
--

/*!40000 ALTER TABLE `examsdoneresults` DISABLE KEYS */;
/*!40000 ALTER TABLE `examsdoneresults` ENABLE KEYS */;


--
-- Definition of table `examsubj`
--

DROP TABLE IF EXISTS `examsubj`;
CREATE TABLE `examsubj` (
  `SID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `exid` int(10) unsigned NOT NULL,
  `SUBID` int(10) unsigned NOT NULL,
  `outof` int(10) unsigned DEFAULT NULL,
  `Paper` varchar(45) DEFAULT NULL,
  `ExamDate` datetime DEFAULT NULL,
  `CSID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`SID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubj`
--

/*!40000 ALTER TABLE `examsubj` DISABLE KEYS */;
/*!40000 ALTER TABLE `examsubj` ENABLE KEYS */;


--
-- Definition of table `examsubj_`
--

DROP TABLE IF EXISTS `examsubj_`;
CREATE TABLE `examsubj_` (
  `SID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `exid` int(10) unsigned NOT NULL,
  `SUBID` int(10) unsigned NOT NULL,
  `outof` int(10) unsigned DEFAULT NULL,
  `Paper` varchar(45) DEFAULT NULL,
  `ExamDate` datetime DEFAULT NULL,
  `CSID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`SID`)
) ENGINE=InnoDB AUTO_INCREMENT=2033 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubj_`
--

/*!40000 ALTER TABLE `examsubj_` DISABLE KEYS */;
INSERT INTO `examsubj_` (`SID`,`exid`,`SUBID`,`outof`,`Paper`,`ExamDate`,`CSID`) VALUES 
 (1999,134,1,100,'ENGLISH','2021-02-01 00:00:00',NULL),
 (2023,134,2,100,'KISWAHILI','2021-02-01 00:00:00',NULL),
 (2024,134,3,100,'MATHEMATICS','2021-02-01 00:00:00',NULL),
 (2025,134,6,100,'CHEMISTRY','2021-02-01 00:00:00',NULL),
 (2026,134,9,100,'CRE','2021-02-01 00:00:00',NULL),
 (2027,134,4,100,'BIOLOGY','2021-02-01 00:00:00',NULL),
 (2028,134,5,100,'PHYSICS','2021-02-01 00:00:00',NULL),
 (2029,134,7,100,'HIST & GOVT','2021-02-01 00:00:00',NULL),
 (2030,134,8,100,'GEOGRAPHY','2021-02-01 00:00:00',NULL),
 (2031,134,10,100,'AGRICULTURE','2021-02-01 00:00:00',NULL),
 (2032,134,11,100,'BUSINESS','2021-02-01 00:00:00',NULL);
/*!40000 ALTER TABLE `examsubj_` ENABLE KEYS */;


--
-- Definition of table `examsubjcomb`
--

DROP TABLE IF EXISTS `examsubjcomb`;
CREATE TABLE `examsubjcomb` (
  `ExStSkId` varchar(45) NOT NULL,
  `Mkst` double DEFAULT NULL,
  `outOft` double DEFAULT NULL,
  `grad` varchar(5) DEFAULT NULL,
  `pnts` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`ExStSkId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubjcomb`
--

/*!40000 ALTER TABLE `examsubjcomb` DISABLE KEYS */;
/*!40000 ALTER TABLE `examsubjcomb` ENABLE KEYS */;


--
-- Definition of table `examsubjcombold`
--

DROP TABLE IF EXISTS `examsubjcombold`;
CREATE TABLE `examsubjcombold` (
  `ExStSkId` varchar(45) NOT NULL,
  `Mkst` double DEFAULT NULL,
  `outOft` double DEFAULT NULL,
  `grad` varchar(5) DEFAULT NULL,
  `pnts` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`ExStSkId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubjcombold`
--

/*!40000 ALTER TABLE `examsubjcombold` DISABLE KEYS */;
/*!40000 ALTER TABLE `examsubjcombold` ENABLE KEYS */;


--
-- Definition of table `examsubjcombrp`
--

DROP TABLE IF EXISTS `examsubjcombrp`;
CREATE TABLE `examsubjcombrp` (
  `TmStSkIdCl` varchar(45) NOT NULL,
  `Mkst` double DEFAULT NULL,
  `outOft` double DEFAULT NULL,
  `grad` varchar(5) DEFAULT NULL,
  `pnts` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`TmStSkIdCl`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubjcombrp`
--

/*!40000 ALTER TABLE `examsubjcombrp` DISABLE KEYS */;
/*!40000 ALTER TABLE `examsubjcombrp` ENABLE KEYS */;


--
-- Definition of table `examsubjcombrpold`
--

DROP TABLE IF EXISTS `examsubjcombrpold`;
CREATE TABLE `examsubjcombrpold` (
  `TmStSkIdCl` varchar(45) NOT NULL,
  `Mkst` double DEFAULT NULL,
  `outOft` double DEFAULT NULL,
  `grad` varchar(5) DEFAULT NULL,
  `pnts` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`TmStSkIdCl`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubjcombrpold`
--

/*!40000 ALTER TABLE `examsubjcombrpold` DISABLE KEYS */;
/*!40000 ALTER TABLE `examsubjcombrpold` ENABLE KEYS */;


--
-- Definition of table `examsubjdet`
--

DROP TABLE IF EXISTS `examsubjdet`;
CREATE TABLE `examsubjdet` (
  `STNO` int(10) unsigned DEFAULT NULL,
  `SUBID` int(10) unsigned DEFAULT NULL,
  `Marks` double DEFAULT NULL,
  `grade` varchar(3) DEFAULT NULL,
  `exId` int(10) unsigned DEFAULT NULL,
  `pnts` int(10) unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubjdet`
--

/*!40000 ALTER TABLE `examsubjdet` DISABLE KEYS */;
/*!40000 ALTER TABLE `examsubjdet` ENABLE KEYS */;


--
-- Definition of table `examsubjdetppr`
--

DROP TABLE IF EXISTS `examsubjdetppr`;
CREATE TABLE `examsubjdetppr` (
  `STNO` int(10) unsigned DEFAULT NULL,
  `SID` int(10) unsigned DEFAULT NULL,
  `Marks` double DEFAULT NULL,
  `grade` varchar(3) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubjdetppr`
--

/*!40000 ALTER TABLE `examsubjdetppr` DISABLE KEYS */;
/*!40000 ALTER TABLE `examsubjdetppr` ENABLE KEYS */;


--
-- Definition of table `examsubjdetrep`
--

DROP TABLE IF EXISTS `examsubjdetrep`;
CREATE TABLE `examsubjdetrep` (
  `STNO` int(10) unsigned DEFAULT NULL,
  `SID` int(10) unsigned DEFAULT NULL,
  `Marks` double DEFAULT NULL,
  `grade` varchar(3) DEFAULT NULL,
  `TId` int(10) unsigned DEFAULT NULL,
  `pnts` int(10) unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubjdetrep`
--

/*!40000 ALTER TABLE `examsubjdetrep` DISABLE KEYS */;
/*!40000 ALTER TABLE `examsubjdetrep` ENABLE KEYS */;


--
-- Definition of table `examsubjhld`
--

DROP TABLE IF EXISTS `examsubjhld`;
CREATE TABLE `examsubjhld` (
  `ExStSub` varchar(45) NOT NULL,
  `Mkst` double DEFAULT NULL,
  `outOft` double DEFAULT NULL,
  `grad` varchar(5) DEFAULT NULL,
  `pnts` int(10) unsigned DEFAULT NULL,
  `cl` int(10) unsigned DEFAULT NULL,
  `subj` int(10) unsigned DEFAULT NULL,
  `st` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`ExStSub`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubjhld`
--

/*!40000 ALTER TABLE `examsubjhld` DISABLE KEYS */;
INSERT INTO `examsubjhld` (`ExStSub`,`Mkst`,`outOft`,`grad`,`pnts`,`cl`,`subj`,`st`) VALUES 
 ('19#5710*10@1',4,30,'E',1,30,10,5710),
 ('19#5710*11@1',11,30,'D',3,30,11,5710),
 ('19#5710*1@1',7,30,'E',1,30,1,5710),
 ('19#5710*2@1',12,30,'D+',4,30,2,5710),
 ('19#5710*3@1',10,100,'E',1,30,3,5710),
 ('19#5710*4@1',9,30,'D',3,30,4,5710),
 ('19#5710*5@1',3,30,'E',1,30,5,5710),
 ('19#5710*6@1',31,100,'D+',4,30,6,5710),
 ('19#5710*7@1',0,30,'E',1,30,7,5710),
 ('19#5710*8@1',0,30,'E',1,30,8,5710),
 ('19#5710*9@1',15,30,'C',6,30,9,5710),
 ('19#5711*10@1',10,30,'D-',2,30,10,5711),
 ('19#5711*11@1',8,30,'E',1,30,11,5711),
 ('19#5711*1@1',14,30,'C-',5,30,1,5711),
 ('19#5711*2@1',20,30,'B',9,30,2,5711),
 ('19#5711*3@1',56,100,'B',9,30,3,5711),
 ('19#5711*4@1',8,30,'D',3,30,4,5711),
 ('19#5711*5@1',10,30,'D+',4,30,5,5711),
 ('19#5711*6@1',51,100,'B-',8,30,6,5711),
 ('19#5711*7@1',12,30,'D+',4,30,7,5711),
 ('19#5711*8@1',13,30,'D+',4,30,8,5711),
 ('19#5711*9@1',23,30,'A-',11,30,9,5711),
 ('19#5712*10@1',3,30,'E',1,30,10,5712),
 ('19#5712*11@1',2,30,'E',1,30,11,5712),
 ('19#5712*1@1',8,30,'E',1,30,1,5712),
 ('19#5712*2@1',16,30,'C',6,30,2,5712),
 ('19#5712*3@1',16,100,'E',1,30,3,5712),
 ('19#5712*4@1',3,30,'E',1,30,4,5712),
 ('19#5712*5@1',5,30,'E',1,30,5,5712),
 ('19#5712*6@1',26,100,'D',3,30,6,5712),
 ('19#5712*7@1',7,30,'E',1,30,7,5712),
 ('19#5712*8@1',4,30,'E',1,30,8,5712),
 ('19#5712*9@1',7,30,'E',1,30,9,5712),
 ('19#5713*10@1',2,30,'E',1,30,10,5713),
 ('19#5713*11@1',4,30,'E',1,30,11,5713),
 ('19#5713*1@1',4,30,'E',1,30,1,5713),
 ('19#5713*2@1',0,30,'E',1,30,2,5713),
 ('19#5713*3@1',5,100,'E',1,30,3,5713),
 ('19#5713*4@1',2,30,'E',1,30,4,5713),
 ('19#5713*5@1',0,30,'E',1,30,5,5713),
 ('19#5713*6@1',3,100,'E',1,30,6,5713),
 ('19#5713*7@1',1,30,'E',1,30,7,5713),
 ('19#5713*8@1',0,30,'E',1,30,8,5713),
 ('19#5713*9@1',2,30,'E',1,30,9,5713),
 ('19#5714*10@1',9,30,'D-',2,30,10,5714),
 ('19#5714*11@1',4,30,'E',1,30,11,5714),
 ('19#5714*1@1',13,30,'D+',4,30,1,5714),
 ('19#5714*2@1',4,30,'E',1,30,2,5714),
 ('19#5714*3@1',8,100,'E',1,30,3,5714),
 ('19#5714*4@1',11,30,'C-',5,30,4,5714),
 ('19#5714*5@1',5,30,'E',1,30,5,5714),
 ('19#5714*6@1',49,100,'C+',7,30,6,5714),
 ('19#5714*7@1',16,30,'C',6,30,7,5714),
 ('19#5714*8@1',6,30,'E',1,30,8,5714),
 ('19#5714*9@1',7,30,'E',1,30,9,5714),
 ('19#5715*10@1',3,30,'E',1,30,10,5715),
 ('19#5715*11@1',0,30,'E',1,30,11,5715),
 ('19#5715*1@1',3,30,'E',1,30,1,5715),
 ('19#5715*2@1',0,30,'E',1,30,2,5715),
 ('19#5715*3@1',5,100,'E',1,30,3,5715),
 ('19#5715*4@1',3,30,'E',1,30,4,5715),
 ('19#5715*5@1',2,30,'E',1,30,5,5715),
 ('19#5715*6@1',14,100,'E',1,30,6,5715),
 ('19#5715*7@1',4,30,'E',1,30,7,5715),
 ('19#5715*8@1',9,30,'D-',2,30,8,5715),
 ('19#5715*9@1',4,30,'E',1,30,9,5715),
 ('19#5716*10@1',15,30,'C',6,30,10,5716),
 ('19#5716*11@1',19,30,'B-',8,30,11,5716),
 ('19#5716*1@1',15,30,'C',6,30,1,5716),
 ('19#5716*2@1',6,30,'E',1,30,2,5716),
 ('19#5716*3@1',69,100,'A-',11,30,3,5716),
 ('19#5716*4@1',17,30,'B',9,30,4,5716),
 ('19#5716*5@1',11,30,'C-',5,30,5,5716),
 ('19#5716*6@1',58,100,'B',9,30,6,5716),
 ('19#5716*7@1',23,30,'A-',11,30,7,5716),
 ('19#5716*8@1',15,30,'C',6,30,8,5716),
 ('19#5716*9@1',21,30,'B+',10,30,9,5716),
 ('19#5717*10@1',3,30,'E',1,30,10,5717),
 ('19#5717*11@1',1,30,'E',1,30,11,5717),
 ('19#5717*1@1',10,30,'D-',2,30,1,5717),
 ('19#5717*2@1',1,30,'E',1,30,2,5717),
 ('19#5717*3@1',8,100,'E',1,30,3,5717),
 ('19#5717*4@1',4,30,'E',1,30,4,5717),
 ('19#5717*5@1',3,30,'E',1,30,5,5717),
 ('19#5717*6@1',28,100,'D',3,30,6,5717),
 ('19#5717*7@1',8,30,'E',1,30,7,5717),
 ('19#5717*8@1',4,30,'E',1,30,8,5717),
 ('19#5717*9@1',3,30,'E',1,30,9,5717),
 ('19#5718*10@1',0,30,'E',1,30,10,5718),
 ('19#5718*11@1',1,30,'E',1,30,11,5718),
 ('19#5718*1@1',4,30,'E',1,30,1,5718),
 ('19#5718*2@1',0,30,'E',1,30,2,5718),
 ('19#5718*3@1',6,100,'E',1,30,3,5718),
 ('19#5718*4@1',2,30,'E',1,30,4,5718),
 ('19#5718*5@1',0,30,'E',1,30,5,5718),
 ('19#5718*6@1',6,100,'E',1,30,6,5718),
 ('19#5718*7@1',6,30,'E',1,30,7,5718),
 ('19#5718*8@1',4,30,'E',1,30,8,5718),
 ('19#5718*9@1',1,30,'E',1,30,9,5718),
 ('19#5719*10@1',0,30,'E',1,30,10,5719),
 ('19#5719*11@1',0,30,'E',1,30,11,5719),
 ('19#5719*1@1',5,30,'E',1,30,1,5719),
 ('19#5719*2@1',0,30,'E',1,30,2,5719),
 ('19#5719*3@1',0,100,'E',1,30,3,5719),
 ('19#5719*4@1',0,30,'E',1,30,4,5719),
 ('19#5719*5@1',0,30,'E',1,30,5,5719),
 ('19#5719*6@1',4,100,'E',1,30,6,5719),
 ('19#5719*7@1',4,30,'E',1,30,7,5719),
 ('19#5719*8@1',0,30,'E',1,30,8,5719),
 ('19#5719*9@1',0,30,'E',1,30,9,5719),
 ('19#5720*10@1',0,30,'E',1,30,10,5720),
 ('19#5720*11@1',0,30,'E',1,30,11,5720),
 ('19#5720*1@1',0,30,'E',1,30,1,5720),
 ('19#5720*2@1',0,30,'E',1,30,2,5720),
 ('19#5720*3@1',0,100,'E',1,30,3,5720),
 ('19#5720*4@1',0,30,'E',1,30,4,5720),
 ('19#5720*5@1',0,30,'E',1,30,5,5720),
 ('19#5720*6@1',0,100,'E',1,30,6,5720),
 ('19#5720*7@1',0,30,'E',1,30,7,5720),
 ('19#5720*8@1',0,30,'E',1,30,8,5720),
 ('19#5720*9@1',0,30,'E',1,30,9,5720),
 ('19#5721*10@1',0,30,'E',1,30,10,5721),
 ('19#5721*11@1',0,30,'E',1,30,11,5721),
 ('19#5721*1@1',0,30,'E',1,30,1,5721),
 ('19#5721*2@1',0,30,'E',1,30,2,5721),
 ('19#5721*3@1',0,100,'E',1,30,3,5721),
 ('19#5721*4@1',0,30,'E',1,30,4,5721),
 ('19#5721*5@1',0,30,'E',1,30,5,5721),
 ('19#5721*6@1',0,100,'E',1,30,6,5721),
 ('19#5721*7@1',0,30,'E',1,30,7,5721),
 ('19#5721*8@1',0,30,'E',1,30,8,5721),
 ('19#5721*9@1',0,30,'E',1,30,9,5721),
 ('19#5722*10@1',2,30,'E',1,30,10,5722),
 ('19#5722*11@1',1,30,'E',1,30,11,5722),
 ('19#5722*1@1',4,30,'E',1,30,1,5722),
 ('19#5722*2@1',9,30,'D-',2,30,2,5722),
 ('19#5722*3@1',9,100,'E',1,30,3,5722),
 ('19#5722*4@1',2,30,'E',1,30,4,5722),
 ('19#5722*5@1',3,30,'E',1,30,5,5722),
 ('19#5722*6@1',16,100,'E',1,30,6,5722),
 ('19#5722*7@1',1,30,'E',1,30,7,5722),
 ('19#5722*8@1',2,30,'E',1,30,8,5722),
 ('19#5722*9@1',1,30,'E',1,30,9,5722),
 ('19#5723*10@1',2,30,'E',1,30,10,5723),
 ('19#5723*11@1',1,30,'E',1,30,11,5723),
 ('19#5723*1@1',3,30,'E',1,30,1,5723),
 ('19#5723*2@1',12,30,'D+',4,30,2,5723),
 ('19#5723*3@1',5,100,'E',1,30,3,5723),
 ('19#5723*4@1',2,30,'E',1,30,4,5723),
 ('19#5723*5@1',0,30,'E',1,30,5,5723),
 ('19#5723*6@1',13,100,'E',1,30,6,5723),
 ('19#5723*7@1',0,30,'E',1,30,7,5723),
 ('19#5723*8@1',4,30,'E',1,30,8,5723),
 ('19#5723*9@1',2,30,'E',1,30,9,5723),
 ('19#5724*10@1',9,30,'D-',2,30,10,5724),
 ('19#5724*11@1',3,30,'E',1,30,11,5724),
 ('19#5724*1@1',3,30,'E',1,30,1,5724),
 ('19#5724*2@1',13,30,'D+',4,30,2,5724),
 ('19#5724*3@1',0,100,'E',1,30,3,5724),
 ('19#5724*4@1',6,30,'E',1,30,4,5724),
 ('19#5724*5@1',5,30,'E',1,30,5,5724),
 ('19#5724*6@1',38,100,'C-',5,30,6,5724),
 ('19#5724*7@1',12,30,'D+',4,30,7,5724),
 ('19#5724*8@1',5,30,'E',1,30,8,5724),
 ('19#5724*9@1',3,30,'E',1,30,9,5724),
 ('19#5725*10@1',7,30,'E',1,30,10,5725),
 ('19#5725*11@1',6,30,'E',1,30,11,5725),
 ('19#5725*1@1',6,30,'E',1,30,1,5725),
 ('19#5725*2@1',12,30,'D+',4,30,2,5725),
 ('19#5725*3@1',30,100,'D',3,30,3,5725),
 ('19#5725*4@1',8,30,'D',3,30,4,5725),
 ('19#5725*5@1',4,30,'E',1,30,5,5725),
 ('19#5725*6@1',43,100,'C',6,30,6,5725),
 ('19#5725*7@1',16,30,'C',6,30,7,5725),
 ('19#5725*8@1',6,30,'E',1,30,8,5725),
 ('19#5725*9@1',12,30,'D+',4,30,9,5725),
 ('19#5726*10@1',0,30,'E',1,30,10,5726),
 ('19#5726*11@1',0,30,'E',1,30,11,5726),
 ('19#5726*1@1',4,30,'E',1,30,1,5726),
 ('19#5726*2@1',0,30,'E',1,30,2,5726),
 ('19#5726*3@1',4,100,'E',1,30,3,5726),
 ('19#5726*4@1',0,30,'E',1,30,4,5726),
 ('19#5726*5@1',0,30,'E',1,30,5,5726),
 ('19#5726*6@1',8,100,'E',1,30,6,5726),
 ('19#5726*7@1',1,30,'E',1,30,7,5726),
 ('19#5726*8@1',0,30,'E',1,30,8,5726),
 ('19#5726*9@1',0,30,'E',1,30,9,5726),
 ('19#5727*10@1',0,30,'E',1,30,10,5727),
 ('19#5727*11@1',0,30,'E',1,30,11,5727),
 ('19#5727*1@1',0,30,'E',1,30,1,5727),
 ('19#5727*2@1',0,30,'E',1,30,2,5727),
 ('19#5727*3@1',0,100,'E',1,30,3,5727),
 ('19#5727*4@1',0,30,'E',1,30,4,5727),
 ('19#5727*5@1',0,30,'E',1,30,5,5727),
 ('19#5727*6@1',0,100,'E',1,30,6,5727),
 ('19#5727*7@1',0,30,'E',1,30,7,5727),
 ('19#5727*8@1',0,30,'E',1,30,8,5727),
 ('19#5727*9@1',0,30,'E',1,30,9,5727),
 ('19#5728*10@1',15,30,'C',6,30,10,5728),
 ('19#5728*11@1',11,30,'D',3,30,11,5728),
 ('19#5728*1@1',18,30,'B-',8,30,1,5728),
 ('19#5728*2@1',14,30,'C-',5,30,2,5728),
 ('19#5728*3@1',43,100,'C',6,30,3,5728),
 ('19#5728*4@1',20,30,'A-',11,30,4,5728),
 ('19#5728*5@1',5,30,'E',1,30,5,5728),
 ('19#5728*6@1',68,100,'A-',11,30,6,5728),
 ('19#5728*7@1',27,30,'A',12,30,7,5728),
 ('19#5728*8@1',22,30,'B+',10,30,8,5728),
 ('19#5728*9@1',15,30,'C',6,30,9,5728),
 ('19#5729*10@1',15,30,'C',6,30,10,5729),
 ('19#5729*11@1',0,30,'E',1,30,11,5729),
 ('19#5729*1@1',16,30,'C',6,30,1,5729),
 ('19#5729*2@1',16,30,'C',6,30,2,5729),
 ('19#5729*3@1',12,100,'E',1,30,3,5729),
 ('19#5729*4@1',5,30,'E',1,30,4,5729),
 ('19#5729*5@1',2,30,'E',1,30,5,5729),
 ('19#5729*6@1',34,100,'D+',4,30,6,5729),
 ('19#5729*7@1',19,30,'B-',8,30,7,5729),
 ('19#5729*8@1',5,30,'E',1,30,8,5729),
 ('19#5729*9@1',5,30,'E',1,30,9,5729),
 ('19#5730*10@1',17,30,'C+',7,30,10,5730),
 ('19#5730*11@1',23,30,'A-',11,30,11,5730),
 ('19#5730*1@1',15,30,'C',6,30,1,5730),
 ('19#5730*2@1',28,30,'A',12,30,2,5730),
 ('19#5730*3@1',64,100,'B+',10,30,3,5730),
 ('19#5730*4@1',24,30,'A',12,30,4,5730),
 ('19#5730*5@1',18,30,'B',9,30,5,5730),
 ('19#5730*6@1',89,100,'A',12,30,6,5730),
 ('19#5730*7@1',28,30,'A',12,30,7,5730),
 ('19#5730*8@1',25,30,'A',12,30,8,5730),
 ('19#5730*9@1',29,30,'A',12,30,9,5730),
 ('19#5731*10@1',10,30,'D-',2,30,10,5731),
 ('19#5731*11@1',6,30,'E',1,30,11,5731),
 ('19#5731*1@1',4,30,'E',1,30,1,5731),
 ('19#5731*2@1',13,30,'D+',4,30,2,5731),
 ('19#5731*3@1',23,100,'D-',2,30,3,5731),
 ('19#5731*4@1',5,30,'E',1,30,4,5731),
 ('19#5731*5@1',2,30,'E',1,30,5,5731),
 ('19#5731*6@1',22,100,'D-',2,30,6,5731),
 ('19#5731*7@1',17,30,'C+',7,30,7,5731),
 ('19#5731*8@1',11,30,'D',3,30,8,5731),
 ('19#5731*9@1',4,30,'E',1,30,9,5731),
 ('19#5732*10@1',3,30,'E',1,30,10,5732),
 ('19#5732*11@1',5,30,'E',1,30,11,5732),
 ('19#5732*1@1',13,30,'D+',4,30,1,5732),
 ('19#5732*2@1',23,30,'A-',11,30,2,5732),
 ('19#5732*3@1',23,100,'D-',2,30,3,5732),
 ('19#5732*4@1',12,30,'C-',5,30,4,5732),
 ('19#5732*5@1',5,30,'E',1,30,5,5732),
 ('19#5732*6@1',36,100,'C-',5,30,6,5732),
 ('19#5732*7@1',17,30,'C+',7,30,7,5732),
 ('19#5732*8@1',6,30,'E',1,30,8,5732),
 ('19#5732*9@1',13,30,'D+',4,30,9,5732),
 ('19#5733*10@1',2,30,'E',1,30,10,5733),
 ('19#5733*11@1',4,30,'E',1,30,11,5733),
 ('19#5733*1@1',6,30,'E',1,30,1,5733),
 ('19#5733*2@1',9,30,'D-',2,30,2,5733),
 ('19#5733*3@1',10,100,'E',1,30,3,5733),
 ('19#5733*4@1',1,30,'E',1,30,4,5733),
 ('19#5733*5@1',5,30,'E',1,30,5,5733),
 ('19#5733*6@1',14,100,'E',1,30,6,5733),
 ('19#5733*7@1',2,30,'E',1,30,7,5733),
 ('19#5733*8@1',4,30,'E',1,30,8,5733),
 ('19#5733*9@1',2,30,'E',1,30,9,5733),
 ('19#5734*10@1',3,30,'E',1,30,10,5734),
 ('19#5734*11@1',2,30,'E',1,30,11,5734),
 ('19#5734*1@1',9,30,'D-',2,30,1,5734),
 ('19#5734*2@1',12,30,'D+',4,30,2,5734),
 ('19#5734*3@1',11,100,'E',1,30,3,5734),
 ('19#5734*4@1',4,30,'E',1,30,4,5734),
 ('19#5734*5@1',4,30,'E',1,30,5,5734),
 ('19#5734*6@1',22,100,'D-',2,30,6,5734),
 ('19#5734*7@1',12,30,'D+',4,30,7,5734),
 ('19#5734*8@1',5,30,'E',1,30,8,5734),
 ('19#5734*9@1',5,30,'E',1,30,9,5734),
 ('19#5735*10@1',2,30,'E',1,30,10,5735),
 ('19#5735*11@1',2,30,'E',1,30,11,5735),
 ('19#5735*1@1',10,30,'D-',2,30,1,5735),
 ('19#5735*2@1',13,30,'D+',4,30,2,5735),
 ('19#5735*3@1',11,100,'E',1,30,3,5735),
 ('19#5735*4@1',4,30,'E',1,30,4,5735),
 ('19#5735*5@1',1,30,'E',1,30,5,5735),
 ('19#5735*6@1',24,100,'D-',2,30,6,5735),
 ('19#5735*7@1',3,30,'E',1,30,7,5735),
 ('19#5735*8@1',6,30,'E',1,30,8,5735),
 ('19#5735*9@1',4,30,'E',1,30,9,5735),
 ('19#5736*10@1',8,30,'E',1,30,10,5736),
 ('19#5736*11@1',1,30,'E',1,30,11,5736),
 ('19#5736*1@1',4,30,'E',1,30,1,5736),
 ('19#5736*2@1',14,30,'C-',5,30,2,5736),
 ('19#5736*3@1',17,100,'E',1,30,3,5736),
 ('19#5736*4@1',9,30,'D',3,30,4,5736),
 ('19#5736*5@1',4,30,'E',1,30,5,5736),
 ('19#5736*6@1',30,100,'D',3,30,6,5736),
 ('19#5736*7@1',18,30,'B-',8,30,7,5736),
 ('19#5736*8@1',8,30,'E',1,30,8,5736),
 ('19#5736*9@1',4,30,'E',1,30,9,5736),
 ('19#5737*10@1',0,30,'E',1,30,10,5737),
 ('19#5737*11@1',0,30,'E',1,30,11,5737),
 ('19#5737*1@1',0,30,'E',1,30,1,5737),
 ('19#5737*2@1',0,30,'E',1,30,2,5737),
 ('19#5737*3@1',0,100,'E',1,30,3,5737),
 ('19#5737*4@1',0,30,'E',1,30,4,5737),
 ('19#5737*5@1',0,30,'E',1,30,5,5737),
 ('19#5737*6@1',0,100,'E',1,30,6,5737),
 ('19#5737*7@1',0,30,'E',1,30,7,5737),
 ('19#5737*8@1',0,30,'E',1,30,8,5737),
 ('19#5737*9@1',0,30,'E',1,30,9,5737),
 ('19#5738*10@1',0,30,'E',1,30,10,5738),
 ('19#5738*11@1',0,30,'E',1,30,11,5738),
 ('19#5738*1@1',0,30,'E',1,30,1,5738),
 ('19#5738*2@1',0,30,'E',1,30,2,5738),
 ('19#5738*3@1',0,100,'E',1,30,3,5738),
 ('19#5738*4@1',0,30,'E',1,30,4,5738),
 ('19#5738*5@1',0,30,'E',1,30,5,5738),
 ('19#5738*6@1',0,100,'E',1,30,6,5738),
 ('19#5738*7@1',0,30,'E',1,30,7,5738),
 ('19#5738*8@1',0,30,'E',1,30,8,5738),
 ('19#5738*9@1',0,30,'E',1,30,9,5738),
 ('19#5739*10@1',2,30,'E',1,30,10,5739),
 ('19#5739*11@1',0,30,'E',1,30,11,5739),
 ('19#5739*1@1',10,30,'D-',2,30,1,5739),
 ('19#5739*2@1',14,30,'C-',5,30,2,5739),
 ('19#5739*3@1',13,100,'E',1,30,3,5739),
 ('19#5739*4@1',2,30,'E',1,30,4,5739),
 ('19#5739*5@1',1,30,'E',1,30,5,5739),
 ('19#5739*6@1',7,100,'E',1,30,6,5739),
 ('19#5739*7@1',5,30,'E',1,30,7,5739),
 ('19#5739*8@1',0,30,'E',1,30,8,5739),
 ('19#5739*9@1',1,30,'E',1,30,9,5739),
 ('19#5740*10@1',9,30,'D-',2,30,10,5740),
 ('19#5740*11@1',5,30,'E',1,30,11,5740),
 ('19#5740*1@1',15,30,'C',6,30,1,5740),
 ('19#5740*2@1',22,30,'B+',10,30,2,5740),
 ('19#5740*3@1',52,100,'B-',8,30,3,5740),
 ('19#5740*4@1',19,30,'B+',10,30,4,5740),
 ('19#5740*5@1',7,30,'D-',2,30,5,5740),
 ('19#5740*6@1',45,100,'C',6,30,6,5740),
 ('19#5740*7@1',20,30,'B',9,30,7,5740),
 ('19#5740*8@1',8,30,'E',1,30,8,5740),
 ('19#5740*9@1',17,30,'C+',7,30,9,5740),
 ('19#5741*10@1',2,30,'E',1,30,10,5741),
 ('19#5741*11@1',4,30,'E',1,30,11,5741),
 ('19#5741*1@1',2,30,'E',1,30,1,5741),
 ('19#5741*2@1',6,30,'E',1,30,2,5741),
 ('19#5741*3@1',2,100,'E',1,30,3,5741),
 ('19#5741*4@1',2,30,'E',1,30,4,5741),
 ('19#5741*5@1',2,30,'E',1,30,5,5741),
 ('19#5741*6@1',12,100,'E',1,30,6,5741),
 ('19#5741*7@1',2,30,'E',1,30,7,5741),
 ('19#5741*8@1',0,30,'E',1,30,8,5741),
 ('19#5741*9@1',0,30,'E',1,30,9,5741),
 ('19#5742*10@1',8,30,'E',1,30,10,5742),
 ('19#5742*11@1',17,30,'C+',7,30,11,5742),
 ('19#5742*1@1',13,30,'D+',4,30,1,5742),
 ('19#5742*2@1',21,30,'B+',10,30,2,5742),
 ('19#5742*3@1',34,100,'D+',4,30,3,5742),
 ('19#5742*4@1',15,30,'C+',7,30,4,5742),
 ('19#5742*5@1',10,30,'D+',4,30,5,5742),
 ('19#5742*6@1',58,100,'B',9,30,6,5742),
 ('19#5742*7@1',23,30,'A-',11,30,7,5742),
 ('19#5742*8@1',12,30,'D+',4,30,8,5742),
 ('19#5742*9@1',11,30,'D',3,30,9,5742),
 ('19#5743*10@1',22,30,'B+',10,30,10,5743),
 ('19#5743*11@1',12,30,'D+',4,30,11,5743),
 ('19#5743*1@1',14,30,'C-',5,30,1,5743),
 ('19#5743*2@1',19,30,'B-',8,30,2,5743),
 ('19#5743*3@1',70,100,'A-',11,30,3,5743),
 ('19#5743*4@1',18,30,'B',9,30,4,5743),
 ('19#5743*5@1',15,30,'C+',7,30,5,5743),
 ('19#5743*6@1',79,100,'A',12,30,6,5743),
 ('19#5743*7@1',26,30,'A',12,30,7,5743),
 ('19#5743*8@1',26,30,'A',12,30,8,5743),
 ('19#5743*9@1',19,30,'B-',8,30,9,5743),
 ('19#5744*10@1',2,30,'E',1,30,10,5744),
 ('19#5744*11@1',1,30,'E',1,30,11,5744),
 ('19#5744*1@1',8,30,'E',1,30,1,5744),
 ('19#5744*2@1',0,30,'E',1,30,2,5744),
 ('19#5744*3@1',8,100,'E',1,30,3,5744),
 ('19#5744*4@1',3,30,'E',1,30,4,5744),
 ('19#5744*5@1',3,30,'E',1,30,5,5744),
 ('19#5744*6@1',5,100,'E',1,30,6,5744),
 ('19#5744*7@1',5,30,'E',1,30,7,5744),
 ('19#5744*8@1',5,30,'E',1,30,8,5744),
 ('19#5744*9@1',2,30,'E',1,30,9,5744),
 ('19#5745*10@1',3,30,'E',1,30,10,5745),
 ('19#5745*11@1',0,30,'E',1,30,11,5745),
 ('19#5745*1@1',0,30,'E',1,30,1,5745),
 ('19#5745*2@1',10,30,'D-',2,30,2,5745),
 ('19#5745*3@1',4,100,'E',1,30,3,5745),
 ('19#5745*4@1',1,30,'E',1,30,4,5745),
 ('19#5745*5@1',0,30,'E',1,30,5,5745),
 ('19#5745*6@1',5,100,'E',1,30,6,5745),
 ('19#5745*7@1',0,30,'E',1,30,7,5745),
 ('19#5745*8@1',0,30,'E',1,30,8,5745),
 ('19#5745*9@1',3,30,'E',1,30,9,5745),
 ('19#5746*10@1',5,30,'E',1,30,10,5746),
 ('19#5746*11@1',2,30,'E',1,30,11,5746),
 ('19#5746*1@1',4,30,'E',1,30,1,5746),
 ('19#5746*2@1',15,30,'C',6,30,2,5746),
 ('19#5746*3@1',20,100,'E',1,30,3,5746),
 ('19#5746*4@1',4,30,'E',1,30,4,5746),
 ('19#5746*5@1',7,30,'D-',2,30,5,5746),
 ('19#5746*6@1',6,100,'E',1,30,6,5746),
 ('19#5746*7@1',10,30,'D-',2,30,7,5746),
 ('19#5746*8@1',6,30,'E',1,30,8,5746),
 ('19#5746*9@1',5,30,'E',1,30,9,5746),
 ('19#5747*10@1',2,30,'E',1,30,10,5747),
 ('19#5747*11@1',1,30,'E',1,30,11,5747),
 ('19#5747*1@1',5,30,'E',1,30,1,5747),
 ('19#5747*2@1',10,30,'D-',2,30,2,5747),
 ('19#5747*3@1',8,100,'E',1,30,3,5747),
 ('19#5747*4@1',3,30,'E',1,30,4,5747),
 ('19#5747*5@1',2,30,'E',1,30,5,5747),
 ('19#5747*6@1',7,100,'E',1,30,6,5747),
 ('19#5747*7@1',6,30,'E',1,30,7,5747),
 ('19#5747*8@1',2,30,'E',1,30,8,5747),
 ('19#5747*9@1',9,30,'D-',2,30,9,5747),
 ('19#5748*10@1',5,30,'E',1,30,10,5748),
 ('19#5748*11@1',3,30,'E',1,30,11,5748),
 ('19#5748*1@1',9,30,'D-',2,30,1,5748),
 ('19#5748*2@1',17,30,'C+',7,30,2,5748),
 ('19#5748*3@1',12,100,'E',1,30,3,5748),
 ('19#5748*4@1',4,30,'E',1,30,4,5748),
 ('19#5748*5@1',6,30,'E',1,30,5,5748),
 ('19#5748*6@1',23,100,'D-',2,30,6,5748),
 ('19#5748*7@1',16,30,'C',6,30,7,5748),
 ('19#5748*8@1',1,30,'E',1,30,8,5748),
 ('19#5748*9@1',15,30,'C',6,30,9,5748),
 ('19#5749*10@1',2,30,'E',1,30,10,5749),
 ('19#5749*11@1',2,30,'E',1,30,11,5749),
 ('19#5749*1@1',6,30,'E',1,30,1,5749),
 ('19#5749*2@1',17,30,'C+',7,30,2,5749),
 ('19#5749*3@1',7,100,'E',1,30,3,5749),
 ('19#5749*4@1',1,30,'E',1,30,4,5749),
 ('19#5749*5@1',1,30,'E',1,30,5,5749),
 ('19#5749*6@1',9,100,'E',1,30,6,5749),
 ('19#5749*7@1',1,30,'E',1,30,7,5749),
 ('19#5749*8@1',3,30,'E',1,30,8,5749),
 ('19#5749*9@1',6,30,'E',1,30,9,5749),
 ('19#5750*10@1',5,30,'E',1,30,10,5750),
 ('19#5750*11@1',2,30,'E',1,30,11,5750),
 ('19#5750*1@1',8,30,'E',1,30,1,5750),
 ('19#5750*2@1',11,30,'D',3,30,2,5750),
 ('19#5750*3@1',8,100,'E',1,30,3,5750),
 ('19#5750*4@1',2,30,'E',1,30,4,5750),
 ('19#5750*5@1',4,30,'E',1,30,5,5750),
 ('19#5750*6@1',10,100,'E',1,30,6,5750),
 ('19#5750*7@1',5,30,'E',1,30,7,5750),
 ('19#5750*8@1',6,30,'E',1,30,8,5750),
 ('19#5750*9@1',4,30,'E',1,30,9,5750),
 ('19#5751*10@1',6,30,'E',1,30,10,5751),
 ('19#5751*11@1',4,30,'E',1,30,11,5751),
 ('19#5751*1@1',12,30,'D+',4,30,1,5751),
 ('19#5751*2@1',12,30,'D+',4,30,2,5751),
 ('19#5751*3@1',48,100,'C+',7,30,3,5751),
 ('19#5751*4@1',5,30,'E',1,30,4,5751),
 ('19#5751*5@1',3,30,'E',1,30,5,5751),
 ('19#5751*6@1',49,100,'C+',7,30,6,5751),
 ('19#5751*7@1',3,30,'E',1,30,7,5751),
 ('19#5751*8@1',8,30,'E',1,30,8,5751),
 ('19#5751*9@1',12,30,'D+',4,30,9,5751),
 ('19#5752*10@1',3,30,'E',1,30,10,5752),
 ('19#5752*11@1',0,30,'E',1,30,11,5752),
 ('19#5752*1@1',5,30,'E',1,30,1,5752),
 ('19#5752*2@1',0,30,'E',1,30,2,5752),
 ('19#5752*3@1',6,100,'E',1,30,3,5752),
 ('19#5752*4@1',1,30,'E',1,30,4,5752),
 ('19#5752*5@1',3,30,'E',1,30,5,5752),
 ('19#5752*6@1',5,100,'E',1,30,6,5752),
 ('19#5752*7@1',5,30,'E',1,30,7,5752),
 ('19#5752*8@1',4,30,'E',1,30,8,5752),
 ('19#5752*9@1',3,30,'E',1,30,9,5752),
 ('19#5753*10@1',16,30,'C',6,18,10,5753),
 ('19#5753*11@1',20,30,'B',9,18,11,5753),
 ('19#5753*1@1',9,30,'D-',2,18,1,5753),
 ('19#5753*2@1',29,30,'A',12,18,2,5753),
 ('19#5753*3@1',45,100,'C',6,18,3,5753),
 ('19#5753*4@1',10,30,'D+',4,18,4,5753),
 ('19#5753*5@1',20,100,'E',1,18,5,5753),
 ('19#5753*6@1',19,30,'B+',10,18,6,5753),
 ('19#5753*7@1',19,30,'B-',8,18,7,5753),
 ('19#5753*8@1',8,30,'E',1,18,8,5753),
 ('19#5753*9@1',68,100,'B',9,18,9,5753),
 ('19#5754*10@1',2,30,'E',1,18,10,5754),
 ('19#5754*11@1',2,30,'E',1,18,11,5754),
 ('19#5754*1@1',5,30,'E',1,18,1,5754),
 ('19#5754*2@1',13,30,'D+',4,18,2,5754),
 ('19#5754*3@1',4,100,'E',1,18,3,5754),
 ('19#5754*4@1',2,30,'E',1,18,4,5754),
 ('19#5754*5@1',0,100,'E',1,18,5,5754),
 ('19#5754*6@1',1,30,'E',1,18,6,5754),
 ('19#5754*7@1',3,30,'E',1,18,7,5754),
 ('19#5754*8@1',4,30,'E',1,18,8,5754),
 ('19#5754*9@1',12,100,'E',1,18,9,5754),
 ('19#5755*10@1',2,30,'E',1,18,10,5755),
 ('19#5755*11@1',1,30,'E',1,18,11,5755),
 ('19#5755*1@1',0,30,'E',1,18,1,5755),
 ('19#5755*2@1',7,30,'E',1,18,2,5755),
 ('19#5755*3@1',4,100,'E',1,18,3,5755),
 ('19#5755*4@1',1,30,'E',1,18,4,5755),
 ('19#5755*5@1',1,100,'E',1,18,5,5755),
 ('19#5755*6@1',1,30,'E',1,18,6,5755),
 ('19#5755*7@1',1,30,'E',1,18,7,5755),
 ('19#5755*8@1',4,30,'E',1,18,8,5755),
 ('19#5755*9@1',6,100,'E',1,18,9,5755),
 ('19#5756*10@1',2,30,'E',1,18,10,5756),
 ('19#5756*11@1',4,30,'E',1,18,11,5756),
 ('19#5756*1@1',0,30,'E',1,18,1,5756),
 ('19#5756*2@1',10,30,'D-',2,18,2,5756),
 ('19#5756*3@1',22,100,'D-',2,18,3,5756),
 ('19#5756*4@1',4,30,'E',1,18,4,5756),
 ('19#5756*5@1',17,100,'E',1,18,5,5756),
 ('19#5756*6@1',1,30,'E',1,18,6,5756),
 ('19#5756*7@1',8,30,'E',1,18,7,5756),
 ('19#5756*8@1',4,30,'E',1,18,8,5756),
 ('19#5756*9@1',32,100,'D-',2,18,9,5756),
 ('19#5757*10@1',3,30,'E',1,18,10,5757),
 ('19#5757*11@1',1,30,'E',1,18,11,5757),
 ('19#5757*1@1',9,30,'D-',2,18,1,5757),
 ('19#5757*2@1',19,30,'B-',8,18,2,5757),
 ('19#5757*3@1',25,100,'D-',2,18,3,5757),
 ('19#5757*4@1',5,30,'E',1,18,4,5757),
 ('19#5757*5@1',14,100,'E',1,18,5,5757),
 ('19#5757*6@1',7,30,'D-',2,18,6,5757),
 ('19#5757*7@1',7,30,'E',1,18,7,5757),
 ('19#5757*8@1',17,30,'C+',7,18,8,5757),
 ('19#5757*9@1',32,100,'D-',2,18,9,5757),
 ('19#5758*10@1',3,30,'E',1,18,10,5758),
 ('19#5758*11@1',6,30,'E',1,18,11,5758),
 ('19#5758*1@1',4,30,'E',1,18,1,5758),
 ('19#5758*2@1',13,30,'D+',4,18,2,5758),
 ('19#5758*3@1',26,100,'D',3,18,3,5758),
 ('19#5758*4@1',2,30,'E',1,18,4,5758),
 ('19#5758*5@1',5,100,'E',1,18,5,5758),
 ('19#5758*6@1',5,30,'E',1,18,6,5758),
 ('19#5758*7@1',6,30,'E',1,18,7,5758),
 ('19#5758*8@1',6,30,'E',1,18,8,5758),
 ('19#5758*9@1',5,100,'E',1,18,9,5758),
 ('19#5759*10@1',0,30,'E',1,18,10,5759),
 ('19#5759*11@1',0,30,'E',1,18,11,5759),
 ('19#5759*1@1',0,30,'E',1,18,1,5759),
 ('19#5759*2@1',14,30,'C-',5,18,2,5759),
 ('19#5759*3@1',0,100,'E',1,18,3,5759),
 ('19#5759*4@1',0,30,'E',1,18,4,5759),
 ('19#5759*5@1',0,100,'E',1,18,5,5759),
 ('19#5759*6@1',0,30,'E',1,18,6,5759),
 ('19#5759*7@1',0,30,'E',1,18,7,5759),
 ('19#5759*8@1',0,30,'E',1,18,8,5759),
 ('19#5759*9@1',0,100,'E',1,18,9,5759),
 ('19#5760*10@1',8,30,'E',1,18,10,5760),
 ('19#5760*11@1',12,30,'D+',4,18,11,5760),
 ('19#5760*1@1',11,30,'D',3,18,1,5760),
 ('19#5760*2@1',23,30,'A-',11,18,2,5760),
 ('19#5760*3@1',66,100,'A-',11,18,3,5760),
 ('19#5760*4@1',8,30,'D',3,18,4,5760),
 ('19#5760*5@1',24,100,'D-',2,18,5,5760),
 ('19#5760*6@1',20,30,'A-',11,18,6,5760),
 ('19#5760*7@1',11,30,'D',3,18,7,5760),
 ('19#5760*8@1',17,30,'C+',7,18,8,5760),
 ('19#5760*9@1',83,100,'A',12,18,9,5760),
 ('19#5761*10@1',2,30,'E',1,18,10,5761),
 ('19#5761*11@1',0,30,'E',1,18,11,5761),
 ('19#5761*1@1',4,30,'E',1,18,1,5761),
 ('19#5761*2@1',6,30,'E',1,18,2,5761),
 ('19#5761*3@1',11,100,'E',1,18,3,5761),
 ('19#5761*4@1',2,30,'E',1,18,4,5761),
 ('19#5761*5@1',0,100,'E',1,18,5,5761),
 ('19#5761*6@1',4,30,'E',1,18,6,5761),
 ('19#5761*7@1',2,30,'E',1,18,7,5761),
 ('19#5761*8@1',1,30,'E',1,18,8,5761),
 ('19#5761*9@1',11,100,'E',1,18,9,5761),
 ('19#5762*10@1',8,30,'E',1,18,10,5762),
 ('19#5762*11@1',14,30,'C-',5,18,11,5762),
 ('19#5762*1@1',7,30,'E',1,18,1,5762),
 ('19#5762*2@1',11,30,'D',3,18,2,5762),
 ('19#5762*3@1',47,100,'C+',7,18,3,5762),
 ('19#5762*4@1',4,30,'E',1,18,4,5762),
 ('19#5762*5@1',16,100,'E',1,18,5,5762),
 ('19#5762*6@1',10,30,'D+',4,18,6,5762),
 ('19#5762*7@1',7,30,'E',1,18,7,5762),
 ('19#5762*8@1',6,30,'E',1,18,8,5762),
 ('19#5762*9@1',57,100,'C+',7,18,9,5762),
 ('19#5763*10@1',2,30,'E',1,18,10,5763),
 ('19#5763*11@1',5,30,'E',1,18,11,5763),
 ('19#5763*1@1',8,30,'E',1,18,1,5763),
 ('19#5763*2@1',14,30,'C-',5,18,2,5763),
 ('19#5763*3@1',21,100,'D-',2,18,3,5763),
 ('19#5763*4@1',2,30,'E',1,18,4,5763),
 ('19#5763*5@1',8,100,'E',1,18,5,5763),
 ('19#5763*6@1',3,30,'E',1,18,6,5763),
 ('19#5763*7@1',2,30,'E',1,18,7,5763),
 ('19#5763*8@1',2,30,'E',1,18,8,5763),
 ('19#5763*9@1',23,100,'E',1,18,9,5763),
 ('19#5764*10@1',0,30,'E',1,18,10,5764),
 ('19#5764*11@1',0,30,'E',1,18,11,5764),
 ('19#5764*1@1',0,30,'E',1,18,1,5764),
 ('19#5764*2@1',0,30,'E',1,18,2,5764),
 ('19#5764*3@1',0,100,'E',1,18,3,5764),
 ('19#5764*4@1',0,30,'E',1,18,4,5764),
 ('19#5764*5@1',0,100,'E',1,18,5,5764),
 ('19#5764*6@1',0,30,'E',1,18,6,5764),
 ('19#5764*7@1',0,30,'E',1,18,7,5764),
 ('19#5764*8@1',2,30,'E',1,18,8,5764),
 ('19#5764*9@1',0,100,'E',1,18,9,5764),
 ('19#5765*10@1',2,30,'E',1,18,10,5765),
 ('19#5765*11@1',9,30,'D-',2,18,11,5765),
 ('19#5765*1@1',15,30,'C',6,18,1,5765),
 ('19#5765*2@1',18,30,'B-',8,18,2,5765),
 ('19#5765*3@1',7,100,'E',1,18,3,5765),
 ('19#5765*4@1',2,30,'E',1,18,4,5765),
 ('19#5765*5@1',4,100,'E',1,18,5,5765),
 ('19#5765*6@1',4,30,'E',1,18,6,5765),
 ('19#5765*7@1',6,30,'E',1,18,7,5765),
 ('19#5765*8@1',3,30,'E',1,18,8,5765),
 ('19#5765*9@1',31,100,'D-',2,18,9,5765),
 ('19#5766*10@1',5,30,'E',1,18,10,5766),
 ('19#5766*11@1',4,30,'E',1,18,11,5766),
 ('19#5766*1@1',11,30,'D',3,18,1,5766),
 ('19#5766*2@1',19,30,'B-',8,18,2,5766),
 ('19#5766*3@1',25,100,'D-',2,18,3,5766),
 ('19#5766*4@1',8,30,'D',3,18,4,5766),
 ('19#5766*5@1',14,100,'E',1,18,5,5766),
 ('19#5766*6@1',10,30,'D+',4,18,6,5766),
 ('19#5766*7@1',9,30,'D-',2,18,7,5766),
 ('19#5766*8@1',5,30,'E',1,18,8,5766),
 ('19#5766*9@1',57,100,'C+',7,18,9,5766),
 ('19#5767*10@1',4,30,'E',1,18,10,5767),
 ('19#5767*11@1',12,30,'D+',4,18,11,5767),
 ('19#5767*1@1',8,30,'E',1,18,1,5767),
 ('19#5767*2@1',21,30,'B+',10,18,2,5767),
 ('19#5767*3@1',15,100,'E',1,18,3,5767),
 ('19#5767*4@1',3,30,'E',1,18,4,5767),
 ('19#5767*5@1',14,100,'E',1,18,5,5767),
 ('19#5767*6@1',10,30,'D+',4,18,6,5767),
 ('19#5767*7@1',5,30,'E',1,18,7,5767),
 ('19#5767*8@1',8,30,'E',1,18,8,5767),
 ('19#5767*9@1',50,100,'C',6,18,9,5767),
 ('19#5768*10@1',13,30,'D+',4,18,10,5768),
 ('19#5768*11@1',10,30,'D-',2,18,11,5768),
 ('19#5768*1@1',5,30,'E',1,18,1,5768),
 ('19#5768*2@1',24,30,'A',12,18,2,5768),
 ('19#5768*3@1',62,100,'B+',10,18,3,5768),
 ('19#5768*4@1',8,30,'D',3,18,4,5768),
 ('19#5768*5@1',17,100,'E',1,18,5,5768),
 ('19#5768*6@1',19,30,'B+',10,18,6,5768),
 ('19#5768*7@1',12,30,'D+',4,18,7,5768),
 ('19#5768*8@1',15,30,'C',6,18,8,5768),
 ('19#5768*9@1',68,100,'B',9,18,9,5768),
 ('19#5769*10@1',4,30,'E',1,18,10,5769),
 ('19#5769*11@1',8,30,'E',1,18,11,5769),
 ('19#5769*1@1',8,30,'E',1,18,1,5769),
 ('19#5769*2@1',16,30,'C',6,18,2,5769),
 ('19#5769*3@1',6,100,'E',1,18,3,5769),
 ('19#5769*4@1',2,30,'E',1,18,4,5769),
 ('19#5769*5@1',9,100,'E',1,18,5,5769),
 ('19#5769*6@1',6,30,'E',1,18,6,5769),
 ('19#5769*7@1',6,30,'E',1,18,7,5769),
 ('19#5769*8@1',8,30,'E',1,18,8,5769),
 ('19#5769*9@1',46,100,'C-',5,18,9,5769),
 ('19#5770*10@1',12,30,'D+',4,18,10,5770),
 ('19#5770*11@1',8,30,'E',1,18,11,5770),
 ('19#5770*1@1',8,30,'E',1,18,1,5770),
 ('19#5770*2@1',25,30,'A',12,18,2,5770),
 ('19#5770*3@1',20,100,'E',1,18,3,5770),
 ('19#5770*4@1',4,30,'E',1,18,4,5770),
 ('19#5770*5@1',11,100,'E',1,18,5,5770),
 ('19#5770*6@1',8,30,'D',3,18,6,5770),
 ('19#5770*7@1',12,30,'D+',4,18,7,5770),
 ('19#5770*8@1',14,30,'C-',5,18,8,5770),
 ('19#5770*9@1',63,100,'B-',8,18,9,5770),
 ('19#5771*10@1',2,30,'E',1,18,10,5771),
 ('19#5771*11@1',7,30,'E',1,18,11,5771),
 ('19#5771*1@1',10,30,'D-',2,18,1,5771),
 ('19#5771*2@1',21,30,'B+',10,18,2,5771),
 ('19#5771*3@1',15,100,'E',1,18,3,5771),
 ('19#5771*4@1',3,30,'E',1,18,4,5771),
 ('19#5771*5@1',5,100,'E',1,18,5,5771),
 ('19#5771*6@1',5,30,'E',1,18,6,5771),
 ('19#5771*7@1',7,30,'E',1,18,7,5771),
 ('19#5771*8@1',5,30,'E',1,18,8,5771),
 ('19#5771*9@1',45,100,'C-',5,18,9,5771),
 ('19#5772*10@1',2,30,'E',1,18,10,5772),
 ('19#5772*11@1',11,30,'D',3,18,11,5772),
 ('19#5772*1@1',13,30,'D+',4,18,1,5772),
 ('19#5772*2@1',14,30,'C-',5,18,2,5772),
 ('19#5772*3@1',14,100,'E',1,18,3,5772),
 ('19#5772*4@1',2,30,'E',1,18,4,5772),
 ('19#5772*5@1',12,100,'E',1,18,5,5772),
 ('19#5772*6@1',3,30,'E',1,18,6,5772),
 ('19#5772*7@1',4,30,'E',1,18,7,5772),
 ('19#5772*8@1',2,30,'E',1,18,8,5772),
 ('19#5772*9@1',30,100,'D-',2,18,9,5772),
 ('19#5773*10@1',12,30,'D+',4,18,10,5773),
 ('19#5773*11@1',4,30,'E',1,18,11,5773),
 ('19#5773*1@1',4,30,'E',1,18,1,5773),
 ('19#5773*2@1',17,30,'C+',7,18,2,5773),
 ('19#5773*3@1',43,100,'C',6,18,3,5773),
 ('19#5773*4@1',7,30,'D-',2,18,4,5773),
 ('19#5773*5@1',19,100,'E',1,18,5,5773),
 ('19#5773*6@1',13,30,'C',6,18,6,5773),
 ('19#5773*7@1',9,30,'D-',2,18,7,5773),
 ('19#5773*8@1',14,30,'C-',5,18,8,5773),
 ('19#5773*9@1',33,100,'D-',2,18,9,5773),
 ('19#5774*10@1',4,30,'E',1,18,10,5774),
 ('19#5774*11@1',5,30,'E',1,18,11,5774),
 ('19#5774*1@1',10,30,'D-',2,18,1,5774),
 ('19#5774*2@1',19,30,'B-',8,18,2,5774),
 ('19#5774*3@1',42,100,'C',6,18,3,5774),
 ('19#5774*4@1',5,30,'E',1,18,4,5774),
 ('19#5774*5@1',13,100,'E',1,18,5,5774),
 ('19#5774*6@1',7,30,'D-',2,18,6,5774),
 ('19#5774*7@1',7,30,'E',1,18,7,5774),
 ('19#5774*8@1',4,30,'E',1,18,8,5774),
 ('19#5774*9@1',58,100,'C+',7,18,9,5774),
 ('19#5775*10@1',2,30,'E',1,18,10,5775),
 ('19#5775*11@1',0,30,'E',1,18,11,5775),
 ('19#5775*1@1',9,30,'D-',2,18,1,5775),
 ('19#5775*2@1',9,30,'D-',2,18,2,5775),
 ('19#5775*3@1',6,100,'E',1,18,3,5775),
 ('19#5775*4@1',3,30,'E',1,18,4,5775),
 ('19#5775*5@1',2,100,'E',1,18,5,5775),
 ('19#5775*6@1',4,30,'E',1,18,6,5775),
 ('19#5775*7@1',2,30,'E',1,18,7,5775),
 ('19#5775*8@1',2,30,'E',1,18,8,5775),
 ('19#5775*9@1',14,100,'E',1,18,9,5775),
 ('19#5776*10@1',7,30,'E',1,18,10,5776),
 ('19#5776*11@1',15,30,'C',6,18,11,5776),
 ('19#5776*1@1',11,30,'D',3,18,1,5776),
 ('19#5776*2@1',25,30,'A',12,18,2,5776),
 ('19#5776*3@1',36,100,'C-',5,18,3,5776),
 ('19#5776*4@1',4,30,'E',1,18,4,5776),
 ('19#5776*5@1',9,100,'E',1,18,5,5776),
 ('19#5776*6@1',12,30,'C-',5,18,6,5776),
 ('19#5776*7@1',11,30,'D',3,18,7,5776),
 ('19#5776*8@1',10,30,'D-',2,18,8,5776),
 ('19#5776*9@1',44,100,'D+',4,18,9,5776),
 ('19#5777*10@1',10,30,'D-',2,18,10,5777),
 ('19#5777*11@1',9,30,'D-',2,18,11,5777),
 ('19#5777*1@1',12,30,'D+',4,18,1,5777),
 ('19#5777*2@1',25,30,'A',12,18,2,5777),
 ('19#5777*3@1',67,100,'A-',11,18,3,5777),
 ('19#5777*4@1',6,30,'E',1,18,4,5777),
 ('19#5777*5@1',34,100,'D+',4,18,5,5777),
 ('19#5777*6@1',18,30,'B',9,18,6,5777),
 ('19#5777*7@1',12,30,'D+',4,18,7,5777),
 ('19#5777*8@1',12,30,'D+',4,18,8,5777),
 ('19#5777*9@1',57,100,'C+',7,18,9,5777),
 ('19#5778*10@1',1,30,'E',1,18,10,5778),
 ('19#5778*11@1',0,30,'E',1,18,11,5778),
 ('19#5778*1@1',4,30,'E',1,18,1,5778),
 ('19#5778*2@1',1,30,'E',1,18,2,5778),
 ('19#5778*3@1',0,100,'E',1,18,3,5778),
 ('19#5778*4@1',4,30,'E',1,18,4,5778),
 ('19#5778*5@1',3,100,'E',1,18,5,5778),
 ('19#5778*6@1',4,30,'E',1,18,6,5778),
 ('19#5778*7@1',3,30,'E',1,18,7,5778),
 ('19#5778*8@1',3,30,'E',1,18,8,5778),
 ('19#5778*9@1',3,100,'E',1,18,9,5778),
 ('19#5779*10@1',5,30,'E',1,18,10,5779),
 ('19#5779*11@1',2,30,'E',1,18,11,5779),
 ('19#5779*1@1',4,30,'E',1,18,1,5779),
 ('19#5779*2@1',11,30,'D',3,18,2,5779),
 ('19#5779*3@1',17,100,'E',1,18,3,5779),
 ('19#5779*4@1',0,30,'E',1,18,4,5779),
 ('19#5779*5@1',7,100,'E',1,18,5,5779),
 ('19#5779*6@1',6,30,'E',1,18,6,5779),
 ('19#5779*7@1',0,30,'E',1,18,7,5779),
 ('19#5779*8@1',3,30,'E',1,18,8,5779),
 ('19#5779*9@1',32,100,'D-',2,18,9,5779),
 ('19#5780*10@1',7,30,'E',1,18,10,5780),
 ('19#5780*11@1',7,30,'E',1,18,11,5780),
 ('19#5780*1@1',8,30,'E',1,18,1,5780),
 ('19#5780*2@1',20,30,'B',9,18,2,5780),
 ('19#5780*3@1',13,100,'E',1,18,3,5780),
 ('19#5780*4@1',5,30,'E',1,18,4,5780),
 ('19#5780*5@1',2,100,'E',1,18,5,5780),
 ('19#5780*6@1',13,30,'C',6,18,6,5780),
 ('19#5780*7@1',6,30,'E',1,18,7,5780),
 ('19#5780*8@1',5,30,'E',1,18,8,5780),
 ('19#5780*9@1',49,100,'C-',5,18,9,5780),
 ('19#5781*10@1',11,30,'D',3,18,10,5781),
 ('19#5781*11@1',12,30,'D+',4,18,11,5781),
 ('19#5781*1@1',12,30,'D+',4,18,1,5781),
 ('19#5781*2@1',15,30,'C',6,18,2,5781),
 ('19#5781*3@1',21,100,'D-',2,18,3,5781),
 ('19#5781*4@1',5,30,'E',1,18,4,5781),
 ('19#5781*5@1',8,100,'E',1,18,5,5781),
 ('19#5781*6@1',10,30,'D+',4,18,6,5781),
 ('19#5781*7@1',9,30,'D-',2,18,7,5781),
 ('19#5781*8@1',11,30,'D',3,18,8,5781),
 ('19#5781*9@1',48,100,'C-',5,18,9,5781),
 ('19#5782*10@1',2,30,'E',1,18,10,5782),
 ('19#5782*11@1',5,30,'E',1,18,11,5782),
 ('19#5782*1@1',10,30,'D-',2,18,1,5782),
 ('19#5782*2@1',13,30,'D+',4,18,2,5782),
 ('19#5782*3@1',14,100,'E',1,18,3,5782),
 ('19#5782*4@1',5,30,'E',1,18,4,5782),
 ('19#5782*5@1',7,100,'E',1,18,5,5782),
 ('19#5782*6@1',4,30,'E',1,18,6,5782),
 ('19#5782*7@1',1,30,'E',1,18,7,5782),
 ('19#5782*8@1',11,30,'D',3,18,8,5782),
 ('19#5782*9@1',30,100,'D-',2,18,9,5782),
 ('19#5783*10@1',2,30,'E',1,18,10,5783),
 ('19#5783*11@1',0,30,'E',1,18,11,5783),
 ('19#5783*1@1',3,30,'E',1,18,1,5783),
 ('19#5783*2@1',8,30,'E',1,18,2,5783),
 ('19#5783*3@1',13,100,'E',1,18,3,5783),
 ('19#5783*4@1',2,30,'E',1,18,4,5783),
 ('19#5783*5@1',2,100,'E',1,18,5,5783),
 ('19#5783*6@1',0,30,'E',1,18,6,5783),
 ('19#5783*7@1',3,30,'E',1,18,7,5783),
 ('19#5783*8@1',2,30,'E',1,18,8,5783),
 ('19#5783*9@1',22,100,'E',1,18,9,5783),
 ('19#5784*10@1',2,30,'E',1,18,10,5784),
 ('19#5784*11@1',1,30,'E',1,18,11,5784),
 ('19#5784*1@1',8,30,'E',1,18,1,5784),
 ('19#5784*2@1',13,30,'D+',4,18,2,5784),
 ('19#5784*3@1',3,100,'E',1,18,3,5784),
 ('19#5784*4@1',2,30,'E',1,18,4,5784),
 ('19#5784*5@1',5,100,'E',1,18,5,5784),
 ('19#5784*6@1',4,30,'E',1,18,6,5784),
 ('19#5784*7@1',1,30,'E',1,18,7,5784),
 ('19#5784*8@1',2,30,'E',1,18,8,5784),
 ('19#5784*9@1',14,100,'E',1,18,9,5784),
 ('19#5785*10@1',5,30,'E',1,18,10,5785),
 ('19#5785*11@1',4,30,'E',1,18,11,5785),
 ('19#5785*1@1',9,30,'D-',2,18,1,5785),
 ('19#5785*2@1',21,30,'B+',10,18,2,5785),
 ('19#5785*3@1',17,100,'E',1,18,3,5785),
 ('19#5785*4@1',2,30,'E',1,18,4,5785),
 ('19#5785*5@1',21,100,'D-',2,18,5,5785),
 ('19#5785*6@1',9,30,'D',3,18,6,5785),
 ('19#5785*7@1',6,30,'E',1,18,7,5785),
 ('19#5785*8@1',9,30,'D-',2,18,8,5785),
 ('19#5785*9@1',43,100,'D+',4,18,9,5785),
 ('19#5786*10@1',5,30,'E',1,18,10,5786),
 ('19#5786*11@1',13,30,'D+',4,18,11,5786),
 ('19#5786*1@1',17,30,'C+',7,18,1,5786),
 ('19#5786*2@1',16,30,'C',6,18,2,5786),
 ('19#5786*3@1',17,100,'E',1,18,3,5786),
 ('19#5786*4@1',6,30,'E',1,18,4,5786),
 ('19#5786*5@1',11,100,'E',1,18,5,5786),
 ('19#5786*6@1',9,30,'D',3,18,6,5786),
 ('19#5786*7@1',7,30,'E',1,18,7,5786),
 ('19#5786*8@1',7,30,'E',1,18,8,5786),
 ('19#5786*9@1',60,100,'B-',8,18,9,5786),
 ('19#5787*10@1',15,30,'C',6,18,10,5787),
 ('19#5787*11@1',13,30,'D+',4,18,11,5787),
 ('19#5787*1@1',6,30,'E',1,18,1,5787),
 ('19#5787*2@1',17,30,'C+',7,18,2,5787),
 ('19#5787*3@1',12,100,'E',1,18,3,5787),
 ('19#5787*4@1',16,30,'B-',8,18,4,5787),
 ('19#5787*5@1',12,100,'E',1,18,5,5787),
 ('19#5787*6@1',14,30,'C+',7,18,6,5787),
 ('19#5787*7@1',12,30,'D+',4,18,7,5787),
 ('19#5787*8@1',6,30,'E',1,18,8,5787),
 ('19#5787*9@1',15,100,'E',1,18,9,5787),
 ('19#5788*10@1',7,30,'E',1,18,10,5788),
 ('19#5788*11@1',9,30,'D-',2,18,11,5788),
 ('19#5788*1@1',6,30,'E',1,18,1,5788),
 ('19#5788*2@1',14,30,'C-',5,18,2,5788),
 ('19#5788*3@1',21,100,'D-',2,18,3,5788),
 ('19#5788*4@1',4,30,'E',1,18,4,5788),
 ('19#5788*5@1',10,100,'E',1,18,5,5788),
 ('19#5788*6@1',12,30,'C-',5,18,6,5788),
 ('19#5788*7@1',7,30,'E',1,18,7,5788),
 ('19#5788*8@1',7,30,'E',1,18,8,5788),
 ('19#5788*9@1',30,100,'D-',2,18,9,5788),
 ('19#5789*10@1',2,30,'E',1,18,10,5789),
 ('19#5789*11@1',3,30,'E',1,18,11,5789),
 ('19#5789*1@1',12,30,'D+',4,18,1,5789),
 ('19#5789*2@1',11,30,'D',3,18,2,5789),
 ('19#5789*3@1',8,100,'E',1,18,3,5789),
 ('19#5789*4@1',1,30,'E',1,18,4,5789),
 ('19#5789*5@1',2,100,'E',1,18,5,5789),
 ('19#5789*6@1',2,30,'E',1,18,6,5789),
 ('19#5789*7@1',0,30,'E',1,18,7,5789),
 ('19#5789*8@1',9,30,'D-',2,18,8,5789),
 ('19#5789*9@1',31,100,'D-',2,18,9,5789),
 ('19#5790*10@1',8,30,'E',1,18,10,5790),
 ('19#5790*11@1',8,30,'E',1,18,11,5790),
 ('19#5790*1@1',8,30,'E',1,18,1,5790),
 ('19#5790*2@1',15,30,'C',6,18,2,5790),
 ('19#5790*3@1',26,100,'D',3,18,3,5790),
 ('19#5790*4@1',11,30,'C-',5,18,4,5790),
 ('19#5790*5@1',11,100,'E',1,18,5,5790),
 ('19#5790*6@1',10,30,'D+',4,18,6,5790),
 ('19#5790*7@1',11,30,'D',3,18,7,5790),
 ('19#5790*8@1',10,30,'D-',2,18,8,5790),
 ('19#5790*9@1',60,100,'B-',8,18,9,5790),
 ('19#5791*10@1',4,30,'E',1,22,10,5791),
 ('19#5791*11@1',8,30,'E',1,22,11,5791),
 ('19#5791*1@1',11,30,'D',3,22,1,5791),
 ('19#5791*2@1',11,30,'D',3,22,2,5791),
 ('19#5791*3@1',7,100,'E',1,22,3,5791),
 ('19#5791*4@1',10,30,'D+',4,22,4,5791),
 ('19#5791*5@1',8,30,'D',3,22,5,5791),
 ('19#5791*6@1',13,30,'C',6,22,6,5791),
 ('19#5791*7@1',7,100,'E',1,22,7,5791),
 ('19#5791*8@1',7,30,'E',1,22,8,5791),
 ('19#5791*9@1',17,30,'C+',7,22,9,5791),
 ('19#5792*10@1',11,30,'D',3,22,10,5792),
 ('19#5792*11@1',7,30,'E',1,22,11,5792),
 ('19#5792*1@1',17,30,'C+',7,22,1,5792),
 ('19#5792*2@1',16,30,'C',6,22,2,5792),
 ('19#5792*3@1',7,100,'E',1,22,3,5792),
 ('19#5792*4@1',14,30,'C+',7,22,4,5792),
 ('19#5792*5@1',7,30,'D-',2,22,5,5792),
 ('19#5792*6@1',20,30,'A-',11,22,6,5792),
 ('19#5792*7@1',57,100,'C+',7,22,7,5792),
 ('19#5792*8@1',13,30,'D+',4,22,8,5792),
 ('19#5792*9@1',27,30,'A',12,22,9,5792),
 ('19#5793*10@1',1,30,'E',1,22,10,5793),
 ('19#5793*11@1',11,30,'D',3,22,11,5793),
 ('19#5793*1@1',13,30,'D+',4,22,1,5793),
 ('19#5793*2@1',7,30,'E',1,22,2,5793),
 ('19#5793*3@1',6,100,'E',1,22,3,5793),
 ('19#5793*4@1',6,30,'E',1,22,4,5793),
 ('19#5793*5@1',5,30,'E',1,22,5,5793),
 ('19#5793*6@1',10,30,'D+',4,22,6,5793),
 ('19#5793*7@1',13,100,'E',1,22,7,5793),
 ('19#5793*8@1',10,30,'D-',2,22,8,5793),
 ('19#5793*9@1',15,30,'C',6,22,9,5793),
 ('19#5794*10@1',0,30,'E',1,22,10,5794),
 ('19#5794*11@1',0,30,'E',1,22,11,5794),
 ('19#5794*1@1',0,30,'E',1,22,1,5794),
 ('19#5794*2@1',0,30,'E',1,22,2,5794),
 ('19#5794*3@1',0,100,'E',1,22,3,5794),
 ('19#5794*4@1',0,30,'E',1,22,4,5794),
 ('19#5794*5@1',0,30,'E',1,22,5,5794),
 ('19#5794*6@1',0,30,'E',1,22,6,5794),
 ('19#5794*7@1',0,100,'E',1,22,7,5794),
 ('19#5794*8@1',0,30,'E',1,22,8,5794),
 ('19#5794*9@1',26,30,'A',12,22,9,5794),
 ('19#5795*10@1',0,30,'E',1,22,10,5795),
 ('19#5795*11@1',2,30,'E',1,22,11,5795),
 ('19#5795*1@1',0,30,'E',1,22,1,5795),
 ('19#5795*2@1',0,30,'E',1,22,2,5795),
 ('19#5795*3@1',0,100,'E',1,22,3,5795),
 ('19#5795*4@1',0,30,'E',1,22,4,5795),
 ('19#5795*5@1',1,30,'E',1,22,5,5795),
 ('19#5795*6@1',0,30,'E',1,22,6,5795),
 ('19#5795*7@1',10,100,'E',1,22,7,5795),
 ('19#5795*8@1',0,30,'E',1,22,8,5795),
 ('19#5795*9@1',21,30,'B+',10,22,9,5795),
 ('19#5796*10@1',3,30,'E',1,22,10,5796),
 ('19#5796*11@1',6,30,'E',1,22,11,5796),
 ('19#5796*1@1',15,30,'C',6,22,1,5796),
 ('19#5796*2@1',12,30,'D+',4,22,2,5796),
 ('19#5796*3@1',16,100,'E',1,22,3,5796),
 ('19#5796*4@1',11,30,'C-',5,22,4,5796),
 ('19#5796*5@1',5,30,'E',1,22,5,5796),
 ('19#5796*6@1',14,30,'C+',7,22,6,5796),
 ('19#5796*7@1',17,100,'E',1,22,7,5796),
 ('19#5796*8@1',5,30,'E',1,22,8,5796),
 ('19#5796*9@1',18,30,'B-',8,22,9,5796),
 ('19#5797*10@1',10,30,'D-',2,22,10,5797),
 ('19#5797*11@1',19,30,'B-',8,22,11,5797),
 ('19#5797*1@1',17,30,'C+',7,22,1,5797),
 ('19#5797*2@1',16,30,'C',6,22,2,5797),
 ('19#5797*3@1',6,100,'E',1,22,3,5797),
 ('19#5797*4@1',17,30,'B',9,22,4,5797),
 ('19#5797*5@1',11,30,'C-',5,22,5,5797),
 ('19#5797*6@1',16,30,'B-',8,22,6,5797),
 ('19#5797*7@1',38,100,'D',3,22,7,5797),
 ('19#5797*8@1',14,30,'C-',5,22,8,5797),
 ('19#5797*9@1',26,30,'A',12,22,9,5797),
 ('19#5798*10@1',17,30,'C+',7,22,10,5798),
 ('19#5798*11@1',20,30,'B',9,22,11,5798),
 ('19#5798*1@1',23,30,'A-',11,22,1,5798),
 ('19#5798*2@1',24,30,'A',12,22,2,5798),
 ('19#5798*3@1',15,100,'E',1,22,3,5798),
 ('19#5798*4@1',25,30,'A',12,22,4,5798),
 ('19#5798*5@1',16,30,'B-',8,22,5,5798),
 ('19#5798*6@1',24,30,'A',12,22,6,5798),
 ('19#5798*7@1',66,100,'B',9,22,7,5798),
 ('19#5798*8@1',23,30,'A-',11,22,8,5798),
 ('19#5798*9@1',30,30,'A',12,22,9,5798),
 ('19#5799*10@1',0,30,'E',1,22,10,5799),
 ('19#5799*11@1',3,30,'E',1,22,11,5799),
 ('19#5799*1@1',9,30,'D-',2,22,1,5799),
 ('19#5799*2@1',6,30,'E',1,22,2,5799),
 ('19#5799*3@1',1,100,'E',1,22,3,5799),
 ('19#5799*4@1',4,30,'E',1,22,4,5799),
 ('19#5799*5@1',3,30,'E',1,22,5,5799),
 ('19#5799*6@1',1,30,'E',1,22,6,5799),
 ('19#5799*7@1',2,100,'E',1,22,7,5799),
 ('19#5799*8@1',3,30,'E',1,22,8,5799),
 ('19#5799*9@1',5,30,'E',1,22,9,5799),
 ('19#5800*10@1',11,30,'D',3,22,10,5800),
 ('19#5800*11@1',20,30,'B',9,22,11,5800),
 ('19#5800*1@1',10,30,'D-',2,22,1,5800),
 ('19#5800*2@1',7,30,'E',1,22,2,5800),
 ('19#5800*3@1',4,100,'E',1,22,3,5800),
 ('19#5800*4@1',16,30,'B-',8,22,4,5800),
 ('19#5800*5@1',4,30,'E',1,22,5,5800),
 ('19#5800*6@1',7,30,'D-',2,22,6,5800),
 ('19#5800*7@1',34,100,'D-',2,22,7,5800),
 ('19#5800*8@1',9,30,'D-',2,22,8,5800),
 ('19#5800*9@1',17,30,'C+',7,22,9,5800),
 ('19#5801*10@1',11,30,'D',3,22,10,5801),
 ('19#5801*11@1',14,30,'C-',5,22,11,5801),
 ('19#5801*1@1',11,30,'D',3,22,1,5801),
 ('19#5801*2@1',9,30,'D-',2,22,2,5801),
 ('19#5801*3@1',8,100,'E',1,22,3,5801),
 ('19#5801*4@1',10,30,'D+',4,22,4,5801),
 ('19#5801*5@1',10,30,'D+',4,22,5,5801),
 ('19#5801*6@1',9,30,'D',3,22,6,5801),
 ('19#5801*7@1',29,100,'E',1,22,7,5801),
 ('19#5801*8@1',6,30,'E',1,22,8,5801),
 ('19#5801*9@1',15,30,'C',6,22,9,5801),
 ('19#5802*10@1',0,30,'E',1,22,10,5802),
 ('19#5802*11@1',5,30,'E',1,22,11,5802),
 ('19#5802*1@1',7,30,'E',1,22,1,5802),
 ('19#5802*2@1',10,30,'D-',2,22,2,5802),
 ('19#5802*3@1',3,100,'E',1,22,3,5802),
 ('19#5802*4@1',4,30,'E',1,22,4,5802),
 ('19#5802*5@1',3,30,'E',1,22,5,5802),
 ('19#5802*6@1',5,30,'E',1,22,6,5802),
 ('19#5802*7@1',3,100,'E',1,22,7,5802),
 ('19#5802*8@1',3,30,'E',1,22,8,5802),
 ('19#5802*9@1',7,30,'E',1,22,9,5802),
 ('19#5803*10@1',5,30,'E',1,22,10,5803),
 ('19#5803*11@1',11,30,'D',3,22,11,5803),
 ('19#5803*1@1',8,30,'E',1,22,1,5803),
 ('19#5803*2@1',9,30,'D-',2,22,2,5803),
 ('19#5803*3@1',4,100,'E',1,22,3,5803),
 ('19#5803*4@1',6,30,'E',1,22,4,5803),
 ('19#5803*5@1',4,30,'E',1,22,5,5803),
 ('19#5803*6@1',9,30,'D',3,22,6,5803),
 ('19#5803*7@1',19,100,'E',1,22,7,5803),
 ('19#5803*8@1',9,30,'D-',2,22,8,5803),
 ('19#5803*9@1',19,30,'B-',8,22,9,5803),
 ('19#5804*10@1',9,30,'D-',2,22,10,5804),
 ('19#5804*11@1',18,30,'B-',8,22,11,5804),
 ('19#5804*1@1',14,30,'C-',5,22,1,5804),
 ('19#5804*2@1',15,30,'C',6,22,2,5804),
 ('19#5804*3@1',9,100,'E',1,22,3,5804),
 ('19#5804*4@1',6,30,'E',1,22,4,5804),
 ('19#5804*5@1',7,30,'D-',2,22,5,5804),
 ('19#5804*6@1',16,30,'B-',8,22,6,5804),
 ('19#5804*7@1',21,100,'E',1,22,7,5804),
 ('19#5804*8@1',11,30,'D',3,22,8,5804),
 ('19#5804*9@1',22,30,'B+',10,22,9,5804),
 ('19#5805*10@1',9,30,'D-',2,22,10,5805),
 ('19#5805*11@1',21,30,'B+',10,22,11,5805),
 ('19#5805*1@1',16,30,'C',6,22,1,5805),
 ('19#5805*2@1',16,30,'C',6,22,2,5805),
 ('19#5805*3@1',21,100,'D-',2,22,3,5805),
 ('19#5805*4@1',17,30,'B',9,22,4,5805),
 ('19#5805*5@1',14,30,'C+',7,22,5,5805),
 ('19#5805*6@1',20,30,'A-',11,22,6,5805),
 ('19#5805*7@1',13,100,'E',1,22,7,5805),
 ('19#5805*8@1',10,30,'D-',2,22,8,5805),
 ('19#5805*9@1',29,30,'A',12,22,9,5805),
 ('19#5806*10@1',0,30,'E',1,22,10,5806),
 ('19#5806*11@1',0,30,'E',1,22,11,5806),
 ('19#5806*1@1',0,30,'E',1,22,1,5806),
 ('19#5806*2@1',0,30,'E',1,22,2,5806),
 ('19#5806*3@1',0,100,'E',1,22,3,5806),
 ('19#5806*4@1',0,30,'E',1,22,4,5806),
 ('19#5806*5@1',1,30,'E',1,22,5,5806),
 ('19#5806*6@1',2,30,'E',1,22,6,5806),
 ('19#5806*7@1',35,100,'D',3,22,7,5806),
 ('19#5806*8@1',5,30,'E',1,22,8,5806),
 ('19#5806*9@1',0,30,'E',1,22,9,5806),
 ('19#5807*10@1',8,30,'E',1,22,10,5807),
 ('19#5807*11@1',11,30,'D',3,22,11,5807),
 ('19#5807*1@1',13,30,'D+',4,22,1,5807),
 ('19#5807*2@1',10,30,'D-',2,22,2,5807),
 ('19#5807*3@1',8,100,'E',1,22,3,5807),
 ('19#5807*4@1',4,30,'E',1,22,4,5807),
 ('19#5807*5@1',10,30,'D+',4,22,5,5807),
 ('19#5807*6@1',12,30,'C-',5,22,6,5807),
 ('19#5807*7@1',19,100,'E',1,22,7,5807),
 ('19#5807*8@1',6,30,'E',1,22,8,5807),
 ('19#5807*9@1',20,30,'B',9,22,9,5807),
 ('19#5808*10@1',7,30,'E',1,22,10,5808),
 ('19#5808*11@1',12,30,'D+',4,22,11,5808),
 ('19#5808*1@1',15,30,'C',6,22,1,5808),
 ('19#5808*2@1',9,30,'D-',2,22,2,5808),
 ('19#5808*3@1',5,100,'E',1,22,3,5808),
 ('19#5808*4@1',11,30,'C-',5,22,4,5808),
 ('19#5808*5@1',6,30,'E',1,22,5,5808),
 ('19#5808*6@1',15,30,'C+',7,22,6,5808),
 ('19#5808*7@1',17,100,'E',1,22,7,5808),
 ('19#5808*8@1',8,30,'E',1,22,8,5808),
 ('19#5808*9@1',17,30,'C+',7,22,9,5808),
 ('19#5809*10@1',3,30,'E',1,22,10,5809),
 ('19#5809*11@1',11,30,'D',3,22,11,5809),
 ('19#5809*1@1',11,30,'D',3,22,1,5809),
 ('19#5809*2@1',11,30,'D',3,22,2,5809),
 ('19#5809*3@1',3,100,'E',1,22,3,5809),
 ('19#5809*4@1',5,30,'E',1,22,4,5809),
 ('19#5809*5@1',6,30,'E',1,22,5,5809),
 ('19#5809*6@1',13,30,'C',6,22,6,5809),
 ('19#5809*7@1',13,100,'E',1,22,7,5809),
 ('19#5809*8@1',8,30,'E',1,22,8,5809),
 ('19#5809*9@1',17,30,'C+',7,22,9,5809),
 ('19#5810*10@1',4,30,'E',1,22,10,5810),
 ('19#5810*11@1',6,30,'E',1,22,11,5810),
 ('19#5810*1@1',12,30,'D+',4,22,1,5810),
 ('19#5810*2@1',14,30,'C-',5,22,2,5810),
 ('19#5810*3@1',2,100,'E',1,22,3,5810),
 ('19#5810*4@1',5,30,'E',1,22,4,5810),
 ('19#5810*5@1',4,30,'E',1,22,5,5810),
 ('19#5810*6@1',18,30,'B',9,22,6,5810),
 ('19#5810*7@1',15,100,'E',1,22,7,5810),
 ('19#5810*8@1',6,30,'E',1,22,8,5810),
 ('19#5810*9@1',18,30,'B-',8,22,9,5810),
 ('19#5811*10@1',3,30,'E',1,22,10,5811),
 ('19#5811*11@1',3,30,'E',1,22,11,5811),
 ('19#5811*1@1',3,30,'E',1,22,1,5811),
 ('19#5811*2@1',0,30,'E',1,22,2,5811),
 ('19#5811*3@1',2,100,'E',1,22,3,5811),
 ('19#5811*4@1',2,30,'E',1,22,4,5811),
 ('19#5811*5@1',4,30,'E',1,22,5,5811),
 ('19#5811*6@1',1,30,'E',1,22,6,5811),
 ('19#5811*7@1',2,100,'E',1,22,7,5811),
 ('19#5811*8@1',2,30,'E',1,22,8,5811),
 ('19#5811*9@1',7,30,'E',1,22,9,5811),
 ('19#5812*10@1',0,30,'E',1,22,10,5812),
 ('19#5812*11@1',0,30,'E',1,22,11,5812),
 ('19#5812*1@1',0,30,'E',1,22,1,5812),
 ('19#5812*2@1',0,30,'E',1,22,2,5812),
 ('19#5812*3@1',0,100,'E',1,22,3,5812),
 ('19#5812*4@1',0,15,'E',1,22,4,5812),
 ('19#5812*5@1',0,30,'E',1,22,5,5812),
 ('19#5812*6@1',0,30,'E',1,22,6,5812),
 ('19#5812*7@1',3,100,'E',1,22,7,5812),
 ('19#5812*8@1',0,30,'E',1,22,8,5812),
 ('19#5812*9@1',29,30,'A',12,22,9,5812),
 ('19#5813*10@1',8,30,'E',1,22,10,5813),
 ('19#5813*11@1',16,30,'C',6,22,11,5813),
 ('19#5813*1@1',12,30,'D+',4,22,1,5813),
 ('19#5813*2@1',13,30,'D+',4,22,2,5813),
 ('19#5813*3@1',12,100,'E',1,22,3,5813),
 ('19#5813*4@1',12,30,'C-',5,22,4,5813),
 ('19#5813*5@1',11,30,'C-',5,22,5,5813),
 ('19#5813*6@1',19,30,'B+',10,22,6,5813),
 ('19#5813*7@1',40,100,'D+',4,22,7,5813),
 ('19#5813*8@1',11,30,'D',3,22,8,5813),
 ('19#5813*9@1',21,30,'B+',10,22,9,5813),
 ('19#5814*10@1',2,30,'E',1,22,10,5814),
 ('19#5814*11@1',3,30,'E',1,22,11,5814),
 ('19#5814*1@1',10,30,'D-',2,22,1,5814),
 ('19#5814*2@1',10,30,'D-',2,22,2,5814),
 ('19#5814*3@1',5,100,'E',1,22,3,5814),
 ('19#5814*4@1',3,30,'E',1,22,4,5814),
 ('19#5814*5@1',3,30,'E',1,22,5,5814),
 ('19#5814*6@1',11,30,'C-',5,22,6,5814),
 ('19#5814*7@1',13,100,'E',1,22,7,5814),
 ('19#5814*8@1',4,30,'E',1,22,8,5814),
 ('19#5814*9@1',7,30,'E',1,22,9,5814),
 ('19#5815*10@1',8,30,'E',1,22,10,5815),
 ('19#5815*11@1',5,30,'E',1,22,11,5815),
 ('19#5815*1@1',11,30,'D',3,22,1,5815),
 ('19#5815*2@1',9,30,'D-',2,22,2,5815),
 ('19#5815*3@1',8,100,'E',1,22,3,5815),
 ('19#5815*4@1',5,30,'E',1,22,4,5815),
 ('19#5815*5@1',4,30,'E',1,22,5,5815),
 ('19#5815*6@1',13,30,'C',6,22,6,5815),
 ('19#5815*7@1',12,100,'E',1,22,7,5815),
 ('19#5815*8@1',5,30,'E',1,22,8,5815),
 ('19#5815*9@1',14,30,'C-',5,22,9,5815),
 ('19#5816*10@1',2,30,'E',1,22,10,5816),
 ('19#5816*11@1',4,30,'E',1,22,11,5816),
 ('19#5816*1@1',11,30,'D',3,22,1,5816),
 ('19#5816*2@1',17,30,'C+',7,22,2,5816),
 ('19#5816*3@1',12,100,'E',1,22,3,5816),
 ('19#5816*4@1',8,30,'D',3,22,4,5816),
 ('19#5816*5@1',4,30,'E',1,22,5,5816),
 ('19#5816*6@1',7,30,'D-',2,22,6,5816),
 ('19#5816*7@1',23,100,'E',1,22,7,5816),
 ('19#5816*8@1',6,30,'E',1,22,8,5816),
 ('19#5816*9@1',20,30,'B',9,22,9,5816),
 ('19#5817*10@1',21,30,'B+',10,22,10,5817),
 ('19#5817*11@1',28,30,'A',12,22,11,5817),
 ('19#5817*1@1',16,30,'C',6,22,1,5817),
 ('19#5817*2@1',18,30,'B-',8,22,2,5817),
 ('19#5817*3@1',14,100,'E',1,22,3,5817),
 ('19#5817*4@1',15,30,'C+',7,22,4,5817),
 ('19#5817*5@1',14,30,'C+',7,22,5,5817),
 ('19#5817*6@1',23,30,'A',12,22,6,5817),
 ('19#5817*7@1',84,100,'A',12,22,7,5817),
 ('19#5817*8@1',27,30,'A',12,22,8,5817),
 ('19#5817*9@1',28,30,'A',12,22,9,5817),
 ('19#5818*10@1',8,30,'E',1,22,10,5818),
 ('19#5818*11@1',18,30,'B-',8,22,11,5818),
 ('19#5818*1@1',17,30,'C+',7,22,1,5818),
 ('19#5818*2@1',12,30,'D+',4,22,2,5818),
 ('19#5818*3@1',8,100,'E',1,22,3,5818),
 ('19#5818*4@1',17,30,'B',9,22,4,5818),
 ('19#5818*5@1',7,30,'D-',2,22,5,5818),
 ('19#5818*6@1',15,30,'C+',7,22,6,5818),
 ('19#5818*7@1',50,100,'C',6,22,7,5818),
 ('19#5818*8@1',10,30,'D-',2,22,8,5818),
 ('19#5818*9@1',23,30,'A-',11,22,9,5818),
 ('19#5819*10@1',1,30,'E',1,22,10,5819),
 ('19#5819*11@1',3,30,'E',1,22,11,5819),
 ('19#5819*1@1',4,30,'E',1,22,1,5819),
 ('19#5819*2@1',8,30,'E',1,22,2,5819),
 ('19#5819*3@1',3,100,'E',1,22,3,5819),
 ('19#5819*4@1',6,30,'E',1,22,4,5819),
 ('19#5819*5@1',5,30,'E',1,22,5,5819),
 ('19#5819*6@1',5,30,'E',1,22,6,5819),
 ('19#5819*7@1',1,100,'E',1,22,7,5819),
 ('19#5819*8@1',3,30,'E',1,22,8,5819),
 ('19#5819*9@1',5,30,'E',1,22,9,5819),
 ('19#5820*10@1',4,30,'E',1,22,10,5820),
 ('19#5820*11@1',6,30,'E',1,22,11,5820),
 ('19#5820*1@1',10,30,'D-',2,22,1,5820),
 ('19#5820*2@1',8,30,'E',1,22,2,5820),
 ('19#5820*3@1',4,100,'E',1,22,3,5820),
 ('19#5820*4@1',8,30,'D',3,22,4,5820),
 ('19#5820*5@1',6,30,'E',1,22,5,5820),
 ('19#5820*6@1',10,30,'D+',4,22,6,5820),
 ('19#5820*7@1',16,100,'E',1,22,7,5820),
 ('19#5820*8@1',11,30,'D',3,22,8,5820),
 ('19#5820*9@1',18,30,'B-',8,22,9,5820),
 ('19#5821*10@1',14,30,'C-',5,22,10,5821),
 ('19#5821*11@1',27,30,'A',12,22,11,5821),
 ('19#5821*1@1',17,30,'C+',7,22,1,5821),
 ('19#5821*2@1',13,30,'D+',4,22,2,5821),
 ('19#5821*3@1',16,100,'E',1,22,3,5821),
 ('19#5821*4@1',12,30,'C-',5,22,4,5821),
 ('19#5821*5@1',14,30,'C+',7,22,5,5821),
 ('19#5821*6@1',27,30,'A',12,22,6,5821),
 ('19#5821*7@1',67,100,'B',9,22,7,5821),
 ('19#5821*8@1',15,30,'C',6,22,8,5821),
 ('19#5821*9@1',29,30,'A',12,22,9,5821),
 ('19#5822*10@1',5,30,'E',1,22,10,5822),
 ('19#5822*11@1',13,30,'D+',4,22,11,5822),
 ('19#5822*1@1',6,30,'E',1,22,1,5822),
 ('19#5822*2@1',8,30,'E',1,22,2,5822),
 ('19#5822*3@1',2,100,'E',1,22,3,5822),
 ('19#5822*4@1',11,30,'C-',5,22,4,5822),
 ('19#5822*5@1',4,30,'E',1,22,5,5822),
 ('19#5822*6@1',14,30,'C+',7,22,6,5822),
 ('19#5822*7@1',28,100,'E',1,22,7,5822),
 ('19#5822*8@1',7,30,'E',1,22,8,5822),
 ('19#5822*9@1',24,30,'A',12,22,9,5822),
 ('19#5823*10@1',9,30,'D-',2,22,10,5823),
 ('19#5823*11@1',9,30,'D-',2,22,11,5823),
 ('19#5823*1@1',10,30,'D-',2,22,1,5823),
 ('19#5823*2@1',9,30,'D-',2,22,2,5823),
 ('19#5823*3@1',8,100,'E',1,22,3,5823),
 ('19#5823*4@1',9,30,'D',3,22,4,5823),
 ('19#5823*5@1',9,30,'D',3,22,5,5823),
 ('19#5823*6@1',16,30,'B-',8,22,6,5823),
 ('19#5823*7@1',24,100,'E',1,22,7,5823),
 ('19#5823*8@1',10,30,'D-',2,22,8,5823),
 ('19#5823*9@1',10,30,'D-',2,22,9,5823),
 ('19#5824*10@1',5,30,'E',1,22,10,5824),
 ('19#5824*11@1',7,30,'E',1,22,11,5824),
 ('19#5824*1@1',14,30,'C-',5,22,1,5824),
 ('19#5824*2@1',9,30,'D-',2,22,2,5824),
 ('19#5824*3@1',6,100,'E',1,22,3,5824),
 ('19#5824*4@1',8,30,'D',3,22,4,5824),
 ('19#5824*5@1',14,30,'C+',7,22,5,5824),
 ('19#5824*6@1',10,30,'D+',4,22,6,5824),
 ('19#5824*7@1',6,100,'E',1,22,7,5824),
 ('19#5824*8@1',6,30,'E',1,22,8,5824),
 ('19#5824*9@1',12,30,'D+',4,22,9,5824),
 ('19#5825*10@1',1,30,'E',1,22,10,5825),
 ('19#5825*11@1',0,30,'E',1,22,11,5825),
 ('19#5825*1@1',0,30,'E',1,22,1,5825),
 ('19#5825*2@1',0,30,'E',1,22,2,5825),
 ('19#5825*3@1',0,100,'E',1,22,3,5825),
 ('19#5825*4@1',0,15,'E',1,22,4,5825),
 ('19#5825*5@1',0,30,'E',1,22,5,5825),
 ('19#5825*6@1',0,30,'E',1,22,6,5825),
 ('19#5825*7@1',2,100,'E',1,22,7,5825),
 ('19#5825*8@1',0,30,'E',1,22,8,5825),
 ('19#5825*9@1',0,30,'E',1,22,9,5825);
/*!40000 ALTER TABLE `examsubjhld` ENABLE KEYS */;


--
-- Definition of table `examsubjhldold`
--

DROP TABLE IF EXISTS `examsubjhldold`;
CREATE TABLE `examsubjhldold` (
  `ExStSub` varchar(45) NOT NULL,
  `Mkst` double DEFAULT NULL,
  `outOft` double DEFAULT NULL,
  `grad` varchar(5) DEFAULT NULL,
  `pnts` int(10) unsigned DEFAULT NULL,
  `cl` int(10) unsigned DEFAULT NULL,
  `subj` int(10) unsigned DEFAULT NULL,
  `st` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`ExStSub`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubjhldold`
--

/*!40000 ALTER TABLE `examsubjhldold` DISABLE KEYS */;
/*!40000 ALTER TABLE `examsubjhldold` ENABLE KEYS */;


--
-- Definition of table `examsubjold`
--

DROP TABLE IF EXISTS `examsubjold`;
CREATE TABLE `examsubjold` (
  `SID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `exid` int(10) unsigned NOT NULL,
  `SUBID` int(10) unsigned NOT NULL,
  `outof` int(10) unsigned DEFAULT NULL,
  `Paper` varchar(45) DEFAULT NULL,
  `ExamDate` datetime DEFAULT NULL,
  `CSID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`SID`)
) ENGINE=InnoDB AUTO_INCREMENT=2168 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubjold`
--

/*!40000 ALTER TABLE `examsubjold` DISABLE KEYS */;
/*!40000 ALTER TABLE `examsubjold` ENABLE KEYS */;


--
-- Definition of table `examsubjravail`
--

DROP TABLE IF EXISTS `examsubjravail`;
CREATE TABLE `examsubjravail` (
  `stNo` int(10) unsigned DEFAULT NULL,
  `Tid` int(10) unsigned DEFAULT NULL,
  `Admino` varchar(45) DEFAULT NULL,
  `name` varchar(45) DEFAULT NULL,
  `Sid` varchar(45) DEFAULT NULL,
  `SubId` int(10) unsigned DEFAULT NULL,
  `ClId` int(10) unsigned DEFAULT NULL,
  `cl` int(10) unsigned DEFAULT NULL,
  `stcid` varchar(45) DEFAULT NULL,
  `coreSubj` varchar(45) DEFAULT NULL,
  `ESID` varchar(45) DEFAULT NULL,
  `MKS` double DEFAULT NULL,
  `OUTOF` double DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubjravail`
--

/*!40000 ALTER TABLE `examsubjravail` DISABLE KEYS */;
/*!40000 ALTER TABLE `examsubjravail` ENABLE KEYS */;


--
-- Definition of table `examsubjresult`
--

DROP TABLE IF EXISTS `examsubjresult`;
CREATE TABLE `examsubjresult` (
  `ESID` int(10) unsigned DEFAULT NULL,
  `stNo` int(255) unsigned DEFAULT NULL,
  `MKS` double DEFAULT NULL,
  `OUTOF` double DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubjresult`
--

/*!40000 ALTER TABLE `examsubjresult` DISABLE KEYS */;
/*!40000 ALTER TABLE `examsubjresult` ENABLE KEYS */;


--
-- Definition of table `examsubjresult_`
--

DROP TABLE IF EXISTS `examsubjresult_`;
CREATE TABLE `examsubjresult_` (
  `ESID` int(10) unsigned DEFAULT NULL,
  `stNo` int(255) unsigned DEFAULT NULL,
  `MKS` double DEFAULT NULL,
  `OUTOF` double DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubjresult_`
--

/*!40000 ALTER TABLE `examsubjresult_` DISABLE KEYS */;
/*!40000 ALTER TABLE `examsubjresult_` ENABLE KEYS */;


--
-- Definition of table `examsubjresultadj`
--

DROP TABLE IF EXISTS `examsubjresultadj`;
CREATE TABLE `examsubjresultadj` (
  `col1` varchar(10) NOT NULL DEFAULT '',
  `upd1` text,
  `Upd2` text,
  `upd3` text,
  `upd4` text,
  `upd5` text,
  `upd6` text,
  `upd7` text,
  `upd8` text,
  `upd9` text,
  `edt1` text,
  `edt2` text,
  `edt3` text,
  `edt4` text,
  `edt5` text,
  `edt6` text,
  `edt7` text,
  `edt8` text,
  `edt9` text,
  `all1` text,
  `all2` text,
  `all3` text,
  `all4` text,
  `all5` text,
  `all6` text,
  `all7` text,
  `all8` text,
  `all9` text,
  PRIMARY KEY (`col1`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubjresultadj`
--

/*!40000 ALTER TABLE `examsubjresultadj` DISABLE KEYS */;
INSERT INTO `examsubjresultadj` (`col1`,`upd1`,`Upd2`,`upd3`,`upd4`,`upd5`,`upd6`,`upd7`,`upd8`,`upd9`,`edt1`,`edt2`,`edt3`,`edt4`,`edt5`,`edt6`,`edt7`,`edt8`,`edt9`,`all1`,`all2`,`all3`,`all4`,`all5`,`all6`,`all7`,`all8`,`all9`) VALUES 
 ('EXM','call `pr_upsubjtot` ();','update examsubjtot t set grad=( SELECT G FROM examsdone e join examsubj j on(e.exId=j.exId) join clasubject k on(e.clId=k.clid)and (j.subId=k.subid)\r\njoin clsubgrade g on(k.CSID=g.CSID) join examsubjresult r on(j.SID=r.ESID) and concat(ESID,\'#\',STNo)=@vrbl\r\nwhere  EXstSub=@sub and round(mkst*100/outoft) between GFrom and GTo ) where EXstSub=@sub;',NULL,'update examsubrept t set grd=( SELECT G FROM examsdone e join examsubj j on(e.exId=j.exId) join clasubject k on(e.clId=k.clid)and (j.subId=k.subid)\r\njoin clsubgrade g on(k.CSID=g.CSID) join examsubjresult r on(j.SID=r.ESID)\r\nand concat(ESID,(\'#\' ),STNo)=@vrbl\r\nwhere (TmStSubCl=@tid) and round(Mksr*100/outOfr) between GFrom and GTo ) where TmStSubCl=@tid;','update examsubrept t set pnts=(SELECT Mks FROM defgrades d where d.G=t.grd) where TmStSubCl=@tid;','update examsubjtot t set pnts=(SELECT Mks FROM defgrades d where d.G=t.grad) where ExStSub=@sub;','call pr_nwtallsubjt(@vrbl);',NULL,NULL,'insert into examsubjtot( ExStSub, Mkst, outOft )\r\nselect concat((@exId),(\'#\' ),STNo,(\'*\' ),(@SUBID)),-Mks,-outof   from   examsubjresult where\r\nconcat(ESID,(\'#\' ),STNo)=@vrbl\r\nON DUPLICATE KEY UPDATE  Mkst=coalesce(Mkst,0)-(SELECT coalesce(Mks,0) from   examsubjresult where\r\nconcat(ESID,(\'#\' ),STNo)=@vrbl),outOft=coalesce(outOft,0)-(SELECT  coalesce( outOf,0)   from   examsubjresult where\r\nconcat(ESID,(\'#\' ),STNo)=@vrbl);','insert into examsubrept(TmStSubCl, Mksr,outOfr)\r\nSELECT @tid, -round(Mkst*Perc/outOft),-Perc  FROM examsubjtot e join examsdone d\r\n on(d.exId=substr(Exstsub,1,locate((\'#\' ),Exstsub))) and Report=(\'True\' )\r\n where Exstsub=@sub\r\nON DUPLICATE KEY UPDATE  Mksr=coalesce(Mksr,0)-(select round(Mkst*Perc/outOft)    FROM examsubjtot e join examsdone d\r\n on(d.exId=substr(Exstsub,1,locate((\'#\' ),Exstsub))) and Report=(\'True\' )\r\n where Exstsub=@sub),\r\noutOfr=coalesce(outOfr,0)-(select Perc   FROM examsubjtot e join examsdone d\r\n on(d.exId=substr(Exstsub,1,locate((\'#\' ),Exstsub))) and Report=(\'True\' )\r\n where Exstsub=@sub);',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `examsubjresultadj` ENABLE KEYS */;


--
-- Definition of table `examsubjresultadjk`
--

DROP TABLE IF EXISTS `examsubjresultadjk`;
CREATE TABLE `examsubjresultadjk` (
  `col1` varchar(10) NOT NULL DEFAULT '',
  `upd1` text,
  `Upd2` text,
  `upd3` text,
  `upd4` text,
  `upd5` text,
  `upd6` text,
  `upd7` text,
  `upd8` text,
  `upd9` text,
  `edt1` text,
  `edt2` text,
  `edt3` text,
  `edt4` text,
  `edt5` text,
  `edt6` text,
  `edt7` text,
  `edt8` text,
  `edt9` text,
  `all1` text,
  `all2` text,
  `all3` text,
  `all4` text,
  `all5` text,
  `all6` text,
  `all7` text,
  `all8` text,
  `all9` text,
  PRIMARY KEY (`col1`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubjresultadjk`
--

/*!40000 ALTER TABLE `examsubjresultadjk` DISABLE KEYS */;
INSERT INTO `examsubjresultadjk` (`col1`,`upd1`,`Upd2`,`upd3`,`upd4`,`upd5`,`upd6`,`upd7`,`upd8`,`upd9`,`edt1`,`edt2`,`edt3`,`edt4`,`edt5`,`edt6`,`edt7`,`edt8`,`edt9`,`all1`,`all2`,`all3`,`all4`,`all5`,`all6`,`all7`,`all8`,`all9`) VALUES 
 ('EXM','insert into examsubjtot( ExStSub, Mkst, outOft )\r\nselect concat((select exId from examsubj where SID=ESID),(select abbrv from journlabbrv where id=19 ),STNo,(select abbrv from journlabbrv where id=18 ),(SELECT SUBID FROM examsubj e where SID=ESID)),Mks,outof   from   examsubjresult where\r\nconcat(ESID,(select abbrv from journlabbrv where id=19 ),STNo)=@vrbl\r\nON DUPLICATE KEY UPDATE  Mkst=coalesce(Mkst,0)+(SELECT coalesce(Mks,0) from   examsubjresult where\r\nconcat(ESID,(select abbrv from journlabbrv where id=19 ),STNo)=@vrbl),outOft=coalesce(outOft,0)+(SELECT  coalesce( outOf,0)   from   examsubjresult where\r\nconcat(ESID,(select abbrv from journlabbrv where id=19 ),STNo)=@vrbl);','update examsubjtot t set grad=( SELECT G FROM examsdone e join examsubj j on(e.exId=j.exId) join clasubject k on(e.clId=k.clid)and (j.subId=k.subid)\r\njoin clsubgrade g on(k.CSID=g.CSID) join examsubjresult r on(j.SID=r.ESID) and concat(ESID,(select abbrv from journlabbrv where id=19 ),STNo)=@vrbl\r\nwhere (EXstSub=concat(e.exId,(select abbrv from journlabbrv where id=19 ),STNo,(select abbrv from journlabbrv where id=18 ),j.subId))\r\nand round(mkst*100/outoft) between GFrom and GTo ) where EXstSub=(\r\nselect  concat((select exId from examsubj where SID=ESID),(select abbrv from journlabbrv where id=19 ),STNo,(select abbrv from journlabbrv where id=18 ),(SELECT SUBID FROM examsubj e where SID=ESID))\r\nfrom    examsubjresult where concat(ESID,(select abbrv from journlabbrv where id=19 ),STNo)=@vrbl);','insert into examsubrept(TmStSubCl, Mksr,outOfr)\r\nSELECT @tid, round(Mkst*Perc/outOft),Perc  FROM examsubjtot e join examsdone d\r\n on(d.exId=substr(Exstsub,1,locate((select abbrv from journlabbrv where id=19 ),Exstsub))) and Report=(select abbrv from journlabbrv where id=22 )\r\n where Exstsub=@sub\r\nON DUPLICATE KEY UPDATE  Mksr=coalesce(Mksr,0)+(select round(Mkst*Perc/outOft)    FROM examsubjtot e join examsdone d\r\n on(d.exId=substr(Exstsub,1,locate((select abbrv from journlabbrv where id=19 ),Exstsub))) and Report=(select abbrv from journlabbrv where id=22 )\r\n where Exstsub=@sub),\r\noutOfr=coalesce(outOfr,0)+(select Perc   FROM examsubjtot e join examsdone d\r\n on(d.exId=substr(Exstsub,1,locate((select abbrv from journlabbrv where id=19 ),Exstsub))) and Report=(select abbrv from journlabbrv where id=22 )\r\n where Exstsub=@sub);','update examsubrept t set grd=( SELECT G FROM examsdone e join examsubj j on(e.exId=j.exId) join clasubject k on(e.clId=k.clid)and (j.subId=k.subid)\r\njoin clsubgrade g on(k.CSID=g.CSID) join examsubjresult r on(j.SID=r.ESID)\r\nand concat(ESID,(select abbrv from journlabbrv where id=19 ),STNo)=@vrbl\r\nwhere (TmStSubCl=@tid) and round(Mksr*100/outOfr) between GFrom and GTo ) where TmStSubCl=@tid;','update examsubrept t set pnts=(SELECT Mks FROM defgrades d where d.G=t.grd) where TmStSubCl=@tid;','update examsubjtot t set pnts=(SELECT Mks FROM defgrades d where d.G=t.grad) where ExStSub=@sub;','call pr_nwtallsubjt(@sub);',NULL,NULL,'insert into examsubjtot ( ExStSub, Mkst, outOft )\r\nselect concat((select exId from examsubj where SID=ESID),(select abbrv from journlabbrv where id=19 ),STNo,(select abbrv from journlabbrv where id=18 ),(SELECT SUBID FROM examsubj e where SID=ESID)),-Mks,-outof   from   examsubjresult where\r\nconcat(ESID,(select abbrv from journlabbrv where id=19 ),STNo)=@vrbl\r\nON DUPLICATE KEY UPDATE  Mkst=coalesce(Mkst,0)-(SELECT coalesce(Mks,0) from   examsubjresult where\r\nconcat(ESID,(select abbrv from journlabbrv where id=19 ),STNo)=@vrbl),outOft=coalesce(outOft,0)-(SELECT  coalesce( outOf,0)   from   examsubjresult where\r\nconcat(ESID,(select abbrv from journlabbrv where id=19 ),STNo)=@vrbl);','insert into examsubrept(TmStSubCl, Mksr,outOfr)\r\nSELECT @tid, -round(Mkst*Perc/outOft),-Perc  FROM examsubjtot e join examsdone d\r\n on(d.exId=substr(Exstsub,1,locate((select abbrv from journlabbrv where id=19 ),Exstsub))) and Report=(select abbrv from journlabbrv where id=22 )\r\n where Exstsub=@sub\r\nON DUPLICATE KEY UPDATE  Mksr=coalesce(Mksr,0)-(select round(Mkst*Perc/outOft)    FROM examsubjtot e join examsdone d\r\n on(d.exId=substr(Exstsub,1,locate((select abbrv from journlabbrv where id=19 ),Exstsub))) and Report=(select abbrv from journlabbrv where id=22 )\r\n where Exstsub=@sub),\r\noutOfr=coalesce(outOfr,0)-(select Perc   FROM examsubjtot e join examsdone d\r\n on(d.exId=substr(Exstsub,1,locate((select abbrv from journlabbrv where id=19 ),Exstsub))) and Report=(select abbrv from journlabbrv where id=22 )\r\n where Exstsub=@sub);',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `examsubjresultadjk` ENABLE KEYS */;


--
-- Definition of table `examsubjresultadjmm`
--

DROP TABLE IF EXISTS `examsubjresultadjmm`;
CREATE TABLE `examsubjresultadjmm` (
  `col1` varchar(10) NOT NULL DEFAULT '',
  `upd1` text,
  `Upd2` text,
  `upd3` text,
  `upd4` text,
  `upd5` text,
  `upd6` text,
  `upd7` text,
  `upd8` text,
  `upd9` text,
  `edt1` text,
  `edt2` text,
  `edt3` text,
  `edt4` text,
  `edt5` text,
  `edt6` text,
  `edt7` text,
  `edt8` text,
  `edt9` text,
  `all1` text,
  `all2` text,
  `all3` text,
  `all4` text,
  `all5` text,
  `all6` text,
  `all7` text,
  `all8` text,
  `all9` text,
  PRIMARY KEY (`col1`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubjresultadjmm`
--

/*!40000 ALTER TABLE `examsubjresultadjmm` DISABLE KEYS */;
INSERT INTO `examsubjresultadjmm` (`col1`,`upd1`,`Upd2`,`upd3`,`upd4`,`upd5`,`upd6`,`upd7`,`upd8`,`upd9`,`edt1`,`edt2`,`edt3`,`edt4`,`edt5`,`edt6`,`edt7`,`edt8`,`edt9`,`all1`,`all2`,`all3`,`all4`,`all5`,`all6`,`all7`,`all8`,`all9`) VALUES 
 ('EXM','insert into examsubjtot( ExStSub, Mkst, outOft )\r\nselect concat((@exId),(\'#\' ),STNo,(\'*\' ),(@SUBID)),Mks,outof   from   examsubjresult where\r\nconcat(ESID,(\'#\' ),STNo)=@vrbl\r\nON DUPLICATE KEY UPDATE  Mkst=coalesce(Mkst,0)+(SELECT coalesce(Mks,0) from   examsubjresult where\r\nconcat(ESID,(\'#\' ),STNo)=@vrbl),outOft=coalesce(outOft,0)+(SELECT  coalesce( outOf,0)   from   examsubjresult where\r\nconcat(ESID,(\'#\' ),STNo)=@vrbl);','update examsubjtot t set grad=(select G from clsubgrade g where CSID=@CSID and round(mkst*100/outoft) between GFrom and GTo  )\r\nwhere EXstSub=   concat(@exId,\'#\',substr(@vrbl,locate(\'#\',@vrbl)+1),\'*\' ,@SUBID);','insert into examsubrept(TmStSubCl, Mksr,outOfr)\r\nSELECT @tid, round(Mkst*Perc/outOft),Perc  FROM examsubjtot e join examsdone d\r\n on(d.exId=substr(Exstsub,1,locate((\'#\' ),Exstsub))) and Report=(\'True\' )\r\n where Exstsub=@sub\r\nON DUPLICATE KEY UPDATE  Mksr=coalesce(Mksr,0)+(select round(Mkst*Perc/outOft)    FROM examsubjtot e join examsdone d\r\n on(d.exId=substr(Exstsub,1,locate((\'#\' ),Exstsub))) and Report=(\'True\' )\r\n where Exstsub=@sub),\r\noutOfr=coalesce(outOfr,0)+(select Perc   FROM examsubjtot e join examsdone d\r\n on(d.exId=substr(Exstsub,1,locate((\'#\' ),Exstsub))) and Report=(\'True\' )\r\n where Exstsub=@sub);','update examsubrept t set grd=( SELECT G FROM examsdone e join examsubj j on(e.exId=j.exId) join clasubject k on(e.clId=k.clid)and (j.subId=k.subid)\r\njoin clsubgrade g on(k.CSID=g.CSID) join examsubjresult r on(j.SID=r.ESID)\r\nand concat(ESID,(\'#\' ),STNo)=@vrbl\r\nwhere (TmStSubCl=@tid) and round(Mksr*100/outOfr) between GFrom and GTo ) where TmStSubCl=@tid;','update examsubrept t set pnts=(SELECT Mks FROM defgrades d where d.G=t.grd) where TmStSubCl=@tid;','update examsubjtot t set pnts=(SELECT Mks FROM defgrades d where d.G=t.grad) where ExStSub=@sub;',NULL,NULL,NULL,'insert into examsubjtot ( ExStSub, Mkst, outOft )\r\nselect concat((select exId from examsubj where SID=ESID),(select abbrv from journlabbrv where id=19 ),STNo,(select abbrv from journlabbrv where id=18 ),(SELECT SUBID FROM examsubj e where SID=ESID)),-Mks,-outof   from   examsubjresult where\r\nconcat(ESID,(select abbrv from journlabbrv where id=19 ),STNo)=@vrbl\r\nON DUPLICATE KEY UPDATE  Mkst=coalesce(Mkst,0)-(SELECT coalesce(Mks,0) from   examsubjresult where\r\nconcat(ESID,(select abbrv from journlabbrv where id=19 ),STNo)=@vrbl),outOft=coalesce(outOft,0)-(SELECT  coalesce( outOf,0)   from   examsubjresult where\r\nconcat(ESID,(select abbrv from journlabbrv where id=19 ),STNo)=@vrbl);','insert into examsubrept(TmStSubCl, Mksr,outOfr)\r\nSELECT @tid, -round(Mkst*Perc/outOft),-Perc  FROM examsubjtot e join examsdone d\r\n on(d.exId=substr(Exstsub,1,locate((select abbrv from journlabbrv where id=19 ),Exstsub))) and Report=(select abbrv from journlabbrv where id=22 )\r\n where Exstsub=@sub\r\nON DUPLICATE KEY UPDATE  Mksr=coalesce(Mksr,0)-(select round(Mkst*Perc/outOft)    FROM examsubjtot e join examsdone d\r\n on(d.exId=substr(Exstsub,1,locate((select abbrv from journlabbrv where id=19 ),Exstsub))) and Report=(select abbrv from journlabbrv where id=22 )\r\n where Exstsub=@sub),\r\noutOfr=coalesce(outOfr,0)-(select Perc   FROM examsubjtot e join examsdone d\r\n on(d.exId=substr(Exstsub,1,locate((select abbrv from journlabbrv where id=19 ),Exstsub))) and Report=(select abbrv from journlabbrv where id=22 )\r\n where Exstsub=@sub);',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `examsubjresultadjmm` ENABLE KEYS */;


--
-- Definition of table `examsubjresultav`
--

DROP TABLE IF EXISTS `examsubjresultav`;
CREATE TABLE `examsubjresultav` (
  `stNo` int(10) unsigned DEFAULT NULL,
  `ESID` int(10) unsigned DEFAULT NULL,
  `MKS` double DEFAULT NULL,
  `OUTOF` double DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubjresultav`
--

/*!40000 ALTER TABLE `examsubjresultav` DISABLE KEYS */;
/*!40000 ALTER TABLE `examsubjresultav` ENABLE KEYS */;


--
-- Definition of table `examsubjresultold`
--

DROP TABLE IF EXISTS `examsubjresultold`;
CREATE TABLE `examsubjresultold` (
  `ESID` int(10) unsigned DEFAULT NULL,
  `stNo` int(255) unsigned DEFAULT NULL,
  `MKS` double DEFAULT NULL,
  `OUTOF` double DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubjresultold`
--

/*!40000 ALTER TABLE `examsubjresultold` DISABLE KEYS */;
/*!40000 ALTER TABLE `examsubjresultold` ENABLE KEYS */;


--
-- Definition of table `examsubjtot`
--

DROP TABLE IF EXISTS `examsubjtot`;
CREATE TABLE `examsubjtot` (
  `ExStSub` varchar(45) NOT NULL,
  `Mkst` double DEFAULT NULL,
  `outOft` double DEFAULT NULL,
  `grad` varchar(5) DEFAULT NULL,
  `pnts` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`ExStSub`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubjtot`
--

/*!40000 ALTER TABLE `examsubjtot` DISABLE KEYS */;
/*!40000 ALTER TABLE `examsubjtot` ENABLE KEYS */;


--
-- Definition of table `examsubjtot_`
--

DROP TABLE IF EXISTS `examsubjtot_`;
CREATE TABLE `examsubjtot_` (
  `ExStSub` varchar(45) NOT NULL,
  `Mkst` double DEFAULT NULL,
  `outOft` double DEFAULT NULL,
  `grad` varchar(5) DEFAULT NULL,
  `pnts` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`ExStSub`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubjtot_`
--

/*!40000 ALTER TABLE `examsubjtot_` DISABLE KEYS */;
/*!40000 ALTER TABLE `examsubjtot_` ENABLE KEYS */;


--
-- Definition of table `examsubjtotk`
--

DROP TABLE IF EXISTS `examsubjtotk`;
CREATE TABLE `examsubjtotk` (
  `ExSt` varchar(45) NOT NULL,
  `Mkst` double DEFAULT NULL,
  `outOft` double DEFAULT NULL,
  `grad` varchar(5) DEFAULT NULL,
  `pnts` int(10) unsigned DEFAULT NULL,
  `Remarks` text,
  `pos` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`ExSt`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubjtotk`
--

/*!40000 ALTER TABLE `examsubjtotk` DISABLE KEYS */;
/*!40000 ALTER TABLE `examsubjtotk` ENABLE KEYS */;


--
-- Definition of table `examsubjtotk_`
--

DROP TABLE IF EXISTS `examsubjtotk_`;
CREATE TABLE `examsubjtotk_` (
  `ExSt` varchar(45) NOT NULL,
  `Mkst` double DEFAULT NULL,
  `outOft` double DEFAULT NULL,
  `grad` varchar(5) DEFAULT NULL,
  `pnts` int(10) unsigned DEFAULT NULL,
  `Remarks` text,
  `pos` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`ExSt`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubjtotk_`
--

/*!40000 ALTER TABLE `examsubjtotk_` DISABLE KEYS */;
/*!40000 ALTER TABLE `examsubjtotk_` ENABLE KEYS */;


--
-- Definition of table `examsubjtotkold`
--

DROP TABLE IF EXISTS `examsubjtotkold`;
CREATE TABLE `examsubjtotkold` (
  `ExSt` varchar(45) NOT NULL,
  `Mkst` double DEFAULT NULL,
  `outOft` double DEFAULT NULL,
  `grad` varchar(5) DEFAULT NULL,
  `pnts` int(10) unsigned DEFAULT NULL,
  `Remarks` text,
  `pos` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`ExSt`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubjtotkold`
--

/*!40000 ALTER TABLE `examsubjtotkold` DISABLE KEYS */;
/*!40000 ALTER TABLE `examsubjtotkold` ENABLE KEYS */;


--
-- Definition of table `examsubjtotold`
--

DROP TABLE IF EXISTS `examsubjtotold`;
CREATE TABLE `examsubjtotold` (
  `ExStSub` varchar(45) NOT NULL,
  `Mkst` double DEFAULT NULL,
  `outOft` double DEFAULT NULL,
  `grad` varchar(5) DEFAULT NULL,
  `pnts` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`ExStSub`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubjtotold`
--

/*!40000 ALTER TABLE `examsubjtotold` DISABLE KEYS */;
/*!40000 ALTER TABLE `examsubjtotold` ENABLE KEYS */;


--
-- Definition of table `examsubrept`
--

DROP TABLE IF EXISTS `examsubrept`;
CREATE TABLE `examsubrept` (
  `TmStSubCl` varchar(95) NOT NULL,
  `Mksr` double DEFAULT NULL,
  `grd` varchar(5) DEFAULT NULL,
  `Remaiks` text,
  `outOfr` double DEFAULT NULL,
  `pnts` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`TmStSubCl`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubrept`
--

/*!40000 ALTER TABLE `examsubrept` DISABLE KEYS */;
/*!40000 ALTER TABLE `examsubrept` ENABLE KEYS */;


--
-- Definition of table `examsubrept_`
--

DROP TABLE IF EXISTS `examsubrept_`;
CREATE TABLE `examsubrept_` (
  `TmStSubCl` varchar(95) NOT NULL,
  `Mksr` double DEFAULT NULL,
  `grd` varchar(5) DEFAULT NULL,
  `Remaiks` text,
  `outOfr` double DEFAULT NULL,
  `pnts` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`TmStSubCl`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubrept_`
--

/*!40000 ALTER TABLE `examsubrept_` DISABLE KEYS */;
/*!40000 ALTER TABLE `examsubrept_` ENABLE KEYS */;


--
-- Definition of table `examsubreptk`
--

DROP TABLE IF EXISTS `examsubreptk`;
CREATE TABLE `examsubreptk` (
  `TmStCl` varchar(95) NOT NULL,
  `Mksr` double DEFAULT NULL,
  `grd` varchar(5) DEFAULT NULL,
  `Remarks` text,
  `outOfr` double DEFAULT NULL,
  `pnts` int(10) unsigned DEFAULT NULL,
  `outOfp` int(10) unsigned DEFAULT NULL,
  `pos` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`TmStCl`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubreptk`
--

/*!40000 ALTER TABLE `examsubreptk` DISABLE KEYS */;
/*!40000 ALTER TABLE `examsubreptk` ENABLE KEYS */;


--
-- Definition of table `examsubreptk_`
--

DROP TABLE IF EXISTS `examsubreptk_`;
CREATE TABLE `examsubreptk_` (
  `TmStCl` varchar(95) NOT NULL,
  `Mksr` double DEFAULT NULL,
  `grd` varchar(5) DEFAULT NULL,
  `Remarks` text,
  `outOfr` double DEFAULT NULL,
  `pnts` int(10) unsigned DEFAULT NULL,
  `outOfp` int(10) unsigned DEFAULT NULL,
  `pos` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`TmStCl`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubreptk_`
--

/*!40000 ALTER TABLE `examsubreptk_` DISABLE KEYS */;
/*!40000 ALTER TABLE `examsubreptk_` ENABLE KEYS */;


--
-- Definition of table `examsubreptkold`
--

DROP TABLE IF EXISTS `examsubreptkold`;
CREATE TABLE `examsubreptkold` (
  `TmStCl` varchar(95) NOT NULL,
  `Mksr` double DEFAULT NULL,
  `grd` varchar(5) DEFAULT NULL,
  `Remarks` text,
  `outOfr` double DEFAULT NULL,
  `pnts` int(10) unsigned DEFAULT NULL,
  `outOfp` int(10) unsigned DEFAULT NULL,
  `pos` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`TmStCl`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubreptkold`
--

/*!40000 ALTER TABLE `examsubreptkold` DISABLE KEYS */;
INSERT INTO `examsubreptkold` (`TmStCl`,`Mksr`,`grd`,`Remarks`,`outOfr`,`pnts`,`outOfp`,`pos`) VALUES 
 ('13#1*1',220,NULL,NULL,1100,23,NULL,148),
 ('13#10*1',665,NULL,NULL,1100,86,NULL,6),
 ('13#100*1',299,NULL,NULL,1100,22,NULL,150),
 ('13#101*1',383,NULL,NULL,1100,37,NULL,85),
 ('13#102*1',293,NULL,NULL,1100,22,NULL,152),
 ('13#103*1',81,NULL,NULL,1100,11,NULL,248),
 ('13#104*1',121,NULL,NULL,1100,12,NULL,239),
 ('13#105*1',281,NULL,NULL,1100,21,NULL,160),
 ('13#106*1',372,NULL,NULL,1100,31,NULL,109),
 ('13#107*1',171,NULL,NULL,1100,17,NULL,201),
 ('13#108*1',484,NULL,NULL,1100,51,NULL,41),
 ('13#109*1',588,NULL,NULL,1100,68,NULL,17),
 ('13#11*1',720,NULL,NULL,1100,94,NULL,2),
 ('13#110*1',2,NULL,NULL,1100,11,NULL,273),
 ('13#111*1',182,NULL,NULL,1100,15,NULL,211),
 ('13#112*1',364,NULL,NULL,1100,29,NULL,118),
 ('13#113*1',237,NULL,NULL,1100,16,NULL,202),
 ('13#114*1',303,NULL,NULL,1100,22,NULL,149),
 ('13#115*1',179,NULL,NULL,1100,14,NULL,217),
 ('13#116*1',192,NULL,NULL,1100,16,NULL,206),
 ('13#117*1',354,NULL,NULL,1100,32,NULL,106),
 ('13#118*1',336,NULL,NULL,1100,30,NULL,116),
 ('13#119*1',9,NULL,NULL,1100,11,NULL,271),
 ('13#12*1',396,NULL,NULL,1100,36,NULL,87),
 ('13#120*1',222,NULL,NULL,1100,17,NULL,198),
 ('13#121*1',184,NULL,NULL,1100,16,NULL,207),
 ('13#122*1',383,NULL,NULL,1100,37,NULL,85),
 ('13#123*1',377,NULL,NULL,1100,33,NULL,100),
 ('13#124*1',0,NULL,NULL,1100,11,NULL,274),
 ('13#125*1',164,NULL,NULL,1100,12,NULL,232),
 ('13#126*1',340,NULL,NULL,1100,31,NULL,110),
 ('13#127*1',173,NULL,NULL,1100,19,NULL,187),
 ('13#128*1',260,NULL,NULL,1100,20,NULL,171),
 ('13#129*1',300,NULL,NULL,1100,24,NULL,140),
 ('13#13*1',0,NULL,NULL,1100,11,NULL,274),
 ('13#130*1',341,NULL,NULL,1100,29,NULL,119),
 ('13#131*1',333,NULL,NULL,1100,30,NULL,117),
 ('13#132*1',414,NULL,NULL,1100,39,NULL,77),
 ('13#133*1',399,NULL,NULL,1100,40,NULL,75),
 ('13#134*1',321,NULL,NULL,1100,27,NULL,128),
 ('13#135*1',260,NULL,NULL,1100,20,NULL,171),
 ('13#136*1',428,NULL,NULL,1100,40,NULL,74),
 ('13#137*1',703,NULL,NULL,1100,90,NULL,4),
 ('13#138*1',328,NULL,NULL,1100,28,NULL,123),
 ('13#139*1',231,NULL,NULL,1100,20,NULL,178),
 ('13#14*1',428,NULL,NULL,1100,42,NULL,69),
 ('13#140*1',277,NULL,NULL,1100,21,NULL,161),
 ('13#141*1',647,NULL,NULL,1100,79,NULL,9),
 ('13#142*1',216,NULL,NULL,1100,19,NULL,185),
 ('13#143*1',193,NULL,NULL,1100,16,NULL,205),
 ('13#144*1',388,NULL,NULL,1100,35,NULL,91),
 ('13#145*1',438,NULL,NULL,1100,48,NULL,49),
 ('13#146*1',134,NULL,NULL,1100,12,NULL,236),
 ('13#147*1',174,NULL,NULL,1100,18,NULL,195),
 ('13#148*1',163,NULL,NULL,1100,13,NULL,224),
 ('13#149*1',299,NULL,NULL,1100,22,NULL,150),
 ('13#15*1',351,NULL,NULL,1100,34,NULL,96),
 ('13#150*1',339,NULL,NULL,1100,31,NULL,111),
 ('13#151*1',525,NULL,NULL,1100,59,NULL,29),
 ('13#152*1',269,NULL,NULL,1100,19,NULL,180),
 ('13#153*1',294,NULL,NULL,1100,26,NULL,132),
 ('13#154*1',380,NULL,NULL,1100,34,NULL,95),
 ('13#155*1',169,NULL,NULL,1100,14,NULL,219),
 ('13#156*1',268,NULL,NULL,1100,22,NULL,156),
 ('13#157*1',73,NULL,NULL,1100,11,NULL,252),
 ('13#158*1',264,NULL,NULL,1100,25,NULL,138),
 ('13#159*1',313,NULL,NULL,1100,25,NULL,133),
 ('13#16*1',236,NULL,NULL,1100,21,NULL,168),
 ('13#160*1',324,NULL,NULL,1100,26,NULL,130),
 ('13#161*1',466,NULL,NULL,1100,46,NULL,52),
 ('13#162*1',37,NULL,NULL,1100,11,NULL,265),
 ('13#163*1',124,NULL,NULL,1100,12,NULL,238),
 ('13#164*1',390,NULL,NULL,1100,33,NULL,98),
 ('13#165*1',18,NULL,NULL,1100,11,NULL,270),
 ('13#166*1',460,NULL,NULL,1100,49,NULL,46),
 ('13#167*1',707,NULL,NULL,1100,90,NULL,3),
 ('13#168*1',196,NULL,NULL,1100,17,NULL,200),
 ('13#169*1',612,NULL,NULL,1100,76,NULL,11),
 ('13#17*1',451,NULL,NULL,1100,42,NULL,65),
 ('13#170*1',551,NULL,NULL,1100,64,NULL,24),
 ('13#171*1',333,NULL,NULL,1100,34,NULL,97),
 ('13#172*1',158,NULL,NULL,1100,13,NULL,226),
 ('13#173*1',23,NULL,NULL,1100,11,NULL,269),
 ('13#174*1',218,NULL,NULL,1100,19,NULL,183),
 ('13#175*1',246,NULL,NULL,1100,20,NULL,177),
 ('13#176*1',336,NULL,NULL,1100,31,NULL,112),
 ('13#177*1',133,NULL,NULL,1100,14,NULL,220),
 ('13#178*1',340,NULL,NULL,1100,33,NULL,102),
 ('13#179*1',504,NULL,NULL,1100,53,NULL,32),
 ('13#18*1',298,NULL,NULL,1100,24,NULL,141),
 ('13#180*1',269,NULL,NULL,1100,21,NULL,163),
 ('13#181*1',134,NULL,NULL,1100,12,NULL,236),
 ('13#182*1',235,NULL,NULL,1100,18,NULL,191),
 ('13#183*1',161,NULL,NULL,1100,13,NULL,225),
 ('13#184*1',294,NULL,NULL,1100,25,NULL,134),
 ('13#185*1',136,NULL,NULL,1100,16,NULL,208),
 ('13#186*1',75,NULL,NULL,1100,11,NULL,250),
 ('13#187*1',128,NULL,NULL,1100,14,NULL,221),
 ('13#188*1',115,NULL,NULL,1100,12,NULL,241),
 ('13#189*1',464,NULL,NULL,1100,49,NULL,45),
 ('13#19*1',175,NULL,NULL,1100,14,NULL,218),
 ('13#190*1',435,NULL,NULL,1100,42,NULL,66),
 ('13#191*1',237,NULL,NULL,1100,22,NULL,158),
 ('13#192*1',370,NULL,NULL,1100,32,NULL,105),
 ('13#193*1',681,NULL,NULL,1100,85,NULL,7),
 ('13#194*1',392,NULL,NULL,1100,35,NULL,90),
 ('13#195*1',58,NULL,NULL,1100,11,NULL,261),
 ('13#196*1',198,NULL,NULL,1100,16,NULL,204),
 ('13#197*1',93,NULL,NULL,1100,13,NULL,230),
 ('13#198*1',242,NULL,NULL,1100,21,NULL,167),
 ('13#199*1',354,NULL,NULL,1100,26,NULL,129),
 ('13#2*1',636,NULL,NULL,1100,80,NULL,8),
 ('13#20*1',417,NULL,NULL,1100,39,NULL,76),
 ('13#200*1',502,NULL,NULL,1100,53,NULL,34),
 ('13#201*1',296,NULL,NULL,1100,26,NULL,131),
 ('13#202*1',89,NULL,NULL,1100,11,NULL,246),
 ('13#203*1',463,NULL,NULL,1100,46,NULL,53),
 ('13#204*1',268,NULL,NULL,1100,21,NULL,164),
 ('13#205*1',304,NULL,NULL,1100,29,NULL,121),
 ('13#206*1',222,NULL,NULL,1100,17,NULL,198),
 ('13#207*1',443,NULL,NULL,1100,41,NULL,70),
 ('13#208*1',500,NULL,NULL,1100,51,NULL,40),
 ('13#209*1',435,NULL,NULL,1100,42,NULL,66),
 ('13#21*1',551,NULL,NULL,1100,61,NULL,27),
 ('13#210*1',434,NULL,NULL,1100,42,NULL,68),
 ('13#211*1',263,NULL,NULL,1100,18,NULL,189),
 ('13#212*1',398,NULL,NULL,1100,38,NULL,82),
 ('13#213*1',215,NULL,NULL,1100,15,NULL,209),
 ('13#214*1',496,NULL,NULL,1100,52,NULL,37),
 ('13#215*1',96,NULL,NULL,1100,11,NULL,245),
 ('13#216*1',144,NULL,NULL,1100,13,NULL,228),
 ('13#217*1',455,NULL,NULL,1100,44,NULL,56),
 ('13#218*1',78,NULL,NULL,1100,11,NULL,249),
 ('13#219*1',408,NULL,NULL,1100,37,NULL,84),
 ('13#22*1',526,NULL,NULL,1100,60,NULL,28),
 ('13#220*1',203,NULL,NULL,1100,21,NULL,170),
 ('13#221*1',69,NULL,NULL,1100,11,NULL,256),
 ('13#222*1',212,NULL,NULL,1100,22,NULL,159),
 ('13#223*1',169,NULL,NULL,1100,12,NULL,231),
 ('13#224*1',572,NULL,NULL,1100,68,NULL,19),
 ('13#225*1',235,NULL,NULL,1100,24,NULL,145),
 ('13#226*1',226,NULL,NULL,1100,17,NULL,197),
 ('13#227*1',314,NULL,NULL,1100,29,NULL,120),
 ('13#228*1',382,NULL,NULL,1100,30,NULL,114),
 ('13#229*1',151,NULL,NULL,1100,13,NULL,227),
 ('13#23*1',175,NULL,NULL,1100,20,NULL,179),
 ('13#230*1',128,NULL,NULL,1100,13,NULL,229),
 ('13#231*1',284,NULL,NULL,1100,22,NULL,153),
 ('13#232*1',336,NULL,NULL,1100,27,NULL,125),
 ('13#233*1',134,NULL,NULL,1100,11,NULL,243),
 ('13#234*1',180,NULL,NULL,1100,18,NULL,194),
 ('13#235*1',60,NULL,NULL,1100,11,NULL,260),
 ('13#236*1',387,NULL,NULL,1100,30,NULL,113),
 ('13#237*1',185,NULL,NULL,1100,13,NULL,222),
 ('13#238*1',576,NULL,NULL,1100,68,NULL,18),
 ('13#239*1',248,NULL,NULL,1100,20,NULL,176),
 ('13#24*1',267,NULL,NULL,1100,25,NULL,137),
 ('13#240*1',491,NULL,NULL,1100,54,NULL,31),
 ('13#241*1',571,NULL,NULL,1100,70,NULL,14),
 ('13#242*1',256,NULL,NULL,1100,20,NULL,173),
 ('13#243*1',179,NULL,NULL,1100,19,NULL,186),
 ('13#244*1',27,NULL,NULL,1100,11,NULL,267),
 ('13#245*1',63,NULL,NULL,1100,11,NULL,258),
 ('13#246*1',240,NULL,NULL,1100,18,NULL,190),
 ('13#247*1',182,NULL,NULL,1100,14,NULL,216),
 ('13#248*1',215,NULL,NULL,1100,18,NULL,193),
 ('13#249*1',217,NULL,NULL,1100,19,NULL,184),
 ('13#25*1',339,NULL,NULL,1100,28,NULL,122),
 ('13#250*1',119,NULL,NULL,1100,12,NULL,240),
 ('13#251*1',396,NULL,NULL,1100,36,NULL,87),
 ('13#252*1',189,NULL,NULL,1100,14,NULL,215),
 ('13#253*1',239,NULL,NULL,1100,19,NULL,181),
 ('13#254*1',228,NULL,NULL,1100,23,NULL,147),
 ('13#255*1',230,NULL,NULL,1100,24,NULL,146),
 ('13#256*1',291,NULL,NULL,1100,24,NULL,142),
 ('13#257*1',63,NULL,NULL,1100,11,NULL,258),
 ('13#258*1',488,NULL,NULL,1100,53,NULL,35),
 ('13#259*1',556,NULL,NULL,1100,61,NULL,26),
 ('13#26*1',571,NULL,NULL,1100,70,NULL,14),
 ('13#260*1',414,NULL,NULL,1100,38,NULL,79),
 ('13#261*1',322,NULL,NULL,1100,24,NULL,139),
 ('13#262*1',98,NULL,NULL,1100,15,NULL,212),
 ('13#263*1',227,NULL,NULL,1100,18,NULL,192),
 ('13#264*1',405,NULL,NULL,1100,32,NULL,103),
 ('13#265*1',633,NULL,NULL,1100,79,NULL,10),
 ('13#266*1',250,NULL,NULL,1100,21,NULL,165),
 ('13#267*1',353,NULL,NULL,1100,32,NULL,107),
 ('13#268*1',0,NULL,NULL,1100,11,NULL,274),
 ('13#269*1',764,NULL,NULL,1100,103,NULL,1),
 ('13#27*1',568,NULL,NULL,1100,67,NULL,21),
 ('13#270*1',201,NULL,NULL,1100,16,NULL,203),
 ('13#271*1',273,NULL,NULL,1100,25,NULL,136),
 ('13#272*1',47,NULL,NULL,1100,11,NULL,262),
 ('13#273*1',553,NULL,NULL,1100,62,NULL,25),
 ('13#274*1',82,NULL,NULL,1100,11,NULL,247),
 ('13#275*1',98,NULL,NULL,1100,11,NULL,244),
 ('13#276*1',382,NULL,NULL,1100,32,NULL,104),
 ('13#277*1',424,NULL,NULL,1100,41,NULL,72),
 ('13#278*1',34,NULL,NULL,1100,11,NULL,266),
 ('13#279*2',300,NULL,NULL,1100,25,NULL,58),
 ('13#28*1',443,NULL,NULL,1100,45,NULL,54),
 ('13#280*2',138,NULL,NULL,1100,12,NULL,129),
 ('13#281*2',388,NULL,NULL,1100,41,NULL,20),
 ('13#282*2',108,NULL,NULL,1100,13,NULL,116),
 ('13#283*2',438,NULL,NULL,1100,44,NULL,16),
 ('13#284*2',692,NULL,NULL,1100,92,NULL,2),
 ('13#285*2',84,NULL,NULL,1100,11,NULL,141),
 ('13#286*2',316,NULL,NULL,1100,29,NULL,43),
 ('13#287*2',363,NULL,NULL,1100,33,NULL,33),
 ('13#288*2',0,NULL,NULL,1100,11,NULL,169),
 ('13#289*2',4,NULL,NULL,1100,11,NULL,165),
 ('13#29*1',221,NULL,NULL,1100,14,NULL,214),
 ('13#290*2',78,NULL,NULL,1100,11,NULL,146),
 ('13#291*2',269,NULL,NULL,1100,24,NULL,64),
 ('13#292*2',447,NULL,NULL,1100,46,NULL,14),
 ('13#293*2',52,NULL,NULL,1100,11,NULL,153),
 ('13#294*2',1,NULL,NULL,1100,11,NULL,168),
 ('13#295*2',164,NULL,NULL,1100,15,NULL,96),
 ('13#296*2',126,NULL,NULL,1100,12,NULL,131),
 ('13#297*2',0,NULL,NULL,1100,11,NULL,169),
 ('13#298*2',0,NULL,NULL,1100,11,NULL,169),
 ('13#299*2',487,NULL,NULL,1100,56,NULL,9),
 ('13#3*1',421,NULL,NULL,1100,38,NULL,78),
 ('13#30*1',343,NULL,NULL,1100,30,NULL,115),
 ('13#300*2',237,NULL,NULL,1100,16,NULL,84),
 ('13#301*2',211,NULL,NULL,1100,18,NULL,78),
 ('13#302*2',518,NULL,NULL,1100,58,NULL,6),
 ('13#303*2',274,NULL,NULL,1100,30,NULL,40),
 ('13#304*2',12,NULL,NULL,1100,11,NULL,163),
 ('13#305*2',412,NULL,NULL,1100,44,NULL,17),
 ('13#306*2',74,NULL,NULL,1100,15,NULL,99),
 ('13#307*2',181,NULL,NULL,1100,14,NULL,103),
 ('13#308*2',3,NULL,NULL,1100,11,NULL,166),
 ('13#309*2',158,NULL,NULL,1100,15,NULL,98),
 ('13#31*1',373,NULL,NULL,1100,33,NULL,101),
 ('13#310*2',297,NULL,NULL,1100,25,NULL,59),
 ('13#311*2',108,NULL,NULL,1100,13,NULL,116),
 ('13#312*2',50,NULL,NULL,1100,11,NULL,154),
 ('13#313*2',141,NULL,NULL,1100,11,NULL,135),
 ('13#314*2',206,NULL,NULL,1100,15,NULL,87),
 ('13#315*2',127,NULL,NULL,1100,11,NULL,136),
 ('13#316*2',20,NULL,NULL,1100,11,NULL,161),
 ('13#317*2',374,NULL,NULL,1100,37,NULL,27),
 ('13#318*2',81,NULL,NULL,1100,11,NULL,144),
 ('13#319*2',19,NULL,NULL,1100,11,NULL,162),
 ('13#32*1',143,NULL,NULL,1100,12,NULL,233),
 ('13#320*2',291,NULL,NULL,1100,25,NULL,60),
 ('13#321*2',98,NULL,NULL,1100,13,NULL,118),
 ('13#322*2',146,NULL,NULL,1100,11,NULL,134),
 ('13#323*2',258,NULL,NULL,1100,21,NULL,69),
 ('13#324*2',192,NULL,NULL,1100,22,NULL,67),
 ('13#325*2',68,NULL,NULL,1100,11,NULL,149),
 ('13#326*2',448,NULL,NULL,1100,54,NULL,11),
 ('13#327*2',251,NULL,NULL,1100,17,NULL,79),
 ('13#328*2',151,NULL,NULL,1100,11,NULL,133),
 ('13#329*2',413,NULL,NULL,1100,37,NULL,25),
 ('13#33*1',210,NULL,NULL,1100,21,NULL,169),
 ('13#330*2',159,NULL,NULL,1100,15,NULL,97),
 ('13#331*2',284,NULL,NULL,1100,23,NULL,65),
 ('13#332*2',369,NULL,NULL,1100,33,NULL,32),
 ('13#333*2',362,NULL,NULL,1100,29,NULL,41),
 ('13#334*2',103,NULL,NULL,1100,11,NULL,139),
 ('13#335*2',77,NULL,NULL,1100,11,NULL,147),
 ('13#336*2',301,NULL,NULL,1100,25,NULL,57),
 ('13#337*2',356,NULL,NULL,1100,38,NULL,24),
 ('13#338*2',144,NULL,NULL,1100,12,NULL,128),
 ('13#339*2',130,NULL,NULL,1100,14,NULL,109),
 ('13#34*1',275,NULL,NULL,1100,21,NULL,162),
 ('13#340*2',8,NULL,NULL,1100,11,NULL,164),
 ('13#341*2',384,NULL,NULL,1100,37,NULL,26),
 ('13#342*2',170,NULL,NULL,1100,13,NULL,114),
 ('13#343*2',283,NULL,NULL,1100,26,NULL,55),
 ('13#344*2',236,NULL,NULL,1100,18,NULL,75),
 ('13#345*2',289,NULL,NULL,1100,24,NULL,63),
 ('13#346*2',318,NULL,NULL,1100,28,NULL,46),
 ('13#347*2',201,NULL,NULL,1100,20,NULL,72),
 ('13#348*2',55,NULL,NULL,1100,11,NULL,152),
 ('13#349*2',165,NULL,NULL,1100,14,NULL,105),
 ('13#35*1',266,NULL,NULL,1100,24,NULL,144),
 ('13#350*2',182,NULL,NULL,1100,17,NULL,81),
 ('13#351*2',64,NULL,NULL,1100,11,NULL,151),
 ('13#352*2',187,NULL,NULL,1100,13,NULL,111),
 ('13#353*2',338,NULL,NULL,1100,28,NULL,45),
 ('13#354*2',340,NULL,NULL,1100,30,NULL,39),
 ('13#355*2',322,NULL,NULL,1100,29,NULL,42),
 ('13#356*2',334,NULL,NULL,1100,31,NULL,37),
 ('13#357*2',520,NULL,NULL,1100,56,NULL,7),
 ('13#358*2',615,NULL,NULL,1100,77,NULL,4),
 ('13#359*2',369,NULL,NULL,1100,31,NULL,36),
 ('13#36*1',196,NULL,NULL,1100,15,NULL,210),
 ('13#360*2',208,NULL,NULL,1100,19,NULL,74),
 ('13#361*2',119,NULL,NULL,1100,11,NULL,137),
 ('13#362*2',221,NULL,NULL,1100,16,NULL,86),
 ('13#363*2',188,NULL,NULL,1100,14,NULL,102),
 ('13#364*2',228,NULL,NULL,1100,17,NULL,80),
 ('13#365*2',173,NULL,NULL,1100,12,NULL,123),
 ('13#366*2',333,NULL,NULL,1100,37,NULL,28),
 ('13#367*2',82,NULL,NULL,1100,11,NULL,142),
 ('13#368*2',215,NULL,NULL,1100,14,NULL,100),
 ('13#369*2',265,NULL,NULL,1100,26,NULL,56),
 ('13#37*1',430,NULL,NULL,1100,43,NULL,62),
 ('13#370*2',184,NULL,NULL,1100,12,NULL,120),
 ('13#371*2',314,NULL,NULL,1100,28,NULL,48),
 ('13#372*2',206,NULL,NULL,1100,15,NULL,87),
 ('13#373*2',269,NULL,NULL,1100,21,NULL,68),
 ('13#374*2',362,NULL,NULL,1100,35,NULL,31),
 ('13#375*2',0,NULL,NULL,1100,11,NULL,169),
 ('13#376*2',174,NULL,NULL,1100,14,NULL,104),
 ('13#377*2',142,NULL,NULL,1100,13,NULL,115),
 ('13#378*2',507,NULL,NULL,1100,54,NULL,10),
 ('13#379*2',184,NULL,NULL,1100,15,NULL,94),
 ('13#38*1',411,NULL,NULL,1100,34,NULL,93),
 ('13#380*2',383,NULL,NULL,1100,39,NULL,21),
 ('13#381*2',68,NULL,NULL,1100,11,NULL,149),
 ('13#382*2',89,NULL,NULL,1100,11,NULL,140),
 ('13#383*2',325,NULL,NULL,1100,31,NULL,38),
 ('13#384*2',514,NULL,NULL,1100,56,NULL,8),
 ('13#385*2',82,NULL,NULL,1100,11,NULL,142),
 ('13#386*2',306,NULL,NULL,1100,28,NULL,50),
 ('13#387*2',637,NULL,NULL,1100,78,NULL,3),
 ('13#388*2',0,NULL,NULL,1100,11,NULL,169),
 ('13#389*2',179,NULL,NULL,1100,13,NULL,112),
 ('13#39*1',270,NULL,NULL,1100,18,NULL,188),
 ('13#390*2',248,NULL,NULL,1100,16,NULL,83),
 ('13#391*2',201,NULL,NULL,1100,14,NULL,101),
 ('13#392*2',195,NULL,NULL,1100,15,NULL,91),
 ('13#393*2',2,NULL,NULL,1100,11,NULL,167),
 ('13#394*2',130,NULL,NULL,1100,12,NULL,130),
 ('13#395*2',94,NULL,NULL,1100,13,NULL,119),
 ('13#396*2',265,NULL,NULL,1100,25,NULL,61),
 ('13#397*2',71,NULL,NULL,1100,11,NULL,148),
 ('13#398*2',280,NULL,NULL,1100,27,NULL,53),
 ('13#399*2',332,NULL,NULL,1100,33,NULL,34),
 ('13#4*1',72,NULL,NULL,1100,11,NULL,254),
 ('13#40*1',424,NULL,NULL,1100,44,NULL,59),
 ('13#400*2',157,NULL,NULL,1100,12,NULL,125),
 ('13#401*2',190,NULL,NULL,1100,15,NULL,92),
 ('13#402*2',28,NULL,NULL,1100,11,NULL,158),
 ('13#403*2',228,NULL,NULL,1100,16,NULL,85),
 ('13#404*2',316,NULL,NULL,1100,28,NULL,47),
 ('13#405*2',185,NULL,NULL,1100,15,NULL,93),
 ('13#406*2',245,NULL,NULL,1100,20,NULL,71),
 ('13#407*2',165,NULL,NULL,1100,14,NULL,105),
 ('13#408*2',169,NULL,NULL,1100,17,NULL,82),
 ('13#409*2',257,NULL,NULL,1100,21,NULL,70),
 ('13#41*1',324,NULL,NULL,1100,27,NULL,127),
 ('13#410*2',27,NULL,NULL,1100,11,NULL,160),
 ('13#411*2',28,NULL,NULL,1100,11,NULL,158),
 ('13#412*2',0,NULL,NULL,1100,11,NULL,169),
 ('13#413*2',39,NULL,NULL,1100,11,NULL,156),
 ('13#414*2',228,NULL,NULL,1100,18,NULL,76),
 ('13#415*2',107,NULL,NULL,1100,11,NULL,138),
 ('13#416*2',32,NULL,NULL,1100,11,NULL,157),
 ('13#417*2',419,NULL,NULL,1100,42,NULL,18),
 ('13#418*2',301,NULL,NULL,1100,27,NULL,52),
 ('13#419*2',325,NULL,NULL,1100,26,NULL,54),
 ('13#42*1',408,NULL,NULL,1100,38,NULL,80),
 ('13#420*2',251,NULL,NULL,1100,19,NULL,73),
 ('13#421*2',184,NULL,NULL,1100,12,NULL,120),
 ('13#422*2',884,NULL,NULL,1100,119,NULL,1),
 ('13#423*2',0,NULL,NULL,1100,11,NULL,169),
 ('13#424*2',178,NULL,NULL,1100,12,NULL,122),
 ('13#425*2',412,NULL,NULL,1100,38,NULL,22),
 ('13#426*2',79,NULL,NULL,1100,11,NULL,145),
 ('13#427*2',308,NULL,NULL,1100,28,NULL,49),
 ('13#428*2',154,NULL,NULL,1100,14,NULL,107),
 ('13#429*2',155,NULL,NULL,1100,12,NULL,127),
 ('13#43*1',329,NULL,NULL,1100,27,NULL,126),
 ('13#430*2',311,NULL,NULL,1100,32,NULL,35),
 ('13#431*2',355,NULL,NULL,1100,36,NULL,30),
 ('13#432*2',200,NULL,NULL,1100,15,NULL,89),
 ('13#433*2',377,NULL,NULL,1100,36,NULL,29),
 ('13#434*2',239,NULL,NULL,1100,25,NULL,62),
 ('13#435*2',44,NULL,NULL,1100,11,NULL,155),
 ('13#436*2',424,NULL,NULL,1100,45,NULL,15),
 ('13#437*2',455,NULL,NULL,1100,51,NULL,13),
 ('13#438*2',306,NULL,NULL,1100,29,NULL,44),
 ('13#439*2',157,NULL,NULL,1100,12,NULL,125),
 ('13#44*1',481,NULL,NULL,1100,48,NULL,48),
 ('13#440*2',274,NULL,NULL,1100,22,NULL,66),
 ('13#441*2',174,NULL,NULL,1100,13,NULL,113),
 ('13#442*2',100,NULL,NULL,1100,12,NULL,132),
 ('13#443*2',618,NULL,NULL,1100,74,NULL,5),
 ('13#444*2',196,NULL,NULL,1100,15,NULL,90),
 ('13#445*2',481,NULL,NULL,1100,51,NULL,12),
 ('13#446*2',158,NULL,NULL,1100,12,NULL,124),
 ('13#447*2',213,NULL,NULL,1100,18,NULL,77),
 ('13#448*2',169,NULL,NULL,1100,15,NULL,95),
 ('13#449*2',403,NULL,NULL,1100,38,NULL,23),
 ('13#45*1',309,NULL,NULL,1100,32,NULL,108),
 ('13#450*2',418,NULL,NULL,1100,42,NULL,19),
 ('13#451*2',291,NULL,NULL,1100,28,NULL,51),
 ('13#452*3',41,NULL,NULL,700,7,NULL,159),
 ('13#453*3',294,NULL,NULL,800,26,NULL,34),
 ('13#454*3',256,NULL,NULL,800,24,NULL,42),
 ('13#455*3',218,NULL,NULL,800,19,NULL,57),
 ('13#456*3',0,NULL,NULL,500,5,NULL,169),
 ('13#457*3',74,NULL,NULL,800,10,NULL,134),
 ('13#458*3',352,NULL,NULL,800,39,NULL,14),
 ('13#459*3',187,NULL,NULL,800,13,NULL,98),
 ('13#46*1',288,NULL,NULL,1100,25,NULL,135),
 ('13#460*3',0,NULL,NULL,600,6,NULL,169),
 ('13#461*3',193,NULL,NULL,800,15,NULL,80),
 ('13#462*3',119,NULL,NULL,800,11,NULL,118),
 ('13#463*3',139,NULL,NULL,800,10,NULL,128),
 ('13#464*3',121,NULL,NULL,800,10,NULL,132),
 ('13#465*3',0,NULL,NULL,500,5,NULL,169),
 ('13#466*3',272,NULL,NULL,800,23,NULL,45),
 ('13#467*3',450,NULL,NULL,800,56,NULL,5),
 ('13#468*3',49,NULL,NULL,800,8,NULL,151),
 ('13#469*3',145,NULL,NULL,800,9,NULL,137),
 ('13#4699*3',0,NULL,NULL,600,6,NULL,169),
 ('13#47*1',617,NULL,NULL,1100,74,NULL,12),
 ('13#470*3',0,NULL,NULL,500,5,NULL,169),
 ('13#4700*2',126,NULL,NULL,1100,14,NULL,110),
 ('13#4701*2',140,NULL,NULL,1100,14,NULL,108),
 ('13#471*3',167,NULL,NULL,800,11,NULL,113),
 ('13#472*3',76,NULL,NULL,800,8,NULL,148),
 ('13#473*3',280,NULL,NULL,800,25,NULL,37),
 ('13#474*3',0,NULL,NULL,500,5,NULL,169),
 ('13#475*3',91,NULL,NULL,700,7,NULL,158),
 ('13#476*3',113,NULL,NULL,800,9,NULL,139),
 ('13#477*3',0,NULL,NULL,500,5,NULL,169),
 ('13#478*3',240,NULL,NULL,800,21,NULL,50),
 ('13#479*3',94,NULL,NULL,800,8,NULL,145),
 ('13#48*1',571,NULL,NULL,1100,67,NULL,20),
 ('13#480*3',218,NULL,NULL,800,17,NULL,67),
 ('13#481*3',1,NULL,NULL,700,7,NULL,163),
 ('13#482*3',0,NULL,NULL,500,5,NULL,169),
 ('13#483*3',243,NULL,NULL,800,22,NULL,49),
 ('13#484*3',90,NULL,NULL,800,8,NULL,146),
 ('13#485*3',201,NULL,NULL,800,17,NULL,68),
 ('13#486*3',0,NULL,NULL,500,5,NULL,169),
 ('13#487*3',200,NULL,NULL,800,15,NULL,79),
 ('13#488*3',316,NULL,NULL,800,31,NULL,23),
 ('13#489*3',193,NULL,NULL,800,14,NULL,86),
 ('13#49*1',249,NULL,NULL,1100,20,NULL,175),
 ('13#490*3',175,NULL,NULL,800,14,NULL,88),
 ('13#491*3',30,NULL,NULL,800,8,NULL,152),
 ('13#492*3',0,NULL,NULL,600,6,NULL,169),
 ('13#493*3',180,NULL,NULL,800,13,NULL,102),
 ('13#494*3',52,NULL,NULL,500,6,NULL,165),
 ('13#495*3',247,NULL,NULL,800,22,NULL,48),
 ('13#496*3',2,NULL,NULL,700,7,NULL,161),
 ('13#497*3',265,NULL,NULL,800,24,NULL,41),
 ('13#498*3',0,NULL,NULL,500,5,NULL,169),
 ('13#499*3',158,NULL,NULL,800,12,NULL,109),
 ('13#5*1',272,NULL,NULL,1100,17,NULL,196),
 ('13#50*1',0,NULL,NULL,1100,11,NULL,274),
 ('13#500*3',227,NULL,NULL,800,20,NULL,52),
 ('13#501*3',163,NULL,NULL,800,14,NULL,93),
 ('13#502*3',147,NULL,NULL,800,10,NULL,127),
 ('13#503*3',219,NULL,NULL,800,18,NULL,61),
 ('13#504*3',184,NULL,NULL,800,12,NULL,106),
 ('13#505*3',193,NULL,NULL,700,16,NULL,73),
 ('13#506*3',202,NULL,NULL,800,14,NULL,85),
 ('13#507*3',205,NULL,NULL,800,16,NULL,77),
 ('13#508*3',0,NULL,NULL,500,5,NULL,169),
 ('13#509*3',188,NULL,NULL,800,13,NULL,97),
 ('13#51*1',588,NULL,NULL,1100,73,NULL,13),
 ('13#510*3',199,NULL,NULL,800,18,NULL,64),
 ('13#511*3',160,NULL,NULL,800,9,NULL,135),
 ('13#512*3',113,NULL,NULL,800,11,NULL,119),
 ('13#513*3',186,NULL,NULL,800,13,NULL,99),
 ('13#514*3',232,NULL,NULL,800,19,NULL,55),
 ('13#515*3',151,NULL,NULL,800,9,NULL,136),
 ('13#516*3',161,NULL,NULL,800,10,NULL,122),
 ('13#517*3',92,NULL,NULL,700,7,NULL,157),
 ('13#518*3',201,NULL,NULL,800,17,NULL,68),
 ('13#519*3',108,NULL,NULL,800,8,NULL,143),
 ('13#52*1',280,NULL,NULL,1100,22,NULL,155),
 ('13#520*3',266,NULL,NULL,800,28,NULL,28),
 ('13#521*3',0,NULL,NULL,500,5,NULL,169),
 ('13#522*3',80,NULL,NULL,800,8,NULL,147),
 ('13#523*3',231,NULL,NULL,800,18,NULL,59),
 ('13#524*3',167,NULL,NULL,800,10,NULL,121),
 ('13#525*3',228,NULL,NULL,800,16,NULL,71),
 ('13#526*3',246,NULL,NULL,800,23,NULL,46),
 ('13#527*3',156,NULL,NULL,800,10,NULL,123),
 ('13#528*3',220,NULL,NULL,800,17,NULL,66),
 ('13#529*3',50,NULL,NULL,800,8,NULL,150),
 ('13#53*1',248,NULL,NULL,1100,22,NULL,157),
 ('13#530*3',182,NULL,NULL,800,14,NULL,87),
 ('13#531*3',155,NULL,NULL,800,11,NULL,115),
 ('13#532*3',374,NULL,NULL,800,41,NULL,11),
 ('13#533*3',374,NULL,NULL,800,42,NULL,11),
 ('13#534*3',225,NULL,NULL,800,18,NULL,60),
 ('13#535*3',315,NULL,NULL,800,28,NULL,27),
 ('13#536*3',487,NULL,NULL,800,62,NULL,3),
 ('13#537*3',196,NULL,NULL,800,13,NULL,95),
 ('13#538*3',215,NULL,NULL,800,23,NULL,47),
 ('13#539*3',181,NULL,NULL,800,13,NULL,101),
 ('13#54*1',440,NULL,NULL,1100,44,NULL,58),
 ('13#540*3',212,NULL,NULL,800,16,NULL,74),
 ('13#541*3',133,NULL,NULL,800,11,NULL,116),
 ('13#542*3',168,NULL,NULL,800,12,NULL,107),
 ('13#543*3',56,NULL,NULL,800,8,NULL,149),
 ('13#544*3',259,NULL,NULL,800,25,NULL,38),
 ('13#545*3',208,NULL,NULL,800,18,NULL,63),
 ('13#546*3',103,NULL,NULL,800,10,NULL,133),
 ('13#547*3',122,NULL,NULL,800,12,NULL,111),
 ('13#548*3',106,NULL,NULL,800,12,NULL,112),
 ('13#549*3',472,NULL,NULL,800,59,NULL,4),
 ('13#55*1',362,NULL,NULL,1100,35,NULL,92),
 ('13#550*3',268,NULL,NULL,800,27,NULL,32),
 ('13#551*3',169,NULL,NULL,800,14,NULL,92),
 ('13#552*3',0,NULL,NULL,600,6,NULL,169),
 ('13#553*3',216,NULL,NULL,800,19,NULL,58),
 ('13#554*3',394,NULL,NULL,800,45,NULL,8),
 ('13#555*3',0,NULL,NULL,600,6,NULL,169),
 ('13#556*3',328,NULL,NULL,800,34,NULL,18),
 ('13#557*3',359,NULL,NULL,800,37,NULL,16),
 ('13#558*3',173,NULL,NULL,800,15,NULL,82),
 ('13#559*3',359,NULL,NULL,800,39,NULL,13),
 ('13#56*1',135,NULL,NULL,1100,12,NULL,235),
 ('13#560*3',168,NULL,NULL,800,12,NULL,107),
 ('13#561*3',6,NULL,NULL,600,6,NULL,167),
 ('13#562*3',209,NULL,NULL,800,16,NULL,76),
 ('13#563*3',169,NULL,NULL,800,13,NULL,103),
 ('13#564*3',10,NULL,NULL,800,8,NULL,155),
 ('13#565*3',175,NULL,NULL,800,14,NULL,88),
 ('13#566*3',193,NULL,NULL,800,13,NULL,96),
 ('13#567*3',274,NULL,NULL,800,29,NULL,26),
 ('13#568*3',202,NULL,NULL,800,21,NULL,51),
 ('13#569*3',152,NULL,NULL,800,10,NULL,124),
 ('13#57*1',73,NULL,NULL,1100,11,NULL,252),
 ('13#570*3',217,NULL,NULL,800,14,NULL,83),
 ('13#571*3',123,NULL,NULL,800,10,NULL,131),
 ('13#572*3',209,NULL,NULL,800,14,NULL,84),
 ('13#573*3',0,NULL,NULL,600,6,NULL,169),
 ('13#574*3',171,NULL,NULL,800,14,NULL,91),
 ('13#575*3',125,NULL,NULL,800,10,NULL,130),
 ('13#576*3',0,NULL,NULL,600,6,NULL,169),
 ('13#577*3',160,NULL,NULL,800,14,NULL,94),
 ('13#578*3',0,NULL,NULL,700,7,NULL,164),
 ('13#579*3',126,NULL,NULL,800,8,NULL,141),
 ('13#58*1',390,NULL,NULL,1100,36,NULL,89),
 ('13#580*3',214,NULL,NULL,800,15,NULL,78),
 ('13#581*3',132,NULL,NULL,800,9,NULL,138),
 ('13#582*3',22,NULL,NULL,800,8,NULL,154),
 ('13#583*3',249,NULL,NULL,800,25,NULL,39),
 ('13#584*3',246,NULL,NULL,800,27,NULL,33),
 ('13#585*3',24,NULL,NULL,800,8,NULL,153),
 ('13#586*3',0,NULL,NULL,600,6,NULL,169),
 ('13#587*3',0,NULL,NULL,600,6,NULL,169),
 ('13#588*3',275,NULL,NULL,800,27,NULL,31),
 ('13#589*3',428,NULL,NULL,800,50,NULL,6),
 ('13#59*1',46,NULL,NULL,1100,11,NULL,263),
 ('13#590*3',270,NULL,NULL,800,30,NULL,24),
 ('13#591*3',0,NULL,NULL,600,6,NULL,169),
 ('13#592*3',211,NULL,NULL,800,16,NULL,75),
 ('13#593*3',189,NULL,NULL,800,17,NULL,70),
 ('13#594*3',303,NULL,NULL,800,34,NULL,20),
 ('13#595*3',0,NULL,NULL,600,6,NULL,169),
 ('13#596*3',383,NULL,NULL,800,45,NULL,9),
 ('13#597*3',350,NULL,NULL,800,39,NULL,15),
 ('13#598*3',2,NULL,NULL,700,7,NULL,161),
 ('13#599*3',112,NULL,NULL,800,8,NULL,142),
 ('13#6*1',283,NULL,NULL,1100,22,NULL,154),
 ('13#60*1',234,NULL,NULL,1100,19,NULL,182),
 ('13#600*3',159,NULL,NULL,800,11,NULL,114),
 ('13#601*3',258,NULL,NULL,800,19,NULL,54),
 ('13#602*3',323,NULL,NULL,800,33,NULL,21),
 ('13#603*3',0,NULL,NULL,600,6,NULL,169),
 ('13#604*3',419,NULL,NULL,800,49,NULL,7),
 ('13#605*3',551,NULL,NULL,800,72,NULL,1),
 ('13#606*3',90,NULL,NULL,800,11,NULL,120),
 ('13#607*3',308,NULL,NULL,800,34,NULL,19),
 ('13#608*3',513,NULL,NULL,800,69,NULL,2),
 ('13#609*3',0,NULL,NULL,600,6,NULL,169),
 ('13#61*1',443,NULL,NULL,1100,46,NULL,54),
 ('13#610*3',62,NULL,NULL,700,13,NULL,105),
 ('13#611*3',233,NULL,NULL,800,24,NULL,44),
 ('13#612*3',181,NULL,NULL,800,15,NULL,81),
 ('13#613*3',172,NULL,NULL,800,14,NULL,90),
 ('13#614*3',146,NULL,NULL,800,12,NULL,110),
 ('13#615*3',148,NULL,NULL,800,10,NULL,126),
 ('13#616*3',10,NULL,NULL,600,6,NULL,166),
 ('13#617*3',307,NULL,NULL,800,33,NULL,22),
 ('13#618*3',209,NULL,NULL,800,20,NULL,53),
 ('13#619*3',212,NULL,NULL,800,18,NULL,62),
 ('13#62*1',41,NULL,NULL,1100,11,NULL,264),
 ('13#620*3',0,NULL,NULL,600,6,NULL,169),
 ('13#621*3',244,NULL,NULL,800,26,NULL,35),
 ('13#622*3',4,NULL,NULL,600,6,NULL,168),
 ('13#623*3',203,NULL,NULL,700,17,NULL,65),
 ('13#624*3',283,NULL,NULL,800,27,NULL,30),
 ('13#625*3',288,NULL,NULL,800,25,NULL,36),
 ('13#626*3',150,NULL,NULL,800,10,NULL,125),
 ('13#627*3',20,NULL,NULL,700,7,NULL,160),
 ('13#628*3',130,NULL,NULL,800,11,NULL,117),
 ('13#629*3',254,NULL,NULL,800,24,NULL,43),
 ('13#63*1',425,NULL,NULL,1100,43,NULL,63),
 ('13#630*3',228,NULL,NULL,800,19,NULL,56),
 ('13#631*3',268,NULL,NULL,800,24,NULL,40),
 ('13#632*3',104,NULL,NULL,800,9,NULL,140),
 ('13#633*3',290,NULL,NULL,800,29,NULL,25),
 ('13#634*3',336,NULL,NULL,800,34,NULL,17),
 ('13#635*3',388,NULL,NULL,800,43,NULL,10),
 ('13#636*3',302,NULL,NULL,800,27,NULL,29),
 ('13#637*3',98,NULL,NULL,800,8,NULL,144),
 ('13#638*3',132,NULL,NULL,800,10,NULL,129),
 ('13#639*3',186,NULL,NULL,800,13,NULL,99),
 ('13#64*1',430,NULL,NULL,1100,41,NULL,71),
 ('13#640*3',122,NULL,NULL,800,13,NULL,104),
 ('13#641*3',223,NULL,NULL,800,16,NULL,72),
 ('13#642*3',0,NULL,NULL,800,8,NULL,156),
 ('13#643*4',0,NULL,NULL,600,6,NULL,88),
 ('13#644*4',249,NULL,NULL,800,18,NULL,21),
 ('13#645*4',171,NULL,NULL,800,12,NULL,38),
 ('13#646*4',368,NULL,NULL,800,38,NULL,4),
 ('13#647*4',237,NULL,NULL,800,29,NULL,11),
 ('13#648*4',308,NULL,NULL,800,30,NULL,10),
 ('13#649*4',110,NULL,NULL,800,10,NULL,44),
 ('13#65*1',408,NULL,NULL,1100,38,NULL,80),
 ('13#650*4',224,NULL,NULL,800,13,NULL,35),
 ('13#651*4',213,NULL,NULL,800,12,NULL,37),
 ('13#652*4',343,NULL,NULL,800,35,NULL,8),
 ('13#653*4',360,NULL,NULL,800,40,NULL,3),
 ('13#654*4',298,NULL,NULL,800,26,NULL,13),
 ('13#655*4',277,NULL,NULL,800,23,NULL,14),
 ('13#656*4',138,NULL,NULL,800,9,NULL,49),
 ('13#657*4',357,NULL,NULL,800,37,NULL,6),
 ('13#658*4',294,NULL,NULL,800,38,NULL,5),
 ('13#659*4',83,NULL,NULL,800,10,NULL,45),
 ('13#66*1',499,NULL,NULL,1100,57,NULL,30),
 ('13#660*4',46,NULL,NULL,800,8,NULL,79),
 ('13#661*4',224,NULL,NULL,800,18,NULL,23),
 ('13#662*4',109,NULL,NULL,800,8,NULL,60),
 ('13#663*4',1,NULL,NULL,600,6,NULL,87),
 ('13#664*4',151,NULL,NULL,800,10,NULL,43),
 ('13#665*4',222,NULL,NULL,800,13,NULL,36),
 ('13#666*4',195,NULL,NULL,800,15,NULL,31),
 ('13#667*4',9,NULL,NULL,600,6,NULL,86),
 ('13#668*4',119,NULL,NULL,800,9,NULL,50),
 ('13#669*4',95,NULL,NULL,800,8,NULL,65),
 ('13#67*1',434,NULL,NULL,1100,40,NULL,73),
 ('13#670*4',195,NULL,NULL,800,15,NULL,31),
 ('13#671*4',318,NULL,NULL,800,44,NULL,2),
 ('13#672*4',48,NULL,NULL,800,8,NULL,77),
 ('13#673*4',60,NULL,NULL,800,8,NULL,75),
 ('13#674*4',136,NULL,NULL,800,8,NULL,55),
 ('13#675*4',165,NULL,NULL,800,9,NULL,46),
 ('13#676*4',139,NULL,NULL,800,8,NULL,54),
 ('13#677*4',131,NULL,NULL,800,8,NULL,58),
 ('13#678*4',46,NULL,NULL,800,8,NULL,79),
 ('13#679*4',88,NULL,NULL,800,8,NULL,68),
 ('13#68*1',454,NULL,NULL,1100,42,NULL,64),
 ('13#680*4',48,NULL,NULL,800,8,NULL,77),
 ('13#681*4',100,NULL,NULL,800,8,NULL,63),
 ('13#682*4',74,NULL,NULL,800,8,NULL,70),
 ('13#683*4',84,NULL,NULL,800,8,NULL,69),
 ('13#684*4',153,NULL,NULL,800,10,NULL,42),
 ('13#685*4',96,NULL,NULL,800,8,NULL,64),
 ('13#686*4',132,NULL,NULL,800,8,NULL,57),
 ('13#687*4',26,NULL,NULL,700,7,NULL,84),
 ('13#688*4',217,NULL,NULL,800,16,NULL,26),
 ('13#689*4',22,NULL,NULL,700,7,NULL,85),
 ('13#69*1',0,NULL,NULL,1100,11,NULL,274),
 ('13#690*4',244,NULL,NULL,800,19,NULL,20),
 ('13#691*4',226,NULL,NULL,800,18,NULL,22),
 ('13#692*4',261,NULL,NULL,800,21,NULL,16),
 ('13#693*4',142,NULL,NULL,800,14,NULL,34),
 ('13#694*4',108,NULL,NULL,800,8,NULL,61),
 ('13#695*4',210,NULL,NULL,800,15,NULL,30),
 ('13#696*4',335,NULL,NULL,800,47,NULL,1),
 ('13#697*4',248,NULL,NULL,800,21,NULL,17),
 ('13#698*4',146,NULL,NULL,800,9,NULL,48),
 ('13#699*4',0,NULL,NULL,500,5,NULL,88),
 ('13#7*1',505,NULL,NULL,1100,52,NULL,36),
 ('13#70*1',457,NULL,NULL,1100,43,NULL,60),
 ('13#700*4',127,NULL,NULL,800,11,NULL,41),
 ('13#701*4',51,NULL,NULL,700,7,NULL,82),
 ('13#702*4',359,NULL,NULL,800,35,NULL,7),
 ('13#703*4',107,NULL,NULL,800,9,NULL,51),
 ('13#704*4',155,NULL,NULL,800,9,NULL,47),
 ('13#705*4',226,NULL,NULL,800,17,NULL,25),
 ('13#706*4',167,NULL,NULL,800,15,NULL,33),
 ('13#707*4',266,NULL,NULL,800,22,NULL,15),
 ('13#708*4',316,NULL,NULL,800,34,NULL,9),
 ('13#709*4',157,NULL,NULL,800,8,NULL,52),
 ('13#71*1',461,NULL,NULL,1100,47,NULL,50),
 ('13#710*4',65,NULL,NULL,800,8,NULL,73),
 ('13#711*4',152,NULL,NULL,800,16,NULL,28),
 ('13#712*4',91,NULL,NULL,800,8,NULL,67),
 ('13#713*4',35,NULL,NULL,700,7,NULL,83),
 ('13#714*4',172,NULL,NULL,800,11,NULL,40),
 ('13#715*4',212,NULL,NULL,800,15,NULL,29),
 ('13#716*4',245,NULL,NULL,800,19,NULL,19),
 ('13#717*4',104,NULL,NULL,800,8,NULL,62),
 ('13#718*4',235,NULL,NULL,800,28,NULL,12),
 ('13#719*4',121,NULL,NULL,800,8,NULL,59),
 ('13#72*1',575,NULL,NULL,1100,69,NULL,16),
 ('13#720*4',204,NULL,NULL,800,16,NULL,27),
 ('13#721*4',45,NULL,NULL,800,8,NULL,81),
 ('13#722*4',135,NULL,NULL,800,12,NULL,39),
 ('13#723*4',69,NULL,NULL,800,8,NULL,72),
 ('13#724*4',150,NULL,NULL,800,8,NULL,53),
 ('13#725*4',95,NULL,NULL,800,8,NULL,65),
 ('13#726*4',217,NULL,NULL,800,18,NULL,24),
 ('13#727*4',55,NULL,NULL,800,8,NULL,76),
 ('13#728*4',134,NULL,NULL,800,8,NULL,56),
 ('13#729*4',255,NULL,NULL,800,19,NULL,18),
 ('13#73*1',68,NULL,NULL,1100,11,NULL,257),
 ('13#730*4',0,NULL,NULL,500,5,NULL,88),
 ('13#731*4',64,NULL,NULL,800,8,NULL,74),
 ('13#732*4',70,NULL,NULL,800,8,NULL,71),
 ('13#74*1',469,NULL,NULL,1100,49,NULL,44),
 ('13#75*1',385,NULL,NULL,1100,38,NULL,83),
 ('13#76*1',341,NULL,NULL,1100,27,NULL,124),
 ('13#77*1',684,NULL,NULL,1100,88,NULL,5),
 ('13#78*1',244,NULL,NULL,1100,21,NULL,166),
 ('13#79*1',455,NULL,NULL,1100,49,NULL,47),
 ('13#8*1',489,NULL,NULL,1100,50,NULL,42),
 ('13#80*1',487,NULL,NULL,1100,52,NULL,39),
 ('13#81*1',469,NULL,NULL,1100,46,NULL,51),
 ('13#82*1',81,NULL,NULL,1100,12,NULL,242),
 ('13#83*1',488,NULL,NULL,1100,50,NULL,43),
 ('13#84*1',559,NULL,NULL,1100,67,NULL,22),
 ('13#85*1',74,NULL,NULL,1100,15,NULL,213),
 ('13#86*1',446,NULL,NULL,1100,43,NULL,61),
 ('13#87*1',70,NULL,NULL,1100,11,NULL,255),
 ('13#88*1',378,NULL,NULL,1100,33,NULL,99),
 ('13#89*1',455,NULL,NULL,1100,44,NULL,56),
 ('13#9*1',25,NULL,NULL,1100,11,NULL,268),
 ('13#90*1',503,NULL,NULL,1100,53,NULL,33),
 ('13#91*1',573,NULL,NULL,1100,65,NULL,23),
 ('13#92*1',408,NULL,NULL,1100,34,NULL,94),
 ('13#93*1',5,NULL,NULL,1100,11,NULL,272),
 ('13#94*1',138,NULL,NULL,1100,12,NULL,234),
 ('13#95*1',172,NULL,NULL,1100,13,NULL,223),
 ('13#96*1',496,NULL,NULL,1100,52,NULL,37),
 ('13#97*1',75,NULL,NULL,1100,11,NULL,250),
 ('13#98*1',250,NULL,NULL,1100,20,NULL,174),
 ('13#99*1',286,NULL,NULL,1100,24,NULL,143),
 ('14#1*1',133,NULL,NULL,1100,16,NULL,232),
 ('14#10*1',603,NULL,NULL,1100,89,NULL,11),
 ('14#100*1',314,NULL,NULL,1100,42,NULL,109),
 ('14#101*1',398,NULL,NULL,1100,54,NULL,65),
 ('14#102*1',400,NULL,NULL,1100,51,NULL,69),
 ('14#103*1',65,NULL,NULL,1100,11,NULL,258),
 ('14#104*1',145,NULL,NULL,1100,18,NULL,226),
 ('14#105*1',0,NULL,NULL,1100,11,NULL,274),
 ('14#106*1',396,NULL,NULL,1100,53,NULL,68),
 ('14#107*1',268,NULL,NULL,1100,30,NULL,162),
 ('14#108*1',417,NULL,NULL,1100,56,NULL,54),
 ('14#109*1',590,NULL,NULL,1100,89,NULL,12),
 ('14#11*1',636,NULL,NULL,1100,92,NULL,8),
 ('14#110*1',0,NULL,NULL,1100,11,NULL,274),
 ('14#111*1',201,NULL,NULL,1100,23,NULL,200),
 ('14#112*1',391,NULL,NULL,1100,50,NULL,75),
 ('14#113*1',254,NULL,NULL,1100,30,NULL,166),
 ('14#114*1',345,NULL,NULL,1100,45,NULL,96),
 ('14#115*1',289,NULL,NULL,1100,34,NULL,137),
 ('14#116*1',164,NULL,NULL,1100,23,NULL,203),
 ('14#117*1',391,NULL,NULL,1100,50,NULL,75),
 ('14#118*1',261,NULL,NULL,1100,27,NULL,176),
 ('14#119*1',26,NULL,NULL,1100,11,NULL,262),
 ('14#12*1',342,NULL,NULL,1100,44,NULL,102),
 ('14#120*1',305,NULL,NULL,1100,38,NULL,124),
 ('14#121*1',180,NULL,NULL,1100,24,NULL,193),
 ('14#122*1',420,NULL,NULL,1100,55,NULL,57),
 ('14#123*1',384,NULL,NULL,1100,49,NULL,80),
 ('14#124*1',7,NULL,NULL,1100,11,NULL,270),
 ('14#125*1',86,NULL,NULL,1100,11,NULL,257),
 ('14#126*1',318,NULL,NULL,1100,40,NULL,116),
 ('14#127*1',112,NULL,NULL,1100,16,NULL,234),
 ('14#128*1',183,NULL,NULL,1100,21,NULL,212),
 ('14#129*1',340,NULL,NULL,1100,44,NULL,103),
 ('14#13*1',27,NULL,NULL,1100,11,NULL,261),
 ('14#130*1',251,NULL,NULL,1100,28,NULL,172),
 ('14#131*1',301,NULL,NULL,1100,36,NULL,127),
 ('14#132*1',470,NULL,NULL,1100,63,NULL,32),
 ('14#133*1',400,NULL,NULL,1100,50,NULL,73),
 ('14#134*1',285,NULL,NULL,1100,35,NULL,134),
 ('14#135*1',166,NULL,NULL,1100,19,NULL,222),
 ('14#136*1',315,NULL,NULL,1100,35,NULL,131),
 ('14#137*1',678,NULL,NULL,1100,104,NULL,2),
 ('14#138*1',354,NULL,NULL,1100,43,NULL,105),
 ('14#139*1',281,NULL,NULL,1100,33,NULL,146),
 ('14#14*1',275,NULL,NULL,1100,36,NULL,130),
 ('14#140*1',278,NULL,NULL,1100,30,NULL,161),
 ('14#141*1',636,NULL,NULL,1100,94,NULL,6),
 ('14#142*1',226,NULL,NULL,1100,30,NULL,168),
 ('14#143*1',203,NULL,NULL,1100,23,NULL,198),
 ('14#144*1',460,NULL,NULL,1100,65,NULL,31),
 ('14#145*1',417,NULL,NULL,1100,57,NULL,51),
 ('14#146*1',86,NULL,NULL,1100,14,NULL,243),
 ('14#147*1',343,NULL,NULL,1100,45,NULL,97),
 ('14#148*1',222,NULL,NULL,1100,27,NULL,181),
 ('14#149*1',269,NULL,NULL,1100,31,NULL,158),
 ('14#15*1',259,NULL,NULL,1100,31,NULL,159),
 ('14#150*1',464,NULL,NULL,1100,67,NULL,29),
 ('14#151*1',601,NULL,NULL,1100,90,NULL,10),
 ('14#152*1',279,NULL,NULL,1100,31,NULL,157),
 ('14#153*1',331,NULL,NULL,1100,41,NULL,110),
 ('14#154*1',324,NULL,NULL,1100,38,NULL,122),
 ('14#155*1',276,NULL,NULL,1100,32,NULL,151),
 ('14#156*1',173,NULL,NULL,1100,21,NULL,213),
 ('14#157*1',37,NULL,NULL,1100,11,NULL,260),
 ('14#158*1',290,NULL,NULL,1100,36,NULL,129),
 ('14#159*1',288,NULL,NULL,1100,33,NULL,143),
 ('14#16*1',162,NULL,NULL,1100,24,NULL,194),
 ('14#160*1',430,NULL,NULL,1100,57,NULL,50),
 ('14#161*1',442,NULL,NULL,1100,58,NULL,48),
 ('14#162*1',9,NULL,NULL,1100,11,NULL,269),
 ('14#163*1',292,NULL,NULL,1100,32,NULL,148),
 ('14#164*1',353,NULL,NULL,1100,44,NULL,101),
 ('14#165*1',4,NULL,NULL,1100,11,NULL,273),
 ('14#166*1',174,NULL,NULL,1100,22,NULL,208),
 ('14#167*1',690,NULL,NULL,1100,102,NULL,3),
 ('14#168*1',314,NULL,NULL,1100,40,NULL,117),
 ('14#169*1',466,NULL,NULL,1100,63,NULL,33),
 ('14#17*1',384,NULL,NULL,1100,50,NULL,78),
 ('14#170*1',586,NULL,NULL,1100,86,NULL,15),
 ('14#171*1',334,NULL,NULL,1100,45,NULL,99),
 ('14#172*1',113,NULL,NULL,1100,14,NULL,242),
 ('14#173*1',10,NULL,NULL,1100,11,NULL,268),
 ('14#174*1',225,NULL,NULL,1100,25,NULL,189),
 ('14#175*1',190,NULL,NULL,1100,22,NULL,204),
 ('14#176*1',445,NULL,NULL,1100,62,NULL,40),
 ('14#177*1',22,NULL,NULL,1100,11,NULL,265),
 ('14#178*1',374,NULL,NULL,1100,47,NULL,88),
 ('14#179*1',535,NULL,NULL,1100,75,NULL,22),
 ('14#18*1',357,NULL,NULL,1100,46,NULL,93),
 ('14#180*1',129,NULL,NULL,1100,13,NULL,244),
 ('14#181*1',254,NULL,NULL,1100,31,NULL,160),
 ('14#182*1',375,NULL,NULL,1100,50,NULL,79),
 ('14#183*1',218,NULL,NULL,1100,24,NULL,190),
 ('14#184*1',270,NULL,NULL,1100,27,NULL,175),
 ('14#185*1',266,NULL,NULL,1100,30,NULL,163),
 ('14#186*1',7,NULL,NULL,1100,11,NULL,270),
 ('14#187*1',154,NULL,NULL,1100,14,NULL,240),
 ('14#188*1',101,NULL,NULL,1100,12,NULL,250),
 ('14#189*1',426,NULL,NULL,1100,59,NULL,47),
 ('14#19*1',190,NULL,NULL,1100,24,NULL,192),
 ('14#190*1',416,NULL,NULL,1100,55,NULL,60),
 ('14#191*1',239,NULL,NULL,1100,27,NULL,178),
 ('14#192*1',328,NULL,NULL,1100,40,NULL,113),
 ('14#193*1',650,NULL,NULL,1100,95,NULL,5),
 ('14#194*1',0,NULL,NULL,1100,11,NULL,274),
 ('14#195*1',74,NULL,NULL,1100,13,NULL,246),
 ('14#196*1',202,NULL,NULL,1100,24,NULL,191),
 ('14#197*1',154,NULL,NULL,1100,22,NULL,209),
 ('14#198*1',200,NULL,NULL,1100,23,NULL,201),
 ('14#199*1',288,NULL,NULL,1100,32,NULL,150),
 ('14#2*1',560,NULL,NULL,1100,82,NULL,17),
 ('14#20*1',368,NULL,NULL,1100,48,NULL,83),
 ('14#200*1',425,NULL,NULL,1100,55,NULL,56),
 ('14#201*1',116,NULL,NULL,1100,15,NULL,235),
 ('14#202*1',175,NULL,NULL,1100,19,NULL,221),
 ('14#203*1',399,NULL,NULL,1100,51,NULL,70),
 ('14#204*1',245,NULL,NULL,1100,27,NULL,177),
 ('14#205*1',293,NULL,NULL,1100,36,NULL,128),
 ('14#206*1',192,NULL,NULL,1100,19,NULL,219),
 ('14#207*1',396,NULL,NULL,1100,50,NULL,74),
 ('14#208*1',530,NULL,NULL,1100,79,NULL,21),
 ('14#209*1',438,NULL,NULL,1100,59,NULL,46),
 ('14#21*1',551,NULL,NULL,1100,81,NULL,19),
 ('14#210*1',446,NULL,NULL,1100,62,NULL,39),
 ('14#211*1',186,NULL,NULL,1100,18,NULL,223),
 ('14#212*1',358,NULL,NULL,1100,46,NULL,91),
 ('14#213*1',175,NULL,NULL,1100,22,NULL,207),
 ('14#214*1',436,NULL,NULL,1100,57,NULL,49),
 ('14#215*1',96,NULL,NULL,1100,12,NULL,251),
 ('14#216*1',117,NULL,NULL,1100,16,NULL,233),
 ('14#217*1',401,NULL,NULL,1100,54,NULL,64),
 ('14#218*1',105,NULL,NULL,1100,13,NULL,245),
 ('14#219*1',423,NULL,NULL,1100,56,NULL,52),
 ('14#22*1',459,NULL,NULL,1100,63,NULL,36),
 ('14#220*1',285,NULL,NULL,1100,35,NULL,134),
 ('14#221*1',235,NULL,NULL,1100,28,NULL,174),
 ('14#222*1',192,NULL,NULL,1100,26,NULL,188),
 ('14#223*1',197,NULL,NULL,1100,23,NULL,202),
 ('14#224*1',512,NULL,NULL,1100,73,NULL,25),
 ('14#225*1',182,NULL,NULL,1100,22,NULL,206),
 ('14#226*1',248,NULL,NULL,1100,29,NULL,170),
 ('14#227*1',326,NULL,NULL,1100,40,NULL,114),
 ('14#228*1',311,NULL,NULL,1100,39,NULL,119),
 ('14#229*1',117,NULL,NULL,1100,17,NULL,229),
 ('14#23*1',261,NULL,NULL,1100,32,NULL,153),
 ('14#230*1',144,NULL,NULL,1100,18,NULL,227),
 ('14#231*1',332,NULL,NULL,1100,39,NULL,118),
 ('14#232*1',0,NULL,NULL,1100,11,NULL,274),
 ('14#233*1',174,NULL,NULL,1100,18,NULL,224),
 ('14#234*1',101,NULL,NULL,1100,15,NULL,239),
 ('14#235*1',0,NULL,NULL,1100,11,NULL,274),
 ('14#236*1',399,NULL,NULL,1100,51,NULL,70),
 ('14#237*1',340,NULL,NULL,1100,45,NULL,98),
 ('14#238*1',587,NULL,NULL,1100,87,NULL,13),
 ('14#239*1',229,NULL,NULL,1100,27,NULL,179),
 ('14#24*1',284,NULL,NULL,1100,39,NULL,121),
 ('14#240*1',392,NULL,NULL,1100,51,NULL,72),
 ('14#241*1',595,NULL,NULL,1100,86,NULL,14),
 ('14#242*1',259,NULL,NULL,1100,30,NULL,165),
 ('14#243*1',113,NULL,NULL,1100,15,NULL,236),
 ('14#244*1',12,NULL,NULL,1100,11,NULL,266),
 ('14#245*1',26,NULL,NULL,1100,11,NULL,262),
 ('14#246*1',210,NULL,NULL,1100,26,NULL,186),
 ('14#247*1',187,NULL,NULL,1100,22,NULL,205),
 ('14#248*1',172,NULL,NULL,1100,20,NULL,216),
 ('14#249*1',164,NULL,NULL,1100,21,NULL,214),
 ('14#25*1',246,NULL,NULL,1100,28,NULL,173),
 ('14#250*1',49,NULL,NULL,1100,12,NULL,254),
 ('14#251*1',361,NULL,NULL,1100,43,NULL,104),
 ('14#252*1',214,NULL,NULL,1100,27,NULL,182),
 ('14#253*1',320,NULL,NULL,1100,38,NULL,123),
 ('14#254*1',231,NULL,NULL,1100,29,NULL,171),
 ('14#255*1',123,NULL,NULL,1100,20,NULL,218),
 ('14#256*1',260,NULL,NULL,1100,30,NULL,164),
 ('14#257*1',82,NULL,NULL,1100,12,NULL,253),
 ('14#258*1',425,NULL,NULL,1100,54,NULL,62),
 ('14#259*1',505,NULL,NULL,1100,72,NULL,26),
 ('14#26*1',578,NULL,NULL,1100,85,NULL,16),
 ('14#260*1',290,NULL,NULL,1100,32,NULL,149),
 ('14#261*1',287,NULL,NULL,1100,33,NULL,144),
 ('14#262*1',65,NULL,NULL,1100,11,NULL,258),
 ('14#263*1',185,NULL,NULL,1100,21,NULL,211),
 ('14#264*1',310,NULL,NULL,1100,33,NULL,142),
 ('14#265*1',630,NULL,NULL,1100,96,NULL,4),
 ('14#266*1',221,NULL,NULL,1100,23,NULL,196),
 ('14#267*1',309,NULL,NULL,1100,35,NULL,132),
 ('14#268*1',445,NULL,NULL,1100,61,NULL,40),
 ('14#269*1',701,NULL,NULL,1100,108,NULL,1),
 ('14#27*1',546,NULL,NULL,1100,81,NULL,20),
 ('14#270*1',255,NULL,NULL,1100,32,NULL,154),
 ('14#271*1',284,NULL,NULL,1100,31,NULL,156),
 ('14#272*1',163,NULL,NULL,1100,18,NULL,225),
 ('14#273*1',408,NULL,NULL,1100,53,NULL,66),
 ('14#274*1',136,NULL,NULL,1100,20,NULL,217),
 ('14#275*1',67,NULL,NULL,1100,13,NULL,247),
 ('14#276*1',391,NULL,NULL,1100,47,NULL,87),
 ('14#277*1',291,NULL,NULL,1100,31,NULL,155),
 ('14#278*1',195,NULL,NULL,1100,26,NULL,187),
 ('14#279*2',78,NULL,NULL,1100,13,NULL,150),
 ('14#28*1',355,NULL,NULL,1100,49,NULL,81),
 ('14#280*2',28,NULL,NULL,1100,12,NULL,156),
 ('14#281*2',503,NULL,NULL,1100,72,NULL,14),
 ('14#282*2',79,NULL,NULL,1100,12,NULL,155),
 ('14#283*2',395,NULL,NULL,1100,53,NULL,30),
 ('14#284*2',624,NULL,NULL,1100,90,NULL,6),
 ('14#285*2',133,NULL,NULL,1100,18,NULL,130),
 ('14#286*2',355,NULL,NULL,1100,49,NULL,41),
 ('14#287*2',445,NULL,NULL,1100,63,NULL,17),
 ('14#288*2',33,NULL,NULL,1100,14,NULL,146),
 ('14#289*2',0,NULL,NULL,1100,11,NULL,168),
 ('14#29*1',179,NULL,NULL,1100,20,NULL,215),
 ('14#290*2',116,NULL,NULL,1100,15,NULL,142),
 ('14#291*2',276,NULL,NULL,1100,33,NULL,65),
 ('14#292*2',438,NULL,NULL,1100,60,NULL,21),
 ('14#293*2',125,NULL,NULL,1100,19,NULL,122),
 ('14#294*2',0,NULL,NULL,1100,11,NULL,168),
 ('14#295*2',147,NULL,NULL,1100,17,NULL,132),
 ('14#296*2',144,NULL,NULL,1100,18,NULL,129),
 ('14#297*2',0,NULL,NULL,1100,11,NULL,168),
 ('14#298*2',0,NULL,NULL,1100,11,NULL,168),
 ('14#299*2',451,NULL,NULL,1100,61,NULL,20),
 ('14#3*1',348,NULL,NULL,1100,43,NULL,106),
 ('14#30*1',439,NULL,NULL,1100,60,NULL,44),
 ('14#300*2',215,NULL,NULL,1100,22,NULL,105),
 ('14#301*2',226,NULL,NULL,1100,28,NULL,83),
 ('14#302*2',628,NULL,NULL,1100,97,NULL,5),
 ('14#303*2',218,NULL,NULL,1100,26,NULL,90),
 ('14#304*2',202,NULL,NULL,1100,27,NULL,87),
 ('14#305*2',480,NULL,NULL,1100,69,NULL,15),
 ('14#306*2',284,NULL,NULL,1100,36,NULL,62),
 ('14#307*2',235,NULL,NULL,1100,26,NULL,89),
 ('14#308*2',0,NULL,NULL,1100,11,NULL,168),
 ('14#309*2',286,NULL,NULL,1100,32,NULL,67),
 ('14#31*1',283,NULL,NULL,1100,34,NULL,139),
 ('14#310*2',0,NULL,NULL,1100,11,NULL,168),
 ('14#311*2',184,NULL,NULL,1100,24,NULL,100),
 ('14#312*2',63,NULL,NULL,1100,11,NULL,160),
 ('14#313*2',167,NULL,NULL,1100,19,NULL,119),
 ('14#314*2',236,NULL,NULL,1100,23,NULL,102),
 ('14#315*2',126,NULL,NULL,1100,17,NULL,133),
 ('14#316*2',3,NULL,NULL,1100,11,NULL,167),
 ('14#317*2',253,NULL,NULL,1100,30,NULL,76),
 ('14#318*2',84,NULL,NULL,1100,13,NULL,149),
 ('14#319*2',48,NULL,NULL,1100,16,NULL,141),
 ('14#32*1',240,NULL,NULL,1100,26,NULL,184),
 ('14#320*2',293,NULL,NULL,1100,32,NULL,66),
 ('14#321*2',89,NULL,NULL,1100,14,NULL,145),
 ('14#322*2',150,NULL,NULL,1100,18,NULL,127),
 ('14#323*2',264,NULL,NULL,1100,31,NULL,69),
 ('14#324*2',219,NULL,NULL,1100,29,NULL,80),
 ('14#325*2',0,NULL,NULL,1100,11,NULL,168),
 ('14#326*2',328,NULL,NULL,1100,44,NULL,53),
 ('14#327*2',290,NULL,NULL,1100,36,NULL,61),
 ('14#328*2',205,NULL,NULL,1100,24,NULL,97),
 ('14#329*2',445,NULL,NULL,1100,63,NULL,17),
 ('14#33*1',204,NULL,NULL,1100,21,NULL,210),
 ('14#330*2',192,NULL,NULL,1100,25,NULL,94),
 ('14#331*2',242,NULL,NULL,1100,27,NULL,86),
 ('14#332*2',374,NULL,NULL,1100,48,NULL,43),
 ('14#333*2',407,NULL,NULL,1100,52,NULL,32),
 ('14#334*2',131,NULL,NULL,1100,14,NULL,144),
 ('14#335*2',77,NULL,NULL,1100,16,NULL,140),
 ('14#336*2',306,NULL,NULL,1100,36,NULL,59),
 ('14#337*2',405,NULL,NULL,1100,56,NULL,24),
 ('14#338*2',149,NULL,NULL,1100,16,NULL,135),
 ('14#339*2',146,NULL,NULL,1100,18,NULL,128),
 ('14#34*1',133,NULL,NULL,1100,11,NULL,255),
 ('14#340*2',29,NULL,NULL,1100,13,NULL,152),
 ('14#341*2',380,NULL,NULL,1100,53,NULL,31),
 ('14#342*2',218,NULL,NULL,1100,28,NULL,84),
 ('14#343*2',401,NULL,NULL,1100,54,NULL,26),
 ('14#344*2',254,NULL,NULL,1100,31,NULL,71),
 ('14#345*2',376,NULL,NULL,1100,48,NULL,42),
 ('14#346*2',378,NULL,NULL,1100,51,NULL,34),
 ('14#347*2',297,NULL,NULL,1100,36,NULL,60),
 ('14#348*2',185,NULL,NULL,1100,23,NULL,103),
 ('14#349*2',125,NULL,NULL,1100,16,NULL,136),
 ('14#35*1',204,NULL,NULL,1100,23,NULL,197),
 ('14#350*2',171,NULL,NULL,1100,18,NULL,125),
 ('14#351*2',120,NULL,NULL,1100,16,NULL,137),
 ('14#352*2',246,NULL,NULL,1100,31,NULL,72),
 ('14#353*2',373,NULL,NULL,1100,49,NULL,39),
 ('14#354*2',379,NULL,NULL,1100,50,NULL,36),
 ('14#355*2',248,NULL,NULL,1100,28,NULL,81),
 ('14#356*2',324,NULL,NULL,1100,46,NULL,49),
 ('14#357*2',195,NULL,NULL,1100,18,NULL,124),
 ('14#358*2',787,NULL,NULL,1100,117,NULL,2),
 ('14#359*2',399,NULL,NULL,1100,56,NULL,25),
 ('14#36*1',203,NULL,NULL,1100,23,NULL,198),
 ('14#360*2',264,NULL,NULL,1100,30,NULL,73),
 ('14#361*2',157,NULL,NULL,1100,16,NULL,134),
 ('14#362*2',416,NULL,NULL,1100,53,NULL,29),
 ('14#363*2',112,NULL,NULL,1100,19,NULL,123),
 ('14#364*2',231,NULL,NULL,1100,29,NULL,79),
 ('14#365*2',221,NULL,NULL,1100,25,NULL,93),
 ('14#366*2',358,NULL,NULL,1100,45,NULL,50),
 ('14#367*2',139,NULL,NULL,1100,23,NULL,104),
 ('14#368*2',200,NULL,NULL,1100,22,NULL,107),
 ('14#369*2',305,NULL,NULL,1100,41,NULL,54),
 ('14#37*1',400,NULL,NULL,1100,53,NULL,67),
 ('14#370*2',155,NULL,NULL,1100,19,NULL,120),
 ('14#371*2',344,NULL,NULL,1100,44,NULL,52),
 ('14#372*2',216,NULL,NULL,1100,28,NULL,85),
 ('14#373*2',323,NULL,NULL,1100,39,NULL,56),
 ('14#374*2',500,NULL,NULL,1100,74,NULL,12),
 ('14#375*2',0,NULL,NULL,1100,11,NULL,168),
 ('14#376*2',245,NULL,NULL,1100,30,NULL,77),
 ('14#377*2',184,NULL,NULL,1100,19,NULL,118),
 ('14#378*2',650,NULL,NULL,1100,97,NULL,4),
 ('14#379*2',242,NULL,NULL,1100,28,NULL,82),
 ('14#38*1',319,NULL,NULL,1100,40,NULL,115),
 ('14#380*2',420,NULL,NULL,1100,57,NULL,22),
 ('14#381*2',92,NULL,NULL,1100,11,NULL,158),
 ('14#382*2',121,NULL,NULL,1100,13,NULL,147),
 ('14#383*2',401,NULL,NULL,1100,55,NULL,26),
 ('14#384*2',598,NULL,NULL,1100,90,NULL,7),
 ('14#385*2',168,NULL,NULL,1100,20,NULL,117),
 ('14#386*2',365,NULL,NULL,1100,47,NULL,45),
 ('14#387*2',765,NULL,NULL,1100,114,NULL,3),
 ('14#388*2',0,NULL,NULL,1100,11,NULL,168),
 ('14#389*2',222,NULL,NULL,1100,24,NULL,95),
 ('14#39*1',364,NULL,NULL,1100,48,NULL,85),
 ('14#390*2',312,NULL,NULL,1100,38,NULL,58),
 ('14#391*2',234,NULL,NULL,1100,25,NULL,92),
 ('14#392*2',172,NULL,NULL,1100,22,NULL,110),
 ('14#393*2',22,NULL,NULL,1100,12,NULL,157),
 ('14#394*2',194,NULL,NULL,1100,21,NULL,112),
 ('14#395*2',189,NULL,NULL,1100,20,NULL,115),
 ('14#396*2',253,NULL,NULL,1100,34,NULL,64),
 ('14#397*2',17,NULL,NULL,1100,11,NULL,163),
 ('14#398*2',357,NULL,NULL,1100,47,NULL,47),
 ('14#399*2',364,NULL,NULL,1100,49,NULL,40),
 ('14#4*1',12,NULL,NULL,1100,11,NULL,266),
 ('14#40*1',522,NULL,NULL,1100,74,NULL,24),
 ('14#400*2',188,NULL,NULL,1100,20,NULL,116),
 ('14#401*2',254,NULL,NULL,1100,30,NULL,75),
 ('14#402*2',19,NULL,NULL,1100,11,NULL,162),
 ('14#403*2',272,NULL,NULL,1100,31,NULL,68),
 ('14#404*2',353,NULL,NULL,1100,47,NULL,48),
 ('14#405*2',256,NULL,NULL,1100,31,NULL,70),
 ('14#406*2',240,NULL,NULL,1100,23,NULL,101),
 ('14#407*2',192,NULL,NULL,1100,20,NULL,114),
 ('14#408*2',205,NULL,NULL,1100,24,NULL,97),
 ('14#409*2',330,NULL,NULL,1100,48,NULL,44),
 ('14#41*1',415,NULL,NULL,1100,55,NULL,61),
 ('14#410*2',0,NULL,NULL,1100,11,NULL,168),
 ('14#411*2',0,NULL,NULL,1100,11,NULL,168),
 ('14#412*2',8,NULL,NULL,1100,11,NULL,166),
 ('14#413*2',0,NULL,NULL,1100,11,NULL,168),
 ('14#414*2',311,NULL,NULL,1100,39,NULL,57),
 ('14#415*2',169,NULL,NULL,1100,18,NULL,126),
 ('14#416*2',45,NULL,NULL,1100,11,NULL,161),
 ('14#417*2',506,NULL,NULL,1100,73,NULL,13),
 ('14#418*2',364,NULL,NULL,1100,47,NULL,46),
 ('14#419*2',342,NULL,NULL,1100,45,NULL,51),
 ('14#42*1',352,NULL,NULL,1100,45,NULL,95),
 ('14#420*2',328,NULL,NULL,1100,40,NULL,55),
 ('14#421*2',202,NULL,NULL,1100,21,NULL,111),
 ('14#422*2',941,NULL,NULL,1100,126,NULL,1),
 ('14#423*2',17,NULL,NULL,1100,11,NULL,163),
 ('14#424*2',214,NULL,NULL,1100,24,NULL,96),
 ('14#425*2',522,NULL,NULL,1100,75,NULL,11),
 ('14#426*2',149,NULL,NULL,1100,19,NULL,121),
 ('14#427*2',377,NULL,NULL,1100,49,NULL,37),
 ('14#428*2',207,NULL,NULL,1100,22,NULL,106),
 ('14#429*2',202,NULL,NULL,1100,24,NULL,99),
 ('14#43*1',289,NULL,NULL,1100,35,NULL,133),
 ('14#430*2',394,NULL,NULL,1100,54,NULL,28),
 ('14#431*2',446,NULL,NULL,1100,62,NULL,19),
 ('14#432*2',189,NULL,NULL,1100,26,NULL,91),
 ('14#433*2',397,NULL,NULL,1100,51,NULL,33),
 ('14#434*2',283,NULL,NULL,1100,34,NULL,63),
 ('14#435*2',88,NULL,NULL,1100,12,NULL,154),
 ('14#436*2',421,NULL,NULL,1100,56,NULL,23),
 ('14#437*2',564,NULL,NULL,1100,84,NULL,9),
 ('14#438*2',375,NULL,NULL,1100,49,NULL,38),
 ('14#439*2',200,NULL,NULL,1100,22,NULL,107),
 ('14#44*1',465,NULL,NULL,1100,63,NULL,34),
 ('14#440*2',246,NULL,NULL,1100,26,NULL,88),
 ('14#441*2',169,NULL,NULL,1100,17,NULL,131),
 ('14#442*2',105,NULL,NULL,1100,16,NULL,138),
 ('14#443*2',218,NULL,NULL,1100,20,NULL,113),
 ('14#444*2',107,NULL,NULL,1100,15,NULL,143),
 ('14#445*2',582,NULL,NULL,1100,86,NULL,8),
 ('14#446*2',268,NULL,NULL,1100,29,NULL,78),
 ('14#447*2',256,NULL,NULL,1100,30,NULL,74),
 ('14#448*2',105,NULL,NULL,1100,12,NULL,153),
 ('14#449*2',357,NULL,NULL,1100,51,NULL,35),
 ('14#45*1',345,NULL,NULL,1100,42,NULL,108),
 ('14#450*2',525,NULL,NULL,1100,78,NULL,10),
 ('14#451*2',446,NULL,NULL,1100,63,NULL,16),
 ('14#452*3',127,NULL,NULL,800,11,NULL,81),
 ('14#453*3',248,NULL,NULL,800,20,NULL,41),
 ('14#454*3',208,NULL,NULL,800,16,NULL,54),
 ('14#455*3',166,NULL,NULL,800,14,NULL,65),
 ('14#456*3',0,NULL,NULL,700,7,NULL,167),
 ('14#457*3',55,NULL,NULL,800,8,NULL,133),
 ('14#458*3',331,NULL,NULL,800,33,NULL,11),
 ('14#459*3',264,NULL,NULL,800,20,NULL,40),
 ('14#46*1',252,NULL,NULL,1100,33,NULL,147),
 ('14#460*3',0,NULL,NULL,700,7,NULL,167),
 ('14#461*3',4,NULL,NULL,800,8,NULL,155),
 ('14#462*3',28,NULL,NULL,800,8,NULL,141),
 ('14#463*3',162,NULL,NULL,800,11,NULL,77),
 ('14#464*3',153,NULL,NULL,800,9,NULL,91),
 ('14#465*3',2,NULL,NULL,700,7,NULL,166),
 ('14#466*3',211,NULL,NULL,800,19,NULL,44),
 ('14#467*3',269,NULL,NULL,800,29,NULL,22),
 ('14#468*3',110,NULL,NULL,800,11,NULL,84),
 ('14#469*3',111,NULL,NULL,800,11,NULL,83),
 ('14#4699*3',66,NULL,NULL,600,12,NULL,73),
 ('14#47*1',632,NULL,NULL,1100,93,NULL,7),
 ('14#470*3',0,NULL,NULL,700,7,NULL,167),
 ('14#4700*2',93,NULL,NULL,1100,16,NULL,139),
 ('14#4701*2',41,NULL,NULL,1100,13,NULL,151),
 ('14#4702*2',13,NULL,NULL,1100,11,NULL,165),
 ('14#471*3',129,NULL,NULL,800,11,NULL,80),
 ('14#4711*1',0,NULL,NULL,1100,11,NULL,274),
 ('14#4714*3',30,NULL,NULL,600,6,NULL,179),
 ('14#4715*2',79,NULL,NULL,1100,11,NULL,159),
 ('14#472*3',76,NULL,NULL,800,8,NULL,123),
 ('14#4720*3',19,NULL,NULL,600,6,NULL,180),
 ('14#4721*1',470,NULL,NULL,1100,67,NULL,28),
 ('14#4723*2',87,NULL,NULL,1100,13,NULL,148),
 ('14#4724*2',193,NULL,NULL,1100,22,NULL,109),
 ('14#473*3',71,NULL,NULL,800,8,NULL,125),
 ('14#474*3',0,NULL,NULL,700,7,NULL,167),
 ('14#475*3',53,NULL,NULL,800,8,NULL,135),
 ('14#476*3',109,NULL,NULL,800,8,NULL,116),
 ('14#477*3',0,NULL,NULL,700,7,NULL,167),
 ('14#478*3',314,NULL,NULL,800,32,NULL,13),
 ('14#479*3',50,NULL,NULL,800,9,NULL,106),
 ('14#48*1',473,NULL,NULL,1100,69,NULL,27),
 ('14#480*3',161,NULL,NULL,800,11,NULL,78),
 ('14#481*3',0,NULL,NULL,800,8,NULL,156),
 ('14#482*3',0,NULL,NULL,700,7,NULL,167),
 ('14#483*3',196,NULL,NULL,800,16,NULL,56),
 ('14#484*3',0,NULL,NULL,800,8,NULL,156),
 ('14#485*3',251,NULL,NULL,800,19,NULL,42),
 ('14#486*3',0,NULL,NULL,700,7,NULL,167),
 ('14#487*3',158,NULL,NULL,800,9,NULL,90),
 ('14#488*3',273,NULL,NULL,800,25,NULL,27),
 ('14#489*3',238,NULL,NULL,800,21,NULL,37),
 ('14#49*1',303,NULL,NULL,1100,34,NULL,136),
 ('14#490*3',134,NULL,NULL,800,10,NULL,87),
 ('14#491*3',208,NULL,NULL,800,17,NULL,54),
 ('14#492*3',0,NULL,NULL,800,8,NULL,156),
 ('14#493*3',0,NULL,NULL,800,8,NULL,156),
 ('14#494*3',57,NULL,NULL,700,8,NULL,128),
 ('14#495*3',261,NULL,NULL,800,24,NULL,30),
 ('14#496*3',7,NULL,NULL,800,8,NULL,153),
 ('14#497*3',0,NULL,NULL,800,8,NULL,156),
 ('14#498*3',0,NULL,NULL,700,7,NULL,167),
 ('14#499*3',11,NULL,NULL,800,8,NULL,149),
 ('14#5*1',225,NULL,NULL,1100,23,NULL,195),
 ('14#50*1',0,NULL,NULL,1100,11,NULL,274),
 ('14#500*3',207,NULL,NULL,800,18,NULL,48),
 ('14#501*3',47,NULL,NULL,700,9,NULL,105),
 ('14#502*3',139,NULL,NULL,800,11,NULL,79),
 ('14#503*3',170,NULL,NULL,800,14,NULL,64),
 ('14#504*3',153,NULL,NULL,800,9,NULL,91),
 ('14#505*3',166,NULL,NULL,800,15,NULL,61),
 ('14#506*3',109,NULL,NULL,800,9,NULL,101),
 ('14#507*3',125,NULL,NULL,800,8,NULL,113),
 ('14#508*3',0,NULL,NULL,700,7,NULL,167),
 ('14#509*3',217,NULL,NULL,800,17,NULL,52),
 ('14#51*1',361,NULL,NULL,1100,48,NULL,86),
 ('14#510*3',188,NULL,NULL,800,18,NULL,51),
 ('14#511*3',148,NULL,NULL,800,12,NULL,71),
 ('14#512*3',18,NULL,NULL,800,8,NULL,146),
 ('14#513*3',20,NULL,NULL,800,8,NULL,144),
 ('14#514*3',138,NULL,NULL,800,12,NULL,72),
 ('14#515*3',163,NULL,NULL,800,12,NULL,68),
 ('14#516*3',5,NULL,NULL,800,8,NULL,154),
 ('14#517*3',9,NULL,NULL,800,8,NULL,152),
 ('14#518*3',192,NULL,NULL,800,14,NULL,62),
 ('14#519*3',82,NULL,NULL,800,9,NULL,104),
 ('14#52*1',281,NULL,NULL,1100,34,NULL,140),
 ('14#520*3',259,NULL,NULL,800,23,NULL,33),
 ('14#521*3',120,NULL,NULL,700,10,NULL,86),
 ('14#522*3',18,NULL,NULL,800,8,NULL,146),
 ('14#523*3',184,NULL,NULL,800,11,NULL,76),
 ('14#524*3',133,NULL,NULL,800,9,NULL,95),
 ('14#525*3',10,NULL,NULL,800,8,NULL,151),
 ('14#526*3',229,NULL,NULL,800,19,NULL,43),
 ('14#527*3',124,NULL,NULL,800,9,NULL,98),
 ('14#528*3',156,NULL,NULL,800,8,NULL,107),
 ('14#529*3',71,NULL,NULL,800,8,NULL,125),
 ('14#53*1',284,NULL,NULL,1100,34,NULL,138),
 ('14#530*3',87,NULL,NULL,800,8,NULL,119),
 ('14#531*3',61,NULL,NULL,800,8,NULL,130),
 ('14#532*3',348,NULL,NULL,800,35,NULL,10),
 ('14#533*3',351,NULL,NULL,800,35,NULL,9),
 ('14#534*3',140,NULL,NULL,800,8,NULL,108),
 ('14#535*3',283,NULL,NULL,800,23,NULL,32),
 ('14#536*3',318,NULL,NULL,800,28,NULL,23),
 ('14#537*3',140,NULL,NULL,800,9,NULL,94),
 ('14#538*3',286,NULL,NULL,800,32,NULL,15),
 ('14#539*3',127,NULL,NULL,800,8,NULL,112),
 ('14#54*1',365,NULL,NULL,1100,48,NULL,84),
 ('14#540*3',0,NULL,NULL,800,8,NULL,156),
 ('14#541*3',108,NULL,NULL,800,8,NULL,117),
 ('14#542*3',57,NULL,NULL,800,8,NULL,132),
 ('14#543*3',88,NULL,NULL,800,10,NULL,88),
 ('14#544*3',181,NULL,NULL,800,12,NULL,67),
 ('14#545*3',29,NULL,NULL,800,8,NULL,139),
 ('14#546*3',83,NULL,NULL,800,8,NULL,120),
 ('14#547*3',422,NULL,NULL,800,51,NULL,3),
 ('14#548*3',74,NULL,NULL,800,8,NULL,124),
 ('14#549*3',428,NULL,NULL,800,50,NULL,4),
 ('14#55*1',356,NULL,NULL,1100,45,NULL,94),
 ('14#550*3',71,NULL,NULL,800,8,NULL,125),
 ('14#551*3',26,NULL,NULL,800,8,NULL,142),
 ('14#552*3',0,NULL,NULL,500,5,NULL,188),
 ('14#553*3',29,NULL,NULL,800,8,NULL,139),
 ('14#554*3',270,NULL,NULL,800,27,NULL,26),
 ('14#555*3',14,NULL,NULL,500,5,NULL,186),
 ('14#556*3',266,NULL,NULL,800,24,NULL,29),
 ('14#557*3',292,NULL,NULL,800,29,NULL,20),
 ('14#558*3',221,NULL,NULL,800,21,NULL,38),
 ('14#559*3',325,NULL,NULL,800,30,NULL,18),
 ('14#56*1',239,NULL,NULL,1100,26,NULL,185),
 ('14#560*3',136,NULL,NULL,800,13,NULL,66),
 ('14#561*3',0,NULL,NULL,500,5,NULL,188),
 ('14#562*3',190,NULL,NULL,800,14,NULL,63),
 ('14#563*3',109,NULL,NULL,800,9,NULL,101),
 ('14#564*3',74,NULL,NULL,700,7,NULL,162),
 ('14#565*3',136,NULL,NULL,800,8,NULL,109),
 ('14#566*3',150,NULL,NULL,800,12,NULL,70),
 ('14#567*3',49,NULL,NULL,800,8,NULL,137),
 ('14#568*3',178,NULL,NULL,800,21,NULL,39),
 ('14#569*3',136,NULL,NULL,800,8,NULL,109),
 ('14#57*1',106,NULL,NULL,1100,15,NULL,238),
 ('14#570*3',188,NULL,NULL,800,19,NULL,46),
 ('14#571*3',87,NULL,NULL,800,10,NULL,89),
 ('14#572*3',240,NULL,NULL,800,24,NULL,31),
 ('14#573*3',0,NULL,NULL,500,5,NULL,188),
 ('14#574*3',144,NULL,NULL,800,9,NULL,93),
 ('14#575*3',54,NULL,NULL,800,8,NULL,134),
 ('14#576*3',3,NULL,NULL,500,5,NULL,187),
 ('14#577*3',124,NULL,NULL,800,9,NULL,98),
 ('14#578*3',0,NULL,NULL,500,5,NULL,188),
 ('14#579*3',25,NULL,NULL,700,7,NULL,164),
 ('14#58*1',423,NULL,NULL,1100,56,NULL,52),
 ('14#580*3',192,NULL,NULL,800,19,NULL,45),
 ('14#581*3',80,NULL,NULL,800,8,NULL,121),
 ('14#582*3',20,NULL,NULL,800,8,NULL,144),
 ('14#583*3',242,NULL,NULL,800,25,NULL,28),
 ('14#584*3',22,NULL,NULL,800,8,NULL,143),
 ('14#585*3',142,NULL,NULL,700,12,NULL,69),
 ('14#586*3',0,NULL,NULL,500,5,NULL,188),
 ('14#587*3',0,NULL,NULL,600,6,NULL,182),
 ('14#588*3',292,NULL,NULL,800,32,NULL,14),
 ('14#589*3',116,NULL,NULL,800,8,NULL,115),
 ('14#59*1',109,NULL,NULL,1100,11,NULL,256),
 ('14#590*3',11,NULL,NULL,800,8,NULL,149),
 ('14#591*3',21,NULL,NULL,500,5,NULL,185),
 ('14#592*3',182,NULL,NULL,800,16,NULL,57),
 ('14#593*3',204,NULL,NULL,800,18,NULL,50),
 ('14#594*3',213,NULL,NULL,800,17,NULL,53),
 ('14#595*3',0,NULL,NULL,600,6,NULL,182),
 ('14#596*3',279,NULL,NULL,800,31,NULL,17),
 ('14#597*3',312,NULL,NULL,800,37,NULL,8),
 ('14#598*3',11,NULL,NULL,700,7,NULL,165),
 ('14#599*3',81,NULL,NULL,800,12,NULL,74),
 ('14#6*1',360,NULL,NULL,1100,44,NULL,100),
 ('14#60*1',258,NULL,NULL,1100,29,NULL,169),
 ('14#600*3',114,NULL,NULL,800,9,NULL,100),
 ('14#601*3',225,NULL,NULL,800,15,NULL,59),
 ('14#602*3',328,NULL,NULL,800,40,NULL,7),
 ('14#603*3',33,NULL,NULL,500,6,NULL,178),
 ('14#604*3',0,NULL,NULL,700,7,NULL,167),
 ('14#605*3',520,NULL,NULL,800,67,NULL,1),
 ('14#606*3',53,NULL,NULL,800,8,NULL,135),
 ('14#607*3',208,NULL,NULL,800,23,NULL,34),
 ('14#608*3',484,NULL,NULL,800,61,NULL,2),
 ('14#609*3',0,NULL,NULL,500,5,NULL,188),
 ('14#61*1',358,NULL,NULL,1100,47,NULL,91),
 ('14#610*3',41,NULL,NULL,800,8,NULL,138),
 ('14#611*3',175,NULL,NULL,800,16,NULL,58),
 ('14#612*3',206,NULL,NULL,800,18,NULL,49),
 ('14#613*3',117,NULL,NULL,800,8,NULL,114),
 ('14#614*3',135,NULL,NULL,800,8,NULL,111),
 ('14#615*3',104,NULL,NULL,800,9,NULL,103),
 ('14#616*3',0,NULL,NULL,600,6,NULL,182),
 ('14#617*3',292,NULL,NULL,800,29,NULL,20),
 ('14#618*3',70,NULL,NULL,700,12,NULL,75),
 ('14#619*3',199,NULL,NULL,800,23,NULL,35),
 ('14#62*1',257,NULL,NULL,1100,34,NULL,141),
 ('14#620*3',0,NULL,NULL,500,5,NULL,188),
 ('14#621*3',175,NULL,NULL,800,19,NULL,47),
 ('14#622*3',36,NULL,NULL,500,6,NULL,177),
 ('14#623*3',29,NULL,NULL,700,7,NULL,163),
 ('14#624*3',196,NULL,NULL,800,23,NULL,36),
 ('14#625*3',267,NULL,NULL,800,30,NULL,19),
 ('14#626*3',63,NULL,NULL,800,8,NULL,129),
 ('14#627*3',8,NULL,NULL,600,6,NULL,181),
 ('14#628*3',127,NULL,NULL,800,9,NULL,97),
 ('14#629*3',196,NULL,NULL,800,15,NULL,60),
 ('14#63*1',310,NULL,NULL,1100,39,NULL,120),
 ('14#630*3',80,NULL,NULL,800,8,NULL,121),
 ('14#631*3',61,NULL,NULL,800,8,NULL,130),
 ('14#632*3',132,NULL,NULL,800,9,NULL,96),
 ('14#633*3',300,NULL,NULL,800,33,NULL,12),
 ('14#634*3',358,NULL,NULL,800,40,NULL,6),
 ('14#635*3',370,NULL,NULL,800,43,NULL,5),
 ('14#636*3',288,NULL,NULL,800,27,NULL,25),
 ('14#637*3',117,NULL,NULL,800,11,NULL,82),
 ('14#638*3',103,NULL,NULL,800,8,NULL,118),
 ('14#639*3',15,NULL,NULL,800,8,NULL,148),
 ('14#64*1',284,NULL,NULL,1100,33,NULL,145),
 ('14#640*3',319,NULL,NULL,800,31,NULL,16),
 ('14#641*3',262,NULL,NULL,800,28,NULL,24),
 ('14#642*3',49,NULL,NULL,700,11,NULL,85),
 ('14#65*1',435,NULL,NULL,1100,60,NULL,45),
 ('14#66*1',439,NULL,NULL,1100,63,NULL,37),
 ('14#67*1',449,NULL,NULL,1100,62,NULL,38),
 ('14#68*1',420,NULL,NULL,1100,55,NULL,57),
 ('14#69*1',5,NULL,NULL,1100,11,NULL,272),
 ('14#7*1',417,NULL,NULL,1100,55,NULL,59),
 ('14#70*1',457,NULL,NULL,1100,60,NULL,42),
 ('14#71*1',390,NULL,NULL,1100,50,NULL,77),
 ('14#72*1',506,NULL,NULL,1100,75,NULL,23),
 ('14#73*1',237,NULL,NULL,1100,30,NULL,167),
 ('14#74*1',413,NULL,NULL,1100,54,NULL,63),
 ('14#75*1',360,NULL,NULL,1100,47,NULL,90),
 ('14#76*1',243,NULL,NULL,1100,26,NULL,183),
 ('14#77*1',609,NULL,NULL,1100,91,NULL,9),
 ('14#78*1',302,NULL,NULL,1100,38,NULL,125),
 ('14#79*1',362,NULL,NULL,1100,47,NULL,89),
 ('14#8*1',452,NULL,NULL,1100,60,NULL,43),
 ('14#80*1',467,NULL,NULL,1100,65,NULL,30),
 ('14#81*1',404,NULL,NULL,1100,56,NULL,55),
 ('14#82*1',50,NULL,NULL,1100,17,NULL,231),
 ('14#83*1',336,NULL,NULL,1100,43,NULL,107),
 ('14#84*1',464,NULL,NULL,1100,63,NULL,35),
 ('14#85*1',55,NULL,NULL,1100,18,NULL,228),
 ('14#86*1',331,NULL,NULL,1100,40,NULL,112),
 ('14#87*1',63,NULL,NULL,1100,17,NULL,230),
 ('14#88*1',304,NULL,NULL,1100,36,NULL,126),
 ('14#89*1',378,NULL,NULL,1100,48,NULL,82),
 ('14#9*1',176,NULL,NULL,1100,19,NULL,220),
 ('14#90*1',272,NULL,NULL,1100,32,NULL,152),
 ('14#91*1',30,NULL,NULL,1100,13,NULL,248),
 ('14#92*1',109,NULL,NULL,1100,15,NULL,237),
 ('14#93*1',23,NULL,NULL,1100,11,NULL,264),
 ('14#94*1',119,NULL,NULL,1100,14,NULL,241),
 ('14#95*1',147,NULL,NULL,1100,12,NULL,249),
 ('14#96*1',560,NULL,NULL,1100,83,NULL,17),
 ('14#97*1',95,NULL,NULL,1100,12,NULL,252),
 ('14#98*1',228,NULL,NULL,1100,27,NULL,180),
 ('14#99*1',327,NULL,NULL,1100,41,NULL,111),
 ('15#1*2',87,NULL,NULL,1100,11,NULL,245),
 ('15#10*2',660,NULL,NULL,1100,81,NULL,3),
 ('15#100*2',299,NULL,NULL,1100,28,NULL,96),
 ('15#101*2',310,NULL,NULL,1100,26,NULL,106),
 ('15#102*2',288,NULL,NULL,1100,24,NULL,120),
 ('15#103*2',104,NULL,NULL,1100,11,NULL,238),
 ('15#104*2',144,NULL,NULL,1100,14,NULL,208),
 ('15#105*2',2,NULL,NULL,1100,11,NULL,270),
 ('15#106*2',253,NULL,NULL,1100,22,NULL,131),
 ('15#107*2',177,NULL,NULL,1100,16,NULL,188),
 ('15#108*2',342,NULL,NULL,1100,34,NULL,66),
 ('15#11*2',643,NULL,NULL,1100,80,NULL,5),
 ('15#110*2',26,NULL,NULL,1100,11,NULL,259),
 ('15#111*2',121,NULL,NULL,1100,11,NULL,233),
 ('15#112*2',344,NULL,NULL,1100,32,NULL,74),
 ('15#113*2',231,NULL,NULL,1100,20,NULL,145),
 ('15#114*2',300,NULL,NULL,1100,27,NULL,102),
 ('15#115*2',183,NULL,NULL,1100,19,NULL,161),
 ('15#116*2',182,NULL,NULL,1100,18,NULL,170),
 ('15#117*2',338,NULL,NULL,1100,29,NULL,90),
 ('15#118*2',210,NULL,NULL,1100,16,NULL,182),
 ('15#12*2',269,NULL,NULL,1100,25,NULL,115),
 ('15#120*2',267,NULL,NULL,1100,21,NULL,135),
 ('15#121*2',123,NULL,NULL,1100,14,NULL,209),
 ('15#123*2',301,NULL,NULL,1100,26,NULL,108),
 ('15#124*2',51,NULL,NULL,1100,13,NULL,219),
 ('15#125*2',36,NULL,NULL,1100,11,NULL,256),
 ('15#126*2',227,NULL,NULL,1100,22,NULL,134),
 ('15#127*2',81,NULL,NULL,1100,11,NULL,246),
 ('15#128*2',242,NULL,NULL,1100,25,NULL,119),
 ('15#129*2',262,NULL,NULL,1100,19,NULL,150),
 ('15#13*2',0,NULL,NULL,1100,11,NULL,274),
 ('15#130*2',388,NULL,NULL,1100,35,NULL,61),
 ('15#131*2',281,NULL,NULL,1100,25,NULL,114),
 ('15#132*2',355,NULL,NULL,1100,33,NULL,69),
 ('15#133*2',328,NULL,NULL,1100,30,NULL,86),
 ('15#134*2',379,NULL,NULL,1100,36,NULL,55),
 ('15#135*2',0,NULL,NULL,1100,11,NULL,274),
 ('15#136*2',288,NULL,NULL,1100,20,NULL,139),
 ('15#137*2',638,NULL,NULL,1100,79,NULL,6),
 ('15#138*2',249,NULL,NULL,1100,22,NULL,132),
 ('15#139*2',145,NULL,NULL,1100,14,NULL,207),
 ('15#14*2',339,NULL,NULL,1100,29,NULL,89),
 ('15#140*2',242,NULL,NULL,1100,20,NULL,143),
 ('15#141*2',503,NULL,NULL,1100,53,NULL,19),
 ('15#142*2',231,NULL,NULL,1100,19,NULL,152),
 ('15#143*2',235,NULL,NULL,1100,23,NULL,126),
 ('15#144*2',364,NULL,NULL,1100,30,NULL,82);
INSERT INTO `examsubreptkold` (`TmStCl`,`Mksr`,`grd`,`Remarks`,`outOfr`,`pnts`,`outOfp`,`pos`) VALUES 
 ('15#145*2',342,NULL,NULL,1100,32,NULL,75),
 ('15#146*2',196,NULL,NULL,1100,20,NULL,149),
 ('15#147*2',176,NULL,NULL,1100,15,NULL,195),
 ('15#149*2',256,NULL,NULL,1100,24,NULL,121),
 ('15#15*2',264,NULL,NULL,1100,18,NULL,162),
 ('15#150*2',378,NULL,NULL,1100,38,NULL,50),
 ('15#151*2',427,NULL,NULL,1100,43,NULL,34),
 ('15#152*2',29,NULL,NULL,1100,11,NULL,257),
 ('15#153*2',289,NULL,NULL,1100,28,NULL,99),
 ('15#154*2',234,NULL,NULL,1100,20,NULL,144),
 ('15#155*2',159,NULL,NULL,1100,13,NULL,210),
 ('15#156*2',193,NULL,NULL,1100,19,NULL,160),
 ('15#157*2',57,NULL,NULL,1100,11,NULL,253),
 ('15#158*2',301,NULL,NULL,1100,29,NULL,92),
 ('15#159*2',226,NULL,NULL,1100,19,NULL,154),
 ('15#16*2',133,NULL,NULL,1100,17,NULL,181),
 ('15#160*2',481,NULL,NULL,1100,52,NULL,20),
 ('15#161*2',372,NULL,NULL,1100,38,NULL,51),
 ('15#163*2',185,NULL,NULL,1100,16,NULL,185),
 ('15#164*2',420,NULL,NULL,1100,44,NULL,32),
 ('15#165*2',22,NULL,NULL,1100,11,NULL,261),
 ('15#166*2',256,NULL,NULL,1100,24,NULL,121),
 ('15#167*2',636,NULL,NULL,1100,81,NULL,4),
 ('15#168*2',50,NULL,NULL,1100,13,NULL,220),
 ('15#169*2',462,NULL,NULL,1100,47,NULL,29),
 ('15#17*2',397,NULL,NULL,1100,35,NULL,60),
 ('15#170*2',452,NULL,NULL,1100,51,NULL,24),
 ('15#171*2',33,NULL,NULL,1100,12,NULL,229),
 ('15#172*2',104,NULL,NULL,1100,11,NULL,238),
 ('15#173*2',30,NULL,NULL,1100,12,NULL,230),
 ('15#174*2',164,NULL,NULL,1100,17,NULL,179),
 ('15#175*2',215,NULL,NULL,1100,19,NULL,157),
 ('15#176*2',396,NULL,NULL,1100,43,NULL,37),
 ('15#177*2',59,NULL,NULL,1100,11,NULL,251),
 ('15#178*2',280,NULL,NULL,1100,23,NULL,123),
 ('15#179*2',396,NULL,NULL,1100,37,NULL,54),
 ('15#18*2',363,NULL,NULL,1100,31,NULL,78),
 ('15#180*2',98,NULL,NULL,1100,11,NULL,242),
 ('15#181*2',128,NULL,NULL,1100,13,NULL,215),
 ('15#182*2',246,NULL,NULL,1100,22,NULL,133),
 ('15#183*2',118,NULL,NULL,1100,11,NULL,235),
 ('15#184*2',210,NULL,NULL,1100,20,NULL,148),
 ('15#185*2',256,NULL,NULL,1100,22,NULL,130),
 ('15#186*2',0,NULL,NULL,1100,11,NULL,274),
 ('15#187*2',190,NULL,NULL,1100,18,NULL,169),
 ('15#188*2',167,NULL,NULL,1100,12,NULL,221),
 ('15#189*2',466,NULL,NULL,1100,52,NULL,21),
 ('15#19*2',145,NULL,NULL,1100,15,NULL,197),
 ('15#190*2',365,NULL,NULL,1100,33,NULL,67),
 ('15#191*2',214,NULL,NULL,1100,18,NULL,168),
 ('15#192*2',322,NULL,NULL,1100,29,NULL,91),
 ('15#193*2',4,NULL,NULL,1100,11,NULL,266),
 ('15#194*2',6,NULL,NULL,1100,11,NULL,264),
 ('15#195*2',73,NULL,NULL,1100,11,NULL,249),
 ('15#196*2',138,NULL,NULL,1100,13,NULL,213),
 ('15#197*2',77,NULL,NULL,1100,11,NULL,248),
 ('15#198*2',154,NULL,NULL,1100,16,NULL,189),
 ('15#199*2',322,NULL,NULL,1100,26,NULL,105),
 ('15#2*2',529,NULL,NULL,1100,60,NULL,12),
 ('15#20*2',307,NULL,NULL,1100,25,NULL,111),
 ('15#200*2',482,NULL,NULL,1100,57,NULL,16),
 ('15#201*2',179,NULL,NULL,1100,17,NULL,177),
 ('15#202*2',214,NULL,NULL,1100,17,NULL,175),
 ('15#203*2',43,NULL,NULL,1100,12,NULL,227),
 ('15#204*2',334,NULL,NULL,1100,30,NULL,83),
 ('15#205*2',326,NULL,NULL,1100,31,NULL,80),
 ('15#206*2',249,NULL,NULL,1100,18,NULL,164),
 ('15#207*2',399,NULL,NULL,1100,40,NULL,46),
 ('15#208*2',481,NULL,NULL,1100,50,NULL,25),
 ('15#209*2',473,NULL,NULL,1100,51,NULL,22),
 ('15#21*2',161,NULL,NULL,1100,11,NULL,231),
 ('15#210*2',7,NULL,NULL,1100,11,NULL,263),
 ('15#211*2',136,NULL,NULL,1100,12,NULL,223),
 ('15#212*2',381,NULL,NULL,1100,39,NULL,49),
 ('15#213*2',181,NULL,NULL,1100,15,NULL,193),
 ('15#214*2',344,NULL,NULL,1100,36,NULL,59),
 ('15#215*2',118,NULL,NULL,1100,11,NULL,235),
 ('15#216*2',104,NULL,NULL,1100,11,NULL,238),
 ('15#217*2',398,NULL,NULL,1100,40,NULL,47),
 ('15#218*2',179,NULL,NULL,1100,15,NULL,194),
 ('15#219*2',368,NULL,NULL,1100,35,NULL,63),
 ('15#22*2',415,NULL,NULL,1100,42,NULL,40),
 ('15#220*2',115,NULL,NULL,1100,16,NULL,191),
 ('15#221*2',217,NULL,NULL,1100,20,NULL,147),
 ('15#222*2',53,NULL,NULL,1100,12,NULL,226),
 ('15#223*2',228,NULL,NULL,1100,17,NULL,173),
 ('15#224*2',564,NULL,NULL,1100,70,NULL,7),
 ('15#225*2',118,NULL,NULL,1100,13,NULL,217),
 ('15#226*2',169,NULL,NULL,1100,14,NULL,201),
 ('15#227*2',355,NULL,NULL,1100,32,NULL,73),
 ('15#228*2',329,NULL,NULL,1100,32,NULL,76),
 ('15#229*2',167,NULL,NULL,1100,14,NULL,202),
 ('15#23*2',195,NULL,NULL,1100,16,NULL,183),
 ('15#230*2',48,NULL,NULL,1100,11,NULL,255),
 ('15#231*2',258,NULL,NULL,1100,21,NULL,136),
 ('15#232*2',0,NULL,NULL,1100,11,NULL,274),
 ('15#233*2',177,NULL,NULL,1100,17,NULL,178),
 ('15#234*2',180,NULL,NULL,1100,18,NULL,171),
 ('15#235*2',43,NULL,NULL,1100,12,NULL,227),
 ('15#236*2',306,NULL,NULL,1100,28,NULL,95),
 ('15#237*2',371,NULL,NULL,1100,35,NULL,62),
 ('15#238*2',429,NULL,NULL,1100,41,NULL,42),
 ('15#239*2',279,NULL,NULL,1100,31,NULL,81),
 ('15#24*2',91,NULL,NULL,1100,11,NULL,244),
 ('15#240*2',451,NULL,NULL,1100,50,NULL,26),
 ('15#241*2',518,NULL,NULL,1100,54,NULL,17),
 ('15#242*2',232,NULL,NULL,1100,27,NULL,103),
 ('15#243*2',121,NULL,NULL,1100,11,NULL,233),
 ('15#244*2',24,NULL,NULL,1100,11,NULL,260),
 ('15#245*2',58,NULL,NULL,1100,11,NULL,252),
 ('15#246*2',3,NULL,NULL,1100,11,NULL,269),
 ('15#247*2',51,NULL,NULL,1100,16,NULL,192),
 ('15#248*2',145,NULL,NULL,1100,16,NULL,190),
 ('15#249*2',177,NULL,NULL,1100,14,NULL,200),
 ('15#25*2',148,NULL,NULL,1100,17,NULL,180),
 ('15#250*2',103,NULL,NULL,1100,13,NULL,218),
 ('15#251*2',295,NULL,NULL,1100,28,NULL,98),
 ('15#252*2',292,NULL,NULL,1100,26,NULL,109),
 ('15#253*2',330,NULL,NULL,1100,30,NULL,85),
 ('15#254*2',234,NULL,NULL,1100,19,NULL,151),
 ('15#255*2',150,NULL,NULL,1100,13,NULL,211),
 ('15#256*2',224,NULL,NULL,1100,19,NULL,156),
 ('15#257*2',69,NULL,NULL,1100,11,NULL,250),
 ('15#258*2',289,NULL,NULL,1100,33,NULL,71),
 ('15#259*2',518,NULL,NULL,1100,59,NULL,13),
 ('15#26*2',433,NULL,NULL,1100,45,NULL,31),
 ('15#260*2',357,NULL,NULL,1100,31,NULL,79),
 ('15#261*2',273,NULL,NULL,1100,22,NULL,129),
 ('15#262*2',155,NULL,NULL,1100,14,NULL,204),
 ('15#263*2',247,NULL,NULL,1100,20,NULL,142),
 ('15#264*2',296,NULL,NULL,1100,28,NULL,97),
 ('15#265*2',565,NULL,NULL,1100,68,NULL,8),
 ('15#266*2',253,NULL,NULL,1100,18,NULL,163),
 ('15#267*2',379,NULL,NULL,1100,37,NULL,55),
 ('15#268*2',367,NULL,NULL,1100,38,NULL,52),
 ('15#269*2',574,NULL,NULL,1100,67,NULL,9),
 ('15#27*2',530,NULL,NULL,1100,62,NULL,10),
 ('15#270*2',280,NULL,NULL,1100,20,NULL,140),
 ('15#271*2',312,NULL,NULL,1100,28,NULL,94),
 ('15#272*2',193,NULL,NULL,1100,16,NULL,184),
 ('15#273*2',499,NULL,NULL,1100,57,NULL,14),
 ('15#274*2',130,NULL,NULL,1100,15,NULL,198),
 ('15#275*2',0,NULL,NULL,1100,11,NULL,274),
 ('15#276*2',429,NULL,NULL,1100,43,NULL,33),
 ('15#277*2',408,NULL,NULL,1100,40,NULL,44),
 ('15#278*2',92,NULL,NULL,1100,11,NULL,243),
 ('15#279*3',150,NULL,NULL,800,12,NULL,92),
 ('15#28*2',310,NULL,NULL,1100,26,NULL,106),
 ('15#281*3',360,NULL,NULL,800,43,NULL,10),
 ('15#282*3',87,NULL,NULL,800,9,NULL,123),
 ('15#283*3',296,NULL,NULL,800,26,NULL,29),
 ('15#284*3',372,NULL,NULL,800,39,NULL,13),
 ('15#285*3',0,NULL,NULL,500,5,NULL,173),
 ('15#286*3',185,NULL,NULL,800,13,NULL,85),
 ('15#287*3',155,NULL,NULL,800,12,NULL,90),
 ('15#288*3',0,NULL,NULL,500,5,NULL,173),
 ('15#289*3',0,NULL,NULL,500,5,NULL,173),
 ('15#29*2',0,NULL,NULL,1100,11,NULL,274),
 ('15#290*3',26,NULL,NULL,800,8,NULL,153),
 ('15#291*3',213,NULL,NULL,800,20,NULL,56),
 ('15#292*3',307,NULL,NULL,800,33,NULL,16),
 ('15#293*3',39,NULL,NULL,800,8,NULL,151),
 ('15#294*3',0,NULL,NULL,500,5,NULL,173),
 ('15#295*3',85,NULL,NULL,800,8,NULL,133),
 ('15#296*3',89,NULL,NULL,800,8,NULL,132),
 ('15#297*3',0,NULL,NULL,500,5,NULL,173),
 ('15#298*3',42,NULL,NULL,800,8,NULL,149),
 ('15#299*3',325,NULL,NULL,800,40,NULL,12),
 ('15#3*2',276,NULL,NULL,1100,22,NULL,128),
 ('15#30*2',4,NULL,NULL,1100,11,NULL,266),
 ('15#300*3',161,NULL,NULL,800,15,NULL,75),
 ('15#301*3',174,NULL,NULL,800,14,NULL,78),
 ('15#302*3',0,NULL,NULL,600,6,NULL,160),
 ('15#303*3',225,NULL,NULL,800,22,NULL,50),
 ('15#304*3',81,NULL,NULL,800,8,NULL,135),
 ('15#305*3',245,NULL,NULL,800,24,NULL,39),
 ('15#306*3',203,NULL,NULL,800,21,NULL,53),
 ('15#307*3',164,NULL,NULL,800,13,NULL,87),
 ('15#308*3',0,NULL,NULL,500,5,NULL,173),
 ('15#309*3',71,NULL,NULL,700,7,NULL,154),
 ('15#31*2',226,NULL,NULL,1100,20,NULL,146),
 ('15#310*3',0,NULL,NULL,500,5,NULL,173),
 ('15#311*3',82,NULL,NULL,800,8,NULL,134),
 ('15#312*3',44,NULL,NULL,800,8,NULL,148),
 ('15#313*3',111,NULL,NULL,800,10,NULL,109),
 ('15#314*3',157,NULL,NULL,800,13,NULL,88),
 ('15#315*3',121,NULL,NULL,800,10,NULL,106),
 ('15#316*3',0,NULL,NULL,500,5,NULL,173),
 ('15#317*3',206,NULL,NULL,800,17,NULL,61),
 ('15#318*3',68,NULL,NULL,800,8,NULL,140),
 ('15#319*3',0,NULL,NULL,600,6,NULL,160),
 ('15#32*2',166,NULL,NULL,1100,14,NULL,203),
 ('15#320*3',184,NULL,NULL,800,14,NULL,77),
 ('15#321*3',71,NULL,NULL,800,8,NULL,139),
 ('15#322*3',62,NULL,NULL,800,8,NULL,142),
 ('15#323*3',169,NULL,NULL,800,16,NULL,68),
 ('15#324*3',161,NULL,NULL,800,17,NULL,64),
 ('15#325*3',0,NULL,NULL,500,5,NULL,173),
 ('15#326*3',0,NULL,NULL,500,5,NULL,173),
 ('15#327*3',166,NULL,NULL,800,15,NULL,73),
 ('15#328*3',130,NULL,NULL,800,12,NULL,95),
 ('15#329*3',246,NULL,NULL,800,27,NULL,28),
 ('15#33*2',273,NULL,NULL,1100,23,NULL,125),
 ('15#330*3',145,NULL,NULL,800,14,NULL,83),
 ('15#331*3',101,NULL,NULL,800,9,NULL,121),
 ('15#332*3',203,NULL,NULL,800,18,NULL,59),
 ('15#333*3',261,NULL,NULL,800,24,NULL,37),
 ('15#334*3',99,NULL,NULL,800,10,NULL,111),
 ('15#335*3',78,NULL,NULL,800,8,NULL,136),
 ('15#336*3',0,NULL,NULL,500,5,NULL,173),
 ('15#337*3',2,NULL,NULL,500,5,NULL,172),
 ('15#338*3',132,NULL,NULL,800,11,NULL,100),
 ('15#339*3',42,NULL,NULL,800,8,NULL,149),
 ('15#34*2',81,NULL,NULL,1100,11,NULL,246),
 ('15#340*3',0,NULL,NULL,500,5,NULL,173),
 ('15#341*3',257,NULL,NULL,800,25,NULL,33),
 ('15#342*3',154,NULL,NULL,800,16,NULL,70),
 ('15#343*3',193,NULL,NULL,800,19,NULL,57),
 ('15#344*3',157,NULL,NULL,800,13,NULL,88),
 ('15#345*3',256,NULL,NULL,800,26,NULL,30),
 ('15#346*3',239,NULL,NULL,800,23,NULL,42),
 ('15#348*3',37,NULL,NULL,600,6,NULL,158),
 ('15#349*3',74,NULL,NULL,800,9,NULL,124),
 ('15#35*2',226,NULL,NULL,1100,19,NULL,154),
 ('15#350*3',141,NULL,NULL,800,11,NULL,99),
 ('15#351*3',48,NULL,NULL,800,8,NULL,145),
 ('15#352*3',185,NULL,NULL,800,15,NULL,71),
 ('15#353*3',255,NULL,NULL,800,25,NULL,34),
 ('15#354*3',285,NULL,NULL,800,29,NULL,23),
 ('15#355*3',259,NULL,NULL,700,28,NULL,24),
 ('15#356*3',0,NULL,NULL,500,5,NULL,173),
 ('15#357*3',0,NULL,NULL,500,5,NULL,173),
 ('15#358*3',502,NULL,NULL,800,64,NULL,2),
 ('15#359*3',269,NULL,NULL,800,23,NULL,40),
 ('15#36*2',155,NULL,NULL,1100,14,NULL,204),
 ('15#360*3',185,NULL,NULL,800,16,NULL,66),
 ('15#361*3',54,NULL,NULL,800,8,NULL,143),
 ('15#362*3',0,NULL,NULL,500,5,NULL,173),
 ('15#363*3',0,NULL,NULL,600,6,NULL,160),
 ('15#364*3',232,NULL,NULL,800,22,NULL,47),
 ('15#365*3',222,NULL,NULL,800,22,NULL,51),
 ('15#366*3',288,NULL,NULL,800,30,NULL,22),
 ('15#367*3',45,NULL,NULL,800,8,NULL,146),
 ('15#368*3',130,NULL,NULL,800,8,NULL,127),
 ('15#369*3',283,NULL,NULL,800,32,NULL,18),
 ('15#37*2',280,NULL,NULL,1100,30,NULL,87),
 ('15#370*3',113,NULL,NULL,800,9,NULL,120),
 ('15#371*3',0,NULL,NULL,600,6,NULL,160),
 ('15#372*3',229,NULL,NULL,800,22,NULL,49),
 ('15#373*3',257,NULL,NULL,800,24,NULL,38),
 ('15#374*3',306,NULL,NULL,800,31,NULL,19),
 ('15#375*3',0,NULL,NULL,600,6,NULL,160),
 ('15#376*3',173,NULL,NULL,800,14,NULL,79),
 ('15#377*3',160,NULL,NULL,800,14,NULL,82),
 ('15#378*3',421,NULL,NULL,800,49,NULL,7),
 ('15#379*3',112,NULL,NULL,800,10,NULL,107),
 ('15#38*2',313,NULL,NULL,1100,28,NULL,93),
 ('15#380*3',261,NULL,NULL,800,27,NULL,27),
 ('15#381*3',53,NULL,NULL,800,8,NULL,144),
 ('15#382*3',117,NULL,NULL,800,9,NULL,119),
 ('15#383*3',296,NULL,NULL,800,31,NULL,20),
 ('15#384*3',452,NULL,NULL,800,54,NULL,5),
 ('15#385*3',65,NULL,NULL,800,8,NULL,141),
 ('15#386*3',247,NULL,NULL,800,25,NULL,35),
 ('15#387*3',462,NULL,NULL,800,57,NULL,3),
 ('15#388*3',0,NULL,NULL,500,5,NULL,173),
 ('15#389*3',132,NULL,NULL,800,9,NULL,117),
 ('15#39*2',262,NULL,NULL,1100,25,NULL,117),
 ('15#390*3',195,NULL,NULL,800,14,NULL,76),
 ('15#391*3',149,NULL,NULL,800,12,NULL,93),
 ('15#392*3',67,NULL,NULL,800,10,NULL,112),
 ('15#393*3',7,NULL,NULL,600,6,NULL,159),
 ('15#394*3',136,NULL,NULL,800,8,NULL,126),
 ('15#395*3',91,NULL,NULL,800,8,NULL,130),
 ('15#396*3',167,NULL,NULL,800,16,NULL,69),
 ('15#397*3',0,NULL,NULL,600,6,NULL,160),
 ('15#398*3',241,NULL,NULL,800,20,NULL,54),
 ('15#399*3',235,NULL,NULL,800,22,NULL,46),
 ('15#4*2',134,NULL,NULL,1100,13,NULL,214),
 ('15#40*2',158,NULL,NULL,1100,11,NULL,232),
 ('15#400*3',138,NULL,NULL,800,9,NULL,115),
 ('15#401*3',126,NULL,NULL,700,9,NULL,114),
 ('15#402*3',0,NULL,NULL,500,5,NULL,173),
 ('15#403*3',206,NULL,NULL,800,17,NULL,61),
 ('15#404*3',162,NULL,NULL,800,15,NULL,74),
 ('15#405*3',0,NULL,NULL,700,7,NULL,156),
 ('15#406*3',212,NULL,NULL,800,17,NULL,60),
 ('15#407*3',149,NULL,NULL,800,9,NULL,113),
 ('15#408*3',0,NULL,NULL,600,6,NULL,160),
 ('15#409*3',219,NULL,NULL,800,23,NULL,44),
 ('15#41*2',419,NULL,NULL,1100,42,NULL,39),
 ('15#410*3',179,NULL,NULL,800,13,NULL,86),
 ('15#411*3',0,NULL,NULL,500,5,NULL,173),
 ('15#412*3',0,NULL,NULL,500,5,NULL,173),
 ('15#413*3',0,NULL,NULL,500,5,NULL,173),
 ('15#414*3',186,NULL,NULL,800,13,NULL,84),
 ('15#415*3',108,NULL,NULL,800,8,NULL,129),
 ('15#416*3',39,NULL,NULL,800,8,NULL,151),
 ('15#417*3',319,NULL,NULL,800,30,NULL,21),
 ('15#418*3',256,NULL,NULL,800,23,NULL,41),
 ('15#419*3',234,NULL,NULL,800,20,NULL,55),
 ('15#42*2',322,NULL,NULL,1100,25,NULL,110),
 ('15#420*3',225,NULL,NULL,800,16,NULL,65),
 ('15#421*3',134,NULL,NULL,800,9,NULL,116),
 ('15#422*3',651,NULL,NULL,800,89,NULL,1),
 ('15#423*3',0,NULL,NULL,500,5,NULL,173),
 ('15#424*3',157,NULL,NULL,800,10,NULL,102),
 ('15#425*3',358,NULL,NULL,800,40,NULL,11),
 ('15#426*3',52,NULL,NULL,700,7,NULL,155),
 ('15#427*3',225,NULL,NULL,800,21,NULL,52),
 ('15#428*3',91,NULL,NULL,800,8,NULL,130),
 ('15#429*3',73,NULL,NULL,800,8,NULL,138),
 ('15#43*2',206,NULL,NULL,1100,19,NULL,158),
 ('15#430*3',369,NULL,NULL,800,46,NULL,8),
 ('15#431*3',265,NULL,NULL,800,27,NULL,26),
 ('15#432*3',78,NULL,NULL,800,8,NULL,136),
 ('15#433*3',312,NULL,NULL,800,32,NULL,17),
 ('15#434*3',266,NULL,NULL,800,27,NULL,25),
 ('15#435*3',126,NULL,NULL,800,11,NULL,101),
 ('15#436*3',378,NULL,NULL,800,45,NULL,9),
 ('15#437*3',339,NULL,NULL,800,33,NULL,15),
 ('15#438*3',232,NULL,NULL,800,22,NULL,47),
 ('15#439*3',135,NULL,NULL,700,10,NULL,103),
 ('15#44*2',425,NULL,NULL,1100,43,NULL,36),
 ('15#440*3',145,NULL,NULL,800,11,NULL,98),
 ('15#441*3',123,NULL,NULL,800,10,NULL,105),
 ('15#442*3',124,NULL,NULL,800,10,NULL,104),
 ('15#443*3',0,NULL,NULL,600,6,NULL,160),
 ('15#444*3',141,NULL,NULL,800,12,NULL,94),
 ('15#445*3',443,NULL,NULL,800,55,NULL,4),
 ('15#446*3',188,NULL,NULL,800,17,NULL,63),
 ('15#447*3',211,NULL,NULL,800,18,NULL,58),
 ('15#448*3',0,NULL,NULL,600,6,NULL,160),
 ('15#449*3',235,NULL,NULL,800,23,NULL,43),
 ('15#45*2',269,NULL,NULL,1100,25,NULL,115),
 ('15#450*3',423,NULL,NULL,800,51,NULL,6),
 ('15#451*3',307,NULL,NULL,800,34,NULL,14),
 ('15#452*4',59,NULL,NULL,800,8,NULL,117),
 ('15#454*4',32,NULL,NULL,800,8,NULL,128),
 ('15#455*4',78,NULL,NULL,800,8,NULL,96),
 ('15#456*4',22,NULL,NULL,800,8,NULL,132),
 ('15#458*4',203,NULL,NULL,800,11,NULL,24),
 ('15#459*4',53,NULL,NULL,800,9,NULL,59),
 ('15#46*2',155,NULL,NULL,1100,14,NULL,204),
 ('15#461*4',6,NULL,NULL,800,8,NULL,136),
 ('15#463*4',79,NULL,NULL,800,8,NULL,95),
 ('15#468*4',22,NULL,NULL,800,8,NULL,132),
 ('15#469*4',65,NULL,NULL,800,8,NULL,110),
 ('15#47*2',526,NULL,NULL,1100,62,NULL,11),
 ('15#4700*3',45,NULL,NULL,800,8,NULL,146),
 ('15#4701*3',95,NULL,NULL,800,12,NULL,96),
 ('15#4702*3',0,NULL,NULL,600,6,NULL,160),
 ('15#471*4',89,NULL,NULL,800,8,NULL,84),
 ('15#4714*4',149,NULL,NULL,800,9,NULL,40),
 ('15#4715*3',0,NULL,NULL,500,5,NULL,173),
 ('15#4720*4',120,NULL,NULL,800,8,NULL,66),
 ('15#4721*2',378,NULL,NULL,1100,36,NULL,57),
 ('15#4722*3',130,NULL,NULL,600,11,NULL,97),
 ('15#4723*3',110,NULL,NULL,800,10,NULL,110),
 ('15#4724*3',153,NULL,NULL,800,12,NULL,91),
 ('15#4726*1',184,NULL,NULL,1100,19,NULL,149),
 ('15#4727*1',591,NULL,NULL,1100,70,NULL,10),
 ('15#4728*1',259,NULL,NULL,1100,21,NULL,137),
 ('15#4729*1',159,NULL,NULL,1100,15,NULL,167),
 ('15#473*4',166,NULL,NULL,800,12,NULL,23),
 ('15#4730*1',571,NULL,NULL,1100,65,NULL,13),
 ('15#4731*1',481,NULL,NULL,1100,48,NULL,38),
 ('15#4732*1',89,NULL,NULL,1100,12,NULL,183),
 ('15#4733*1',433,NULL,NULL,1100,41,NULL,59),
 ('15#4734*1',631,NULL,NULL,1100,79,NULL,5),
 ('15#4735*1',809,NULL,NULL,1100,110,NULL,1),
 ('15#4736*1',230,NULL,NULL,1100,14,NULL,170),
 ('15#4737*1',337,NULL,NULL,1100,23,NULL,118),
 ('15#4738*1',530,NULL,NULL,1100,57,NULL,20),
 ('15#4739*1',417,NULL,NULL,1100,37,NULL,70),
 ('15#4740*1',499,NULL,NULL,1100,53,NULL,29),
 ('15#4741*1',173,NULL,NULL,1100,18,NULL,154),
 ('15#4742*1',529,NULL,NULL,1100,58,NULL,19),
 ('15#4743*1',209,NULL,NULL,1100,14,NULL,171),
 ('15#4744*1',149,NULL,NULL,1100,15,NULL,168),
 ('15#4745*1',121,NULL,NULL,1100,11,NULL,188),
 ('15#4746*1',301,NULL,NULL,1100,24,NULL,116),
 ('15#4747*1',462,NULL,NULL,1100,47,NULL,43),
 ('15#4748*1',326,NULL,NULL,1100,28,NULL,99),
 ('15#4749*1',318,NULL,NULL,1100,25,NULL,111),
 ('15#475*4',72,NULL,NULL,800,8,NULL,106),
 ('15#4750*1',197,NULL,NULL,1100,16,NULL,161),
 ('15#4751*1',334,NULL,NULL,1100,31,NULL,89),
 ('15#4752*1',274,NULL,NULL,1100,20,NULL,142),
 ('15#4753*1',478,NULL,NULL,1100,48,NULL,39),
 ('15#4754*1',286,NULL,NULL,1100,21,NULL,134),
 ('15#4755*1',533,NULL,NULL,1100,59,NULL,17),
 ('15#4756*1',424,NULL,NULL,1100,44,NULL,53),
 ('15#4757*1',462,NULL,NULL,1100,46,NULL,46),
 ('15#4758*1',367,NULL,NULL,1100,27,NULL,103),
 ('15#4759*1',218,NULL,NULL,1100,16,NULL,160),
 ('15#476*4',104,NULL,NULL,800,8,NULL,78),
 ('15#4760*1',269,NULL,NULL,1100,22,NULL,130),
 ('15#4761*1',623,NULL,NULL,1100,75,NULL,6),
 ('15#4762*1',338,NULL,NULL,1100,26,NULL,106),
 ('15#4763*1',470,NULL,NULL,1100,45,NULL,48),
 ('15#4764*1',181,NULL,NULL,1100,15,NULL,166),
 ('15#4765*1',218,NULL,NULL,1100,17,NULL,156),
 ('15#4766*1',751,NULL,NULL,1100,99,NULL,3),
 ('15#4767*1',255,NULL,NULL,1100,24,NULL,117),
 ('15#4768*1',160,NULL,NULL,1100,17,NULL,159),
 ('15#4769*1',322,NULL,NULL,1100,28,NULL,100),
 ('15#4770*1',582,NULL,NULL,1100,72,NULL,8),
 ('15#4771*1',295,NULL,NULL,1100,23,NULL,123),
 ('15#4772*1',251,NULL,NULL,1100,23,NULL,128),
 ('15#4773*1',186,NULL,NULL,1100,14,NULL,172),
 ('15#4774*1',65,NULL,NULL,1100,11,NULL,191),
 ('15#4775*1',275,NULL,NULL,1100,19,NULL,146),
 ('15#4776*1',424,NULL,NULL,1100,43,NULL,56),
 ('15#4777*1',262,NULL,NULL,1100,18,NULL,151),
 ('15#4778*1',287,NULL,NULL,1100,20,NULL,141),
 ('15#4779*1',127,NULL,NULL,1100,11,NULL,186),
 ('15#478*4',210,NULL,NULL,800,17,NULL,14),
 ('15#4780*1',186,NULL,NULL,1100,16,NULL,162),
 ('15#4781*1',397,NULL,NULL,1100,37,NULL,71),
 ('15#4782*1',471,NULL,NULL,1100,48,NULL,41),
 ('15#4783*1',389,NULL,NULL,1100,36,NULL,73),
 ('15#4784*1',324,NULL,NULL,1100,26,NULL,108),
 ('15#4785*1',270,NULL,NULL,1100,18,NULL,150),
 ('15#4786*1',255,NULL,NULL,1100,21,NULL,138),
 ('15#4787*1',13,NULL,NULL,1100,11,NULL,192),
 ('15#4788*1',480,NULL,NULL,1100,49,NULL,35),
 ('15#4789*1',267,NULL,NULL,1100,23,NULL,127),
 ('15#479*4',64,NULL,NULL,800,8,NULL,113),
 ('15#4790*1',345,NULL,NULL,1100,33,NULL,84),
 ('15#4791*1',392,NULL,NULL,1100,39,NULL,65),
 ('15#4792*1',391,NULL,NULL,1100,39,NULL,67),
 ('15#4793*1',86,NULL,NULL,1100,12,NULL,184),
 ('15#4794*1',246,NULL,NULL,1100,22,NULL,132),
 ('15#4795*1',116,NULL,NULL,1100,13,NULL,177),
 ('15#4796*1',165,NULL,NULL,1100,13,NULL,174),
 ('15#4797*1',253,NULL,NULL,1100,21,NULL,139),
 ('15#4798*1',352,NULL,NULL,1100,31,NULL,88),
 ('15#4799*1',365,NULL,NULL,1100,33,NULL,83),
 ('15#48*2',410,NULL,NULL,1100,42,NULL,41),
 ('15#480*4',120,NULL,NULL,800,9,NULL,48),
 ('15#4800*1',421,NULL,NULL,1100,42,NULL,58),
 ('15#4801*1',436,NULL,NULL,1100,44,NULL,52),
 ('15#4802*1',504,NULL,NULL,1100,57,NULL,23),
 ('15#4803*1',414,NULL,NULL,1100,39,NULL,64),
 ('15#4804*1',471,NULL,NULL,1100,46,NULL,44),
 ('15#4805*1',205,NULL,NULL,1100,17,NULL,157),
 ('15#4806*1',374,NULL,NULL,1100,36,NULL,74),
 ('15#4807*1',233,NULL,NULL,1100,19,NULL,147),
 ('15#4808*1',232,NULL,NULL,1100,17,NULL,155),
 ('15#4809*1',283,NULL,NULL,1100,21,NULL,135),
 ('15#4810*1',506,NULL,NULL,1100,56,NULL,26),
 ('15#4811*1',456,NULL,NULL,1100,44,NULL,49),
 ('15#4812*1',314,NULL,NULL,1100,27,NULL,104),
 ('15#4813*1',356,NULL,NULL,1100,29,NULL,95),
 ('15#4814*1',310,NULL,NULL,1100,23,NULL,119),
 ('15#4815*1',142,NULL,NULL,1100,13,NULL,176),
 ('15#4816*1',260,NULL,NULL,1100,20,NULL,143),
 ('15#4817*1',382,NULL,NULL,1100,33,NULL,81),
 ('15#4818*1',443,NULL,NULL,1100,44,NULL,51),
 ('15#4819*1',236,NULL,NULL,1100,18,NULL,152),
 ('15#4820*1',320,NULL,NULL,1100,28,NULL,101),
 ('15#4821*1',418,NULL,NULL,1100,38,NULL,68),
 ('15#4822*1',392,NULL,NULL,1100,39,NULL,65),
 ('15#4823*1',187,NULL,NULL,1100,15,NULL,165),
 ('15#4824*1',366,NULL,NULL,1100,36,NULL,75),
 ('15#4825*1',315,NULL,NULL,1100,25,NULL,112),
 ('15#4826*1',307,NULL,NULL,1100,24,NULL,115),
 ('15#4827*1',390,NULL,NULL,1100,34,NULL,77),
 ('15#4828*1',469,NULL,NULL,1100,46,NULL,45),
 ('15#4829*1',129,NULL,NULL,1100,16,NULL,163),
 ('15#483*4',62,NULL,NULL,800,8,NULL,114),
 ('15#4830*1',335,NULL,NULL,1100,30,NULL,92),
 ('15#4831*1',126,NULL,NULL,1100,12,NULL,180),
 ('15#4832*1',698,NULL,NULL,1100,90,NULL,4),
 ('15#4833*1',486,NULL,NULL,1100,53,NULL,30),
 ('15#4834*1',423,NULL,NULL,1100,44,NULL,54),
 ('15#4835*1',172,NULL,NULL,1100,17,NULL,158),
 ('15#4836*1',389,NULL,NULL,1100,40,NULL,63),
 ('15#4837*1',188,NULL,NULL,1100,12,NULL,178),
 ('15#4838*1',344,NULL,NULL,1100,28,NULL,98),
 ('15#4839*1',281,NULL,NULL,1100,23,NULL,126),
 ('15#4840*1',570,NULL,NULL,1100,67,NULL,12),
 ('15#4841*1',184,NULL,NULL,1100,20,NULL,145),
 ('15#4842*1',291,NULL,NULL,1100,23,NULL,124),
 ('15#4843*1',462,NULL,NULL,1100,49,NULL,37),
 ('15#4844*1',304,NULL,NULL,1100,23,NULL,120),
 ('15#4845*1',266,NULL,NULL,1100,22,NULL,131),
 ('15#4846*1',386,NULL,NULL,1100,33,NULL,80),
 ('15#4847*1',456,NULL,NULL,1100,50,NULL,34),
 ('15#4848*1',182,NULL,NULL,1100,18,NULL,153),
 ('15#4849*1',123,NULL,NULL,1100,12,NULL,181),
 ('15#485*4',114,NULL,NULL,800,8,NULL,71),
 ('15#4850*1',82,NULL,NULL,1100,11,NULL,189),
 ('15#4851*1',282,NULL,NULL,1100,23,NULL,125),
 ('15#4852*1',67,NULL,NULL,1100,11,NULL,190),
 ('15#4853*1',296,NULL,NULL,1100,28,NULL,102),
 ('15#4854*1',436,NULL,NULL,1100,43,NULL,55),
 ('15#4855*1',279,NULL,NULL,1100,22,NULL,129),
 ('15#4856*1',365,NULL,NULL,1100,38,NULL,69),
 ('15#4857*1',234,NULL,NULL,1100,20,NULL,144),
 ('15#4858*1',343,NULL,NULL,1100,30,NULL,91),
 ('15#4859*1',524,NULL,NULL,1100,59,NULL,18),
 ('15#4860*1',267,NULL,NULL,1100,26,NULL,110),
 ('15#4861*1',341,NULL,NULL,1100,33,NULL,85),
 ('15#4862*1',337,NULL,NULL,1100,29,NULL,97),
 ('15#4863*1',471,NULL,NULL,1100,48,NULL,41),
 ('15#4864*1',541,NULL,NULL,1100,59,NULL,15),
 ('15#4865*1',581,NULL,NULL,1100,67,NULL,11),
 ('15#4866*1',362,NULL,NULL,1100,31,NULL,87),
 ('15#4867*1',393,NULL,NULL,1100,40,NULL,62),
 ('15#4868*1',310,NULL,NULL,1100,25,NULL,113),
 ('15#4869*1',366,NULL,NULL,1100,37,NULL,72),
 ('15#487*4',106,NULL,NULL,800,8,NULL,75),
 ('15#4870*1',537,NULL,NULL,1100,59,NULL,16),
 ('15#4871*1',488,NULL,NULL,1100,50,NULL,33),
 ('15#4872*1',363,NULL,NULL,1100,30,NULL,90),
 ('15#4873*1',601,NULL,NULL,1100,71,NULL,9),
 ('15#4874*1',522,NULL,NULL,1100,56,NULL,24),
 ('15#4875*1',375,NULL,NULL,1100,33,NULL,82),
 ('15#4876*1',212,NULL,NULL,1100,19,NULL,148),
 ('15#4877*1',400,NULL,NULL,1100,33,NULL,79),
 ('15#4878*1',342,NULL,NULL,1100,29,NULL,96),
 ('15#4879*1',145,NULL,NULL,1100,14,NULL,173),
 ('15#488*4',30,NULL,NULL,800,8,NULL,130),
 ('15#4880*1',327,NULL,NULL,1100,30,NULL,94),
 ('15#4881*1',335,NULL,NULL,1100,30,NULL,92),
 ('15#4882*1',557,NULL,NULL,1100,64,NULL,14),
 ('15#4883*1',468,NULL,NULL,1100,49,NULL,36),
 ('15#4884*1',515,NULL,NULL,1100,56,NULL,25),
 ('15#4885*1',223,NULL,NULL,1100,15,NULL,164),
 ('15#4886*1',525,NULL,NULL,1100,57,NULL,21),
 ('15#4887*1',507,NULL,NULL,1100,55,NULL,27),
 ('15#4888*1',147,NULL,NULL,1100,15,NULL,169),
 ('15#4889*1',296,NULL,NULL,1100,23,NULL,122),
 ('15#4890*1',771,NULL,NULL,1100,104,NULL,2),
 ('15#4891*1',494,NULL,NULL,1100,54,NULL,28),
 ('15#4892*1',446,NULL,NULL,1100,42,NULL,57),
 ('15#4893*1',132,NULL,NULL,1100,11,NULL,185),
 ('15#4894*1',620,NULL,NULL,1100,75,NULL,7),
 ('15#4895*1',525,NULL,NULL,1100,57,NULL,21),
 ('15#4896*1',160,NULL,NULL,1100,13,NULL,175),
 ('15#4897*1',179,NULL,NULL,1100,12,NULL,179),
 ('15#4898*1',315,NULL,NULL,1100,21,NULL,133),
 ('15#4899*1',488,NULL,NULL,1100,52,NULL,31),
 ('15#49*2',4,NULL,NULL,1100,11,NULL,266),
 ('15#490*4',105,NULL,NULL,800,8,NULL,76),
 ('15#4900*1',355,NULL,NULL,1100,34,NULL,78),
 ('15#4901*1',463,NULL,NULL,1100,52,NULL,32),
 ('15#4902*1',253,NULL,NULL,1100,21,NULL,139),
 ('15#4903*1',419,NULL,NULL,1100,41,NULL,60),
 ('15#4904*1',123,NULL,NULL,1100,12,NULL,181),
 ('15#4905*1',472,NULL,NULL,1100,48,NULL,40),
 ('15#4906*1',423,NULL,NULL,1100,46,NULL,47),
 ('15#4907*1',452,NULL,NULL,1100,44,NULL,50),
 ('15#4908*1',435,NULL,NULL,1100,40,NULL,61),
 ('15#4909*1',261,NULL,NULL,1100,21,NULL,136),
 ('15#491*4',72,NULL,NULL,800,8,NULL,106),
 ('15#4910*1',331,NULL,NULL,1100,26,NULL,107),
 ('15#4911*1',298,NULL,NULL,1100,23,NULL,121),
 ('15#4912*1',320,NULL,NULL,1100,24,NULL,114),
 ('15#4913*1',312,NULL,NULL,1100,26,NULL,109),
 ('15#4914*1',124,NULL,NULL,1100,11,NULL,187),
 ('15#4915*1',359,NULL,NULL,1100,32,NULL,86),
 ('15#4916*1',408,NULL,NULL,1100,35,NULL,76),
 ('15#4917*2',648,NULL,NULL,1100,85,NULL,1),
 ('15#4918*2',182,NULL,NULL,1100,16,NULL,186),
 ('15#4920*2',165,NULL,NULL,1100,12,NULL,222),
 ('15#4921*2',108,NULL,NULL,1100,11,NULL,237),
 ('15#4922*2',182,NULL,NULL,1100,16,NULL,186),
 ('15#4923*3',173,NULL,NULL,800,16,NULL,67),
 ('15#4924*2',90,NULL,NULL,1100,15,NULL,199),
 ('15#4925*2',219,NULL,NULL,1100,18,NULL,166),
 ('15#4926*2',367,NULL,NULL,1100,34,NULL,64),
 ('15#4927*1',301,NULL,NULL,1100,27,NULL,105),
 ('15#4928*3',163,NULL,NULL,800,14,NULL,81),
 ('15#4929*3',93,NULL,NULL,800,9,NULL,122),
 ('15#4930*3',112,NULL,NULL,800,10,NULL,107),
 ('15#4931*3',169,NULL,NULL,800,14,NULL,80),
 ('15#4932*3',125,NULL,NULL,800,9,NULL,118),
 ('15#4933*3',180,NULL,NULL,800,15,NULL,72),
 ('15#4934*3',276,NULL,NULL,800,25,NULL,31),
 ('15#4936*3',0,NULL,NULL,600,6,NULL,160),
 ('15#4937*3',141,NULL,NULL,800,8,NULL,125),
 ('15#494*4',60,NULL,NULL,800,8,NULL,115),
 ('15#4940*3',250,NULL,NULL,800,22,NULL,45),
 ('15#4941*3',260,NULL,NULL,800,25,NULL,32),
 ('15#4942*3',0,NULL,NULL,600,6,NULL,160),
 ('15#4943*3',283,NULL,NULL,800,24,NULL,36),
 ('15#4944*3',112,NULL,NULL,800,8,NULL,128),
 ('15#4945*4',114,NULL,NULL,800,9,NULL,51),
 ('15#4946*4',65,NULL,NULL,800,8,NULL,110),
 ('15#4947*4',122,NULL,NULL,800,8,NULL,65),
 ('15#495*4',140,NULL,NULL,800,9,NULL,42),
 ('15#4950*4',116,NULL,NULL,800,9,NULL,50),
 ('15#4951*4',74,NULL,NULL,700,7,NULL,137),
 ('15#4953*4',115,NULL,NULL,800,8,NULL,70),
 ('15#4954*4',213,NULL,NULL,800,17,NULL,13),
 ('15#4955*2',311,NULL,NULL,1000,34,NULL,65),
 ('15#4957*2',226,NULL,NULL,1100,21,NULL,137),
 ('15#496*4',21,NULL,NULL,800,8,NULL,134),
 ('15#4960*1',49,NULL,NULL,900,9,NULL,193),
 ('15#4961*3',56,NULL,NULL,600,6,NULL,157),
 ('15#4962*1',31,NULL,NULL,700,7,NULL,194),
 ('15#497*4',65,NULL,NULL,800,8,NULL,110),
 ('15#499*4',32,NULL,NULL,800,8,NULL,128),
 ('15#5*2',234,NULL,NULL,1100,18,NULL,165),
 ('15#50*2',0,NULL,NULL,1100,11,NULL,274),
 ('15#500*4',143,NULL,NULL,800,9,NULL,41),
 ('15#501*4',30,NULL,NULL,800,8,NULL,130),
 ('15#503*4',86,NULL,NULL,800,8,NULL,87),
 ('15#504*4',114,NULL,NULL,800,8,NULL,71),
 ('15#505*4',126,NULL,NULL,800,9,NULL,46),
 ('15#506*4',104,NULL,NULL,800,8,NULL,78),
 ('15#507*4',133,NULL,NULL,800,9,NULL,44),
 ('15#509*4',120,NULL,NULL,800,9,NULL,48),
 ('15#51*2',289,NULL,NULL,1100,22,NULL,127),
 ('15#510*4',160,NULL,NULL,800,11,NULL,27),
 ('15#511*4',80,NULL,NULL,800,8,NULL,94),
 ('15#512*4',74,NULL,NULL,800,8,NULL,102),
 ('15#513*4',105,NULL,NULL,800,9,NULL,55),
 ('15#514*4',93,NULL,NULL,800,8,NULL,83),
 ('15#515*4',44,NULL,NULL,800,8,NULL,123),
 ('15#518*4',86,NULL,NULL,800,8,NULL,87),
 ('15#519*4',40,NULL,NULL,800,8,NULL,126),
 ('15#52*2',337,NULL,NULL,1100,33,NULL,70),
 ('15#520*4',170,NULL,NULL,800,13,NULL,20),
 ('15#521*4',70,NULL,NULL,800,8,NULL,109),
 ('15#522*4',45,NULL,NULL,800,8,NULL,122),
 ('15#525*4',194,NULL,NULL,800,15,NULL,17),
 ('15#526*4',138,NULL,NULL,800,10,NULL,32),
 ('15#527*4',102,NULL,NULL,800,8,NULL,80),
 ('15#528*4',112,NULL,NULL,800,9,NULL,52),
 ('15#529*4',150,NULL,NULL,800,14,NULL,18),
 ('15#53*2',332,NULL,NULL,1100,30,NULL,84),
 ('15#530*4',83,NULL,NULL,800,8,NULL,91),
 ('15#531*4',50,NULL,NULL,800,8,NULL,119),
 ('15#532*4',251,NULL,NULL,800,24,NULL,8),
 ('15#533*4',232,NULL,NULL,800,18,NULL,12),
 ('15#534*4',123,NULL,NULL,800,9,NULL,47),
 ('15#536*4',410,NULL,NULL,800,48,NULL,2),
 ('15#537*4',96,NULL,NULL,800,8,NULL,81),
 ('15#539*4',118,NULL,NULL,800,8,NULL,68),
 ('15#54*2',314,NULL,NULL,1100,27,NULL,101),
 ('15#541*4',85,NULL,NULL,800,8,NULL,90),
 ('15#542*4',18,NULL,NULL,800,8,NULL,135),
 ('15#543*4',114,NULL,NULL,800,8,NULL,71),
 ('15#544*4',171,NULL,NULL,800,10,NULL,31),
 ('15#546*4',50,NULL,NULL,800,8,NULL,119),
 ('15#547*4',439,NULL,NULL,800,53,NULL,1),
 ('15#548*4',81,NULL,NULL,800,8,NULL,93),
 ('15#549*4',305,NULL,NULL,800,30,NULL,6),
 ('15#55*2',206,NULL,NULL,1100,17,NULL,176),
 ('15#551*4',88,NULL,NULL,800,8,NULL,85),
 ('15#553*4',134,NULL,NULL,800,9,NULL,43),
 ('15#554*4',194,NULL,NULL,800,10,NULL,29),
 ('15#556*4',130,NULL,NULL,800,10,NULL,33),
 ('15#557*4',114,NULL,NULL,800,8,NULL,71),
 ('15#558*4',83,NULL,NULL,800,8,NULL,91),
 ('15#56*2',172,NULL,NULL,1100,15,NULL,196),
 ('15#560*4',108,NULL,NULL,800,9,NULL,54),
 ('15#563*4',54,NULL,NULL,800,8,NULL,118),
 ('15#564*4',60,NULL,NULL,800,8,NULL,115),
 ('15#565*4',108,NULL,NULL,800,10,NULL,37),
 ('15#566*4',105,NULL,NULL,800,8,NULL,76),
 ('15#568*4',130,NULL,NULL,800,8,NULL,62),
 ('15#569*4',78,NULL,NULL,800,8,NULL,96),
 ('15#57*2',76,NULL,NULL,1100,12,NULL,225),
 ('15#570*4',88,NULL,NULL,800,8,NULL,85),
 ('15#571*4',74,NULL,NULL,800,8,NULL,102),
 ('15#574*4',86,NULL,NULL,800,8,NULL,87),
 ('15#575*4',74,NULL,NULL,800,8,NULL,102),
 ('15#577*4',94,NULL,NULL,800,8,NULL,82),
 ('15#58*2',348,NULL,NULL,1100,29,NULL,88),
 ('15#580*4',118,NULL,NULL,800,8,NULL,68),
 ('15#581*4',78,NULL,NULL,800,8,NULL,96),
 ('15#582*4',36,NULL,NULL,800,9,NULL,60),
 ('15#583*4',110,NULL,NULL,800,11,NULL,28),
 ('15#584*4',113,NULL,NULL,800,10,NULL,35),
 ('15#585*4',91,NULL,NULL,800,9,NULL,58),
 ('15#588*4',129,NULL,NULL,800,10,NULL,34),
 ('15#59*2',198,NULL,NULL,1100,21,NULL,138),
 ('15#590*4',73,NULL,NULL,800,8,NULL,105),
 ('15#592*4',106,NULL,NULL,800,10,NULL,38),
 ('15#593*4',174,NULL,NULL,800,10,NULL,30),
 ('15#594*4',170,NULL,NULL,800,13,NULL,20),
 ('15#596*4',200,NULL,NULL,800,19,NULL,11),
 ('15#597*4',250,NULL,NULL,800,25,NULL,7),
 ('15#599*4',42,NULL,NULL,800,8,NULL,124),
 ('15#6*2',249,NULL,NULL,1100,17,NULL,172),
 ('15#60*2',54,NULL,NULL,1100,11,NULL,254),
 ('15#600*4',126,NULL,NULL,800,8,NULL,63),
 ('15#602*4',194,NULL,NULL,800,17,NULL,15),
 ('15#605*4',407,NULL,NULL,800,47,NULL,3),
 ('15#606*4',34,NULL,NULL,800,8,NULL,127),
 ('15#607*4',181,NULL,NULL,800,13,NULL,19),
 ('15#61*2',389,NULL,NULL,1100,39,NULL,48),
 ('15#611*4',76,NULL,NULL,800,8,NULL,101),
 ('15#612*4',125,NULL,NULL,800,8,NULL,64),
 ('15#613*4',50,NULL,NULL,800,8,NULL,119),
 ('15#614*4',112,NULL,NULL,800,9,NULL,52),
 ('15#615*4',78,NULL,NULL,800,8,NULL,96),
 ('15#617*4',170,NULL,NULL,800,11,NULL,25),
 ('15#618*4',112,NULL,NULL,800,10,NULL,36),
 ('15#619*4',92,NULL,NULL,800,9,NULL,57),
 ('15#62*2',0,NULL,NULL,1100,11,NULL,274),
 ('15#621*4',168,NULL,NULL,800,12,NULL,22),
 ('15#623*4',162,NULL,NULL,800,11,NULL,26),
 ('15#624*4',196,NULL,NULL,800,15,NULL,16),
 ('15#626*4',72,NULL,NULL,800,8,NULL,106),
 ('15#628*4',78,NULL,NULL,800,8,NULL,96),
 ('15#629*4',130,NULL,NULL,800,9,NULL,45),
 ('15#63*2',276,NULL,NULL,1100,23,NULL,124),
 ('15#630*4',120,NULL,NULL,800,8,NULL,66),
 ('15#631*4',160,NULL,NULL,800,9,NULL,39),
 ('15#632*4',94,NULL,NULL,800,9,NULL,56),
 ('15#633*4',228,NULL,NULL,800,20,NULL,9),
 ('15#634*4',278,NULL,NULL,800,31,NULL,5),
 ('15#635*4',332,NULL,NULL,800,36,NULL,4),
 ('15#636*4',137,NULL,NULL,800,8,NULL,61),
 ('15#637*4',42,NULL,NULL,800,8,NULL,124),
 ('15#64*2',257,NULL,NULL,1100,20,NULL,141),
 ('15#641*4',216,NULL,NULL,800,20,NULL,10),
 ('15#65*2',365,NULL,NULL,1100,33,NULL,67),
 ('15#66*2',432,NULL,NULL,1100,42,NULL,38),
 ('15#67*2',448,NULL,NULL,1100,48,NULL,28),
 ('15#68*2',359,NULL,NULL,1100,27,NULL,100),
 ('15#69*2',2,NULL,NULL,1100,11,NULL,270),
 ('15#7*2',400,NULL,NULL,1100,37,NULL,53),
 ('15#70*2',458,NULL,NULL,1100,51,NULL,23),
 ('15#71*2',303,NULL,NULL,1100,25,NULL,112),
 ('15#72*2',402,NULL,NULL,1100,40,NULL,45),
 ('15#73*2',126,NULL,NULL,1100,12,NULL,224),
 ('15#74*2',487,NULL,NULL,1100,54,NULL,18),
 ('15#75*2',254,NULL,NULL,1100,25,NULL,118),
 ('15#76*2',216,NULL,NULL,1100,18,NULL,167),
 ('15#77*2',664,NULL,NULL,1100,84,NULL,2),
 ('15#78*2',194,NULL,NULL,1100,19,NULL,159),
 ('15#79*2',427,NULL,NULL,1100,43,NULL,34),
 ('15#8*2',379,NULL,NULL,1100,41,NULL,43),
 ('15#80*2',460,NULL,NULL,1100,48,NULL,27),
 ('15#81*2',333,NULL,NULL,1100,26,NULL,104),
 ('15#82*2',0,NULL,NULL,1100,11,NULL,274),
 ('15#83*2',369,NULL,NULL,1100,36,NULL,58),
 ('15#84*2',496,NULL,NULL,1100,57,NULL,15),
 ('15#85*2',17,NULL,NULL,1100,11,NULL,262),
 ('15#86*2',231,NULL,NULL,1100,19,NULL,152),
 ('15#87*2',27,NULL,NULL,1100,11,NULL,258),
 ('15#88*2',369,NULL,NULL,1100,32,NULL,72),
 ('15#89*2',309,NULL,NULL,1100,32,NULL,77),
 ('15#9*2',5,NULL,NULL,1100,11,NULL,265),
 ('15#90*2',1,NULL,NULL,1100,11,NULL,273),
 ('15#91*2',2,NULL,NULL,1100,11,NULL,270),
 ('15#92*2',0,NULL,NULL,1100,11,NULL,274),
 ('15#93*2',0,NULL,NULL,1100,11,NULL,274),
 ('15#94*2',121,NULL,NULL,1100,13,NULL,216),
 ('15#95*2',104,NULL,NULL,1100,11,NULL,238),
 ('15#96*2',444,NULL,NULL,1100,47,NULL,30),
 ('15#97*2',148,NULL,NULL,1100,13,NULL,212),
 ('15#98*2',227,NULL,NULL,1100,17,NULL,174),
 ('15#99*2',283,NULL,NULL,1100,25,NULL,113),
 ('16#1*2',123,NULL,NULL,1100,11,NULL,216),
 ('16#10*2',610,NULL,NULL,1100,75,NULL,5),
 ('16#100*2',171,NULL,NULL,1100,13,NULL,191),
 ('16#101*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#102*2',368,NULL,NULL,1100,33,NULL,64),
 ('16#103*2',86,NULL,NULL,1100,12,NULL,212),
 ('16#104*2',109,NULL,NULL,1100,12,NULL,211),
 ('16#105*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#106*2',70,NULL,NULL,1100,11,NULL,228),
 ('16#107*2',201,NULL,NULL,1100,15,NULL,177),
 ('16#11*2',576,NULL,NULL,1100,69,NULL,9),
 ('16#110*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#111*2',155,NULL,NULL,1100,12,NULL,203),
 ('16#112*2',324,NULL,NULL,1100,30,NULL,82),
 ('16#113*2',270,NULL,NULL,1100,24,NULL,108),
 ('16#114*2',258,NULL,NULL,1100,22,NULL,127),
 ('16#115*2',206,NULL,NULL,1100,17,NULL,160),
 ('16#116*2',142,NULL,NULL,1100,13,NULL,196),
 ('16#118*2',196,NULL,NULL,1100,13,NULL,188),
 ('16#12*2',227,NULL,NULL,1100,20,NULL,143),
 ('16#120*2',248,NULL,NULL,1100,20,NULL,141),
 ('16#121*2',43,NULL,NULL,1100,11,NULL,241),
 ('16#123*2',393,NULL,NULL,1100,39,NULL,48),
 ('16#125*2',83,NULL,NULL,1100,11,NULL,223),
 ('16#126*2',252,NULL,NULL,1100,20,NULL,139),
 ('16#127*2',65,NULL,NULL,1100,11,NULL,229),
 ('16#128*2',86,NULL,NULL,1100,11,NULL,222),
 ('16#129*2',223,NULL,NULL,1100,19,NULL,147),
 ('16#13*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#130*2',426,NULL,NULL,1100,48,NULL,33),
 ('16#131*2',295,NULL,NULL,1100,26,NULL,95),
 ('16#132*2',337,NULL,NULL,1100,30,NULL,79),
 ('16#133*2',363,NULL,NULL,1100,33,NULL,65),
 ('16#134*2',303,NULL,NULL,1100,31,NULL,77),
 ('16#135*2',11,NULL,NULL,1100,11,NULL,248),
 ('16#136*2',304,NULL,NULL,1100,23,NULL,110),
 ('16#137*2',568,NULL,NULL,1100,67,NULL,12),
 ('16#138*2',245,NULL,NULL,1100,23,NULL,118),
 ('16#139*2',214,NULL,NULL,1100,19,NULL,148),
 ('16#14*2',337,NULL,NULL,1100,32,NULL,70),
 ('16#140*2',253,NULL,NULL,1100,23,NULL,116),
 ('16#141*2',655,NULL,NULL,1100,83,NULL,4),
 ('16#142*2',203,NULL,NULL,1100,16,NULL,169),
 ('16#143*2',187,NULL,NULL,1100,13,NULL,189),
 ('16#144*2',276,NULL,NULL,1100,20,NULL,137),
 ('16#145*2',289,NULL,NULL,1100,28,NULL,87),
 ('16#146*2',109,NULL,NULL,1100,16,NULL,173),
 ('16#147*2',78,NULL,NULL,1100,11,NULL,225),
 ('16#149*2',265,NULL,NULL,1100,23,NULL,113),
 ('16#15*2',51,NULL,NULL,1100,11,NULL,234),
 ('16#150*2',403,NULL,NULL,1100,44,NULL,40),
 ('16#151*2',250,NULL,NULL,1100,26,NULL,99),
 ('16#154*2',261,NULL,NULL,1100,23,NULL,114),
 ('16#155*2',49,NULL,NULL,1100,11,NULL,235),
 ('16#156*2',128,NULL,NULL,1100,12,NULL,208),
 ('16#157*2',83,NULL,NULL,1100,11,NULL,223),
 ('16#158*2',255,NULL,NULL,1100,19,NULL,145),
 ('16#159*2',217,NULL,NULL,1100,16,NULL,166),
 ('16#16*2',47,NULL,NULL,1100,11,NULL,237),
 ('16#160*2',553,NULL,NULL,1100,67,NULL,14),
 ('16#161*2',64,NULL,NULL,1100,11,NULL,230),
 ('16#163*2',142,NULL,NULL,1100,14,NULL,186),
 ('16#164*2',491,NULL,NULL,1100,51,NULL,27),
 ('16#165*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#166*2',101,NULL,NULL,1100,13,NULL,200),
 ('16#167*2',670,NULL,NULL,1100,84,NULL,3),
 ('16#168*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#169*2',471,NULL,NULL,1100,54,NULL,22),
 ('16#17*2',348,NULL,NULL,1100,28,NULL,84),
 ('16#170*2',535,NULL,NULL,1100,59,NULL,17),
 ('16#171*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#172*2',166,NULL,NULL,1100,12,NULL,202),
 ('16#173*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#174*2',278,NULL,NULL,1100,25,NULL,102),
 ('16#175*2',183,NULL,NULL,1100,13,NULL,190),
 ('16#176*2',410,NULL,NULL,1100,44,NULL,39),
 ('16#177*2',45,NULL,NULL,1100,11,NULL,238),
 ('16#178*2',331,NULL,NULL,1100,31,NULL,74),
 ('16#179*2',399,NULL,NULL,1100,41,NULL,45),
 ('16#18*2',203,NULL,NULL,1100,13,NULL,187),
 ('16#180*2',45,NULL,NULL,1100,11,NULL,238),
 ('16#181*2',95,NULL,NULL,1100,11,NULL,221),
 ('16#182*2',249,NULL,NULL,1100,19,NULL,146),
 ('16#183*2',202,NULL,NULL,1100,19,NULL,149),
 ('16#184*2',270,NULL,NULL,1100,21,NULL,130),
 ('16#185*2',324,NULL,NULL,1100,32,NULL,72),
 ('16#187*2',151,NULL,NULL,1100,14,NULL,184),
 ('16#188*2',143,NULL,NULL,1100,14,NULL,185),
 ('16#189*2',430,NULL,NULL,1100,46,NULL,35),
 ('16#19*2',135,NULL,NULL,1100,12,NULL,205),
 ('16#190*2',333,NULL,NULL,1100,37,NULL,51),
 ('16#191*2',264,NULL,NULL,1100,26,NULL,98),
 ('16#192*2',391,NULL,NULL,1100,44,NULL,41),
 ('16#195*2',55,NULL,NULL,1100,11,NULL,233),
 ('16#196*2',208,NULL,NULL,1100,16,NULL,167),
 ('16#197*2',111,NULL,NULL,1100,13,NULL,199),
 ('16#198*2',202,NULL,NULL,1100,19,NULL,149),
 ('16#199*2',371,NULL,NULL,1100,34,NULL,62),
 ('16#2*2',481,NULL,NULL,1100,52,NULL,25),
 ('16#20*2',266,NULL,NULL,1100,18,NULL,152),
 ('16#200*2',453,NULL,NULL,1100,57,NULL,19),
 ('16#201*2',334,NULL,NULL,1100,30,NULL,81),
 ('16#202*2',180,NULL,NULL,1100,12,NULL,201),
 ('16#203*2',29,NULL,NULL,1100,11,NULL,244),
 ('16#204*2',312,NULL,NULL,1100,28,NULL,85),
 ('16#205*2',288,NULL,NULL,1100,26,NULL,97),
 ('16#206*2',239,NULL,NULL,1100,14,NULL,181),
 ('16#207*2',447,NULL,NULL,1100,48,NULL,31),
 ('16#208*2',473,NULL,NULL,1100,52,NULL,26),
 ('16#209*2',336,NULL,NULL,1100,30,NULL,80),
 ('16#21*2',470,NULL,NULL,1100,48,NULL,30),
 ('16#210*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#211*2',120,NULL,NULL,1100,12,NULL,209),
 ('16#212*2',108,NULL,NULL,1100,11,NULL,217),
 ('16#213*2',185,NULL,NULL,1100,18,NULL,156),
 ('16#214*2',382,NULL,NULL,1100,41,NULL,46),
 ('16#215*2',161,NULL,NULL,1100,13,NULL,195),
 ('16#216*2',132,NULL,NULL,1100,12,NULL,206),
 ('16#217*2',505,NULL,NULL,1100,60,NULL,16),
 ('16#218*2',167,NULL,NULL,1100,13,NULL,194),
 ('16#219*2',358,NULL,NULL,1100,38,NULL,49),
 ('16#22*2',303,NULL,NULL,1100,26,NULL,94),
 ('16#220*2',102,NULL,NULL,1100,16,NULL,174),
 ('16#221*2',275,NULL,NULL,1100,24,NULL,107),
 ('16#222*2',171,NULL,NULL,1100,13,NULL,191),
 ('16#223*2',306,NULL,NULL,1100,28,NULL,86),
 ('16#224*2',567,NULL,NULL,1100,67,NULL,13),
 ('16#225*2',277,NULL,NULL,1100,20,NULL,136),
 ('16#226*2',171,NULL,NULL,1100,16,NULL,172),
 ('16#227*2',385,NULL,NULL,1100,37,NULL,50),
 ('16#228*2',309,NULL,NULL,1100,27,NULL,91),
 ('16#229*2',178,NULL,NULL,1100,17,NULL,162),
 ('16#23*2',195,NULL,NULL,1100,16,NULL,170),
 ('16#230*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#231*2',308,NULL,NULL,1100,31,NULL,76),
 ('16#232*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#233*2',221,NULL,NULL,1100,17,NULL,159),
 ('16#234*2',259,NULL,NULL,1100,22,NULL,126),
 ('16#236*2',356,NULL,NULL,1100,31,NULL,73),
 ('16#237*2',63,NULL,NULL,1100,11,NULL,231),
 ('16#238*2',558,NULL,NULL,1100,68,NULL,11),
 ('16#239*2',314,NULL,NULL,1100,33,NULL,67),
 ('16#24*2',20,NULL,NULL,1100,11,NULL,246),
 ('16#240*2',438,NULL,NULL,1100,48,NULL,32),
 ('16#241*2',577,NULL,NULL,1100,71,NULL,8),
 ('16#242*2',415,NULL,NULL,1100,46,NULL,36),
 ('16#243*2',252,NULL,NULL,1100,25,NULL,103),
 ('16#244*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#245*2',120,NULL,NULL,1100,12,NULL,209),
 ('16#246*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#247*2',48,NULL,NULL,1100,11,NULL,236),
 ('16#248*2',173,NULL,NULL,1100,18,NULL,157),
 ('16#249*2',242,NULL,NULL,1100,20,NULL,142),
 ('16#25*2',180,NULL,NULL,1100,17,NULL,161),
 ('16#250*2',134,NULL,NULL,1100,11,NULL,215),
 ('16#251*2',411,NULL,NULL,1100,45,NULL,37),
 ('16#252*2',219,NULL,NULL,1100,16,NULL,165),
 ('16#253*2',360,NULL,NULL,1100,33,NULL,66),
 ('16#254*2',278,NULL,NULL,1100,24,NULL,106),
 ('16#255*2',210,NULL,NULL,1100,15,NULL,176),
 ('16#256*2',337,NULL,NULL,1100,35,NULL,59),
 ('16#257*2',98,NULL,NULL,1100,11,NULL,219),
 ('16#258*2',386,NULL,NULL,1100,44,NULL,42),
 ('16#259*2',462,NULL,NULL,1100,55,NULL,21),
 ('16#26*2',489,NULL,NULL,1100,50,NULL,28),
 ('16#260*2',387,NULL,NULL,1100,36,NULL,52),
 ('16#261*2',295,NULL,NULL,1100,25,NULL,101),
 ('16#262*2',134,NULL,NULL,1100,15,NULL,180),
 ('16#263*2',340,NULL,NULL,1100,36,NULL,54),
 ('16#264*2',251,NULL,NULL,1100,25,NULL,104),
 ('16#265*2',562,NULL,NULL,1100,68,NULL,10),
 ('16#266*2',256,NULL,NULL,1100,17,NULL,158),
 ('16#267*2',342,NULL,NULL,1100,32,NULL,68),
 ('16#268*2',546,NULL,NULL,1100,58,NULL,18),
 ('16#269*2',622,NULL,NULL,1100,74,NULL,6),
 ('16#27*2',583,NULL,NULL,1100,73,NULL,7),
 ('16#270*2',241,NULL,NULL,1100,23,NULL,119),
 ('16#271*2',250,NULL,NULL,1100,20,NULL,140),
 ('16#272*2',225,NULL,NULL,1100,18,NULL,155),
 ('16#273*2',1,NULL,NULL,1100,11,NULL,251),
 ('16#274*2',265,NULL,NULL,1100,18,NULL,153),
 ('16#275*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#276*2',255,NULL,NULL,1100,23,NULL,115),
 ('16#277*2',455,NULL,NULL,1100,54,NULL,23),
 ('16#278*2',269,NULL,NULL,1100,20,NULL,138),
 ('16#279*3',136,NULL,NULL,800,8,NULL,76),
 ('16#28*2',289,NULL,NULL,1100,26,NULL,96),
 ('16#281*3',304,NULL,NULL,800,28,NULL,13),
 ('16#282*3',1,NULL,NULL,800,8,NULL,134),
 ('16#286*3',199,NULL,NULL,800,17,NULL,36),
 ('16#287*3',225,NULL,NULL,800,22,NULL,24),
 ('16#29*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#290*3',40,NULL,NULL,800,8,NULL,122),
 ('16#291*3',185,NULL,NULL,800,14,NULL,45),
 ('16#292*3',260,NULL,NULL,800,24,NULL,21),
 ('16#293*3',27,NULL,NULL,800,8,NULL,128),
 ('16#295*3',59,NULL,NULL,800,8,NULL,117),
 ('16#296*3',64,NULL,NULL,800,8,NULL,113),
 ('16#298*3',14,NULL,NULL,800,8,NULL,131),
 ('16#299*3',277,NULL,NULL,800,31,NULL,8),
 ('16#3*2',281,NULL,NULL,1100,19,NULL,144),
 ('16#30*2',6,NULL,NULL,1100,11,NULL,250),
 ('16#300*3',182,NULL,NULL,800,11,NULL,55),
 ('16#301*3',126,NULL,NULL,800,9,NULL,69),
 ('16#303*3',214,NULL,NULL,800,19,NULL,32),
 ('16#304*3',87,NULL,NULL,800,8,NULL,98),
 ('16#305*3',316,NULL,NULL,800,36,NULL,6),
 ('16#306*3',141,NULL,NULL,800,10,NULL,59),
 ('16#307*3',124,NULL,NULL,800,9,NULL,70),
 ('16#31*2',104,NULL,NULL,1100,11,NULL,218),
 ('16#311*3',75,NULL,NULL,800,8,NULL,107),
 ('16#312*3',35,NULL,NULL,800,8,NULL,124),
 ('16#313*3',77,NULL,NULL,800,8,NULL,106),
 ('16#314*3',120,NULL,NULL,800,8,NULL,79),
 ('16#315*3',72,NULL,NULL,800,8,NULL,109),
 ('16#317*3',264,NULL,NULL,800,21,NULL,25),
 ('16#32*2',189,NULL,NULL,1100,15,NULL,178),
 ('16#321*3',55,NULL,NULL,800,8,NULL,118),
 ('16#322*3',0,NULL,NULL,800,8,NULL,135),
 ('16#323*3',120,NULL,NULL,800,9,NULL,72),
 ('16#324*3',87,NULL,NULL,800,9,NULL,74),
 ('16#327*3',127,NULL,NULL,800,8,NULL,78),
 ('16#328*3',62,NULL,NULL,800,8,NULL,115),
 ('16#329*3',241,NULL,NULL,800,23,NULL,23),
 ('16#33*2',274,NULL,NULL,1100,23,NULL,111),
 ('16#331*3',115,NULL,NULL,800,8,NULL,83),
 ('16#332*3',201,NULL,NULL,800,16,NULL,38),
 ('16#333*3',256,NULL,NULL,800,25,NULL,19),
 ('16#334*3',93,NULL,NULL,800,10,NULL,61),
 ('16#335*3',89,NULL,NULL,800,8,NULL,97),
 ('16#338*3',104,NULL,NULL,800,8,NULL,88),
 ('16#339*3',74,NULL,NULL,800,8,NULL,108),
 ('16#34*2',281,NULL,NULL,1100,21,NULL,128),
 ('16#341*3',265,NULL,NULL,800,25,NULL,18),
 ('16#342*3',62,NULL,NULL,800,8,NULL,115),
 ('16#344*3',180,NULL,NULL,800,14,NULL,48),
 ('16#345*3',230,NULL,NULL,800,21,NULL,26),
 ('16#346*3',229,NULL,NULL,800,20,NULL,28),
 ('16#348*3',178,NULL,NULL,700,12,NULL,52),
 ('16#349*3',47,NULL,NULL,800,8,NULL,120),
 ('16#35*2',73,NULL,NULL,1100,11,NULL,227),
 ('16#350*3',119,NULL,NULL,800,8,NULL,80),
 ('16#351*3',29,NULL,NULL,800,8,NULL,126),
 ('16#352*3',183,NULL,NULL,800,14,NULL,47),
 ('16#353*3',273,NULL,NULL,800,24,NULL,20),
 ('16#354*3',303,NULL,NULL,800,30,NULL,10),
 ('16#355*3',187,NULL,NULL,700,20,NULL,29),
 ('16#358*3',476,NULL,NULL,800,60,NULL,2),
 ('16#359*3',308,NULL,NULL,800,31,NULL,7),
 ('16#36*2',140,NULL,NULL,1100,11,NULL,214),
 ('16#360*3',28,NULL,NULL,800,8,NULL,127),
 ('16#365*3',116,NULL,NULL,800,8,NULL,82),
 ('16#366*3',158,NULL,NULL,800,9,NULL,63),
 ('16#367*3',44,NULL,NULL,800,8,NULL,121),
 ('16#368*3',103,NULL,NULL,800,8,NULL,89),
 ('16#369*3',131,NULL,NULL,800,9,NULL,67),
 ('16#37*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#370*3',82,NULL,NULL,800,8,NULL,105),
 ('16#372*3',131,NULL,NULL,800,9,NULL,67),
 ('16#373*3',252,NULL,NULL,800,23,NULL,22),
 ('16#374*3',266,NULL,NULL,800,25,NULL,17),
 ('16#376*3',146,NULL,NULL,800,11,NULL,56),
 ('16#377*3',123,NULL,NULL,800,12,NULL,54),
 ('16#38*2',279,NULL,NULL,1100,20,NULL,135),
 ('16#380*3',202,NULL,NULL,800,17,NULL,35),
 ('16#381*3',85,NULL,NULL,800,8,NULL,100),
 ('16#382*3',105,NULL,NULL,800,8,NULL,86),
 ('16#383*3',224,NULL,NULL,800,19,NULL,30),
 ('16#384*3',153,NULL,NULL,800,13,NULL,51),
 ('16#385*3',40,NULL,NULL,800,8,NULL,122),
 ('16#389*3',98,NULL,NULL,800,8,NULL,93),
 ('16#39*2',238,NULL,NULL,1100,15,NULL,175),
 ('16#392*3',69,NULL,NULL,800,8,NULL,110),
 ('16#393*3',0,NULL,NULL,600,6,NULL,138),
 ('16#394*3',99,NULL,NULL,800,8,NULL,92),
 ('16#395*3',117,NULL,NULL,800,8,NULL,81),
 ('16#396*3',141,NULL,NULL,800,10,NULL,59),
 ('16#397*3',0,NULL,NULL,600,6,NULL,138),
 ('16#398*3',196,NULL,NULL,800,15,NULL,42),
 ('16#399*3',218,NULL,NULL,800,19,NULL,31),
 ('16#4*2',24,NULL,NULL,1100,11,NULL,245),
 ('16#40*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#400*3',91,NULL,NULL,800,8,NULL,96),
 ('16#403*3',154,NULL,NULL,800,9,NULL,64),
 ('16#404*3',153,NULL,NULL,800,9,NULL,65),
 ('16#405*3',0,NULL,NULL,700,7,NULL,138),
 ('16#407*3',100,NULL,NULL,800,8,NULL,90),
 ('16#409*3',4,NULL,NULL,800,8,NULL,133),
 ('16#41*2',361,NULL,NULL,1100,35,NULL,58),
 ('16#414*3',129,NULL,NULL,800,8,NULL,77),
 ('16#415*3',49,NULL,NULL,800,8,NULL,119),
 ('16#416*3',32,NULL,NULL,800,8,NULL,125),
 ('16#417*3',360,NULL,NULL,800,45,NULL,4),
 ('16#418*3',281,NULL,NULL,800,26,NULL,16),
 ('16#42*2',324,NULL,NULL,1100,26,NULL,92),
 ('16#420*3',184,NULL,NULL,800,14,NULL,46),
 ('16#422*3',553,NULL,NULL,800,75,NULL,1),
 ('16#425*3',280,NULL,NULL,800,27,NULL,15),
 ('16#427*3',193,NULL,NULL,800,19,NULL,33),
 ('16#428*3',64,NULL,NULL,800,8,NULL,113),
 ('16#429*3',69,NULL,NULL,800,8,NULL,110),
 ('16#43*2',166,NULL,NULL,1100,14,NULL,183),
 ('16#430*3',295,NULL,NULL,800,28,NULL,14),
 ('16#431*3',85,NULL,NULL,800,8,NULL,100),
 ('16#433*3',221,NULL,NULL,800,17,NULL,34),
 ('16#434*3',196,NULL,NULL,800,16,NULL,39),
 ('16#435*3',20,NULL,NULL,800,8,NULL,129),
 ('16#436*3',243,NULL,NULL,800,20,NULL,27),
 ('16#437*3',308,NULL,NULL,800,30,NULL,9),
 ('16#438*3',164,NULL,NULL,800,13,NULL,49),
 ('16#439*3',69,NULL,NULL,700,7,NULL,136),
 ('16#44*2',400,NULL,NULL,1100,33,NULL,63),
 ('16#440*3',163,NULL,NULL,800,13,NULL,50),
 ('16#441*3',65,NULL,NULL,800,8,NULL,112),
 ('16#442*3',86,NULL,NULL,800,8,NULL,99),
 ('16#444*3',107,NULL,NULL,800,8,NULL,85),
 ('16#445*3',437,NULL,NULL,800,51,NULL,3),
 ('16#446*3',95,NULL,NULL,800,8,NULL,95),
 ('16#447*3',139,NULL,NULL,800,11,NULL,58),
 ('16#449*3',281,NULL,NULL,800,30,NULL,12),
 ('16#45*2',262,NULL,NULL,1100,18,NULL,154),
 ('16#450*3',364,NULL,NULL,800,42,NULL,5),
 ('16#451*3',196,NULL,NULL,800,17,NULL,37),
 ('16#452*4',15,NULL,NULL,800,8,NULL,141),
 ('16#453*4',182,NULL,NULL,800,15,NULL,19),
 ('16#454*4',2,NULL,NULL,800,8,NULL,147),
 ('16#455*4',120,NULL,NULL,800,12,NULL,30),
 ('16#456*4',0,NULL,NULL,800,8,NULL,149),
 ('16#458*4',166,NULL,NULL,800,9,NULL,48),
 ('16#459*4',52,NULL,NULL,800,8,NULL,117),
 ('16#46*2',179,NULL,NULL,1100,15,NULL,179),
 ('16#461*4',0,NULL,NULL,800,8,NULL,149),
 ('16#463*4',48,NULL,NULL,800,8,NULL,121),
 ('16#464*4',63,NULL,NULL,800,8,NULL,104),
 ('16#466*4',168,NULL,NULL,800,13,NULL,25),
 ('16#467*4',350,NULL,NULL,800,40,NULL,2),
 ('16#468*4',4,NULL,NULL,800,8,NULL,144),
 ('16#469*4',55,NULL,NULL,800,8,NULL,112),
 ('16#47*2',511,NULL,NULL,1100,56,NULL,20),
 ('16#4700*3',84,NULL,NULL,800,8,NULL,102),
 ('16#4701*3',7,NULL,NULL,800,8,NULL,132),
 ('16#4702*3',0,NULL,NULL,600,6,NULL,138),
 ('16#471*4',92,NULL,NULL,800,8,NULL,81),
 ('16#4714*4',126,NULL,NULL,800,9,NULL,53),
 ('16#4720*4',106,NULL,NULL,800,8,NULL,74),
 ('16#4721*2',383,NULL,NULL,1100,35,NULL,56),
 ('16#4722*3',136,NULL,NULL,600,16,NULL,40),
 ('16#4723*3',83,NULL,NULL,800,8,NULL,104),
 ('16#4726*1',11,NULL,NULL,1100,11,NULL,201),
 ('16#4727*1',655,NULL,NULL,1100,85,NULL,8),
 ('16#4728*1',286,NULL,NULL,1100,26,NULL,89),
 ('16#4729*1',147,NULL,NULL,1100,13,NULL,158),
 ('16#473*4',223,NULL,NULL,800,18,NULL,12),
 ('16#4730*1',0,NULL,NULL,1100,11,NULL,203),
 ('16#4731*1',560,NULL,NULL,1100,66,NULL,13),
 ('16#4732*1',66,NULL,NULL,1100,11,NULL,186),
 ('16#4733*1',531,NULL,NULL,1100,59,NULL,20),
 ('16#4734*1',776,NULL,NULL,1100,105,NULL,4),
 ('16#4735*1',892,NULL,NULL,1100,119,NULL,1),
 ('16#4736*1',222,NULL,NULL,1100,19,NULL,120),
 ('16#4737*1',314,NULL,NULL,1100,24,NULL,93),
 ('16#4738*1',618,NULL,NULL,1100,78,NULL,9),
 ('16#4739*1',445,NULL,NULL,1100,42,NULL,44),
 ('16#4740*1',542,NULL,NULL,1100,66,NULL,14),
 ('16#4741*1',90,NULL,NULL,1100,14,NULL,153),
 ('16#4742*1',674,NULL,NULL,1100,88,NULL,7),
 ('16#4743*1',47,NULL,NULL,1100,11,NULL,195),
 ('16#4744*1',96,NULL,NULL,1100,14,NULL,152),
 ('16#4745*1',110,NULL,NULL,1100,11,NULL,176),
 ('16#4746*1',390,NULL,NULL,1100,41,NULL,48),
 ('16#4747*1',607,NULL,NULL,1100,78,NULL,10),
 ('16#4748*1',398,NULL,NULL,1100,39,NULL,50),
 ('16#4749*1',364,NULL,NULL,1100,31,NULL,64),
 ('16#475*4',26,NULL,NULL,800,8,NULL,139),
 ('16#4750*1',2,NULL,NULL,1100,11,NULL,202),
 ('16#4751*1',304,NULL,NULL,1100,23,NULL,102),
 ('16#4752*1',261,NULL,NULL,1100,19,NULL,116),
 ('16#4753*1',485,NULL,NULL,1100,55,NULL,26),
 ('16#4754*1',299,NULL,NULL,1100,27,NULL,85),
 ('16#4755*1',714,NULL,NULL,1100,93,NULL,5),
 ('16#4756*1',464,NULL,NULL,1100,51,NULL,29),
 ('16#4757*1',453,NULL,NULL,1100,53,NULL,27),
 ('16#4758*1',394,NULL,NULL,1100,43,NULL,43),
 ('16#4759*1',49,NULL,NULL,1100,11,NULL,194),
 ('16#476*4',89,NULL,NULL,800,9,NULL,66),
 ('16#4760*1',246,NULL,NULL,1100,24,NULL,101),
 ('16#4761*1',139,NULL,NULL,1100,11,NULL,168),
 ('16#4762*1',369,NULL,NULL,1100,35,NULL,57),
 ('16#4763*1',536,NULL,NULL,1100,60,NULL,19),
 ('16#4764*1',106,NULL,NULL,1100,11,NULL,177),
 ('16#4765*1',245,NULL,NULL,1100,16,NULL,131),
 ('16#4766*1',856,NULL,NULL,1100,116,NULL,2),
 ('16#4767*1',160,NULL,NULL,1100,15,NULL,144),
 ('16#4768*1',155,NULL,NULL,1100,15,NULL,145),
 ('16#4769*1',119,NULL,NULL,1100,11,NULL,173),
 ('16#4770*1',712,NULL,NULL,1100,93,NULL,6),
 ('16#4771*1',139,NULL,NULL,1100,11,NULL,168),
 ('16#4772*1',282,NULL,NULL,1100,24,NULL,96),
 ('16#4773*1',140,NULL,NULL,1100,15,NULL,146),
 ('16#4774*1',33,NULL,NULL,1100,11,NULL,198),
 ('16#4775*1',478,NULL,NULL,1100,50,NULL,31),
 ('16#4776*1',611,NULL,NULL,1100,74,NULL,12),
 ('16#4777*1',607,NULL,NULL,1100,75,NULL,10),
 ('16#4778*1',449,NULL,NULL,1100,45,NULL,37),
 ('16#4779*1',240,NULL,NULL,1100,17,NULL,127),
 ('16#478*4',181,NULL,NULL,800,14,NULL,22),
 ('16#4780*1',449,NULL,NULL,1100,44,NULL,37),
 ('16#4781*1',335,NULL,NULL,1100,31,NULL,65),
 ('16#4782*1',345,NULL,NULL,1100,29,NULL,74),
 ('16#4783*1',274,NULL,NULL,1100,24,NULL,97),
 ('16#4784*1',306,NULL,NULL,1100,29,NULL,75),
 ('16#4785*1',235,NULL,NULL,1100,20,NULL,115),
 ('16#4786*1',157,NULL,NULL,1100,14,NULL,151),
 ('16#4787*1',54,NULL,NULL,1100,11,NULL,190),
 ('16#4788*1',0,NULL,NULL,1100,11,NULL,203),
 ('16#4789*1',304,NULL,NULL,1100,27,NULL,84),
 ('16#479*4',12,NULL,NULL,800,8,NULL,143),
 ('16#4790*1',342,NULL,NULL,1100,33,NULL,59),
 ('16#4791*1',313,NULL,NULL,1100,33,NULL,60),
 ('16#4792*1',314,NULL,NULL,1100,31,NULL,67),
 ('16#4793*1',53,NULL,NULL,1100,11,NULL,191),
 ('16#4794*1',65,NULL,NULL,1100,11,NULL,187),
 ('16#4795*1',86,NULL,NULL,1100,11,NULL,180),
 ('16#4796*1',138,NULL,NULL,1100,11,NULL,170),
 ('16#4797*1',244,NULL,NULL,1100,19,NULL,117),
 ('16#4798*1',279,NULL,NULL,1100,22,NULL,105),
 ('16#4799*1',330,NULL,NULL,1100,31,NULL,66),
 ('16#48*2',417,NULL,NULL,1100,41,NULL,44),
 ('16#480*4',118,NULL,NULL,800,11,NULL,38),
 ('16#4800*1',272,NULL,NULL,1100,24,NULL,100),
 ('16#4801*1',421,NULL,NULL,1100,44,NULL,41),
 ('16#4802*1',0,NULL,NULL,1100,11,NULL,203),
 ('16#4803*1',326,NULL,NULL,1100,28,NULL,78),
 ('16#4804*1',434,NULL,NULL,1100,44,NULL,39),
 ('16#4805*1',224,NULL,NULL,1100,19,NULL,119),
 ('16#4806*1',298,NULL,NULL,1100,25,NULL,90),
 ('16#4807*1',78,NULL,NULL,1100,16,NULL,139),
 ('16#4808*1',216,NULL,NULL,1100,18,NULL,125),
 ('16#4809*1',185,NULL,NULL,1100,15,NULL,143),
 ('16#4810*1',323,NULL,NULL,1100,26,NULL,87),
 ('16#4811*1',363,NULL,NULL,1100,35,NULL,58),
 ('16#4812*1',177,NULL,NULL,1100,11,NULL,166),
 ('16#4813*1',253,NULL,NULL,1100,20,NULL,114),
 ('16#4814*1',244,NULL,NULL,1100,19,NULL,117),
 ('16#4815*1',37,NULL,NULL,1100,11,NULL,197),
 ('16#4816*1',227,NULL,NULL,1100,18,NULL,122),
 ('16#4817*1',230,NULL,NULL,1100,22,NULL,109),
 ('16#4818*1',387,NULL,NULL,1100,38,NULL,52),
 ('16#4819*1',167,NULL,NULL,1100,14,NULL,150),
 ('16#482*4',0,NULL,NULL,700,7,NULL,155),
 ('16#4820*1',264,NULL,NULL,1100,23,NULL,103),
 ('16#4821*1',312,NULL,NULL,1100,28,NULL,80),
 ('16#4822*1',430,NULL,NULL,1100,41,NULL,46),
 ('16#4823*1',158,NULL,NULL,1100,13,NULL,156),
 ('16#4824*1',369,NULL,NULL,1100,37,NULL,54),
 ('16#4825*1',307,NULL,NULL,1100,24,NULL,94),
 ('16#4826*1',243,NULL,NULL,1100,22,NULL,107),
 ('16#4827*1',403,NULL,NULL,1100,39,NULL,49),
 ('16#4828*1',352,NULL,NULL,1100,32,NULL,63),
 ('16#4829*1',104,NULL,NULL,1100,11,NULL,178),
 ('16#483*4',64,NULL,NULL,800,8,NULL,101),
 ('16#4830*1',305,NULL,NULL,1100,26,NULL,88),
 ('16#4831*1',181,NULL,NULL,1100,11,NULL,165),
 ('16#4832*1',490,NULL,NULL,1100,52,NULL,28),
 ('16#4833*1',447,NULL,NULL,1100,47,NULL,36),
 ('16#4834*1',271,NULL,NULL,1100,21,NULL,110),
 ('16#4835*1',139,NULL,NULL,1100,12,NULL,161),
 ('16#4836*1',294,NULL,NULL,1100,28,NULL,81),
 ('16#4837*1',64,NULL,NULL,1100,11,NULL,188),
 ('16#4838*1',327,NULL,NULL,1100,26,NULL,86),
 ('16#4839*1',38,NULL,NULL,1100,11,NULL,196),
 ('16#4840*1',520,NULL,NULL,1100,57,NULL,23),
 ('16#4841*1',83,NULL,NULL,1100,11,NULL,181),
 ('16#4842*1',226,NULL,NULL,1100,15,NULL,141),
 ('16#4843*1',433,NULL,NULL,1100,42,NULL,45),
 ('16#4844*1',274,NULL,NULL,1100,24,NULL,97),
 ('16#4845*1',128,NULL,NULL,1100,12,NULL,162),
 ('16#4846*1',280,NULL,NULL,1100,29,NULL,76),
 ('16#4847*1',468,NULL,NULL,1100,48,NULL,35),
 ('16#4848*1',196,NULL,NULL,1100,16,NULL,136),
 ('16#4849*1',67,NULL,NULL,1100,11,NULL,185),
 ('16#485*4',123,NULL,NULL,800,10,NULL,45),
 ('16#4850*1',71,NULL,NULL,1100,11,NULL,184),
 ('16#4851*1',300,NULL,NULL,1100,24,NULL,95),
 ('16#4852*1',113,NULL,NULL,1100,12,NULL,164),
 ('16#4853*1',256,NULL,NULL,1100,21,NULL,111),
 ('16#4854*1',547,NULL,NULL,1100,63,NULL,16),
 ('16#4855*1',190,NULL,NULL,1100,14,NULL,148),
 ('16#4856*1',359,NULL,NULL,1100,36,NULL,56),
 ('16#4857*1',203,NULL,NULL,1100,16,NULL,135),
 ('16#4858*1',56,NULL,NULL,1100,11,NULL,189),
 ('16#4859*1',495,NULL,NULL,1100,50,NULL,30),
 ('16#4860*1',136,NULL,NULL,1100,11,NULL,171),
 ('16#4861*1',27,NULL,NULL,1100,11,NULL,199),
 ('16#4862*1',217,NULL,NULL,1100,14,NULL,147),
 ('16#4863*1',437,NULL,NULL,1100,43,NULL,42),
 ('16#4864*1',274,NULL,NULL,1100,24,NULL,97),
 ('16#4865*1',372,NULL,NULL,1100,32,NULL,61),
 ('16#4866*1',326,NULL,NULL,1100,28,NULL,78),
 ('16#4867*1',226,NULL,NULL,1100,13,NULL,154),
 ('16#4868*1',258,NULL,NULL,1100,23,NULL,104),
 ('16#4869*1',180,NULL,NULL,1100,13,NULL,155),
 ('16#487*4',102,NULL,NULL,800,9,NULL,62),
 ('16#4870*1',508,NULL,NULL,1100,55,NULL,25),
 ('16#4871*1',218,NULL,NULL,1100,18,NULL,124),
 ('16#4872*1',220,NULL,NULL,1100,18,NULL,123),
 ('16#4873*1',542,NULL,NULL,1100,58,NULL,21),
 ('16#4874*1',0,NULL,NULL,1100,11,NULL,203),
 ('16#4875*1',275,NULL,NULL,1100,25,NULL,92),
 ('16#4876*1',146,NULL,NULL,1100,11,NULL,167),
 ('16#4877*1',195,NULL,NULL,1100,12,NULL,160),
 ('16#4878*1',220,NULL,NULL,1100,16,NULL,133),
 ('16#4879*1',105,NULL,NULL,1100,13,NULL,159),
 ('16#488*4',58,NULL,NULL,800,8,NULL,108),
 ('16#4880*1',226,NULL,NULL,1100,17,NULL,128),
 ('16#4881*1',224,NULL,NULL,1100,16,NULL,132),
 ('16#4882*1',528,NULL,NULL,1100,63,NULL,17),
 ('16#4883*1',317,NULL,NULL,1100,27,NULL,82),
 ('16#4884*1',471,NULL,NULL,1100,48,NULL,34),
 ('16#4885*1',116,NULL,NULL,1100,16,NULL,138),
 ('16#4886*1',360,NULL,NULL,1100,32,NULL,62),
 ('16#4887*1',416,NULL,NULL,1100,38,NULL,51),
 ('16#4888*1',209,NULL,NULL,1100,16,NULL,134),
 ('16#4889*1',225,NULL,NULL,1100,17,NULL,129),
 ('16#4890*1',777,NULL,NULL,1100,106,NULL,3),
 ('16#4891*1',246,NULL,NULL,1100,21,NULL,112),
 ('16#4892*1',286,NULL,NULL,1100,25,NULL,91),
 ('16#4893*1',118,NULL,NULL,1100,11,NULL,174),
 ('16#4894*1',520,NULL,NULL,1100,56,NULL,23),
 ('16#4895*1',472,NULL,NULL,1100,50,NULL,32),
 ('16#4896*1',15,NULL,NULL,1100,11,NULL,200),
 ('16#4897*1',116,NULL,NULL,1100,11,NULL,175),
 ('16#4898*1',170,NULL,NULL,1100,14,NULL,149),
 ('16#4899*1',524,NULL,NULL,1100,57,NULL,22),
 ('16#49*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#490*4',102,NULL,NULL,800,8,NULL,77),
 ('16#4900*1',406,NULL,NULL,1100,36,NULL,55),
 ('16#4901*1',427,NULL,NULL,1100,41,NULL,47),
 ('16#4902*1',157,NULL,NULL,1100,13,NULL,157),
 ('16#4903*1',242,NULL,NULL,1100,22,NULL,108),
 ('16#4904*1',97,NULL,NULL,1100,11,NULL,179),
 ('16#4905*1',352,NULL,NULL,1100,30,NULL,70),
 ('16#4906*1',433,NULL,NULL,1100,44,NULL,40),
 ('16#4907*1',356,NULL,NULL,1100,30,NULL,69),
 ('16#4908*1',152,NULL,NULL,1100,19,NULL,121),
 ('16#4909*1',260,NULL,NULL,1100,22,NULL,106),
 ('16#491*4',27,NULL,NULL,800,8,NULL,138),
 ('16#4910*1',338,NULL,NULL,1100,30,NULL,72),
 ('16#4911*1',315,NULL,NULL,1100,27,NULL,83),
 ('16#4912*1',268,NULL,NULL,1100,17,NULL,126),
 ('16#4913*1',324,NULL,NULL,1100,30,NULL,73),
 ('16#4914*1',124,NULL,NULL,1100,12,NULL,163),
 ('16#4915*1',211,NULL,NULL,1100,15,NULL,142),
 ('16#4916*1',549,NULL,NULL,1100,62,NULL,18),
 ('16#4917*2',834,NULL,NULL,1100,113,NULL,1),
 ('16#4918*2',271,NULL,NULL,1100,30,NULL,83),
 ('16#4920*2',189,NULL,NULL,1100,19,NULL,151),
 ('16#4921*2',33,NULL,NULL,1100,11,NULL,243),
 ('16#4922*2',266,NULL,NULL,1100,23,NULL,112),
 ('16#4923*3',100,NULL,NULL,800,8,NULL,90),
 ('16#4924*2',18,NULL,NULL,1100,11,NULL,247),
 ('16#4925*2',266,NULL,NULL,1100,24,NULL,109),
 ('16#4926*2',457,NULL,NULL,1100,50,NULL,29),
 ('16#4927*1',311,NULL,NULL,1100,31,NULL,68),
 ('16#4928*3',98,NULL,NULL,800,8,NULL,93),
 ('16#4929*3',84,NULL,NULL,800,8,NULL,102),
 ('16#4930*3',15,NULL,NULL,800,8,NULL,130),
 ('16#4931*3',109,NULL,NULL,800,9,NULL,73),
 ('16#4932*3',124,NULL,NULL,800,9,NULL,70),
 ('16#4933*3',139,NULL,NULL,800,9,NULL,66),
 ('16#4934*3',190,NULL,NULL,800,12,NULL,53),
 ('16#4936*3',0,NULL,NULL,600,6,NULL,138),
 ('16#4937*3',146,NULL,NULL,800,11,NULL,56),
 ('16#494*4',54,NULL,NULL,800,8,NULL,113),
 ('16#4940*3',296,NULL,NULL,800,30,NULL,11),
 ('16#4941*3',105,NULL,NULL,800,8,NULL,86),
 ('16#4942*3',0,NULL,NULL,600,6,NULL,138),
 ('16#4943*3',213,NULL,NULL,800,15,NULL,41),
 ('16#4944*3',108,NULL,NULL,800,8,NULL,84),
 ('16#4945*4',30,NULL,NULL,800,8,NULL,135),
 ('16#4946*4',64,NULL,NULL,800,8,NULL,101),
 ('16#4947*4',92,NULL,NULL,800,8,NULL,81),
 ('16#495*4',106,NULL,NULL,800,8,NULL,74),
 ('16#4950*4',116,NULL,NULL,800,8,NULL,72),
 ('16#4951*4',32,NULL,NULL,700,7,NULL,153),
 ('16#4953*4',98,NULL,NULL,800,8,NULL,78),
 ('16#4954*4',218,NULL,NULL,800,15,NULL,17),
 ('16#4955*2',426,NULL,NULL,1100,42,NULL,43),
 ('16#4957*2',287,NULL,NULL,1100,22,NULL,123),
 ('16#4958*1',50,NULL,NULL,1100,11,NULL,193),
 ('16#496*4',0,NULL,NULL,800,8,NULL,149),
 ('16#4960*1',74,NULL,NULL,1100,11,NULL,183),
 ('16#4962*1',52,NULL,NULL,1100,11,NULL,192),
 ('16#4963*4',0,NULL,NULL,500,5,NULL,155),
 ('16#4967*3',188,NULL,NULL,700,14,NULL,43),
 ('16#4968*3',66,NULL,NULL,700,7,NULL,137),
 ('16#4969*3',90,NULL,NULL,800,10,NULL,62),
 ('16#497*4',36,NULL,NULL,800,8,NULL,132),
 ('16#4970*3',137,NULL,NULL,700,8,NULL,75),
 ('16#4971*3',168,NULL,NULL,700,14,NULL,44),
 ('16#4976*1',120,NULL,NULL,1100,11,NULL,172),
 ('16#4977*1',561,NULL,NULL,1100,63,NULL,15),
 ('16#4978*1',352,NULL,NULL,1100,28,NULL,77),
 ('16#4979*1',378,NULL,NULL,1100,38,NULL,53),
 ('16#4980*1',457,NULL,NULL,1100,49,NULL,33),
 ('16#4981*1',194,NULL,NULL,1100,16,NULL,137),
 ('16#4982*2',141,NULL,NULL,1100,11,NULL,213),
 ('16#4983*2',328,NULL,NULL,1100,31,NULL,75),
 ('16#4984*2',170,NULL,NULL,1100,17,NULL,163),
 ('16#4985*2',317,NULL,NULL,1100,25,NULL,100),
 ('16#4986*2',168,NULL,NULL,1100,13,NULL,193),
 ('16#4987*2',181,NULL,NULL,1100,14,NULL,182),
 ('16#4988*1',280,NULL,NULL,1100,20,NULL,113),
 ('16#4989*1',340,NULL,NULL,1100,30,NULL,71),
 ('16#499*4',4,NULL,NULL,700,7,NULL,154),
 ('16#4990*1',82,NULL,NULL,1100,11,NULL,182),
 ('16#4991*1',51,NULL,NULL,1100,16,NULL,140),
 ('16#4992*1',207,NULL,NULL,1100,17,NULL,130),
 ('16#4995*4',3,NULL,NULL,200,2,NULL,157),
 ('16#5*2',246,NULL,NULL,1100,16,NULL,164),
 ('16#50*2',9,NULL,NULL,1100,11,NULL,249),
 ('16#500*4',204,NULL,NULL,800,17,NULL,14),
 ('16#501*4',73,NULL,NULL,800,8,NULL,98),
 ('16#503*4',106,NULL,NULL,800,9,NULL,60),
 ('16#504*4',40,NULL,NULL,800,8,NULL,129),
 ('16#505*4',164,NULL,NULL,800,11,NULL,33),
 ('16#506*4',80,NULL,NULL,800,8,NULL,92),
 ('16#507*4',117,NULL,NULL,800,8,NULL,71),
 ('16#509*4',1,NULL,NULL,800,8,NULL,148),
 ('16#51*2',300,NULL,NULL,1100,22,NULL,120),
 ('16#510*4',94,NULL,NULL,800,10,NULL,47),
 ('16#511*4',80,NULL,NULL,800,8,NULL,92),
 ('16#512*4',49,NULL,NULL,800,8,NULL,120),
 ('16#513*4',87,NULL,NULL,800,8,NULL,85),
 ('16#514*4',130,NULL,NULL,800,10,NULL,42),
 ('16#515*4',85,NULL,NULL,800,8,NULL,89),
 ('16#518*4',77,NULL,NULL,800,8,NULL,94),
 ('16#519*4',25,NULL,NULL,800,8,NULL,140),
 ('16#52*2',315,NULL,NULL,1100,27,NULL,89),
 ('16#520*4',208,NULL,NULL,800,16,NULL,15),
 ('16#521*4',65,NULL,NULL,800,8,NULL,100),
 ('16#522*4',44,NULL,NULL,800,8,NULL,127),
 ('16#523*4',166,NULL,NULL,800,11,NULL,32),
 ('16#524*4',53,NULL,NULL,800,8,NULL,116),
 ('16#525*4',138,NULL,NULL,800,13,NULL,27),
 ('16#526*4',146,NULL,NULL,800,11,NULL,35),
 ('16#527*4',99,NULL,NULL,800,9,NULL,64),
 ('16#528*4',124,NULL,NULL,800,9,NULL,54),
 ('16#529*4',124,NULL,NULL,800,9,NULL,54),
 ('16#53*2',391,NULL,NULL,1100,35,NULL,55),
 ('16#530*4',38,NULL,NULL,800,8,NULL,131),
 ('16#531*4',332,NULL,NULL,800,8,NULL,69),
 ('16#532*4',243,NULL,NULL,800,22,NULL,9),
 ('16#533*4',262,NULL,NULL,800,24,NULL,8),
 ('16#534*4',158,NULL,NULL,800,11,NULL,34),
 ('16#535*4',218,NULL,NULL,800,15,NULL,17),
 ('16#536*4',329,NULL,NULL,800,32,NULL,4),
 ('16#537*4',82,NULL,NULL,800,9,NULL,67),
 ('16#538*4',126,NULL,NULL,800,10,NULL,43),
 ('16#539*4',141,NULL,NULL,800,11,NULL,36),
 ('16#54*2',290,NULL,NULL,1100,22,NULL,122),
 ('16#541*4',28,NULL,NULL,800,8,NULL,137),
 ('16#542*4',0,NULL,NULL,800,8,NULL,149),
 ('16#543*4',88,NULL,NULL,800,8,NULL,83),
 ('16#544*4',166,NULL,NULL,800,13,NULL,26),
 ('16#546*4',54,NULL,NULL,800,8,NULL,113),
 ('16#547*4',404,NULL,NULL,800,47,NULL,1),
 ('16#548*4',64,NULL,NULL,800,8,NULL,101);
INSERT INTO `examsubreptkold` (`TmStCl`,`Mksr`,`grd`,`Remarks`,`outOfr`,`pnts`,`outOfp`,`pos`) VALUES 
 ('16#549*4',294,NULL,NULL,800,30,NULL,5),
 ('16#55*2',208,NULL,NULL,1100,16,NULL,167),
 ('16#550*4',94,NULL,NULL,800,9,NULL,65),
 ('16#551*4',62,NULL,NULL,800,8,NULL,105),
 ('16#553*4',94,NULL,NULL,800,8,NULL,80),
 ('16#554*4',141,NULL,NULL,800,9,NULL,51),
 ('16#556*4',148,NULL,NULL,800,8,NULL,70),
 ('16#557*4',123,NULL,NULL,800,9,NULL,56),
 ('16#558*4',40,NULL,NULL,800,8,NULL,129),
 ('16#559*4',181,NULL,NULL,800,13,NULL,24),
 ('16#56*2',39,NULL,NULL,1100,11,NULL,242),
 ('16#560*4',50,NULL,NULL,800,8,NULL,118),
 ('16#562*4',132,NULL,NULL,800,9,NULL,52),
 ('16#563*4',33,NULL,NULL,800,8,NULL,133),
 ('16#564*4',4,NULL,NULL,800,8,NULL,144),
 ('16#565*4',50,NULL,NULL,800,8,NULL,118),
 ('16#566*4',86,NULL,NULL,800,8,NULL,87),
 ('16#568*4',71,NULL,NULL,800,9,NULL,68),
 ('16#569*4',76,NULL,NULL,800,8,NULL,95),
 ('16#57*2',97,NULL,NULL,1100,11,NULL,220),
 ('16#570*4',82,NULL,NULL,800,8,NULL,91),
 ('16#571*4',57,NULL,NULL,800,8,NULL,109),
 ('16#572*4',125,NULL,NULL,800,10,NULL,44),
 ('16#574*4',46,NULL,NULL,800,8,NULL,125),
 ('16#575*4',44,NULL,NULL,800,8,NULL,127),
 ('16#577*4',84,NULL,NULL,800,8,NULL,90),
 ('16#58*2',323,NULL,NULL,1100,24,NULL,105),
 ('16#580*4',75,NULL,NULL,800,8,NULL,97),
 ('16#581*4',48,NULL,NULL,800,8,NULL,121),
 ('16#582*4',3,NULL,NULL,800,8,NULL,146),
 ('16#583*4',48,NULL,NULL,800,8,NULL,121),
 ('16#584*4',76,NULL,NULL,800,8,NULL,95),
 ('16#585*4',56,NULL,NULL,800,8,NULL,110),
 ('16#588*4',88,NULL,NULL,800,8,NULL,83),
 ('16#59*2',277,NULL,NULL,1100,21,NULL,129),
 ('16#590*4',56,NULL,NULL,800,8,NULL,110),
 ('16#592*4',98,NULL,NULL,800,8,NULL,78),
 ('16#593*4',153,NULL,NULL,800,9,NULL,50),
 ('16#594*4',170,NULL,NULL,800,12,NULL,28),
 ('16#596*4',196,NULL,NULL,800,16,NULL,16),
 ('16#597*4',220,NULL,NULL,800,18,NULL,13),
 ('16#599*4',14,NULL,NULL,800,8,NULL,142),
 ('16#6*2',57,NULL,NULL,1100,11,NULL,232),
 ('16#60*2',1,NULL,NULL,1100,11,NULL,251),
 ('16#600*4',104,NULL,NULL,800,9,NULL,61),
 ('16#601*4',106,NULL,NULL,800,8,NULL,74),
 ('16#602*4',137,NULL,NULL,800,12,NULL,29),
 ('16#605*4',344,NULL,NULL,800,35,NULL,3),
 ('16#606*4',30,NULL,NULL,800,8,NULL,135),
 ('16#607*4',165,NULL,NULL,800,15,NULL,20),
 ('16#608*4',304,NULL,NULL,800,26,NULL,7),
 ('16#61*2',399,NULL,NULL,1100,34,NULL,60),
 ('16#611*4',118,NULL,NULL,800,9,NULL,58),
 ('16#612*4',148,NULL,NULL,800,10,NULL,40),
 ('16#613*4',54,NULL,NULL,800,8,NULL,113),
 ('16#614*4',110,NULL,NULL,800,10,NULL,46),
 ('16#615*4',45,NULL,NULL,800,8,NULL,126),
 ('16#617*4',144,NULL,NULL,800,10,NULL,41),
 ('16#618*4',33,NULL,NULL,800,8,NULL,133),
 ('16#619*4',108,NULL,NULL,800,9,NULL,59),
 ('16#62*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#621*4',123,NULL,NULL,800,9,NULL,56),
 ('16#623*4',100,NULL,NULL,800,9,NULL,63),
 ('16#624*4',170,NULL,NULL,800,11,NULL,31),
 ('16#625*4',184,NULL,NULL,800,13,NULL,23),
 ('16#626*4',66,NULL,NULL,800,8,NULL,99),
 ('16#628*4',62,NULL,NULL,800,8,NULL,105),
 ('16#629*4',108,NULL,NULL,800,8,NULL,73),
 ('16#63*2',290,NULL,NULL,1100,20,NULL,133),
 ('16#630*4',60,NULL,NULL,800,8,NULL,107),
 ('16#631*4',156,NULL,NULL,800,9,NULL,49),
 ('16#632*4',86,NULL,NULL,800,8,NULL,87),
 ('16#633*4',225,NULL,NULL,800,19,NULL,11),
 ('16#634*4',282,NULL,NULL,800,29,NULL,6),
 ('16#635*4',126,NULL,NULL,800,11,NULL,37),
 ('16#636*4',87,NULL,NULL,800,8,NULL,85),
 ('16#637*4',48,NULL,NULL,800,8,NULL,121),
 ('16#639*4',162,NULL,NULL,800,10,NULL,39),
 ('16#64*2',195,NULL,NULL,1100,16,NULL,170),
 ('16#640*4',208,NULL,NULL,800,14,NULL,21),
 ('16#641*4',222,NULL,NULL,800,21,NULL,10),
 ('16#65*2',317,NULL,NULL,1100,26,NULL,93),
 ('16#66*2',343,NULL,NULL,1100,30,NULL,78),
 ('16#67*2',381,NULL,NULL,1100,36,NULL,53),
 ('16#68*2',283,NULL,NULL,1100,22,NULL,124),
 ('16#69*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#7*2',259,NULL,NULL,1100,21,NULL,131),
 ('16#70*2',406,NULL,NULL,1100,40,NULL,47),
 ('16#71*2',328,NULL,NULL,1100,27,NULL,88),
 ('16#72*2',338,NULL,NULL,1100,32,NULL,69),
 ('16#73*2',45,NULL,NULL,1100,11,NULL,238),
 ('16#74*2',422,NULL,NULL,1100,44,NULL,38),
 ('16#75*2',78,NULL,NULL,1100,11,NULL,225),
 ('16#76*2',251,NULL,NULL,1100,23,NULL,117),
 ('16#77*2',664,NULL,NULL,1100,85,NULL,2),
 ('16#78*2',120,NULL,NULL,1100,13,NULL,198),
 ('16#79*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#8*2',331,NULL,NULL,1100,32,NULL,71),
 ('16#80*2',522,NULL,NULL,1100,61,NULL,15),
 ('16#81*2',287,NULL,NULL,1100,20,NULL,134),
 ('16#82*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#83*2',391,NULL,NULL,1100,34,NULL,61),
 ('16#84*2',462,NULL,NULL,1100,46,NULL,34),
 ('16#85*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#86*2',296,NULL,NULL,1100,20,NULL,132),
 ('16#87*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#88*2',376,NULL,NULL,1100,35,NULL,57),
 ('16#89*2',312,NULL,NULL,1100,27,NULL,90),
 ('16#9*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#90*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#91*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#92*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#93*2',0,NULL,NULL,1100,11,NULL,253),
 ('16#94*2',142,NULL,NULL,1100,12,NULL,204),
 ('16#95*2',134,NULL,NULL,1100,13,NULL,197),
 ('16#96*2',502,NULL,NULL,1100,53,NULL,24),
 ('16#97*2',130,NULL,NULL,1100,12,NULL,207),
 ('16#98*2',296,NULL,NULL,1100,22,NULL,121),
 ('16#99*2',270,NULL,NULL,1100,22,NULL,125),
 ('17#1*2',109,NULL,NULL,1100,13,NULL,171),
 ('17#10*2',572,NULL,NULL,1100,67,NULL,4),
 ('17#100*2',173,NULL,NULL,1100,14,NULL,160),
 ('17#101*2',0,NULL,NULL,1100,11,NULL,256),
 ('17#102*2',145,NULL,NULL,1100,11,NULL,191),
 ('17#103*2',56,NULL,NULL,1100,11,NULL,217),
 ('17#104*2',82,NULL,NULL,1100,12,NULL,185),
 ('17#105*2',7,NULL,NULL,1100,11,NULL,247),
 ('17#106*2',0,NULL,NULL,1100,11,NULL,256),
 ('17#107*2',148,NULL,NULL,1100,12,NULL,177),
 ('17#11*2',494,NULL,NULL,1100,59,NULL,7),
 ('17#110*2',0,NULL,NULL,1100,11,NULL,256),
 ('17#111*2',33,NULL,NULL,1100,11,NULL,226),
 ('17#112*2',242,NULL,NULL,1100,17,NULL,121),
 ('17#113*2',174,NULL,NULL,1100,13,NULL,165),
 ('17#114*2',218,NULL,NULL,1100,17,NULL,126),
 ('17#115*2',74,NULL,NULL,1100,11,NULL,210),
 ('17#116*2',93,NULL,NULL,1100,11,NULL,206),
 ('17#118*2',70,NULL,NULL,1100,14,NULL,162),
 ('17#12*2',55,NULL,NULL,1100,11,NULL,219),
 ('17#120*2',162,NULL,NULL,1100,11,NULL,187),
 ('17#121*2',67,NULL,NULL,1100,11,NULL,213),
 ('17#123*2',341,NULL,NULL,1100,30,NULL,54),
 ('17#125*2',7,NULL,NULL,1100,11,NULL,247),
 ('17#126*2',183,NULL,NULL,1100,14,NULL,158),
 ('17#127*2',81,NULL,NULL,1100,12,NULL,186),
 ('17#128*2',264,NULL,NULL,1100,20,NULL,102),
 ('17#129*2',194,NULL,NULL,1100,14,NULL,155),
 ('17#13*2',0,NULL,NULL,1100,11,NULL,256),
 ('17#130*2',300,NULL,NULL,1100,25,NULL,73),
 ('17#131*2',264,NULL,NULL,1100,24,NULL,76),
 ('17#132*2',389,NULL,NULL,1100,34,NULL,40),
 ('17#133*2',356,NULL,NULL,1100,31,NULL,46),
 ('17#134*2',205,NULL,NULL,1100,17,NULL,129),
 ('17#135*2',14,NULL,NULL,1100,11,NULL,240),
 ('17#136*2',256,NULL,NULL,1100,19,NULL,108),
 ('17#137*2',471,NULL,NULL,1100,52,NULL,10),
 ('17#138*2',237,NULL,NULL,1100,14,NULL,149),
 ('17#139*2',141,NULL,NULL,1100,11,NULL,193),
 ('17#14*2',342,NULL,NULL,1100,29,NULL,57),
 ('17#140*2',264,NULL,NULL,1100,19,NULL,105),
 ('17#141*2',505,NULL,NULL,1100,58,NULL,8),
 ('17#142*2',209,NULL,NULL,1100,13,NULL,163),
 ('17#143*2',147,NULL,NULL,1100,11,NULL,190),
 ('17#144*2',209,NULL,NULL,1100,15,NULL,144),
 ('17#145*2',319,NULL,NULL,1100,31,NULL,51),
 ('17#146*2',3,NULL,NULL,1100,11,NULL,252),
 ('17#147*2',0,NULL,NULL,1100,11,NULL,256),
 ('17#149*2',191,NULL,NULL,1100,14,NULL,156),
 ('17#15*2',32,NULL,NULL,1100,11,NULL,227),
 ('17#150*2',304,NULL,NULL,1100,31,NULL,52),
 ('17#151*2',303,NULL,NULL,1100,21,NULL,90),
 ('17#154*2',259,NULL,NULL,1100,19,NULL,106),
 ('17#155*2',20,NULL,NULL,1100,11,NULL,235),
 ('17#156*2',16,NULL,NULL,1100,11,NULL,236),
 ('17#157*2',80,NULL,NULL,1100,11,NULL,208),
 ('17#158*2',263,NULL,NULL,1100,22,NULL,87),
 ('17#159*2',229,NULL,NULL,1100,16,NULL,135),
 ('17#16*2',100,NULL,NULL,1100,11,NULL,203),
 ('17#160*2',434,NULL,NULL,1100,42,NULL,19),
 ('17#161*2',0,NULL,NULL,1100,11,NULL,256),
 ('17#163*2',95,NULL,NULL,1100,11,NULL,205),
 ('17#164*2',371,NULL,NULL,1100,34,NULL,42),
 ('17#165*2',0,NULL,NULL,1100,11,NULL,256),
 ('17#166*2',0,NULL,NULL,1100,11,NULL,256),
 ('17#167*2',563,NULL,NULL,1100,69,NULL,3),
 ('17#168*2',35,NULL,NULL,1100,13,NULL,173),
 ('17#169*2',408,NULL,NULL,1100,41,NULL,21),
 ('17#17*2',382,NULL,NULL,1100,36,NULL,34),
 ('17#170*2',441,NULL,NULL,1100,46,NULL,15),
 ('17#171*2',0,NULL,NULL,1100,11,NULL,256),
 ('17#172*2',132,NULL,NULL,1100,12,NULL,180),
 ('17#173*2',7,NULL,NULL,1100,11,NULL,247),
 ('17#174*2',229,NULL,NULL,1100,14,NULL,150),
 ('17#175*2',193,NULL,NULL,1100,13,NULL,164),
 ('17#176*2',281,NULL,NULL,1100,28,NULL,63),
 ('17#177*2',40,NULL,NULL,1100,11,NULL,225),
 ('17#178*2',299,NULL,NULL,1100,22,NULL,85),
 ('17#179*2',384,NULL,NULL,1100,38,NULL,27),
 ('17#18*2',222,NULL,NULL,1100,12,NULL,174),
 ('17#180*2',0,NULL,NULL,1100,11,NULL,256),
 ('17#181*2',28,NULL,NULL,1100,11,NULL,228),
 ('17#182*2',169,NULL,NULL,1100,15,NULL,148),
 ('17#183*2',97,NULL,NULL,1100,11,NULL,204),
 ('17#184*2',193,NULL,NULL,1100,16,NULL,140),
 ('17#185*2',214,NULL,NULL,1100,16,NULL,136),
 ('17#187*2',114,NULL,NULL,1100,11,NULL,200),
 ('17#188*2',24,NULL,NULL,1100,11,NULL,231),
 ('17#189*2',342,NULL,NULL,1100,31,NULL,48),
 ('17#19*2',126,NULL,NULL,1100,11,NULL,195),
 ('17#190*2',151,NULL,NULL,1100,13,NULL,168),
 ('17#191*2',135,NULL,NULL,1100,11,NULL,194),
 ('17#192*2',271,NULL,NULL,1100,17,NULL,118),
 ('17#195*2',71,NULL,NULL,1100,11,NULL,211),
 ('17#196*2',124,NULL,NULL,1100,11,NULL,197),
 ('17#197*2',53,NULL,NULL,1100,11,NULL,221),
 ('17#198*2',209,NULL,NULL,1100,18,NULL,115),
 ('17#199*2',291,NULL,NULL,1100,23,NULL,81),
 ('17#2*2',439,NULL,NULL,1100,45,NULL,17),
 ('17#20*2',294,NULL,NULL,1100,23,NULL,80),
 ('17#200*2',373,NULL,NULL,1100,38,NULL,29),
 ('17#201*2',0,NULL,NULL,1100,11,NULL,256),
 ('17#202*2',110,NULL,NULL,1100,11,NULL,201),
 ('17#203*2',0,NULL,NULL,1100,11,NULL,256),
 ('17#204*2',308,NULL,NULL,1100,25,NULL,71),
 ('17#205*2',292,NULL,NULL,1100,26,NULL,67),
 ('17#206*2',133,NULL,NULL,1100,12,NULL,179),
 ('17#207*2',349,NULL,NULL,1100,30,NULL,53),
 ('17#208*2',394,NULL,NULL,1100,34,NULL,39),
 ('17#209*2',283,NULL,NULL,1100,23,NULL,82),
 ('17#21*2',371,NULL,NULL,1100,35,NULL,36),
 ('17#210*2',0,NULL,NULL,1100,11,NULL,256),
 ('17#211*2',64,NULL,NULL,1100,11,NULL,214),
 ('17#212*2',281,NULL,NULL,1100,23,NULL,83),
 ('17#213*2',152,NULL,NULL,1100,11,NULL,189),
 ('17#214*2',282,NULL,NULL,1100,21,NULL,92),
 ('17#215*2',53,NULL,NULL,1100,11,NULL,221),
 ('17#216*2',69,NULL,NULL,1100,11,NULL,212),
 ('17#217*2',377,NULL,NULL,1100,34,NULL,41),
 ('17#218*2',146,NULL,NULL,1100,12,NULL,178),
 ('17#219*2',298,NULL,NULL,1100,22,NULL,86),
 ('17#22*2',275,NULL,NULL,1100,25,NULL,74),
 ('17#220*2',0,NULL,NULL,1100,11,NULL,256),
 ('17#221*2',195,NULL,NULL,1100,15,NULL,146),
 ('17#222*2',103,NULL,NULL,1100,11,NULL,202),
 ('17#223*2',285,NULL,NULL,1100,21,NULL,91),
 ('17#224*2',441,NULL,NULL,1100,48,NULL,15),
 ('17#225*2',130,NULL,NULL,1100,12,NULL,182),
 ('17#226*2',135,NULL,NULL,1100,13,NULL,170),
 ('17#227*2',179,NULL,NULL,1100,14,NULL,159),
 ('17#228*2',254,NULL,NULL,1100,20,NULL,103),
 ('17#229*2',75,NULL,NULL,1100,11,NULL,209),
 ('17#23*2',120,NULL,NULL,1100,11,NULL,198),
 ('17#230*2',0,NULL,NULL,1100,11,NULL,256),
 ('17#231*2',301,NULL,NULL,1100,25,NULL,72),
 ('17#232*2',10,NULL,NULL,1100,11,NULL,242),
 ('17#233*2',125,NULL,NULL,1100,11,NULL,196),
 ('17#234*2',210,NULL,NULL,1100,19,NULL,114),
 ('17#236*2',320,NULL,NULL,1100,27,NULL,64),
 ('17#237*2',15,NULL,NULL,1100,11,NULL,239),
 ('17#238*2',387,NULL,NULL,1100,37,NULL,32),
 ('17#239*2',259,NULL,NULL,1100,19,NULL,106),
 ('17#24*2',212,NULL,NULL,1100,16,NULL,137),
 ('17#240*2',328,NULL,NULL,1100,28,NULL,62),
 ('17#241*2',493,NULL,NULL,1100,55,NULL,9),
 ('17#242*2',303,NULL,NULL,1100,23,NULL,78),
 ('17#243*2',160,NULL,NULL,1100,11,NULL,188),
 ('17#244*2',3,NULL,NULL,1100,11,NULL,252),
 ('17#245*2',8,NULL,NULL,1100,11,NULL,245),
 ('17#246*2',10,NULL,NULL,1100,11,NULL,242),
 ('17#247*2',0,NULL,NULL,1100,11,NULL,256),
 ('17#248*2',172,NULL,NULL,1100,12,NULL,176),
 ('17#249*2',201,NULL,NULL,1100,15,NULL,145),
 ('17#25*2',224,NULL,NULL,1100,19,NULL,113),
 ('17#250*2',123,NULL,NULL,1100,12,NULL,183),
 ('17#251*2',340,NULL,NULL,1100,31,NULL,49),
 ('17#252*2',247,NULL,NULL,1100,17,NULL,120),
 ('17#253*2',217,NULL,NULL,1100,17,NULL,127),
 ('17#254*2',251,NULL,NULL,1100,19,NULL,109),
 ('17#255*2',219,NULL,NULL,1100,14,NULL,152),
 ('17#256*2',260,NULL,NULL,1100,16,NULL,131),
 ('17#257*2',56,NULL,NULL,1100,11,NULL,217),
 ('17#258*2',355,NULL,NULL,1100,35,NULL,37),
 ('17#259*2',317,NULL,NULL,1100,25,NULL,69),
 ('17#26*2',459,NULL,NULL,1100,48,NULL,13),
 ('17#260*2',349,NULL,NULL,1100,29,NULL,56),
 ('17#261*2',288,NULL,NULL,1100,20,NULL,98),
 ('17#262*2',145,NULL,NULL,1100,13,NULL,169),
 ('17#263*2',268,NULL,NULL,1100,20,NULL,100),
 ('17#264*2',286,NULL,NULL,1100,24,NULL,75),
 ('17#265*2',529,NULL,NULL,1100,62,NULL,6),
 ('17#266*2',188,NULL,NULL,1100,16,NULL,141),
 ('17#267*2',234,NULL,NULL,1100,15,NULL,143),
 ('17#268*2',402,NULL,NULL,1100,38,NULL,24),
 ('17#269*2',559,NULL,NULL,1100,65,NULL,5),
 ('17#27*2',586,NULL,NULL,1100,72,NULL,2),
 ('17#270*2',231,NULL,NULL,1100,16,NULL,134),
 ('17#271*2',255,NULL,NULL,1100,21,NULL,93),
 ('17#272*2',195,NULL,NULL,1100,16,NULL,139),
 ('17#273*2',3,NULL,NULL,1100,11,NULL,252),
 ('17#274*2',189,NULL,NULL,1100,14,NULL,157),
 ('17#275*2',22,NULL,NULL,1100,11,NULL,232),
 ('17#276*2',42,NULL,NULL,1100,11,NULL,224),
 ('17#277*2',309,NULL,NULL,1100,29,NULL,60),
 ('17#278*2',146,NULL,NULL,1100,16,NULL,142),
 ('17#279*3',175,NULL,NULL,800,17,NULL,78),
 ('17#28*2',265,NULL,NULL,1100,23,NULL,84),
 ('17#280*3',0,NULL,NULL,400,4,NULL,201),
 ('17#281*3',409,NULL,NULL,800,46,NULL,9),
 ('17#282*3',21,NULL,NULL,800,8,NULL,156),
 ('17#283*3',328,NULL,NULL,800,31,NULL,40),
 ('17#284*3',460,NULL,NULL,800,58,NULL,5),
 ('17#285*3',7,NULL,NULL,400,4,NULL,198),
 ('17#286*3',246,NULL,NULL,800,23,NULL,58),
 ('17#287*3',291,NULL,NULL,800,30,NULL,42),
 ('17#288*3',0,NULL,NULL,400,4,NULL,201),
 ('17#289*3',0,NULL,NULL,400,4,NULL,201),
 ('17#29*2',0,NULL,NULL,1100,11,NULL,256),
 ('17#290*3',69,NULL,NULL,800,11,NULL,130),
 ('17#291*3',3,NULL,NULL,800,8,NULL,159),
 ('17#292*3',355,NULL,NULL,800,41,NULL,18),
 ('17#293*3',57,NULL,NULL,800,8,NULL,147),
 ('17#294*3',0,NULL,NULL,400,4,NULL,201),
 ('17#295*3',0,NULL,NULL,800,8,NULL,160),
 ('17#296*3',0,NULL,NULL,800,8,NULL,160),
 ('17#297*3',0,NULL,NULL,400,4,NULL,201),
 ('17#298*3',3,NULL,NULL,600,6,NULL,171),
 ('17#299*3',372,NULL,NULL,800,46,NULL,10),
 ('17#3*2',231,NULL,NULL,1100,19,NULL,111),
 ('17#30*2',0,NULL,NULL,1100,11,NULL,256),
 ('17#300*3',235,NULL,NULL,800,24,NULL,57),
 ('17#301*3',191,NULL,NULL,800,18,NULL,72),
 ('17#302*3',8,NULL,NULL,600,6,NULL,169),
 ('17#303*3',324,NULL,NULL,800,37,NULL,26),
 ('17#304*3',44,NULL,NULL,800,8,NULL,151),
 ('17#305*3',313,NULL,NULL,800,34,NULL,36),
 ('17#306*3',217,NULL,NULL,800,21,NULL,61),
 ('17#307*3',191,NULL,NULL,800,16,NULL,84),
 ('17#308*3',35,NULL,NULL,400,6,NULL,167),
 ('17#309*3',121,NULL,NULL,800,14,NULL,104),
 ('17#31*2',234,NULL,NULL,1100,17,NULL,123),
 ('17#310*3',2,NULL,NULL,400,4,NULL,200),
 ('17#311*3',66,NULL,NULL,800,10,NULL,136),
 ('17#312*3',75,NULL,NULL,800,8,NULL,145),
 ('17#313*3',129,NULL,NULL,800,11,NULL,124),
 ('17#314*3',151,NULL,NULL,800,11,NULL,122),
 ('17#315*3',117,NULL,NULL,800,10,NULL,133),
 ('17#316*3',15,NULL,NULL,400,4,NULL,196),
 ('17#317*3',318,NULL,NULL,800,31,NULL,41),
 ('17#318*3',92,NULL,NULL,800,11,NULL,129),
 ('17#319*3',15,NULL,NULL,400,4,NULL,196),
 ('17#32*2',145,NULL,NULL,1100,11,NULL,191),
 ('17#320*3',249,NULL,NULL,800,20,NULL,63),
 ('17#321*3',159,NULL,NULL,800,17,NULL,79),
 ('17#322*3',6,NULL,NULL,800,8,NULL,158),
 ('17#323*3',201,NULL,NULL,800,19,NULL,65),
 ('17#324*3',129,NULL,NULL,800,15,NULL,94),
 ('17#325*3',0,NULL,NULL,400,4,NULL,201),
 ('17#326*3',0,NULL,NULL,400,4,NULL,201),
 ('17#327*3',208,NULL,NULL,800,16,NULL,81),
 ('17#328*3',181,NULL,NULL,800,16,NULL,85),
 ('17#329*3',300,NULL,NULL,800,33,NULL,38),
 ('17#33*2',196,NULL,NULL,1100,18,NULL,116),
 ('17#330*3',182,NULL,NULL,800,17,NULL,77),
 ('17#331*3',165,NULL,NULL,800,12,NULL,112),
 ('17#332*3',274,NULL,NULL,800,28,NULL,48),
 ('17#333*3',291,NULL,NULL,800,30,NULL,42),
 ('17#334*3',108,NULL,NULL,800,12,NULL,119),
 ('17#335*3',99,NULL,NULL,800,11,NULL,128),
 ('17#336*3',2,NULL,NULL,500,5,NULL,184),
 ('17#337*3',0,NULL,NULL,500,5,NULL,186),
 ('17#338*3',118,NULL,NULL,800,14,NULL,105),
 ('17#339*3',162,NULL,NULL,800,18,NULL,76),
 ('17#34*2',140,NULL,NULL,1100,14,NULL,161),
 ('17#340*3',0,NULL,NULL,400,4,NULL,201),
 ('17#341*3',326,NULL,NULL,800,39,NULL,24),
 ('17#342*3',173,NULL,NULL,800,14,NULL,96),
 ('17#343*3',247,NULL,NULL,800,27,NULL,52),
 ('17#344*3',297,NULL,NULL,800,28,NULL,47),
 ('17#345*3',329,NULL,NULL,800,36,NULL,30),
 ('17#346*3',316,NULL,NULL,800,35,NULL,34),
 ('17#348*3',21,NULL,NULL,500,5,NULL,182),
 ('17#349*3',24,NULL,NULL,800,8,NULL,154),
 ('17#35*2',266,NULL,NULL,1100,20,NULL,101),
 ('17#350*3',192,NULL,NULL,800,15,NULL,88),
 ('17#351*3',76,NULL,NULL,800,8,NULL,144),
 ('17#352*3',154,NULL,NULL,800,14,NULL,99),
 ('17#353*3',344,NULL,NULL,800,36,NULL,29),
 ('17#354*3',323,NULL,NULL,800,37,NULL,27),
 ('17#355*3',323,NULL,NULL,800,35,NULL,33),
 ('17#356*3',0,NULL,NULL,400,4,NULL,201),
 ('17#357*3',0,NULL,NULL,400,4,NULL,201),
 ('17#358*3',558,NULL,NULL,800,75,NULL,2),
 ('17#359*3',379,NULL,NULL,800,44,NULL,13),
 ('17#36*2',120,NULL,NULL,1100,11,NULL,198),
 ('17#360*3',0,NULL,NULL,600,6,NULL,172),
 ('17#361*3',0,NULL,NULL,700,7,NULL,160),
 ('17#362*3',0,NULL,NULL,400,4,NULL,201),
 ('17#363*3',48,NULL,NULL,600,6,NULL,168),
 ('17#364*3',175,NULL,NULL,800,15,NULL,89),
 ('17#365*3',172,NULL,NULL,800,14,NULL,97),
 ('17#366*3',202,NULL,NULL,800,18,NULL,70),
 ('17#367*3',100,NULL,NULL,800,11,NULL,127),
 ('17#368*3',140,NULL,NULL,800,11,NULL,123),
 ('17#369*3',150,NULL,NULL,800,15,NULL,93),
 ('17#37*2',25,NULL,NULL,1100,11,NULL,229),
 ('17#370*3',158,NULL,NULL,800,13,NULL,106),
 ('17#371*3',0,NULL,NULL,600,6,NULL,172),
 ('17#372*3',84,NULL,NULL,800,12,NULL,120),
 ('17#373*3',326,NULL,NULL,800,40,NULL,21),
 ('17#374*3',339,NULL,NULL,800,40,NULL,20),
 ('17#375*3',0,NULL,NULL,600,6,NULL,172),
 ('17#376*3',206,NULL,NULL,800,19,NULL,64),
 ('17#377*3',148,NULL,NULL,800,14,NULL,100),
 ('17#378*3',444,NULL,NULL,800,53,NULL,8),
 ('17#379*3',194,NULL,NULL,800,19,NULL,66),
 ('17#38*2',312,NULL,NULL,1100,26,NULL,66),
 ('17#380*3',267,NULL,NULL,800,29,NULL,45),
 ('17#381*3',124,NULL,NULL,800,12,NULL,118),
 ('17#382*3',153,NULL,NULL,800,12,NULL,113),
 ('17#383*3',350,NULL,NULL,800,42,NULL,17),
 ('17#384*3',456,NULL,NULL,800,58,NULL,6),
 ('17#385*3',123,NULL,NULL,800,11,NULL,125),
 ('17#386*3',309,NULL,NULL,800,34,NULL,37),
 ('17#387*3',500,NULL,NULL,800,64,NULL,4),
 ('17#388*3',2,NULL,NULL,500,5,NULL,184),
 ('17#389*3',127,NULL,NULL,800,12,NULL,116),
 ('17#39*2',260,NULL,NULL,1100,17,NULL,119),
 ('17#390*3',158,NULL,NULL,800,13,NULL,106),
 ('17#391*3',136,NULL,NULL,800,12,NULL,115),
 ('17#392*3',17,NULL,NULL,800,8,NULL,157),
 ('17#393*3',0,NULL,NULL,600,6,NULL,172),
 ('17#394*3',120,NULL,NULL,800,9,NULL,138),
 ('17#395*3',125,NULL,NULL,800,12,NULL,117),
 ('17#396*3',192,NULL,NULL,800,16,NULL,83),
 ('17#397*3',0,NULL,NULL,600,6,NULL,172),
 ('17#398*3',329,NULL,NULL,800,39,NULL,22),
 ('17#399*3',240,NULL,NULL,800,26,NULL,53),
 ('17#4*2',242,NULL,NULL,1100,17,NULL,121),
 ('17#40*2',0,NULL,NULL,1100,11,NULL,256),
 ('17#400*3',86,NULL,NULL,800,8,NULL,143),
 ('17#401*3',171,NULL,NULL,800,18,NULL,75),
 ('17#402*3',0,NULL,NULL,500,5,NULL,186),
 ('17#403*3',117,NULL,NULL,800,13,NULL,111),
 ('17#404*3',225,NULL,NULL,800,22,NULL,59),
 ('17#405*3',0,NULL,NULL,800,8,NULL,160),
 ('17#406*3',207,NULL,NULL,800,21,NULL,62),
 ('17#407*3',91,NULL,NULL,800,10,NULL,134),
 ('17#408*3',0,NULL,NULL,600,6,NULL,172),
 ('17#409*3',0,NULL,NULL,800,8,NULL,160),
 ('17#41*2',355,NULL,NULL,1100,32,NULL,45),
 ('17#410*3',168,NULL,NULL,800,15,NULL,92),
 ('17#411*3',0,NULL,NULL,500,5,NULL,186),
 ('17#412*3',0,NULL,NULL,500,5,NULL,186),
 ('17#413*3',0,NULL,NULL,500,5,NULL,186),
 ('17#414*3',187,NULL,NULL,800,18,NULL,73),
 ('17#415*3',74,NULL,NULL,800,9,NULL,139),
 ('17#416*3',49,NULL,NULL,800,8,NULL,148),
 ('17#417*3',358,NULL,NULL,800,42,NULL,15),
 ('17#418*3',327,NULL,NULL,800,41,NULL,19),
 ('17#419*3',265,NULL,NULL,800,27,NULL,50),
 ('17#42*2',211,NULL,NULL,1100,17,NULL,128),
 ('17#420*3',44,NULL,NULL,800,8,NULL,151),
 ('17#421*3',177,NULL,NULL,800,16,NULL,86),
 ('17#422*3',601,NULL,NULL,800,82,NULL,1),
 ('17#423*3',4,NULL,NULL,500,5,NULL,183),
 ('17#424*3',192,NULL,NULL,800,18,NULL,71),
 ('17#425*3',321,NULL,NULL,800,36,NULL,31),
 ('17#426*3',125,NULL,NULL,800,14,NULL,103),
 ('17#427*3',259,NULL,NULL,800,28,NULL,49),
 ('17#428*3',96,NULL,NULL,800,8,NULL,141),
 ('17#429*3',130,NULL,NULL,800,13,NULL,110),
 ('17#43*2',251,NULL,NULL,1100,24,NULL,77),
 ('17#430*3',370,NULL,NULL,800,46,NULL,11),
 ('17#431*3',0,NULL,NULL,800,8,NULL,160),
 ('17#432*3',48,NULL,NULL,800,8,NULL,150),
 ('17#433*3',277,NULL,NULL,800,32,NULL,39),
 ('17#434*3',256,NULL,NULL,800,27,NULL,51),
 ('17#435*3',52,NULL,NULL,800,12,NULL,121),
 ('17#436*3',351,NULL,NULL,800,42,NULL,16),
 ('17#437*3',368,NULL,NULL,800,43,NULL,14),
 ('17#438*3',172,NULL,NULL,800,18,NULL,74),
 ('17#439*3',175,NULL,NULL,800,15,NULL,89),
 ('17#44*2',423,NULL,NULL,1100,41,NULL,20),
 ('17#440*3',151,NULL,NULL,800,16,NULL,87),
 ('17#441*3',133,NULL,NULL,800,14,NULL,102),
 ('17#442*3',140,NULL,NULL,800,14,NULL,101),
 ('17#443*3',24,NULL,NULL,800,8,NULL,154),
 ('17#444*3',63,NULL,NULL,800,8,NULL,146),
 ('17#445*3',530,NULL,NULL,800,69,NULL,3),
 ('17#446*3',189,NULL,NULL,800,19,NULL,68),
 ('17#447*3',192,NULL,NULL,800,19,NULL,67),
 ('17#448*3',0,NULL,NULL,600,6,NULL,172),
 ('17#449*3',328,NULL,NULL,800,39,NULL,23),
 ('17#45*2',208,NULL,NULL,1100,16,NULL,138),
 ('17#450*3',441,NULL,NULL,800,56,NULL,7),
 ('17#451*3',263,NULL,NULL,800,30,NULL,44),
 ('17#46*2',132,NULL,NULL,1100,12,NULL,180),
 ('17#47*2',471,NULL,NULL,1100,50,NULL,10),
 ('17#4700*3',127,NULL,NULL,800,10,NULL,132),
 ('17#4701*3',87,NULL,NULL,800,8,NULL,142),
 ('17#4702*3',0,NULL,NULL,600,6,NULL,172),
 ('17#4715*3',3,NULL,NULL,400,4,NULL,199),
 ('17#4721*2',320,NULL,NULL,1100,27,NULL,64),
 ('17#4722*3',289,NULL,NULL,600,35,NULL,32),
 ('17#4723*3',88,NULL,NULL,800,10,NULL,135),
 ('17#4724*3',163,NULL,NULL,800,14,NULL,98),
 ('17#4726*1',106,NULL,NULL,1100,20,NULL,110),
 ('17#4727*1',487,NULL,NULL,1100,49,NULL,19),
 ('17#4728*1',229,NULL,NULL,1100,20,NULL,103),
 ('17#4729*1',159,NULL,NULL,1100,14,NULL,154),
 ('17#4730*1',13,NULL,NULL,1100,11,NULL,191),
 ('17#4731*1',406,NULL,NULL,1100,43,NULL,29),
 ('17#4732*1',76,NULL,NULL,1100,11,NULL,175),
 ('17#4733*1',464,NULL,NULL,1100,50,NULL,18),
 ('17#4734*1',609,NULL,NULL,1100,74,NULL,4),
 ('17#4735*1',787,NULL,NULL,1100,109,NULL,1),
 ('17#4736*1',144,NULL,NULL,1100,15,NULL,147),
 ('17#4737*1',230,NULL,NULL,1100,20,NULL,102),
 ('17#4738*1',479,NULL,NULL,1100,50,NULL,17),
 ('17#4739*1',297,NULL,NULL,1100,24,NULL,82),
 ('17#4740*1',301,NULL,NULL,1100,26,NULL,70),
 ('17#4741*1',111,NULL,NULL,1100,12,NULL,165),
 ('17#4742*1',589,NULL,NULL,1100,70,NULL,6),
 ('17#4743*1',0,NULL,NULL,1100,11,NULL,199),
 ('17#4744*1',94,NULL,NULL,1100,13,NULL,160),
 ('17#4745*1',76,NULL,NULL,1100,11,NULL,175),
 ('17#4746*1',347,NULL,NULL,1100,30,NULL,51),
 ('17#4747*1',507,NULL,NULL,1100,54,NULL,13),
 ('17#4748*1',298,NULL,NULL,1100,25,NULL,76),
 ('17#4749*1',257,NULL,NULL,1100,20,NULL,99),
 ('17#4750*1',158,NULL,NULL,1100,16,NULL,139),
 ('17#4751*1',253,NULL,NULL,1100,19,NULL,113),
 ('17#4752*1',86,NULL,NULL,1100,11,NULL,171),
 ('17#4753*1',446,NULL,NULL,1100,46,NULL,26),
 ('17#4754*1',213,NULL,NULL,1100,18,NULL,124),
 ('17#4755*1',581,NULL,NULL,1100,68,NULL,7),
 ('17#4756*1',376,NULL,NULL,1100,42,NULL,30),
 ('17#4757*1',456,NULL,NULL,1100,45,NULL,28),
 ('17#4758*1',328,NULL,NULL,1100,29,NULL,56),
 ('17#4759*1',1,NULL,NULL,1100,11,NULL,197),
 ('17#4760*1',84,NULL,NULL,1100,11,NULL,173),
 ('17#4761*1',4,NULL,NULL,1100,11,NULL,195),
 ('17#4762*1',367,NULL,NULL,1100,36,NULL,37),
 ('17#4763*1',332,NULL,NULL,1100,30,NULL,53),
 ('17#4764*1',133,NULL,NULL,1100,11,NULL,169),
 ('17#4765*1',208,NULL,NULL,1100,15,NULL,143),
 ('17#4766*1',737,NULL,NULL,1100,98,NULL,2),
 ('17#4767*1',171,NULL,NULL,1100,16,NULL,138),
 ('17#4768*1',176,NULL,NULL,1100,17,NULL,133),
 ('17#4769*1',6,NULL,NULL,1100,11,NULL,194),
 ('17#4770*1',571,NULL,NULL,1100,65,NULL,9),
 ('17#4771*1',2,NULL,NULL,1100,11,NULL,196),
 ('17#4772*1',160,NULL,NULL,1100,20,NULL,109),
 ('17#4773*1',148,NULL,NULL,1100,14,NULL,155),
 ('17#4774*1',48,NULL,NULL,1100,11,NULL,182),
 ('17#4775*1',360,NULL,NULL,1100,35,NULL,44),
 ('17#4776*1',538,NULL,NULL,1100,59,NULL,11),
 ('17#4777*1',495,NULL,NULL,1100,55,NULL,12),
 ('17#4778*1',429,NULL,NULL,1100,47,NULL,24),
 ('17#4779*1',164,NULL,NULL,1100,15,NULL,145),
 ('17#4780*1',361,NULL,NULL,1100,36,NULL,38),
 ('17#4781*1',266,NULL,NULL,1100,21,NULL,92),
 ('17#4782*1',214,NULL,NULL,1100,20,NULL,106),
 ('17#4783*1',170,NULL,NULL,1100,19,NULL,122),
 ('17#4784*1',216,NULL,NULL,1100,18,NULL,123),
 ('17#4785*1',191,NULL,NULL,1100,20,NULL,108),
 ('17#4786*1',111,NULL,NULL,1100,16,NULL,142),
 ('17#4787*1',29,NULL,NULL,1100,11,NULL,188),
 ('17#4788*1',1,NULL,NULL,1100,11,NULL,197),
 ('17#4789*1',229,NULL,NULL,1100,22,NULL,91),
 ('17#4790*1',184,NULL,NULL,1100,21,NULL,97),
 ('17#4791*1',193,NULL,NULL,1100,19,NULL,119),
 ('17#4792*1',314,NULL,NULL,1100,25,NULL,74),
 ('17#4793*1',43,NULL,NULL,1100,11,NULL,184),
 ('17#4794*1',136,NULL,NULL,1100,13,NULL,159),
 ('17#4795*1',56,NULL,NULL,1100,11,NULL,179),
 ('17#4796*1',106,NULL,NULL,1100,11,NULL,170),
 ('17#4797*1',217,NULL,NULL,1100,14,NULL,151),
 ('17#4798*1',206,NULL,NULL,1100,19,NULL,118),
 ('17#4799*1',255,NULL,NULL,1100,21,NULL,94),
 ('17#48*2',402,NULL,NULL,1100,39,NULL,24),
 ('17#4800*1',226,NULL,NULL,1100,20,NULL,104),
 ('17#4801*1',329,NULL,NULL,1100,26,NULL,68),
 ('17#4802*1',0,NULL,NULL,1100,11,NULL,199),
 ('17#4803*1',230,NULL,NULL,1100,23,NULL,87),
 ('17#4804*1',388,NULL,NULL,1100,33,NULL,48),
 ('17#4805*1',140,NULL,NULL,1100,17,NULL,136),
 ('17#4806*1',227,NULL,NULL,1100,19,NULL,116),
 ('17#4807*1',0,NULL,NULL,1100,11,NULL,199),
 ('17#4808*1',118,NULL,NULL,1100,14,NULL,156),
 ('17#4809*1',82,NULL,NULL,1100,11,NULL,174),
 ('17#4810*1',259,NULL,NULL,1100,26,NULL,73),
 ('17#4811*1',262,NULL,NULL,1100,21,NULL,93),
 ('17#4812*1',137,NULL,NULL,1100,15,NULL,150),
 ('17#4813*1',194,NULL,NULL,1100,18,NULL,125),
 ('17#4814*1',158,NULL,NULL,1100,12,NULL,163),
 ('17#4815*1',62,NULL,NULL,1100,13,NULL,161),
 ('17#4816*1',131,NULL,NULL,1100,16,NULL,140),
 ('17#4817*1',156,NULL,NULL,1100,18,NULL,127),
 ('17#4818*1',297,NULL,NULL,1100,28,NULL,61),
 ('17#4819*1',144,NULL,NULL,1100,15,NULL,147),
 ('17#4820*1',231,NULL,NULL,1100,19,NULL,114),
 ('17#4821*1',275,NULL,NULL,1100,23,NULL,85),
 ('17#4822*1',303,NULL,NULL,1100,30,NULL,54),
 ('17#4823*1',144,NULL,NULL,1100,15,NULL,147),
 ('17#4824*1',283,NULL,NULL,1100,26,NULL,71),
 ('17#4825*1',266,NULL,NULL,1100,27,NULL,67),
 ('17#4826*1',176,NULL,NULL,1100,17,NULL,133),
 ('17#4827*1',242,NULL,NULL,1100,21,NULL,96),
 ('17#4828*1',282,NULL,NULL,1100,27,NULL,63),
 ('17#4829*1',128,NULL,NULL,1100,16,NULL,141),
 ('17#4830*1',243,NULL,NULL,1100,25,NULL,81),
 ('17#4831*1',104,NULL,NULL,1100,12,NULL,167),
 ('17#4832*1',329,NULL,NULL,1100,28,NULL,58),
 ('17#4833*1',383,NULL,NULL,1100,35,NULL,43),
 ('17#4834*1',281,NULL,NULL,1100,27,NULL,65),
 ('17#4835*1',105,NULL,NULL,1100,12,NULL,166),
 ('17#4836*1',266,NULL,NULL,1100,19,NULL,112),
 ('17#4837*1',87,NULL,NULL,1100,12,NULL,168),
 ('17#4838*1',229,NULL,NULL,1100,19,NULL,115),
 ('17#4839*1',53,NULL,NULL,1100,11,NULL,181),
 ('17#4840*1',407,NULL,NULL,1100,37,NULL,35),
 ('17#4841*1',43,NULL,NULL,1100,11,NULL,184),
 ('17#4842*1',165,NULL,NULL,1100,17,NULL,135),
 ('17#4843*1',346,NULL,NULL,1100,27,NULL,62),
 ('17#4844*1',174,NULL,NULL,1100,19,NULL,121),
 ('17#4845*1',7,NULL,NULL,1100,11,NULL,193),
 ('17#4846*1',250,NULL,NULL,1100,25,NULL,79),
 ('17#4847*1',354,NULL,NULL,1100,32,NULL,49),
 ('17#4848*1',147,NULL,NULL,1100,15,NULL,146),
 ('17#4849*1',54,NULL,NULL,1100,11,NULL,180),
 ('17#4850*1',46,NULL,NULL,1100,11,NULL,183),
 ('17#4851*1',277,NULL,NULL,1100,19,NULL,111),
 ('17#4852*1',59,NULL,NULL,1100,11,NULL,178),
 ('17#4853*1',186,NULL,NULL,1100,19,NULL,120),
 ('17#4854*1',438,NULL,NULL,1100,40,NULL,31),
 ('17#4855*1',199,NULL,NULL,1100,17,NULL,131),
 ('17#4856*1',245,NULL,NULL,1100,25,NULL,80),
 ('17#4857*1',136,NULL,NULL,1100,17,NULL,137),
 ('17#4858*1',0,NULL,NULL,1100,11,NULL,199),
 ('17#4859*1',405,NULL,NULL,1100,35,NULL,42),
 ('17#4860*1',248,NULL,NULL,1100,22,NULL,90),
 ('17#4861*1',171,NULL,NULL,1100,15,NULL,144),
 ('17#4862*1',193,NULL,NULL,1100,18,NULL,126),
 ('17#4863*1',431,NULL,NULL,1100,46,NULL,27),
 ('17#4864*1',258,NULL,NULL,1100,20,NULL,98),
 ('17#4865*1',325,NULL,NULL,1100,28,NULL,59),
 ('17#4866*1',330,NULL,NULL,1100,29,NULL,55),
 ('17#4867*1',447,NULL,NULL,1100,46,NULL,25),
 ('17#4868*1',275,NULL,NULL,1100,27,NULL,66),
 ('17#4869*1',222,NULL,NULL,1100,20,NULL,105),
 ('17#4870*1',346,NULL,NULL,1100,30,NULL,52),
 ('17#4871*1',0,NULL,NULL,1100,11,NULL,199),
 ('17#4872*1',237,NULL,NULL,1100,20,NULL,101),
 ('17#4873*1',551,NULL,NULL,1100,67,NULL,8),
 ('17#4874*1',35,NULL,NULL,1100,13,NULL,162),
 ('17#4875*1',148,NULL,NULL,1100,18,NULL,128),
 ('17#4876*1',197,NULL,NULL,1100,13,NULL,157),
 ('17#4877*1',344,NULL,NULL,1100,36,NULL,41),
 ('17#4878*1',240,NULL,NULL,1100,20,NULL,100),
 ('17#4879*1',86,NULL,NULL,1100,11,NULL,171),
 ('17#4880*1',222,NULL,NULL,1100,19,NULL,117),
 ('17#4881*1',206,NULL,NULL,1100,17,NULL,130),
 ('17#4882*1',565,NULL,NULL,1100,63,NULL,10),
 ('17#4883*1',42,NULL,NULL,1100,11,NULL,186),
 ('17#4884*1',457,NULL,NULL,1100,49,NULL,21),
 ('17#4885*1',8,NULL,NULL,1100,11,NULL,192),
 ('17#4886*1',352,NULL,NULL,1100,36,NULL,40),
 ('17#4887*1',265,NULL,NULL,1100,22,NULL,88),
 ('17#4888*1',256,NULL,NULL,1100,22,NULL,89),
 ('17#4889*1',0,NULL,NULL,1100,11,NULL,199),
 ('17#4890*1',721,NULL,NULL,1100,95,NULL,3),
 ('17#4891*1',361,NULL,NULL,1100,36,NULL,38),
 ('17#4892*1',280,NULL,NULL,1100,26,NULL,72),
 ('17#4893*1',149,NULL,NULL,1100,12,NULL,164),
 ('17#4894*1',494,NULL,NULL,1100,51,NULL,16),
 ('17#4895*1',390,NULL,NULL,1100,36,NULL,36),
 ('17#4896*1',0,NULL,NULL,1100,11,NULL,199),
 ('17#4897*1',188,NULL,NULL,1100,14,NULL,152),
 ('17#4898*1',317,NULL,NULL,1100,29,NULL,57),
 ('17#4899*1',593,NULL,NULL,1100,71,NULL,5),
 ('17#49*2',0,NULL,NULL,1100,11,NULL,256),
 ('17#4900*1',308,NULL,NULL,1100,26,NULL,69),
 ('17#4901*1',493,NULL,NULL,1100,52,NULL,15),
 ('17#4902*1',213,NULL,NULL,1100,20,NULL,107),
 ('17#4903*1',305,NULL,NULL,1100,31,NULL,50),
 ('17#4904*1',217,NULL,NULL,1100,17,NULL,129),
 ('17#4905*1',309,NULL,NULL,1100,28,NULL,60),
 ('17#4906*1',413,NULL,NULL,1100,39,NULL,33),
 ('17#4907*1',414,NULL,NULL,1100,38,NULL,34),
 ('17#4908*1',475,NULL,NULL,1100,49,NULL,20),
 ('17#4909*1',324,NULL,NULL,1100,34,NULL,47),
 ('17#4910*1',270,NULL,NULL,1100,25,NULL,78),
 ('17#4911*1',344,NULL,NULL,1100,34,NULL,45),
 ('17#4912*1',275,NULL,NULL,1100,23,NULL,85),
 ('17#4913*1',397,NULL,NULL,1100,40,NULL,32),
 ('17#4914*1',185,NULL,NULL,1100,17,NULL,132),
 ('17#4915*1',246,NULL,NULL,1100,21,NULL,95),
 ('17#4916*1',466,NULL,NULL,1100,48,NULL,22),
 ('17#4917*2',362,NULL,NULL,1100,38,NULL,30),
 ('17#4918*2',159,NULL,NULL,1100,13,NULL,166),
 ('17#4920*2',251,NULL,NULL,1100,16,NULL,132),
 ('17#4921*2',0,NULL,NULL,1100,11,NULL,256),
 ('17#4922*2',55,NULL,NULL,1100,11,NULL,219),
 ('17#4923*3',210,NULL,NULL,800,18,NULL,69),
 ('17#4924*2',121,NULL,NULL,1100,12,NULL,184),
 ('17#4925*2',248,NULL,NULL,1100,22,NULL,88),
 ('17#4926*2',460,NULL,NULL,1100,50,NULL,12),
 ('17#4927*1',188,NULL,NULL,1100,14,NULL,152),
 ('17#4928*3',25,NULL,NULL,800,8,NULL,153),
 ('17#4929*3',49,NULL,NULL,800,8,NULL,148),
 ('17#4930*3',7,NULL,NULL,600,6,NULL,170),
 ('17#4931*3',209,NULL,NULL,800,16,NULL,80),
 ('17#4932*3',157,NULL,NULL,800,13,NULL,108),
 ('17#4933*3',260,NULL,NULL,800,29,NULL,46),
 ('17#4934*3',395,NULL,NULL,800,44,NULL,12),
 ('17#4936*3',0,NULL,NULL,600,6,NULL,172),
 ('17#4937*3',106,NULL,NULL,800,11,NULL,126),
 ('17#4940*3',248,NULL,NULL,800,25,NULL,55),
 ('17#4941*3',42,NULL,NULL,800,11,NULL,131),
 ('17#4942*3',0,NULL,NULL,600,6,NULL,172),
 ('17#4943*3',193,NULL,NULL,800,16,NULL,82),
 ('17#4944*3',153,NULL,NULL,800,12,NULL,113),
 ('17#4955*2',200,NULL,NULL,1100,21,NULL,97),
 ('17#4956*2',212,NULL,NULL,1100,12,NULL,175),
 ('17#4957*2',281,NULL,NULL,1100,20,NULL,99),
 ('17#4958*1',14,NULL,NULL,1100,11,NULL,190),
 ('17#4960*1',21,NULL,NULL,1100,11,NULL,189),
 ('17#4961*3',0,NULL,NULL,800,8,NULL,160),
 ('17#4962*1',0,NULL,NULL,1100,11,NULL,199),
 ('17#4964*3',0,NULL,NULL,500,5,NULL,186),
 ('17#4965*2',220,NULL,NULL,1100,17,NULL,125),
 ('17#4966*3',0,NULL,NULL,500,5,NULL,186),
 ('17#4967*3',255,NULL,NULL,800,24,NULL,56),
 ('17#4968*3',172,NULL,NULL,800,15,NULL,91),
 ('17#4969*3',200,NULL,NULL,800,14,NULL,95),
 ('17#4970*3',350,NULL,NULL,800,38,NULL,25),
 ('17#4971*3',290,NULL,NULL,800,35,NULL,35),
 ('17#4972*3',143,NULL,NULL,800,9,NULL,137),
 ('17#4973*3',140,NULL,NULL,800,13,NULL,109),
 ('17#4974*3',246,NULL,NULL,800,21,NULL,60),
 ('17#4975*3',0,NULL,NULL,500,5,NULL,186),
 ('17#4976*1',62,NULL,NULL,1100,11,NULL,177),
 ('17#4977*1',497,NULL,NULL,1100,52,NULL,14),
 ('17#4978*1',282,NULL,NULL,1100,27,NULL,63),
 ('17#4979*1',297,NULL,NULL,1100,23,NULL,84),
 ('17#4980*1',284,NULL,NULL,1100,25,NULL,77),
 ('17#4981*1',279,NULL,NULL,1100,24,NULL,83),
 ('17#4982*2',61,NULL,NULL,1100,11,NULL,215),
 ('17#4983*2',235,NULL,NULL,1100,21,NULL,96),
 ('17#4984*2',227,NULL,NULL,1100,19,NULL,112),
 ('17#4985*2',387,NULL,NULL,1100,37,NULL,32),
 ('17#4986*2',317,NULL,NULL,1100,25,NULL,69),
 ('17#4987*2',186,NULL,NULL,1100,18,NULL,117),
 ('17#4988*1',299,NULL,NULL,1100,25,NULL,75),
 ('17#4989*1',453,NULL,NULL,1100,47,NULL,23),
 ('17#4990*1',36,NULL,NULL,1100,11,NULL,187),
 ('17#4991*1',178,NULL,NULL,1100,13,NULL,158),
 ('17#4992*1',341,NULL,NULL,1100,34,NULL,46),
 ('17#4993*3',108,NULL,NULL,600,8,NULL,140),
 ('17#4999*3',347,NULL,NULL,800,36,NULL,28),
 ('17#5*2',224,NULL,NULL,1100,20,NULL,104),
 ('17#50*2',11,NULL,NULL,1100,11,NULL,241),
 ('17#5000*3',0,NULL,NULL,500,5,NULL,186),
 ('17#5006*3',0,NULL,NULL,500,5,NULL,186),
 ('17#5007*1',0,NULL,NULL,200,2,NULL,208),
 ('17#5010*1',39,NULL,NULL,200,2,NULL,207),
 ('17#5015*3',222,NULL,NULL,500,25,NULL,54),
 ('17#51*2',231,NULL,NULL,1100,17,NULL,124),
 ('17#52*2',384,NULL,NULL,1100,35,NULL,35),
 ('17#53*2',295,NULL,NULL,1100,23,NULL,79),
 ('17#54*2',236,NULL,NULL,1100,19,NULL,110),
 ('17#55*2',153,NULL,NULL,1100,13,NULL,167),
 ('17#56*2',6,NULL,NULL,1100,11,NULL,250),
 ('17#57*2',25,NULL,NULL,1100,11,NULL,229),
 ('17#58*2',319,NULL,NULL,1100,21,NULL,89),
 ('17#59*2',16,NULL,NULL,1100,11,NULL,236),
 ('17#6*2',3,NULL,NULL,1100,11,NULL,252),
 ('17#60*2',8,NULL,NULL,1100,11,NULL,245),
 ('17#61*2',391,NULL,NULL,1100,38,NULL,26),
 ('17#62*2',4,NULL,NULL,1100,11,NULL,251),
 ('17#63*2',333,NULL,NULL,1100,31,NULL,50),
 ('17#64*2',193,NULL,NULL,1100,15,NULL,147),
 ('17#65*2',338,NULL,NULL,1100,30,NULL,55),
 ('17#66*2',374,NULL,NULL,1100,32,NULL,44),
 ('17#67*2',392,NULL,NULL,1100,37,NULL,31),
 ('17#68*2',349,NULL,NULL,1100,31,NULL,47),
 ('17#69*2',22,NULL,NULL,1100,11,NULL,232),
 ('17#7*2',281,NULL,NULL,1100,26,NULL,68),
 ('17#70*2',382,NULL,NULL,1100,38,NULL,28),
 ('17#71*2',335,NULL,NULL,1100,29,NULL,58),
 ('17#72*2',299,NULL,NULL,1100,29,NULL,61),
 ('17#73*2',43,NULL,NULL,1100,11,NULL,223),
 ('17#74*2',405,NULL,NULL,1100,40,NULL,23),
 ('17#75*2',93,NULL,NULL,1100,11,NULL,206),
 ('17#76*2',192,NULL,NULL,1100,17,NULL,130),
 ('17#77*2',627,NULL,NULL,1100,79,NULL,1),
 ('17#78*2',224,NULL,NULL,1100,14,NULL,151),
 ('17#79*2',0,NULL,NULL,1100,11,NULL,256),
 ('17#8*2',340,NULL,NULL,1100,33,NULL,43),
 ('17#80*2',453,NULL,NULL,1100,48,NULL,14),
 ('17#81*2',217,NULL,NULL,1100,14,NULL,153),
 ('17#82*2',0,NULL,NULL,1100,11,NULL,256),
 ('17#83*2',347,NULL,NULL,1100,35,NULL,38),
 ('17#84*2',406,NULL,NULL,1100,40,NULL,22),
 ('17#85*2',21,NULL,NULL,1100,11,NULL,234),
 ('17#86*2',241,NULL,NULL,1100,16,NULL,133),
 ('17#87*2',0,NULL,NULL,1100,11,NULL,256),
 ('17#88*2',329,NULL,NULL,1100,29,NULL,59),
 ('17#89*2',253,NULL,NULL,1100,21,NULL,95),
 ('17#9*2',0,NULL,NULL,1100,11,NULL,256),
 ('17#90*2',0,NULL,NULL,1100,11,NULL,256),
 ('17#91*2',16,NULL,NULL,1100,11,NULL,236),
 ('17#92*2',0,NULL,NULL,1100,11,NULL,256),
 ('17#93*2',0,NULL,NULL,1100,11,NULL,256),
 ('17#94*2',108,NULL,NULL,1100,13,NULL,172),
 ('17#95*2',10,NULL,NULL,1100,11,NULL,242),
 ('17#96*2',412,NULL,NULL,1100,44,NULL,18),
 ('17#97*2',59,NULL,NULL,1100,11,NULL,216),
 ('17#98*2',254,NULL,NULL,1100,21,NULL,94),
 ('17#99*2',203,NULL,NULL,1100,14,NULL,154),
 ('18#1*3',0,NULL,NULL,500,5,NULL,187),
 ('18#10*3',120,NULL,NULL,600,20,NULL,22),
 ('18#100*3',87,NULL,NULL,600,11,NULL,68),
 ('18#101*3',0,NULL,NULL,600,6,NULL,134),
 ('18#102*3',0,NULL,NULL,600,6,NULL,134),
 ('18#103*3',7,NULL,NULL,600,6,NULL,127),
 ('18#104*3',33,NULL,NULL,700,7,NULL,107),
 ('18#105*3',0,NULL,NULL,600,6,NULL,134),
 ('18#106*3',0,NULL,NULL,600,6,NULL,134),
 ('18#107*3',13,NULL,NULL,600,6,NULL,122),
 ('18#11*3',20,NULL,NULL,500,5,NULL,171),
 ('18#110*3',0,NULL,NULL,600,6,NULL,134),
 ('18#111*3',0,NULL,NULL,600,6,NULL,134),
 ('18#112*3',200,NULL,NULL,600,23,NULL,11),
 ('18#113*3',167,NULL,NULL,700,17,NULL,36),
 ('18#114*3',113,NULL,NULL,700,11,NULL,66),
 ('18#115*3',47,NULL,NULL,600,6,NULL,111),
 ('18#116*3',47,NULL,NULL,600,6,NULL,111),
 ('18#118*3',60,NULL,NULL,600,7,NULL,103),
 ('18#12*3',0,NULL,NULL,500,5,NULL,187),
 ('18#120*3',153,NULL,NULL,700,15,NULL,49),
 ('18#121*3',0,NULL,NULL,600,6,NULL,134),
 ('18#123*3',160,NULL,NULL,600,16,NULL,41),
 ('18#125*3',0,NULL,NULL,600,6,NULL,134),
 ('18#126*3',93,NULL,NULL,600,7,NULL,96),
 ('18#127*3',107,NULL,NULL,600,10,NULL,72),
 ('18#128*3',107,NULL,NULL,600,11,NULL,65),
 ('18#129*3',107,NULL,NULL,700,11,NULL,67),
 ('18#13*3',0,NULL,NULL,500,5,NULL,187),
 ('18#130*3',227,NULL,NULL,700,27,NULL,5),
 ('18#131*3',180,NULL,NULL,700,25,NULL,10),
 ('18#132*3',273,NULL,NULL,600,31,NULL,1),
 ('18#133*3',193,NULL,NULL,600,20,NULL,21),
 ('18#134*3',0,NULL,NULL,600,6,NULL,134),
 ('18#135*3',0,NULL,NULL,600,6,NULL,134),
 ('18#136*3',220,NULL,NULL,700,23,NULL,13),
 ('18#137*3',0,NULL,NULL,600,6,NULL,134),
 ('18#138*3',167,NULL,NULL,700,19,NULL,28),
 ('18#139*3',67,NULL,NULL,700,7,NULL,105),
 ('18#14*3',40,NULL,NULL,600,7,NULL,106),
 ('18#140*3',133,NULL,NULL,600,16,NULL,43),
 ('18#141*3',240,NULL,NULL,600,26,NULL,6),
 ('18#142*3',40,NULL,NULL,600,6,NULL,114),
 ('18#143*3',53,NULL,NULL,600,9,NULL,83),
 ('18#144*3',207,NULL,NULL,600,27,NULL,4),
 ('18#145*3',160,NULL,NULL,700,23,NULL,14),
 ('18#146*3',0,NULL,NULL,600,6,NULL,134),
 ('18#147*3',0,NULL,NULL,600,6,NULL,134),
 ('18#149*3',47,NULL,NULL,600,6,NULL,111),
 ('18#15*3',0,NULL,NULL,500,5,NULL,187),
 ('18#150*3',193,NULL,NULL,600,25,NULL,9),
 ('18#151*3',0,NULL,NULL,600,6,NULL,134),
 ('18#154*3',147,NULL,NULL,600,14,NULL,52),
 ('18#155*3',0,NULL,NULL,600,6,NULL,134),
 ('18#156*3',0,NULL,NULL,600,6,NULL,134),
 ('18#157*3',7,NULL,NULL,600,6,NULL,127),
 ('18#158*3',0,NULL,NULL,600,6,NULL,134),
 ('18#159*3',160,NULL,NULL,600,17,NULL,35),
 ('18#16*3',0,NULL,NULL,500,5,NULL,187),
 ('18#160*3',147,NULL,NULL,700,15,NULL,50),
 ('18#161*3',0,NULL,NULL,600,6,NULL,134),
 ('18#163*3',73,NULL,NULL,700,7,NULL,102),
 ('18#164*3',227,NULL,NULL,700,23,NULL,12),
 ('18#165*3',0,NULL,NULL,600,6,NULL,134),
 ('18#166*3',0,NULL,NULL,600,6,NULL,134),
 ('18#167*3',0,NULL,NULL,600,6,NULL,134),
 ('18#168*3',0,NULL,NULL,600,6,NULL,134),
 ('18#169*3',160,NULL,NULL,600,15,NULL,47),
 ('18#17*3',13,NULL,NULL,500,5,NULL,175),
 ('18#170*3',260,NULL,NULL,700,29,NULL,3),
 ('18#171*3',0,NULL,NULL,600,6,NULL,134),
 ('18#172*3',0,NULL,NULL,600,6,NULL,134),
 ('18#173*3',0,NULL,NULL,600,6,NULL,134),
 ('18#174*3',120,NULL,NULL,600,9,NULL,78),
 ('18#175*3',0,NULL,NULL,600,6,NULL,134),
 ('18#176*3',180,NULL,NULL,700,18,NULL,33),
 ('18#177*3',40,NULL,NULL,600,6,NULL,114),
 ('18#178*3',167,NULL,NULL,600,19,NULL,27),
 ('18#179*3',153,NULL,NULL,600,21,NULL,20),
 ('18#18*3',0,NULL,NULL,500,5,NULL,187),
 ('18#180*3',0,NULL,NULL,600,6,NULL,134),
 ('18#181*3',0,NULL,NULL,600,6,NULL,134),
 ('18#182*3',87,NULL,NULL,700,8,NULL,91),
 ('18#183*3',100,NULL,NULL,600,7,NULL,95),
 ('18#184*3',160,NULL,NULL,600,16,NULL,41),
 ('18#185*3',80,NULL,NULL,600,11,NULL,69),
 ('18#187*3',53,NULL,NULL,500,5,NULL,166),
 ('18#188*3',40,NULL,NULL,400,4,NULL,250),
 ('18#189*3',147,NULL,NULL,400,16,NULL,37),
 ('18#19*3',7,NULL,NULL,600,6,NULL,127),
 ('18#190*3',93,NULL,NULL,500,16,NULL,44),
 ('18#191*3',33,NULL,NULL,400,4,NULL,252),
 ('18#192*3',113,NULL,NULL,400,11,NULL,63),
 ('18#195*3',7,NULL,NULL,400,4,NULL,254),
 ('18#196*3',107,NULL,NULL,500,12,NULL,60),
 ('18#197*3',53,NULL,NULL,400,8,NULL,90),
 ('18#198*3',87,NULL,NULL,400,9,NULL,77),
 ('18#199*3',120,NULL,NULL,400,12,NULL,57),
 ('18#2*3',0,NULL,NULL,500,5,NULL,187),
 ('18#20*3',13,NULL,NULL,500,5,NULL,175),
 ('18#200*3',173,NULL,NULL,500,22,NULL,17),
 ('18#201*3',0,NULL,NULL,400,4,NULL,255),
 ('18#202*3',0,NULL,NULL,400,4,NULL,255),
 ('18#203*3',0,NULL,NULL,400,4,NULL,255),
 ('18#204*3',140,NULL,NULL,400,17,NULL,34),
 ('18#205*3',167,NULL,NULL,500,25,NULL,8),
 ('18#206*3',53,NULL,NULL,400,5,NULL,165),
 ('18#207*3',127,NULL,NULL,400,13,NULL,53),
 ('18#208*3',187,NULL,NULL,500,22,NULL,16),
 ('18#209*3',140,NULL,NULL,500,14,NULL,51),
 ('18#21*3',20,NULL,NULL,600,6,NULL,120),
 ('18#210*3',0,NULL,NULL,400,4,NULL,255),
 ('18#211*3',73,NULL,NULL,400,7,NULL,94),
 ('18#212*3',140,NULL,NULL,500,15,NULL,46),
 ('18#213*3',87,NULL,NULL,400,10,NULL,70),
 ('18#214*3',0,NULL,NULL,400,4,NULL,255),
 ('18#215*3',0,NULL,NULL,400,4,NULL,255),
 ('18#216*3',20,NULL,NULL,500,5,NULL,171),
 ('18#217*3',153,NULL,NULL,400,19,NULL,23),
 ('18#218*3',27,NULL,NULL,500,5,NULL,169),
 ('18#219*3',153,NULL,NULL,400,19,NULL,23),
 ('18#22*3',0,NULL,NULL,500,5,NULL,187),
 ('18#220*3',0,NULL,NULL,400,4,NULL,255),
 ('18#221*3',133,NULL,NULL,400,15,NULL,45),
 ('18#222*3',0,NULL,NULL,400,4,NULL,255),
 ('18#223*3',100,NULL,NULL,400,12,NULL,58),
 ('18#224*3',133,NULL,NULL,400,16,NULL,38),
 ('18#225*3',67,NULL,NULL,400,8,NULL,88),
 ('18#226*3',40,NULL,NULL,400,4,NULL,250),
 ('18#227*3',0,NULL,NULL,400,4,NULL,255),
 ('18#228*3',93,NULL,NULL,400,12,NULL,59),
 ('18#229*3',107,NULL,NULL,400,9,NULL,75),
 ('18#23*3',13,NULL,NULL,500,5,NULL,175),
 ('18#230*3',0,NULL,NULL,400,4,NULL,255),
 ('18#231*3',0,NULL,NULL,400,4,NULL,255),
 ('18#232*3',0,NULL,NULL,400,4,NULL,255),
 ('18#233*3',60,NULL,NULL,500,6,NULL,110),
 ('18#234*3',60,NULL,NULL,400,7,NULL,97),
 ('18#236*3',153,NULL,NULL,500,19,NULL,25),
 ('18#237*3',0,NULL,NULL,400,4,NULL,255),
 ('18#238*3',147,NULL,NULL,400,18,NULL,29),
 ('18#239*3',87,NULL,NULL,400,8,NULL,85),
 ('18#24*3',0,NULL,NULL,500,5,NULL,187),
 ('18#240*3',160,NULL,NULL,500,18,NULL,30),
 ('18#241*3',87,NULL,NULL,400,11,NULL,64),
 ('18#242*3',160,NULL,NULL,400,21,NULL,18),
 ('18#243*3',47,NULL,NULL,500,8,NULL,92),
 ('18#244*3',0,NULL,NULL,400,4,NULL,255),
 ('18#245*3',0,NULL,NULL,400,4,NULL,255),
 ('18#246*3',0,NULL,NULL,400,4,NULL,255),
 ('18#247*3',0,NULL,NULL,400,4,NULL,255),
 ('18#248*3',20,NULL,NULL,400,4,NULL,253),
 ('18#249*3',100,NULL,NULL,400,9,NULL,76),
 ('18#25*3',0,NULL,NULL,500,5,NULL,187),
 ('18#250*3',67,NULL,NULL,500,7,NULL,99),
 ('18#251*3',60,NULL,NULL,400,4,NULL,249),
 ('18#252*3',73,NULL,NULL,400,8,NULL,87),
 ('18#253*3',60,NULL,NULL,400,8,NULL,89),
 ('18#254*3',80,NULL,NULL,400,9,NULL,78),
 ('18#255*3',0,NULL,NULL,400,4,NULL,255),
 ('18#256*3',80,NULL,NULL,400,6,NULL,108),
 ('18#257*3',33,NULL,NULL,500,6,NULL,117),
 ('18#258*3',167,NULL,NULL,400,22,NULL,15),
 ('18#259*3',0,NULL,NULL,400,4,NULL,255),
 ('18#26*3',40,NULL,NULL,500,8,NULL,93),
 ('18#260*3',200,NULL,NULL,500,25,NULL,6),
 ('18#261*3',93,NULL,NULL,500,10,NULL,71),
 ('18#262*3',33,NULL,NULL,400,5,NULL,168),
 ('18#263*3',80,NULL,NULL,500,12,NULL,61),
 ('18#264*3',0,NULL,NULL,400,4,NULL,255),
 ('18#265*3',0,NULL,NULL,400,4,NULL,255),
 ('18#266*3',47,NULL,NULL,500,5,NULL,167),
 ('18#267*3',100,NULL,NULL,500,5,NULL,163),
 ('18#268*3',147,NULL,NULL,500,16,NULL,39),
 ('18#269*3',187,NULL,NULL,500,21,NULL,19),
 ('18#27*3',73,NULL,NULL,600,10,NULL,73),
 ('18#270*3',73,NULL,NULL,400,6,NULL,109),
 ('18#271*3',87,NULL,NULL,400,8,NULL,85),
 ('18#272*3',0,NULL,NULL,400,4,NULL,255),
 ('18#273*3',0,NULL,NULL,400,4,NULL,255),
 ('18#274*3',73,NULL,NULL,500,9,NULL,80),
 ('18#275*3',0,NULL,NULL,400,4,NULL,255),
 ('18#276*3',0,NULL,NULL,400,4,NULL,255),
 ('18#277*3',153,NULL,NULL,500,18,NULL,31),
 ('18#278*3',73,NULL,NULL,500,5,NULL,164),
 ('18#279*4',27,NULL,NULL,400,4,NULL,90),
 ('18#28*3',0,NULL,NULL,500,5,NULL,187),
 ('18#281*4',120,NULL,NULL,400,15,NULL,21),
 ('18#282*4',0,NULL,NULL,400,4,NULL,119),
 ('18#283*4',20,NULL,NULL,300,3,NULL,140),
 ('18#284*4',80,NULL,NULL,300,12,NULL,39),
 ('18#286*4',27,NULL,NULL,400,4,NULL,90),
 ('18#287*4',60,NULL,NULL,400,9,NULL,53),
 ('18#29*3',0,NULL,NULL,500,5,NULL,187),
 ('18#290*4',0,NULL,NULL,400,4,NULL,119),
 ('18#291*4',0,NULL,NULL,400,4,NULL,119),
 ('18#292*4',73,NULL,NULL,400,11,NULL,45),
 ('18#293*4',80,NULL,NULL,400,12,NULL,42),
 ('18#295*4',27,NULL,NULL,400,4,NULL,90),
 ('18#296*4',0,NULL,NULL,400,4,NULL,119),
 ('18#299*4',93,NULL,NULL,400,15,NULL,25),
 ('18#3*3',0,NULL,NULL,500,5,NULL,187),
 ('18#30*3',0,NULL,NULL,500,5,NULL,187),
 ('18#300*4',87,NULL,NULL,400,12,NULL,41),
 ('18#301*4',0,NULL,NULL,400,4,NULL,119),
 ('18#302*4',0,NULL,NULL,300,3,NULL,147),
 ('18#303*4',60,NULL,NULL,400,8,NULL,58),
 ('18#304*4',27,NULL,NULL,400,4,NULL,90),
 ('18#305*4',80,NULL,NULL,400,11,NULL,44),
 ('18#306*4',33,NULL,NULL,400,5,NULL,72),
 ('18#307*4',0,NULL,NULL,400,4,NULL,119),
 ('18#309*4',0,NULL,NULL,300,3,NULL,147),
 ('18#31*3',27,NULL,NULL,500,5,NULL,169),
 ('18#311*4',13,NULL,NULL,400,4,NULL,102),
 ('18#312*4',0,NULL,NULL,400,4,NULL,119),
 ('18#313*4',7,NULL,NULL,400,4,NULL,108),
 ('18#314*4',33,NULL,NULL,400,5,NULL,72),
 ('18#315*4',20,NULL,NULL,400,4,NULL,97),
 ('18#317*4',107,NULL,NULL,400,15,NULL,23),
 ('18#318*4',0,NULL,NULL,300,3,NULL,147),
 ('18#32*3',0,NULL,NULL,500,5,NULL,187),
 ('18#320*4',7,NULL,NULL,300,3,NULL,143),
 ('18#321*4',7,NULL,NULL,400,4,NULL,108),
 ('18#322*4',0,NULL,NULL,400,4,NULL,119),
 ('18#323*4',33,NULL,NULL,400,5,NULL,72),
 ('18#324*4',7,NULL,NULL,400,4,NULL,108),
 ('18#327*4',7,NULL,NULL,400,4,NULL,108),
 ('18#328*4',20,NULL,NULL,400,4,NULL,97),
 ('18#329*4',80,NULL,NULL,400,8,NULL,56),
 ('18#33*3',0,NULL,NULL,500,5,NULL,187),
 ('18#330*4',0,NULL,NULL,300,3,NULL,147),
 ('18#331*4',27,NULL,NULL,400,4,NULL,90),
 ('18#332*4',27,NULL,NULL,400,4,NULL,90),
 ('18#333*4',33,NULL,NULL,400,4,NULL,87),
 ('18#334*4',40,NULL,NULL,400,7,NULL,63),
 ('18#335*4',13,NULL,NULL,400,4,NULL,102),
 ('18#336*4',0,NULL,NULL,300,3,NULL,147),
 ('18#337*4',0,NULL,NULL,300,3,NULL,147),
 ('18#338*4',40,NULL,NULL,400,4,NULL,83),
 ('18#339*4',7,NULL,NULL,400,4,NULL,108),
 ('18#34*3',0,NULL,NULL,500,5,NULL,187),
 ('18#341*4',53,NULL,NULL,400,5,NULL,69),
 ('18#342*4',7,NULL,NULL,400,4,NULL,108),
 ('18#343*4',7,NULL,NULL,300,3,NULL,143),
 ('18#344*4',47,NULL,NULL,400,4,NULL,82),
 ('18#345*4',53,NULL,NULL,400,7,NULL,61),
 ('18#346*4',67,NULL,NULL,400,9,NULL,52),
 ('18#349*4',7,NULL,NULL,400,4,NULL,108),
 ('18#35*3',7,NULL,NULL,600,6,NULL,127),
 ('18#350*4',13,NULL,NULL,400,4,NULL,102),
 ('18#351*4',7,NULL,NULL,400,4,NULL,108),
 ('18#352*4',33,NULL,NULL,400,5,NULL,72),
 ('18#353*4',67,NULL,NULL,400,12,NULL,43),
 ('18#354*4',73,NULL,NULL,400,9,NULL,51),
 ('18#355*4',60,NULL,NULL,400,11,NULL,47),
 ('18#358*4',120,NULL,NULL,400,15,NULL,21),
 ('18#359*4',107,NULL,NULL,400,15,NULL,23),
 ('18#36*3',0,NULL,NULL,500,5,NULL,187),
 ('18#363*4',13,NULL,NULL,300,3,NULL,141),
 ('18#364*4',100,NULL,NULL,400,13,NULL,33),
 ('18#365*4',0,NULL,NULL,300,3,NULL,147),
 ('18#366*4',107,NULL,NULL,300,14,NULL,28),
 ('18#367*4',0,NULL,NULL,300,3,NULL,147),
 ('18#368*4',47,NULL,NULL,400,5,NULL,70),
 ('18#369*4',73,NULL,NULL,300,7,NULL,60),
 ('18#37*3',0,NULL,NULL,500,5,NULL,187),
 ('18#370*4',47,NULL,NULL,300,6,NULL,65),
 ('18#371*4',0,NULL,NULL,300,3,NULL,147),
 ('18#372*4',60,NULL,NULL,300,4,NULL,76),
 ('18#373*4',120,NULL,NULL,300,12,NULL,37),
 ('18#374*4',107,NULL,NULL,300,13,NULL,28),
 ('18#375*4',0,NULL,NULL,300,3,NULL,147),
 ('18#376*4',27,NULL,NULL,300,3,NULL,138),
 ('18#377*4',40,NULL,NULL,300,4,NULL,79),
 ('18#378*4',147,NULL,NULL,400,19,NULL,11),
 ('18#379*4',73,NULL,NULL,300,8,NULL,55),
 ('18#38*3',0,NULL,NULL,500,5,NULL,187),
 ('18#380*4',47,NULL,NULL,400,5,NULL,70),
 ('18#381*4',0,NULL,NULL,300,3,NULL,147),
 ('18#382*4',40,NULL,NULL,400,4,NULL,83),
 ('18#383*4',153,NULL,NULL,400,22,NULL,4),
 ('18#384*4',160,NULL,NULL,300,23,NULL,2),
 ('18#385*4',47,NULL,NULL,300,3,NULL,136),
 ('18#386*4',140,NULL,NULL,300,19,NULL,9),
 ('18#387*4',193,NULL,NULL,400,23,NULL,3),
 ('18#388*4',0,NULL,NULL,300,3,NULL,147),
 ('18#389*4',73,NULL,NULL,400,11,NULL,45),
 ('18#39*3',7,NULL,NULL,600,6,NULL,127),
 ('18#390*4',20,NULL,NULL,400,4,NULL,97),
 ('18#391*4',67,NULL,NULL,300,3,NULL,134),
 ('18#392*4',0,NULL,NULL,300,3,NULL,147),
 ('18#393*4',0,NULL,NULL,300,3,NULL,147),
 ('18#394*4',20,NULL,NULL,400,4,NULL,97),
 ('18#395*4',0,NULL,NULL,300,3,NULL,147),
 ('18#396*4',87,NULL,NULL,300,10,NULL,48),
 ('18#397*4',0,NULL,NULL,300,3,NULL,147),
 ('18#398*4',127,NULL,NULL,300,18,NULL,12),
 ('18#399*4',93,NULL,NULL,400,12,NULL,40),
 ('18#4*3',0,NULL,NULL,500,5,NULL,187),
 ('18#40*3',0,NULL,NULL,500,5,NULL,187),
 ('18#400*4',0,NULL,NULL,300,3,NULL,147),
 ('18#401*4',0,NULL,NULL,300,3,NULL,147),
 ('18#402*4',0,NULL,NULL,300,3,NULL,147),
 ('18#403*4',127,NULL,NULL,400,13,NULL,31),
 ('18#404*4',80,NULL,NULL,300,9,NULL,50),
 ('18#405*4',0,NULL,NULL,300,3,NULL,147),
 ('18#406*4',40,NULL,NULL,300,4,NULL,79),
 ('18#407*4',53,NULL,NULL,400,7,NULL,61),
 ('18#408*4',0,NULL,NULL,300,3,NULL,147),
 ('18#409*4',0,NULL,NULL,400,4,NULL,119),
 ('18#41*3',0,NULL,NULL,500,5,NULL,187),
 ('18#410*4',0,NULL,NULL,400,4,NULL,119),
 ('18#411*4',0,NULL,NULL,300,3,NULL,147),
 ('18#412*4',0,NULL,NULL,300,3,NULL,147),
 ('18#413*4',0,NULL,NULL,300,3,NULL,147),
 ('18#414*4',47,NULL,NULL,400,8,NULL,59),
 ('18#415*4',33,NULL,NULL,400,4,NULL,87),
 ('18#416*4',13,NULL,NULL,300,3,NULL,141),
 ('18#417*4',207,NULL,NULL,400,26,NULL,1),
 ('18#418*4',100,NULL,NULL,300,12,NULL,38),
 ('18#419*4',140,NULL,NULL,400,16,NULL,17),
 ('18#42*3',7,NULL,NULL,600,6,NULL,127),
 ('18#420*4',0,NULL,NULL,300,3,NULL,147),
 ('18#421*4',40,NULL,NULL,400,4,NULL,83),
 ('18#422*4',173,NULL,NULL,400,21,NULL,6),
 ('18#423*4',0,NULL,NULL,300,3,NULL,147),
 ('18#424*4',127,NULL,NULL,400,13,NULL,31),
 ('18#425*4',127,NULL,NULL,300,15,NULL,19),
 ('18#426*4',60,NULL,NULL,400,5,NULL,68),
 ('18#427*4',160,NULL,NULL,400,20,NULL,8),
 ('18#428*4',73,NULL,NULL,300,5,NULL,67),
 ('18#429*4',53,NULL,NULL,400,4,NULL,81),
 ('18#43*3',0,NULL,NULL,500,5,NULL,187),
 ('18#430*4',133,NULL,NULL,300,16,NULL,15),
 ('18#431*4',0,NULL,NULL,300,3,NULL,147),
 ('18#432*4',0,NULL,NULL,400,4,NULL,119),
 ('18#433*4',127,NULL,NULL,400,16,NULL,18),
 ('18#434*4',127,NULL,NULL,300,17,NULL,14),
 ('18#435*4',0,NULL,NULL,400,4,NULL,119),
 ('18#436*4',113,NULL,NULL,300,15,NULL,20),
 ('18#437*4',133,NULL,NULL,300,16,NULL,15),
 ('18#438*4',107,NULL,NULL,300,14,NULL,28),
 ('18#439*4',93,NULL,NULL,400,10,NULL,49),
 ('18#44*3',0,NULL,NULL,500,5,NULL,187),
 ('18#440*4',140,NULL,NULL,400,18,NULL,13),
 ('18#441*4',67,NULL,NULL,400,4,NULL,78),
 ('18#442*4',53,NULL,NULL,300,3,NULL,135),
 ('18#443*4',0,NULL,NULL,300,3,NULL,147),
 ('18#444*4',0,NULL,NULL,300,3,NULL,147),
 ('18#445*4',93,NULL,NULL,400,13,NULL,35),
 ('18#447*4',53,NULL,NULL,300,6,NULL,64),
 ('18#448*4',0,NULL,NULL,300,3,NULL,147),
 ('18#45*3',47,NULL,NULL,600,9,NULL,84),
 ('18#450*4',140,NULL,NULL,300,20,NULL,7),
 ('18#451*4',40,NULL,NULL,300,6,NULL,66),
 ('18#46*3',0,NULL,NULL,500,5,NULL,187),
 ('18#47*3',0,NULL,NULL,500,5,NULL,187),
 ('18#4700*4',13,NULL,NULL,400,4,NULL,102),
 ('18#4701*4',20,NULL,NULL,400,4,NULL,97),
 ('18#4721*3',200,NULL,NULL,700,16,NULL,40),
 ('18#4723*4',7,NULL,NULL,400,4,NULL,108),
 ('18#4724*4',0,NULL,NULL,300,3,NULL,147),
 ('18#4727*2',223,NULL,NULL,600,22,NULL,14),
 ('18#4728*2',20,NULL,NULL,600,6,NULL,44),
 ('18#4729*2',37,NULL,NULL,600,7,NULL,41),
 ('18#4731*2',150,NULL,NULL,600,19,NULL,19),
 ('18#4732*2',20,NULL,NULL,600,6,NULL,44),
 ('18#4733*2',223,NULL,NULL,600,21,NULL,14),
 ('18#4734*2',297,NULL,NULL,600,33,NULL,6),
 ('18#4735*2',450,NULL,NULL,600,62,NULL,1),
 ('18#4736*2',77,NULL,NULL,600,7,NULL,39),
 ('18#4737*2',113,NULL,NULL,600,10,NULL,28),
 ('18#4738*2',190,NULL,NULL,600,20,NULL,17),
 ('18#4739*2',133,NULL,NULL,600,13,NULL,24),
 ('18#4740*2',170,NULL,NULL,600,15,NULL,22),
 ('18#4741*2',0,NULL,NULL,600,6,NULL,51),
 ('18#4742*2',307,NULL,NULL,600,37,NULL,5),
 ('18#4743*2',0,NULL,NULL,600,6,NULL,51),
 ('18#4744*2',13,NULL,NULL,600,6,NULL,49),
 ('18#4745*2',83,NULL,NULL,600,11,NULL,26),
 ('18#4746*2',200,NULL,NULL,600,20,NULL,16),
 ('18#4747*2',243,NULL,NULL,600,23,NULL,13),
 ('18#4748*2',123,NULL,NULL,600,9,NULL,31),
 ('18#4749*2',17,NULL,NULL,600,6,NULL,48),
 ('18#4750*2',100,NULL,NULL,600,10,NULL,30),
 ('18#4751*2',63,NULL,NULL,600,8,NULL,37),
 ('18#4752*2',3,NULL,NULL,600,6,NULL,50),
 ('18#4753*2',223,NULL,NULL,600,24,NULL,12),
 ('18#4754*2',77,NULL,NULL,600,9,NULL,33),
 ('18#4755*2',227,NULL,NULL,600,25,NULL,11),
 ('18#4756*2',237,NULL,NULL,600,29,NULL,7),
 ('18#4757*2',167,NULL,NULL,600,20,NULL,18),
 ('18#4758*2',0,NULL,NULL,600,6,NULL,51),
 ('18#4759*2',0,NULL,NULL,600,6,NULL,51),
 ('18#4760*2',60,NULL,NULL,600,6,NULL,42),
 ('18#4761*2',0,NULL,NULL,600,6,NULL,51),
 ('18#4762*2',27,NULL,NULL,600,6,NULL,43),
 ('18#4763*2',200,NULL,NULL,600,17,NULL,20),
 ('18#4764*2',20,NULL,NULL,600,6,NULL,44),
 ('18#4765*2',70,NULL,NULL,600,8,NULL,36),
 ('18#4766*2',333,NULL,NULL,600,41,NULL,3),
 ('18#4767*2',83,NULL,NULL,600,7,NULL,38),
 ('18#4768*2',60,NULL,NULL,600,7,NULL,40),
 ('18#4769*2',0,NULL,NULL,600,6,NULL,51),
 ('18#4770*2',260,NULL,NULL,600,28,NULL,8),
 ('18#4771*2',0,NULL,NULL,600,6,NULL,51),
 ('18#4772*2',83,NULL,NULL,600,8,NULL,35),
 ('18#4773*2',103,NULL,NULL,600,9,NULL,32),
 ('18#4774*2',0,NULL,NULL,600,6,NULL,51),
 ('18#4775*2',183,NULL,NULL,600,15,NULL,21),
 ('18#4776*2',237,NULL,NULL,600,25,NULL,10),
 ('18#4777*2',300,NULL,NULL,600,39,NULL,4),
 ('18#4778*2',20,NULL,NULL,600,6,NULL,44),
 ('18#4779*2',110,NULL,NULL,600,8,NULL,34),
 ('18#4780*2',217,NULL,NULL,600,26,NULL,9),
 ('18#48*3',13,NULL,NULL,500,5,NULL,175),
 ('18#49*3',0,NULL,NULL,500,5,NULL,187),
 ('18#4917*3',0,NULL,NULL,400,4,NULL,255),
 ('18#4918*3',113,NULL,NULL,500,15,NULL,48),
 ('18#4920*3',40,NULL,NULL,400,7,NULL,103),
 ('18#4921*3',0,NULL,NULL,400,4,NULL,255),
 ('18#4922*3',0,NULL,NULL,400,4,NULL,255),
 ('18#4923*4',7,NULL,NULL,400,4,NULL,108),
 ('18#4924*3',0,NULL,NULL,600,6,NULL,134),
 ('18#4925*3',120,NULL,NULL,600,13,NULL,55),
 ('18#4926*3',173,NULL,NULL,600,19,NULL,26),
 ('18#4928*4',0,NULL,NULL,400,4,NULL,119),
 ('18#4929*4',0,NULL,NULL,400,4,NULL,119),
 ('18#4931*4',33,NULL,NULL,400,4,NULL,87),
 ('18#4932*4',7,NULL,NULL,400,4,NULL,108),
 ('18#4933*4',0,NULL,NULL,400,4,NULL,119),
 ('18#4934*4',60,NULL,NULL,400,9,NULL,53),
 ('18#4936*4',0,NULL,NULL,300,3,NULL,147),
 ('18#4937*4',100,NULL,NULL,400,13,NULL,33),
 ('18#4940*4',113,NULL,NULL,300,14,NULL,26),
 ('18#4941*4',0,NULL,NULL,300,3,NULL,147),
 ('18#4942*4',0,NULL,NULL,300,3,NULL,147),
 ('18#4943*4',147,NULL,NULL,400,14,NULL,27),
 ('18#4944*4',40,NULL,NULL,300,3,NULL,137),
 ('18#4955*3',100,NULL,NULL,400,13,NULL,54),
 ('18#4956*3',167,NULL,NULL,600,18,NULL,32),
 ('18#4957*3',13,NULL,NULL,500,5,NULL,175),
 ('18#4958*2',0,NULL,NULL,600,6,NULL,51),
 ('18#4960*2',0,NULL,NULL,600,6,NULL,51),
 ('18#4961*4',0,NULL,NULL,300,3,NULL,147),
 ('18#4962*2',0,NULL,NULL,600,6,NULL,51),
 ('18#4965*3',73,NULL,NULL,600,7,NULL,101),
 ('18#4967*4',27,NULL,NULL,400,4,NULL,90),
 ('18#4968*4',13,NULL,NULL,400,4,NULL,102),
 ('18#4969*4',40,NULL,NULL,400,4,NULL,83),
 ('18#4970*4',73,NULL,NULL,400,13,NULL,36),
 ('18#4971*4',153,NULL,NULL,400,19,NULL,10),
 ('18#4972*4',13,NULL,NULL,400,4,NULL,102),
 ('18#4973*4',53,NULL,NULL,300,4,NULL,77),
 ('18#4974*4',7,NULL,NULL,300,3,NULL,143),
 ('18#4976*2',0,NULL,NULL,600,6,NULL,51),
 ('18#4977*2',357,NULL,NULL,600,46,NULL,2),
 ('18#4978*2',107,NULL,NULL,600,10,NULL,29),
 ('18#4979*2',153,NULL,NULL,600,10,NULL,27),
 ('18#4980*2',0,NULL,NULL,600,6,NULL,51),
 ('18#4981*2',117,NULL,NULL,600,11,NULL,25),
 ('18#4982*3',0,NULL,NULL,400,4,NULL,255),
 ('18#4983*3',0,NULL,NULL,400,4,NULL,255),
 ('18#4984*3',0,NULL,NULL,500,5,NULL,187),
 ('18#4985*3',0,NULL,NULL,500,5,NULL,187),
 ('18#4986*3',47,NULL,NULL,500,9,NULL,81),
 ('18#4987*3',7,NULL,NULL,600,6,NULL,127),
 ('18#4993*4',7,NULL,NULL,300,3,NULL,143),
 ('18#5*3',7,NULL,NULL,500,5,NULL,183),
 ('18#50*3',0,NULL,NULL,500,5,NULL,187),
 ('18#5001*2',143,NULL,NULL,600,15,NULL,23),
 ('18#5005*3',0,NULL,NULL,500,5,NULL,187),
 ('18#5006*4',0,NULL,NULL,300,3,NULL,147),
 ('18#5013*4',160,NULL,NULL,300,21,NULL,5),
 ('18#5014*4',53,NULL,NULL,300,8,NULL,57),
 ('18#5015*4',27,NULL,NULL,300,3,NULL,138),
 ('18#51*3',0,NULL,NULL,500,5,NULL,187),
 ('18#52*3',0,NULL,NULL,500,5,NULL,187),
 ('18#53*3',0,NULL,NULL,500,5,NULL,187),
 ('18#54*3',0,NULL,NULL,500,5,NULL,187),
 ('18#55*3',13,NULL,NULL,600,6,NULL,122),
 ('18#56*3',0,NULL,NULL,500,5,NULL,187),
 ('18#57*3',0,NULL,NULL,500,5,NULL,187),
 ('18#58*3',13,NULL,NULL,600,6,NULL,122),
 ('18#59*3',0,NULL,NULL,500,5,NULL,187),
 ('18#6*3',0,NULL,NULL,500,5,NULL,187),
 ('18#60*3',0,NULL,NULL,500,5,NULL,187),
 ('18#61*3',0,NULL,NULL,500,5,NULL,187),
 ('18#62*3',0,NULL,NULL,500,5,NULL,187),
 ('18#63*3',20,NULL,NULL,500,5,NULL,171),
 ('18#64*3',7,NULL,NULL,500,5,NULL,183),
 ('18#65*3',33,NULL,NULL,500,6,NULL,117),
 ('18#66*3',0,NULL,NULL,500,5,NULL,187),
 ('18#67*3',13,NULL,NULL,500,5,NULL,175),
 ('18#68*3',13,NULL,NULL,500,5,NULL,175),
 ('18#69*3',0,NULL,NULL,500,5,NULL,187),
 ('18#7*3',0,NULL,NULL,500,5,NULL,187),
 ('18#70*3',33,NULL,NULL,600,6,NULL,119),
 ('18#71*3',73,NULL,NULL,600,10,NULL,73),
 ('18#72*3',13,NULL,NULL,600,6,NULL,122),
 ('18#73*3',0,NULL,NULL,500,5,NULL,187),
 ('18#74*3',0,NULL,NULL,500,5,NULL,187),
 ('18#75*3',0,NULL,NULL,500,5,NULL,187),
 ('18#76*3',7,NULL,NULL,500,5,NULL,183),
 ('18#77*3',60,NULL,NULL,500,12,NULL,62),
 ('18#78*3',0,NULL,NULL,500,5,NULL,187),
 ('18#79*3',0,NULL,NULL,500,5,NULL,187),
 ('18#8*3',13,NULL,NULL,500,5,NULL,175),
 ('18#80*3',0,NULL,NULL,500,5,NULL,187),
 ('18#81*3',0,NULL,NULL,500,5,NULL,187),
 ('18#82*3',0,NULL,NULL,500,5,NULL,187),
 ('18#83*3',47,NULL,NULL,500,9,NULL,81),
 ('18#84*3',0,NULL,NULL,500,5,NULL,187),
 ('18#85*3',0,NULL,NULL,500,5,NULL,187),
 ('18#86*3',20,NULL,NULL,500,5,NULL,171),
 ('18#87*3',0,NULL,NULL,500,5,NULL,187),
 ('18#88*3',40,NULL,NULL,600,6,NULL,114),
 ('18#89*3',7,NULL,NULL,500,5,NULL,183),
 ('18#9*3',0,NULL,NULL,500,5,NULL,187),
 ('18#90*3',0,NULL,NULL,500,5,NULL,187),
 ('18#91*3',0,NULL,NULL,500,5,NULL,187),
 ('18#92*3',0,NULL,NULL,500,5,NULL,187),
 ('18#93*3',0,NULL,NULL,500,5,NULL,187),
 ('18#94*3',100,NULL,NULL,600,13,NULL,56),
 ('18#95*3',13,NULL,NULL,600,6,NULL,122),
 ('18#96*3',240,NULL,NULL,600,30,NULL,2),
 ('18#97*3',20,NULL,NULL,600,6,NULL,120),
 ('18#98*3',87,NULL,NULL,600,7,NULL,98),
 ('18#99*3',87,NULL,NULL,700,7,NULL,100);
/*!40000 ALTER TABLE `examsubreptkold` ENABLE KEYS */;


--
-- Definition of table `examsubreptold`
--

DROP TABLE IF EXISTS `examsubreptold`;
CREATE TABLE `examsubreptold` (
  `TmStSubCl` varchar(95) NOT NULL,
  `Mksr` double DEFAULT NULL,
  `grd` varchar(5) DEFAULT NULL,
  `Remaiks` text,
  `outOfr` double DEFAULT NULL,
  `pnts` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`TmStSubCl`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `examsubreptold`
--

/*!40000 ALTER TABLE `examsubreptold` DISABLE KEYS */;
/*!40000 ALTER TABLE `examsubreptold` ENABLE KEYS */;


--
-- Definition of table `exmax`
--

DROP TABLE IF EXISTS `exmax`;
CREATE TABLE `exmax` (
  `AdmNo` varchar(45) DEFAULT NULL,
  `Student` varchar(45) DEFAULT NULL,
  `Maxes` double DEFAULT NULL,
  `SID` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `exmax`
--

/*!40000 ALTER TABLE `exmax` DISABLE KEYS */;
INSERT INTO `exmax` (`AdmNo`,`Student`,`Maxes`,`SID`) VALUES 
 ('931','MAINA IRENE NYAMBURA',0,1596),
 ('993','TONY  BLAIR',0,1596),
 ('959','OUMA IAN OKASIRA',0,1596),
 ('963','FELIX  OCHIENG',0,1596),
 ('921','KINYUA ESTHER MUMBI',0,1596),
 ('930','KINYANJUI GRACE NYANDIRI',0,1596),
 ('973','ROSEMARY  ABUTO',0,1596),
 ('938','OMONDI PURITY AJWANG',0,1596),
 ('934','MUIRURI DORCAS NJOKI',0,1596),
 ('956','BARASA SHARON SHARAI',0,1596),
 ('1014','FRIDAH  KAWIRA',0,1596),
 ('925','OWITI LUCY WAMBUI',0,1596),
 ('928','MBITHI PHILIP MTHIANI',0,1596),
 ('965','PENINAH  OSORE',0,1596),
 ('964','TONY DAVID MWANGI',0,1596),
 ('936','NDUNGE MONICA MBETE',0,1596),
 ('960','MAINA YVONNE NJERI',0,1596),
 ('926','NYOIKE IRENE NYAMBURA',0,1596),
 ('1011','MWANIKI NAOMI WANJIRU',0,1596),
 ('954','THIONGO BRIAN MWANGI',0,1596),
 ('1013','MURUKU DOUGLAS MACHARIA',0,1596),
 ('1017','JANE WANGECI NGUGI',0,1596),
 ('935','NYAMBURA MAGDALENE NJOKI',0,1596),
 ('972','PINTA  MAKENA',0,1596),
 ('944','WAIRIMU MERCY WANJIKU',0,1596),
 ('943','WAIRIMU NAOMI NJERI',0,1596),
 ('937','MUIRURI PETER NDUNGU',0,1596),
 ('998','NELLY WANGUI MUIRURI',0,1596),
 ('933','WAITHAKA ESTHER NYAWIRA',0,1596),
 ('977','ALLAN  NDUATI',0,1596),
 ('992','MUTHENI IRENE KANANU',0,1596),
 ('945','KARIUKI MERCY WAITHIRA',0,1596),
 ('966','BRIAN  KURIA',0,1596),
 ('1006','WAITHIRA HOLLAND NGANGA',0,1596),
 ('952','WANGAI DANIEL KINGAU',0,1596),
 ('1003','GITAU DEDAN NDIRANGU',0,1596),
 ('1019','FRAVIAN MUNGAI WATARI',0,1596),
 ('958','GITAU ESTHER NYAKIRIMA',0,1596),
 ('975','DERRICK  MACHARIA',0,1596),
 ('955','MAINA EZRAH MUGAI',0,1596),
 ('1021','MARY ANN NJERI MUKAMI',0,1596),
 ('920','KINYANJUI HENRY KARERI',0,1596),
 ('1005','WATORO STEPHEN KARIUKI',0,1596),
 ('942','MBURU DENNIS MURIMI',0,1596),
 ('924','GATHU SANCHEZ KARANGI',0,1596),
 ('941','NGANGA PETER NJUGUNA',0,1596),
 ('946','KIARIE GEORGE NJUGUNA',0,1596),
 ('923','GATHU GLENN IRUNGU',0,1596),
 ('940','MBUTHIA MARY WANGARI',0,1596),
 ('962','BENSON  HODARI',0,1596),
 ('1022','EMMANUEL ENKALE AWOI',0,1596),
 ('939','NGANGA MARY NYAMBURA',0,1596),
 ('961','SIMON  KIOKO',0,1596),
 ('927','WANJIKU PETER MWANGI',0,1596),
 ('932','MUCHIRI EZEKIEL NNJUE',0,1596),
 ('953','WAMBUI ENRICK MWANGI',0,1596),
 ('1007','BENSON MBUGUA -',0,1596);
/*!40000 ALTER TABLE `exmax` ENABLE KEYS */;


--
-- Definition of table `expbudget`
--

DROP TABLE IF EXISTS `expbudget`;
CREATE TABLE `expbudget` (
  `YrsExp` varchar(45) NOT NULL,
  `budget` double DEFAULT NULL,
  `Actual` double DEFAULT NULL,
  PRIMARY KEY (`YrsExp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `expbudget`
--

/*!40000 ALTER TABLE `expbudget` DISABLE KEYS */;
/*!40000 ALTER TABLE `expbudget` ENABLE KEYS */;


--
-- Definition of table `expcategory`
--

DROP TABLE IF EXISTS `expcategory`;
CREATE TABLE `expcategory` (
  `Acc` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Descr` varchar(100) NOT NULL,
  PRIMARY KEY (`Acc`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `expcategory`
--

/*!40000 ALTER TABLE `expcategory` DISABLE KEYS */;
INSERT INTO `expcategory` (`Acc`,`Descr`) VALUES 
 (1,'Interest Expense on Deposits'),
 (2,'Cost of External Borrowings'),
 (3,'Dividend Expenses (on member shares)'),
 (4,'Other Financial Expense'),
 (5,'Fees & Commission Expense'),
 (6,'Other Expense'),
 (7,'Personnel Expense'),
 (8,'Governance Expense'),
 (9,'Marketing Expenses'),
 (10,'Depreciation and Armotization Charges'),
 (11,'Administrative Expenses'),
 (12,'Non-Operating Expenses');
/*!40000 ALTER TABLE `expcategory` ENABLE KEYS */;


--
-- Definition of table `expenses`
--

DROP TABLE IF EXISTS `expenses`;
CREATE TABLE `expenses` (
  `inv` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` datetime DEFAULT NULL,
  `Descr` varchar(45) DEFAULT NULL,
  `DRAmount` double DEFAULT NULL,
  `CRAmount` double DEFAULT NULL,
  `TK` varchar(10) DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  `TR` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`inv`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `expenses`
--

/*!40000 ALTER TABLE `expenses` DISABLE KEYS */;
/*!40000 ALTER TABLE `expenses` ENABLE KEYS */;


--
-- Definition of table `expsettings`
--

DROP TABLE IF EXISTS `expsettings`;
CREATE TABLE `expsettings` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `selct` varchar(2) NOT NULL DEFAULT 'F',
  `Descr` varchar(45) NOT NULL,
  `TK` varchar(45) NOT NULL DEFAULT 'UDF',
  `Del` varchar(4) NOT NULL DEFAULT 'T',
  `typ` varchar(4) NOT NULL DEFAULT 'O',
  `code` varchar(45) DEFAULT ' ',
  `Acc` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=70 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `expsettings`
--

/*!40000 ALTER TABLE `expsettings` DISABLE KEYS */;
INSERT INTO `expsettings` (`Id`,`selct`,`Descr`,`TK`,`Del`,`typ`,`code`,`Acc`) VALUES 
 (1,'','BANK CHARGES','CEXP','F','A',' ',4),
 (2,'','Uniform','INVSEX','F','F',' ',11),
 (3,'T','Salary Expenses','PEREXP','F','P',' ',7),
 (4,'T','Disposal Expenses','ADISP','F','A',' ',6),
 (5,'T','Consumed Items','UDF','F','G',' ',11),
 (6,'','Donation','DGIS','F','G',' ',8),
 (7,'T','Supplier Payment','SUPEX','F','A',' ',8),
 (8,'','Printing & Stationary','UDF','T','A',' ',8),
 (9,'','FARE','UDF','T','A',' ',8),
 (10,'','SITTING ALLOWANCE','UDF','T','M',' ',8),
 (11,'','FARM','UDF','T','F',' ',11),
 (12,'','TELEPHONE POSTAGE & AIRTIME','UDF','T','O',' ',11),
 (13,'','AUDITING AND ASSOCIATED FEE','UDF','T','O',' ',11),
 (15,'','FIXED ASSETS DEPRECIATION','UDF','T','A',' ',10),
 (16,'','COMPUTOR REPAIRS AND SERVICES','UDF','T','A',' ',11),
 (20,'','BOOKKEEPING','UDF','T','A',' ',11),
 (21,'','FOOD STUFF','UDF','T','A',' ',8),
 (22,'','NSSF','UDF','T','O',' ',7),
 (23,'','WELFARE','UDF','T','O',' ',7),
 (24,'','TITHE','UDF','T','O',' ',7),
 (25,'','SACCO','UDF','T','O',' ',7),
 (26,'','HELB','UDF','T','O',' ',7),
 (27,'','BUS Expenses','UDF','T','O',' ',11),
 (28,'','NHIF','UDF','T','O',' ',7),
 (29,'','BOG','UDF','T','O',' ',11),
 (30,'','PAYE','UDF','T','O',' ',7),
 (31,'','EDUCATIONAL','UDF','T','F',' ',11),
 (32,'','KITCHEN PETTY','UDF','T','O',' ',6),
 (33,'','REPAIR AND MAINTANANCE','UDF','T','F',' ',11),
 (34,'','STUDENT MED ACCOUNT','UDF','T','F',' ',11),
 (35,'','ELECTRICITY ACCOUNT','UDF','T','F',' ',11),
 (36,'','Activity','UDF','T','O',' ',11),
 (37,'','DEB LEVIES','UDF','T','O',' ',11),
 (38,'','Water Account','UDF','T','O',' ',11),
 (39,'','TEXT BOOK','UDF','T','F',' ',11),
 (40,'','Remidials ','UDF','T','F',' ',11),
 (41,'','MEDICAL ASSISTANCE','UDF','T','O',' ',11),
 (42,'','Miscllenious','UDF','T','F',' ',11),
 (43,'','Admin Expenses','UDF','T','F',' ',11),
 (44,'','CATEEN','UDF','T','O',' ',11),
 (45,'','Terminal benefit','UDF','T','F',' ',11),
 (46,'','exams','UDF','T','F',' ',11),
 (47,'','Pricegiving','UDF','T','F',' ',11),
 (48,'','Workers insurance','UDF','T','F',' ',11),
 (49,'','motivation for pupil/student','UDF','T','F',' ',11),
 (50,'','Boarding','UDF','T','F',' ',11),
 (51,'','Tuition','UDF','T','F',' ',11),
 (52,'','Electricity water &conservancy','UDF','T','F',' ',11),
 (53,'','Personal Emmolument','UDF','T','F',' ',11),
 (54,'','Building Expenses','UDF','T','F',' ',11),
 (55,'','Dairy Farm','UDF','T','F',' ',11),
 (56,'','SCHOOL CHOUR','UDF','T','F',' ',11),
 (57,'','Medical','UDF','T','F',' ',11),
 (58,'','RENT EXPENSE','UDF','T','F',' ',11),
 (59,'','Fees Refund','UDF','T','F',' ',11),
 (60,'','TOILET EXHASTION','UDF','T','F',' ',11),
 (61,'','HARAMBE','UDF','T','F',' ',11),
 (62,'','BOREHOLE ','UDF','T','F',' ',11),
 (63,'','STUDENT ID','UDF','T','F',' ',11),
 (65,'','WORKERS DEDUCTION','UDF','T','P',' ',11),
 (66,'','CKC LOAN','UDF','T','F',' ',11),
 (67,'','KCSE','UDF','T','F',' ',11),
 (68,'','STUDENT ACC','UDF','T','F',' ',11),
 (69,'','BUS INTEREST','UDF','T','F',' ',11);
/*!40000 ALTER TABLE `expsettings` ENABLE KEYS */;


--
-- Definition of table `exptrans`
--

DROP TABLE IF EXISTS `exptrans`;
CREATE TABLE `exptrans` (
  `expid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` varchar(45) NOT NULL,
  `Description` varchar(45) NOT NULL,
  `DrAmount` double DEFAULT NULL,
  `CrAmount` double DEFAULT NULL,
  `TK` varchar(10) DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  `AccId` int(10) unsigned DEFAULT NULL,
  `TransNo` varchar(45) DEFAULT NULL,
  `Qtr` int(10) unsigned NOT NULL DEFAULT '0',
  `Yr` int(10) unsigned NOT NULL DEFAULT '0',
  `TR` varchar(10) DEFAULT NULL,
  `SuppId` int(10) unsigned DEFAULT NULL,
  `Total` double DEFAULT NULL,
  `Paid` double DEFAULT NULL,
  `stats` varchar(45) DEFAULT 'P',
  PRIMARY KEY (`expid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `exptrans`
--

/*!40000 ALTER TABLE `exptrans` DISABLE KEYS */;
/*!40000 ALTER TABLE `exptrans` ENABLE KEYS */;


--
-- Definition of table `extrans`
--

DROP TABLE IF EXISTS `extrans`;
CREATE TABLE `extrans` (
  `expid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `suppId` int(10) unsigned NOT NULL,
  `TransNo` varchar(45) NOT NULL,
  `Amount` double DEFAULT NULL,
  `status` varchar(45) NOT NULL DEFAULT 'inProgress',
  `TrDate` datetime NOT NULL,
  `TAmount` double DEFAULT NULL,
  `AccId` int(10) unsigned NOT NULL,
  `Descr` varchar(45) DEFAULT NULL,
  `Tkind` varchar(45) NOT NULL DEFAULT 'P',
  `Initby` int(10) unsigned DEFAULT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`expid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `extrans`
--

/*!40000 ALTER TABLE `extrans` DISABLE KEYS */;
/*!40000 ALTER TABLE `extrans` ENABLE KEYS */;


--
-- Definition of table `extransdet`
--

DROP TABLE IF EXISTS `extransdet`;
CREATE TABLE `extransdet` (
  `no` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrNo` int(10) unsigned NOT NULL,
  `ItemId` int(10) unsigned NOT NULL,
  `qty` double NOT NULL,
  `Price` double NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `extransdet`
--

/*!40000 ALTER TABLE `extransdet` DISABLE KEYS */;
/*!40000 ALTER TABLE `extransdet` ENABLE KEYS */;


--
-- Definition of table `feeanalys`
--

DROP TABLE IF EXISTS `feeanalys`;
CREATE TABLE `feeanalys` (
  `AId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Category` varchar(45) DEFAULT NULL,
  `AmntFro` double DEFAULT NULL,
  `PrdFro` double DEFAULT NULL,
  `AmntTo` double DEFAULT NULL,
  `PrdTo` double DEFAULT NULL,
  PRIMARY KEY (`AId`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `feeanalys`
--

/*!40000 ALTER TABLE `feeanalys` DISABLE KEYS */;
INSERT INTO `feeanalys` (`AId`,`Category`,`AmntFro`,`PrdFro`,`AmntTo`,`PrdTo`) VALUES 
 (2,'Normal',0,0,8000,3),
 (3,'Watch',8001,4,0,0);
/*!40000 ALTER TABLE `feeanalys` ENABLE KEYS */;


--
-- Definition of table `feeanalysis`
--

DROP TABLE IF EXISTS `feeanalysis`;
CREATE TABLE `feeanalysis` (
  `GID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Normal` double DEFAULT NULL,
  `Watch` double DEFAULT NULL,
  `Substandard` double DEFAULT NULL,
  `Doubtful` double DEFAULT NULL,
  PRIMARY KEY (`GID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `feeanalysis`
--

/*!40000 ALTER TABLE `feeanalysis` DISABLE KEYS */;
/*!40000 ALTER TABLE `feeanalysis` ENABLE KEYS */;


--
-- Definition of table `feebdown`
--

DROP TABLE IF EXISTS `feebdown`;
CREATE TABLE `feebdown` (
  `stNo` int(10) unsigned DEFAULT NULL,
  `trId` int(10) unsigned DEFAULT NULL,
  `Disc` double DEFAULT NULL,
  `ItId` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `feebdown`
--

/*!40000 ALTER TABLE `feebdown` DISABLE KEYS */;
INSERT INTO `feebdown` (`stNo`,`trId`,`Disc`,`ItId`) VALUES 
 (5710,2,200,29);
/*!40000 ALTER TABLE `feebdown` ENABLE KEYS */;


--
-- Definition of table `feecommon`
--

DROP TABLE IF EXISTS `feecommon`;
CREATE TABLE `feecommon` (
  `TId` int(10) unsigned NOT NULL,
  `ItId` varchar(45) NOT NULL,
  `Amount` double NOT NULL,
  `Charge` varchar(5) NOT NULL DEFAULT 'A',
  `Typ` varchar(45) DEFAULT NULL,
  `CLId` int(10) unsigned DEFAULT NULL,
  `main` varchar(45) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `feecommon`
--

/*!40000 ALTER TABLE `feecommon` DISABLE KEYS */;
INSERT INTO `feecommon` (`TId`,`ItId`,`Amount`,`Charge`,`Typ`,`CLId`,`main`) VALUES 
 (21,'2',2000,'A','O',1,''),
 (21,'10',6000,'A','M',1,''),
 (21,'27',0,'A','O',1,''),
 (21,'28',0,'A','O',1,''),
 (21,'29',1000,'A','O',1,'');
/*!40000 ALTER TABLE `feecommon` ENABLE KEYS */;


--
-- Definition of table `feecommonhld`
--

DROP TABLE IF EXISTS `feecommonhld`;
CREATE TABLE `feecommonhld` (
  `TId` int(10) unsigned NOT NULL,
  `ItId` varchar(45) NOT NULL,
  `Amount` double NOT NULL,
  `Charge` varchar(5) NOT NULL DEFAULT 'A',
  `Typ` varchar(45) DEFAULT NULL,
  `CLId` int(10) unsigned DEFAULT NULL,
  `main` varchar(45) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `feecommonhld`
--

/*!40000 ALTER TABLE `feecommonhld` DISABLE KEYS */;
INSERT INTO `feecommonhld` (`TId`,`ItId`,`Amount`,`Charge`,`Typ`,`CLId`,`main`) VALUES 
 (21,'2',2000,'A','O',1,''),
 (21,'10',6000,'A','M',1,''),
 (21,'27',0,'A','O',1,''),
 (21,'28',0,'A','O',1,''),
 (21,'29',1000,'A','O',1,'');
/*!40000 ALTER TABLE `feecommonhld` ENABLE KEYS */;


--
-- Definition of table `feecommonold`
--

DROP TABLE IF EXISTS `feecommonold`;
CREATE TABLE `feecommonold` (
  `TId` int(10) unsigned NOT NULL,
  `ItId` varchar(45) NOT NULL,
  `Amount` double NOT NULL,
  `Charge` varchar(5) NOT NULL DEFAULT 'A',
  `Typ` varchar(45) DEFAULT NULL,
  `CLId` int(10) unsigned DEFAULT NULL,
  `main` varchar(45) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `feecommonold`
--

/*!40000 ALTER TABLE `feecommonold` DISABLE KEYS */;
/*!40000 ALTER TABLE `feecommonold` ENABLE KEYS */;


--
-- Definition of table `feeoptional`
--

DROP TABLE IF EXISTS `feeoptional`;
CREATE TABLE `feeoptional` (
  `cmId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `FID` int(10) unsigned NOT NULL,
  `Items` varchar(45) NOT NULL,
  `Amount` double NOT NULL,
  `Charge` varchar(5) NOT NULL DEFAULT 'A',
  PRIMARY KEY (`cmId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `feeoptional`
--

/*!40000 ALTER TABLE `feeoptional` DISABLE KEYS */;
/*!40000 ALTER TABLE `feeoptional` ENABLE KEYS */;


--
-- Definition of table `feesdisc`
--

DROP TABLE IF EXISTS `feesdisc`;
CREATE TABLE `feesdisc` (
  `DicID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Descr` text,
  `ExpId` int(10) unsigned DEFAULT NULL,
  `Amount` double DEFAULT NULL,
  PRIMARY KEY (`DicID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `feesdisc`
--

/*!40000 ALTER TABLE `feesdisc` DISABLE KEYS */;
INSERT INTO `feesdisc` (`DicID`,`Descr`,`ExpId`,`Amount`) VALUES 
 (1,'WORKERS EDUCATION ALLOWANCE',3,NULL),
 (2,'EDUCATION ASSISTANCE',31,NULL);
/*!40000 ALTER TABLE `feesdisc` ENABLE KEYS */;


--
-- Definition of table `feesitems`
--

DROP TABLE IF EXISTS `feesitems`;
CREATE TABLE `feesitems` (
  `ItId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Descr` text,
  `Amount` double DEFAULT NULL,
  `IncId` int(10) unsigned DEFAULT NULL,
  `repeate` varchar(4) NOT NULL DEFAULT 'N',
  `prior` int(10) unsigned DEFAULT NULL,
  `main` varchar(45) NOT NULL DEFAULT 'N',
  `sbf` varchar(4) DEFAULT NULL,
  PRIMARY KEY (`ItId`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `feesitems`
--

/*!40000 ALTER TABLE `feesitems` DISABLE KEYS */;
INSERT INTO `feesitems` (`ItId`,`Descr`,`Amount`,`IncId`,`repeate`,`prior`,`main`,`sbf`) VALUES 
 (2,'ADMISSION',2000,60,'N',1,'N',NULL),
 (10,'TUITION FEE',6000,61,'N',2,'Y',NULL),
 (27,'ARREARS',0,61,'N',1,'N',NULL),
 (28,'UNIFORM',0,62,'N',1,'Y',NULL),
 (29,'TRANSPORT',1000,65,'Y',1,'Y','T');
/*!40000 ALTER TABLE `feesitems` ENABLE KEYS */;


--
-- Definition of table `feespenalt`
--

DROP TABLE IF EXISTS `feespenalt`;
CREATE TABLE `feespenalt` (
  `PenId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Descr` text,
  PRIMARY KEY (`PenId`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `feespenalt`
--

/*!40000 ALTER TABLE `feespenalt` DISABLE KEYS */;
INSERT INTO `feespenalt` (`PenId`,`Descr`) VALUES 
 (6,'Sneaking Fee');
/*!40000 ALTER TABLE `feespenalt` ENABLE KEYS */;


--
-- Definition of table `feestbal`
--

DROP TABLE IF EXISTS `feestbal`;
CREATE TABLE `feestbal` (
  `colId` varchar(200) NOT NULL DEFAULT '',
  `bal` double DEFAULT NULL,
  PRIMARY KEY (`colId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `feestbal`
--

/*!40000 ALTER TABLE `feestbal` DISABLE KEYS */;
/*!40000 ALTER TABLE `feestbal` ENABLE KEYS */;


--
-- Definition of table `feestrans`
--

DROP TABLE IF EXISTS `feestrans`;
CREATE TABLE `feestrans` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ItId` int(10) unsigned DEFAULT NULL,
  `TK` varchar(10) NOT NULL,
  `TRDATE` datetime NOT NULL,
  `TRANSNO` varchar(45) DEFAULT NULL,
  `CRAMOUNT` double DEFAULT NULL,
  `DRAMOUNT` double DEFAULT NULL,
  `STNO` int(10) unsigned NOT NULL,
  `DESCRIPTION` varchar(45) DEFAULT NULL,
  `TR` varchar(10) DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  `TID` int(10) unsigned DEFAULT NULL,
  `STATE` varchar(10) DEFAULT NULL,
  `DOCNO` varchar(45) DEFAULT NULL,
  `AccId` int(10) unsigned DEFAULT NULL,
  `BrId` int(10) unsigned DEFAULT NULL,
  `ConBy` int(10) unsigned DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `CertBy` int(10) unsigned DEFAULT NULL,
  `AppBy` int(10) unsigned DEFAULT NULL,
  `PayBy` varchar(65) DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  `CanRea` text,
  `Charges` double DEFAULT NULL,
  `clid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `feestrans`
--

/*!40000 ALTER TABLE `feestrans` DISABLE KEYS */;
/*!40000 ALTER TABLE `feestrans` ENABLE KEYS */;


--
-- Definition of table `feestransdet`
--

DROP TABLE IF EXISTS `feestransdet`;
CREATE TABLE `feestransdet` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ItId` int(10) unsigned DEFAULT NULL,
  `TK` varchar(10) NOT NULL,
  `TRDATE` datetime NOT NULL,
  `TRANSNO` varchar(45) DEFAULT NULL,
  `CRAMOUNT` double DEFAULT NULL,
  `DRAMOUNT` double DEFAULT NULL,
  `STNO` int(10) unsigned NOT NULL,
  `DESCRIPTION` varchar(45) DEFAULT NULL,
  `TR` varchar(10) DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  `TID` int(10) unsigned DEFAULT NULL,
  `STATE` varchar(10) DEFAULT NULL,
  `DOCNO` varchar(45) DEFAULT NULL,
  `AccId` int(10) unsigned DEFAULT NULL,
  `BrId` int(10) unsigned DEFAULT NULL,
  `ConBy` int(10) unsigned DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `CertBy` int(10) unsigned DEFAULT NULL,
  `AppBy` int(10) unsigned DEFAULT NULL,
  `PayBy` varchar(65) DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  `CanRea` text,
  `Charges` double DEFAULT NULL,
  `clid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `feestransdet`
--

/*!40000 ALTER TABLE `feestransdet` DISABLE KEYS */;
/*!40000 ALTER TABLE `feestransdet` ENABLE KEYS */;


--
-- Definition of table `feestransold`
--

DROP TABLE IF EXISTS `feestransold`;
CREATE TABLE `feestransold` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ItId` int(10) unsigned DEFAULT NULL,
  `TK` varchar(10) NOT NULL,
  `TRDATE` datetime NOT NULL,
  `TRANSNO` varchar(45) DEFAULT NULL,
  `CRAMOUNT` double DEFAULT NULL,
  `DRAMOUNT` double DEFAULT NULL,
  `STNO` int(10) unsigned NOT NULL,
  `DESCRIPTION` varchar(45) DEFAULT NULL,
  `TR` varchar(10) DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  `TID` int(10) unsigned DEFAULT NULL,
  `STATE` varchar(10) DEFAULT NULL,
  `DOCNO` varchar(45) DEFAULT NULL,
  `AccId` int(10) unsigned DEFAULT NULL,
  `BrId` int(10) unsigned DEFAULT NULL,
  `ConBy` int(10) unsigned DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `CertBy` int(10) unsigned DEFAULT NULL,
  `AppBy` int(10) unsigned DEFAULT NULL,
  `PayBy` varchar(65) DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  `CanRea` text,
  `Charges` double DEFAULT NULL,
  `clid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `feestransold`
--

/*!40000 ALTER TABLE `feestransold` DISABLE KEYS */;
/*!40000 ALTER TABLE `feestransold` ENABLE KEYS */;


--
-- Definition of table `feestructure`
--

DROP TABLE IF EXISTS `feestructure`;
CREATE TABLE `feestructure` (
  `FID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `CLID` int(10) unsigned NOT NULL,
  `TID` int(10) unsigned NOT NULL,
  `FDATE` datetime NOT NULL,
  PRIMARY KEY (`FID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `feestructure`
--

/*!40000 ALTER TABLE `feestructure` DISABLE KEYS */;
/*!40000 ALTER TABLE `feestructure` ENABLE KEYS */;


--
-- Definition of table `feetmbal`
--

DROP TABLE IF EXISTS `feetmbal`;
CREATE TABLE `feetmbal` (
  `colId` varchar(200) NOT NULL DEFAULT '',
  `drbal` double DEFAULT NULL,
  `crbal` double DEFAULT NULL,
  PRIMARY KEY (`colId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `feetmbal`
--

/*!40000 ALTER TABLE `feetmbal` DISABLE KEYS */;
/*!40000 ALTER TABLE `feetmbal` ENABLE KEYS */;


--
-- Definition of table `feetransport`
--

DROP TABLE IF EXISTS `feetransport`;
CREATE TABLE `feetransport` (
  `trId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Descr` varchar(45) DEFAULT NULL,
  `Amount` double DEFAULT NULL,
  `ItId` int(11) DEFAULT NULL,
  PRIMARY KEY (`trId`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `feetransport`
--

/*!40000 ALTER TABLE `feetransport` DISABLE KEYS */;
INSERT INTO `feetransport` (`trId`,`Descr`,`Amount`,`ItId`) VALUES 
 (1,'Transport 1',2000,29),
 (2,'Transport 2',5000,29);
/*!40000 ALTER TABLE `feetransport` ENABLE KEYS */;


--
-- Definition of table `finsettings`
--

DROP TABLE IF EXISTS `finsettings`;
CREATE TABLE `finsettings` (
  `Yrs` int(10) unsigned NOT NULL,
  `tax` double DEFAULT NULL,
  `strefund` double DEFAULT NULL,
  `savint` double DEFAULT NULL,
  `specint` double DEFAULT NULL,
  `nonint` double DEFAULT NULL,
  `divident` double DEFAULT NULL,
  PRIMARY KEY (`Yrs`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `finsettings`
--

/*!40000 ALTER TABLE `finsettings` DISABLE KEYS */;
INSERT INTO `finsettings` (`Yrs`,`tax`,`strefund`,`savint`,`specint`,`nonint`,`divident`) VALUES 
 (2012,0,0,0,0,0,0);
/*!40000 ALTER TABLE `finsettings` ENABLE KEYS */;


--
-- Definition of table `fxasset`
--

DROP TABLE IF EXISTS `fxasset`;
CREATE TABLE `fxasset` (
  `AsId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Descr` varchar(60) NOT NULL,
  `PDate` datetime NOT NULL,
  `Cost` float DEFAULT '0',
  `DepMethod` varchar(10) NOT NULL,
  `ResidualValue` float NOT NULL DEFAULT '0',
  `AssetAcct` varchar(10) NOT NULL,
  `AssetSub` varchar(24) NOT NULL,
  `DepAcct` varchar(10) NOT NULL,
  `DepSub` varchar(24) NOT NULL,
  `RevAcct` varchar(10) NOT NULL,
  `RevSub` varchar(24) NOT NULL,
  `DispAcct` varchar(10) NOT NULL,
  `DispSub` varchar(24) NOT NULL,
  `ClassID` int(10) unsigned NOT NULL,
  `depdate` date DEFAULT NULL,
  `currentvalue` float DEFAULT NULL,
  `deppercent` float DEFAULT NULL,
  `transtatus` varchar(1) NOT NULL,
  `AssetNumber` varchar(45) NOT NULL,
  `PurchAcct` varchar(45) NOT NULL,
  `PurchSub` varchar(45) NOT NULL,
  `transtype` varchar(5) NOT NULL,
  `SuppId` int(10) unsigned DEFAULT NULL,
  `Paid` double DEFAULT NULL,
  `state` varchar(4) NOT NULL DEFAULT 'A',
  `InvNo` varchar(45) DEFAULT NULL,
  `SerialNo` varchar(45) DEFAULT NULL,
  `ModelNo` varchar(45) DEFAULT NULL,
  `Manufact` varchar(45) DEFAULT NULL,
  `Comment` text,
  `Dsposed` varchar(4) NOT NULL DEFAULT 'F',
  `DispDate` datetime DEFAULT NULL,
  `DispAmount` double DEFAULT NULL,
  `Typ` varchar(4) DEFAULT NULL,
  `balance` double DEFAULT NULL,
  `code` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`AsId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `fxasset`
--

/*!40000 ALTER TABLE `fxasset` DISABLE KEYS */;
/*!40000 ALTER TABLE `fxasset` ENABLE KEYS */;


--
-- Definition of table `fxassettrans`
--

DROP TABLE IF EXISTS `fxassettrans`;
CREATE TABLE `fxassettrans` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `AsId` int(10) unsigned NOT NULL,
  `TrDate` datetime DEFAULT NULL,
  `Descr` varchar(45) DEFAULT NULL,
  `DrAmount` double DEFAULT NULL,
  `CrAmount` double DEFAULT NULL,
  `TK` varchar(45) DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  `TransNo` varchar(45) DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  `CanRea` text,
  `Charge` double DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `fxassettrans`
--

/*!40000 ALTER TABLE `fxassettrans` DISABLE KEYS */;
/*!40000 ALTER TABLE `fxassettrans` ENABLE KEYS */;


--
-- Definition of table `fxclass`
--

DROP TABLE IF EXISTS `fxclass`;
CREATE TABLE `fxclass` (
  `ClassID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Descr` varchar(45) NOT NULL,
  `longDescr` text,
  PRIMARY KEY (`ClassID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `fxclass`
--

/*!40000 ALTER TABLE `fxclass` DISABLE KEYS */;
/*!40000 ALTER TABLE `fxclass` ENABLE KEYS */;


--
-- Definition of table `fxdepmethods`
--

DROP TABLE IF EXISTS `fxdepmethods`;
CREATE TABLE `fxdepmethods` (
  `MethodID` varchar(1) NOT NULL,
  `Descr` varchar(30) NOT NULL,
  `DiminishingValue` tinyint(1) NOT NULL,
  PRIMARY KEY (`MethodID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `fxdepmethods`
--

/*!40000 ALTER TABLE `fxdepmethods` DISABLE KEYS */;
/*!40000 ALTER TABLE `fxdepmethods` ENABLE KEYS */;


--
-- Definition of table `fxdepreciation`
--

DROP TABLE IF EXISTS `fxdepreciation`;
CREATE TABLE `fxdepreciation` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` date DEFAULT NULL,
  `AsId` int(10) unsigned DEFAULT NULL,
  `CRAmount` double DEFAULT NULL,
  `DRAmount` double DEFAULT '0',
  `description` varchar(45) DEFAULT NULL,
  `TransNo` int(45) unsigned DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  `TK` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `fxdepreciation`
--

/*!40000 ALTER TABLE `fxdepreciation` DISABLE KEYS */;
/*!40000 ALTER TABLE `fxdepreciation` ENABLE KEYS */;


--
-- Definition of table `fxdisposal`
--

DROP TABLE IF EXISTS `fxdisposal`;
CREATE TABLE `fxdisposal` (
  `recid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `assetcode` varchar(15) NOT NULL,
  `trandate` date NOT NULL,
  `disposalvalue` float DEFAULT NULL,
  `customer` varchar(20) DEFAULT NULL,
  `descr` varchar(30) DEFAULT NULL,
  `disposalcode` varchar(10) NOT NULL,
  `CONFIRMED` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`recid`,`disposalcode`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `fxdisposal`
--

/*!40000 ALTER TABLE `fxdisposal` DISABLE KEYS */;
/*!40000 ALTER TABLE `fxdisposal` ENABLE KEYS */;


--
-- Definition of table `fxreceipts`
--

DROP TABLE IF EXISTS `fxreceipts`;
CREATE TABLE `fxreceipts` (
  `receiptno` varchar(15) NOT NULL,
  `trandate` date NOT NULL,
  `assetcode` varchar(15) NOT NULL,
  `value` float DEFAULT NULL,
  `descr` char(45) DEFAULT NULL,
  `recid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `confirmed` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`recid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `fxreceipts`
--

/*!40000 ALTER TABLE `fxreceipts` DISABLE KEYS */;
/*!40000 ALTER TABLE `fxreceipts` ENABLE KEYS */;


--
-- Definition of table `fxrevaluation`
--

DROP TABLE IF EXISTS `fxrevaluation`;
CREATE TABLE `fxrevaluation` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` date DEFAULT NULL,
  `AsId` int(10) unsigned DEFAULT NULL,
  `CRAmount` double DEFAULT NULL,
  `DRAmount` double DEFAULT '0',
  `description` varchar(45) DEFAULT NULL,
  `TransNo` int(45) unsigned DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  `TK` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `fxrevaluation`
--

/*!40000 ALTER TABLE `fxrevaluation` DISABLE KEYS */;
/*!40000 ALTER TABLE `fxrevaluation` ENABLE KEYS */;


--
-- Definition of table `hdsubjtm`
--

DROP TABLE IF EXISTS `hdsubjtm`;
CREATE TABLE `hdsubjtm` (
  `tfrm` varchar(45) DEFAULT NULL,
  `tto` varchar(45) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `hdsubjtm`
--

/*!40000 ALTER TABLE `hdsubjtm` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdsubjtm` ENABLE KEYS */;


--
-- Definition of table `hld_loanadd`
--

DROP TABLE IF EXISTS `hld_loanadd`;
CREATE TABLE `hld_loanadd` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `loanid` int(10) unsigned DEFAULT NULL,
  `MemberId` int(10) unsigned DEFAULT NULL,
  `Amnt` double DEFAULT NULL,
  `RecId` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `hld_loanadd`
--

/*!40000 ALTER TABLE `hld_loanadd` DISABLE KEYS */;
/*!40000 ALTER TABLE `hld_loanadd` ENABLE KEYS */;


--
-- Definition of table `hld_loanbalcl`
--

DROP TABLE IF EXISTS `hld_loanbalcl`;
CREATE TABLE `hld_loanbalcl` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `loanid` int(10) unsigned DEFAULT NULL,
  `MemberId` int(10) unsigned DEFAULT NULL,
  `Amnt` double DEFAULT NULL,
  `RecId` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `hld_loanbalcl`
--

/*!40000 ALTER TABLE `hld_loanbalcl` DISABLE KEYS */;
/*!40000 ALTER TABLE `hld_loanbalcl` ENABLE KEYS */;


--
-- Definition of table `hld_loanbaldff`
--

DROP TABLE IF EXISTS `hld_loanbaldff`;
CREATE TABLE `hld_loanbaldff` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `loanid` int(10) unsigned DEFAULT NULL,
  `MemberId` int(10) unsigned DEFAULT NULL,
  `DrAmnt` double DEFAULT NULL,
  `CrAmnt` double DEFAULT NULL,
  `RecId` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=272 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `hld_loanbaldff`
--

/*!40000 ALTER TABLE `hld_loanbaldff` DISABLE KEYS */;
/*!40000 ALTER TABLE `hld_loanbaldff` ENABLE KEYS */;


--
-- Definition of table `hld_loanbalop`
--

DROP TABLE IF EXISTS `hld_loanbalop`;
CREATE TABLE `hld_loanbalop` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `loanid` int(10) unsigned DEFAULT NULL,
  `MemberId` int(10) unsigned DEFAULT NULL,
  `Amnt` double DEFAULT NULL,
  `RecId` int(10) unsigned DEFAULT NULL,
  `loanAdd` double DEFAULT NULL,
  `loanpaid` double DEFAULT NULL,
  `LoanBal` double DEFAULT NULL,
  `trdate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=272 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `hld_loanbalop`
--

/*!40000 ALTER TABLE `hld_loanbalop` DISABLE KEYS */;
/*!40000 ALTER TABLE `hld_loanbalop` ENABLE KEYS */;


--
-- Definition of table `hld_loanpaid`
--

DROP TABLE IF EXISTS `hld_loanpaid`;
CREATE TABLE `hld_loanpaid` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `loanid` int(10) unsigned DEFAULT NULL,
  `MemberId` int(10) unsigned DEFAULT NULL,
  `Amnt` double DEFAULT NULL,
  `RecId` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `hld_loanpaid`
--

/*!40000 ALTER TABLE `hld_loanpaid` DISABLE KEYS */;
/*!40000 ALTER TABLE `hld_loanpaid` ENABLE KEYS */;


--
-- Definition of table `incbudget`
--

DROP TABLE IF EXISTS `incbudget`;
CREATE TABLE `incbudget` (
  `Yrsinc` varchar(45) NOT NULL,
  `budget` double DEFAULT NULL,
  `Actual` double DEFAULT NULL,
  PRIMARY KEY (`Yrsinc`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `incbudget`
--

/*!40000 ALTER TABLE `incbudget` DISABLE KEYS */;
/*!40000 ALTER TABLE `incbudget` ENABLE KEYS */;


--
-- Definition of table `inccategory`
--

DROP TABLE IF EXISTS `inccategory`;
CREATE TABLE `inccategory` (
  `Acc` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Descr` varchar(100) NOT NULL,
  PRIMARY KEY (`Acc`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `inccategory`
--

/*!40000 ALTER TABLE `inccategory` DISABLE KEYS */;
INSERT INTO `inccategory` (`Acc`,`Descr`) VALUES 
 (1,'Interest on Loan Portfolio'),
 (2,'Fees & Commission on Loan Portfolio'),
 (3,'Government Securities'),
 (4,'Deposit with Banks and Other Financial Inst.'),
 (5,'Other Investments - dividend & Interest incomes from investments'),
 (6,'Other Operating Income- Salary processing fees, transaction fees, membership fees'),
 (7,'Non-Operating Income'),
 (8,'Donations');
/*!40000 ALTER TABLE `inccategory` ENABLE KEYS */;


--
-- Definition of table `income`
--

DROP TABLE IF EXISTS `income`;
CREATE TABLE `income` (
  `inv` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` datetime DEFAULT NULL,
  `Descr` varchar(45) DEFAULT NULL,
  `DRAmount` double DEFAULT NULL,
  `CRAmount` double DEFAULT NULL,
  `TK` varchar(10) DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`inv`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `income`
--

/*!40000 ALTER TABLE `income` DISABLE KEYS */;
/*!40000 ALTER TABLE `income` ENABLE KEYS */;


--
-- Definition of table `incsettings`
--

DROP TABLE IF EXISTS `incsettings`;
CREATE TABLE `incsettings` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `selct` varchar(2) NOT NULL DEFAULT 'F',
  `Descr` varchar(45) NOT NULL,
  `TK` varchar(45) NOT NULL DEFAULT 'UDF',
  `Del` varchar(4) NOT NULL DEFAULT 'T',
  `typ` varchar(4) NOT NULL DEFAULT 'O',
  `code` varchar(45) DEFAULT NULL,
  `Acc` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `incsettings`
--

/*!40000 ALTER TABLE `incsettings` DISABLE KEYS */;
INSERT INTO `incsettings` (`Id`,`selct`,`Descr`,`TK`,`Del`,`typ`,`code`,`Acc`) VALUES 
 (0,'','Accrued Fees','UDF','F','I',NULL,7),
 (2,'T','Interest From Bank','CINC','F','I',NULL,NULL),
 (3,'F','Interest From Investments','INVSIT','F','I',NULL,NULL),
 (60,'F','ADMISSION','UDF','T','O',NULL,4),
 (61,'F','TUITION FEE','UDF','T','O',NULL,4),
 (62,'F','UNIFORM','UDF','T','O',NULL,4),
 (65,'F','TRANSPORT','UDF','T','O',NULL,4);
/*!40000 ALTER TABLE `incsettings` ENABLE KEYS */;


--
-- Definition of table `inctrans`
--

DROP TABLE IF EXISTS `inctrans`;
CREATE TABLE `inctrans` (
  `incid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` varchar(45) NOT NULL,
  `Description` varchar(45) NOT NULL,
  `DrAmount` double DEFAULT NULL,
  `CrAmount` double DEFAULT NULL,
  `TK` varchar(10) DEFAULT NULL,
  `TKNO` int(10) unsigned DEFAULT NULL,
  `TransNo` varchar(45) DEFAULT NULL,
  `TR` varchar(45) DEFAULT NULL,
  `stNo` int(10) unsigned DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  `AccId` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`incid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `inctrans`
--

/*!40000 ALTER TABLE `inctrans` DISABLE KEYS */;
/*!40000 ALTER TABLE `inctrans` ENABLE KEYS */;


--
-- Definition of table `interestpaid`
--

DROP TABLE IF EXISTS `interestpaid`;
CREATE TABLE `interestpaid` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` varchar(45) NOT NULL,
  `TransNo` varchar(45) DEFAULT NULL,
  `Description` varchar(45) NOT NULL,
  `DrAmount` double DEFAULT NULL,
  `CrAmount` double DEFAULT NULL,
  `TK` varchar(10) DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `interestpaid`
--

/*!40000 ALTER TABLE `interestpaid` DISABLE KEYS */;
/*!40000 ALTER TABLE `interestpaid` ENABLE KEYS */;


--
-- Definition of table `invconsumeord`
--

DROP TABLE IF EXISTS `invconsumeord`;
CREATE TABLE `invconsumeord` (
  `consId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `EmpId` int(10) unsigned DEFAULT NULL,
  `TrDate` datetime DEFAULT NULL,
  `Descr` varchar(45) DEFAULT NULL,
  `Total` double DEFAULT NULL,
  `Paid` double DEFAULT NULL,
  `TransNo` varchar(45) DEFAULT NULL,
  `stats` varchar(5) NOT NULL DEFAULT 'P',
  `Initby` int(10) unsigned DEFAULT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  `DepId` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`consId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `invconsumeord`
--

/*!40000 ALTER TABLE `invconsumeord` DISABLE KEYS */;
/*!40000 ALTER TABLE `invconsumeord` ENABLE KEYS */;


--
-- Definition of table `inventcostgsold`
--

DROP TABLE IF EXISTS `inventcostgsold`;
CREATE TABLE `inventcostgsold` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` datetime DEFAULT NULL,
  `Descr` varchar(45) DEFAULT NULL,
  `DrAmount` double DEFAULT NULL,
  `CrAmount` double DEFAULT NULL,
  `TK` varchar(10) DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `inventcostgsold`
--

/*!40000 ALTER TABLE `inventcostgsold` DISABLE KEYS */;
/*!40000 ALTER TABLE `inventcostgsold` ENABLE KEYS */;


--
-- Definition of table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
CREATE TABLE `inventory` (
  `inv` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` datetime DEFAULT NULL,
  `Descr` varchar(45) DEFAULT NULL,
  `DRAmount` double DEFAULT NULL,
  `CRAmount` double DEFAULT NULL,
  `TK` varchar(10) DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`inv`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `inventory`
--

/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;


--
-- Definition of table `inventreturninw`
--

DROP TABLE IF EXISTS `inventreturninw`;
CREATE TABLE `inventreturninw` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` datetime DEFAULT NULL,
  `Descr` varchar(45) DEFAULT NULL,
  `DrAmount` double DEFAULT NULL,
  `CrAmount` double DEFAULT NULL,
  `TK` varchar(10) DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `inventreturninw`
--

/*!40000 ALTER TABLE `inventreturninw` DISABLE KEYS */;
/*!40000 ALTER TABLE `inventreturninw` ENABLE KEYS */;


--
-- Definition of table `inventreturnoutw`
--

DROP TABLE IF EXISTS `inventreturnoutw`;
CREATE TABLE `inventreturnoutw` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` datetime DEFAULT NULL,
  `Descr` varchar(45) DEFAULT NULL,
  `DrAmount` double DEFAULT NULL,
  `CrAmount` double DEFAULT NULL,
  `TK` varchar(10) DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `inventreturnoutw`
--

/*!40000 ALTER TABLE `inventreturnoutw` DISABLE KEYS */;
/*!40000 ALTER TABLE `inventreturnoutw` ENABLE KEYS */;


--
-- Definition of table `inventsales`
--

DROP TABLE IF EXISTS `inventsales`;
CREATE TABLE `inventsales` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` datetime DEFAULT NULL,
  `Descr` varchar(45) DEFAULT NULL,
  `DrAmount` double DEFAULT NULL,
  `CrAmount` double DEFAULT NULL,
  `TK` varchar(10) DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `inventsales`
--

/*!40000 ALTER TABLE `inventsales` DISABLE KEYS */;
/*!40000 ALTER TABLE `inventsales` ENABLE KEYS */;


--
-- Definition of table `inventstockadj`
--

DROP TABLE IF EXISTS `inventstockadj`;
CREATE TABLE `inventstockadj` (
  `AdjId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` datetime DEFAULT NULL,
  `Descr` varchar(45) DEFAULT NULL,
  `DrAmount` double DEFAULT NULL,
  `CrAmount` double DEFAULT NULL,
  `TK` varchar(10) DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`AdjId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `inventstockadj`
--

/*!40000 ALTER TABLE `inventstockadj` DISABLE KEYS */;
/*!40000 ALTER TABLE `inventstockadj` ENABLE KEYS */;


--
-- Definition of table `invesmentshare`
--

DROP TABLE IF EXISTS `invesmentshare`;
CREATE TABLE `invesmentshare` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` varchar(45) NOT NULL,
  `InvId` int(10) unsigned DEFAULT NULL,
  `TransNo` varchar(45) DEFAULT NULL,
  `Description` varchar(45) NOT NULL,
  `DrShare` double DEFAULT NULL,
  `CrShare` double DEFAULT NULL,
  `TK` varchar(10) DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  `shVal` double DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `invesmentshare`
--

/*!40000 ALTER TABLE `invesmentshare` DISABLE KEYS */;
/*!40000 ALTER TABLE `invesmentshare` ENABLE KEYS */;


--
-- Definition of table `invesmenttrans`
--

DROP TABLE IF EXISTS `invesmenttrans`;
CREATE TABLE `invesmenttrans` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` varchar(45) NOT NULL,
  `InvId` int(10) unsigned DEFAULT NULL,
  `TransNo` varchar(45) DEFAULT NULL,
  `Description` varchar(45) NOT NULL,
  `DrAmount` double DEFAULT NULL,
  `CrAmount` double DEFAULT NULL,
  `TK` varchar(10) DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `invesmenttrans`
--

/*!40000 ALTER TABLE `invesmenttrans` DISABLE KEYS */;
/*!40000 ALTER TABLE `invesmenttrans` ENABLE KEYS */;


--
-- Definition of table `investment`
--

DROP TABLE IF EXISTS `investment`;
CREATE TABLE `investment` (
  `InvId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Descr` text NOT NULL,
  `invest` varchar(35) NOT NULL,
  `typ` varchar(4) DEFAULT NULL,
  `opBal` double DEFAULT NULL,
  `opDate` datetime DEFAULT NULL,
  `opShare` double DEFAULT NULL,
  `shVal` double DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  `code` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`InvId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `investment`
--

/*!40000 ALTER TABLE `investment` DISABLE KEYS */;
/*!40000 ALTER TABLE `investment` ENABLE KEYS */;


--
-- Definition of table `investrans`
--

DROP TABLE IF EXISTS `investrans`;
CREATE TABLE `investrans` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` varchar(45) NOT NULL,
  `Descr` varchar(45) DEFAULT NULL,
  `DrAmount` double DEFAULT NULL,
  `CrAmount` double DEFAULT NULL,
  `TK` varchar(10) DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `investrans`
--

/*!40000 ALTER TABLE `investrans` DISABLE KEYS */;
/*!40000 ALTER TABLE `investrans` ENABLE KEYS */;


--
-- Definition of table `investshare`
--

DROP TABLE IF EXISTS `investshare`;
CREATE TABLE `investshare` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` varchar(45) NOT NULL,
  `Descr` varchar(45) DEFAULT NULL,
  `DrAmount` double DEFAULT NULL,
  `CrAmount` double DEFAULT NULL,
  `TK` varchar(10) DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `investshare`
--

/*!40000 ALTER TABLE `investshare` DISABLE KEYS */;
/*!40000 ALTER TABLE `investshare` ENABLE KEYS */;


--
-- Definition of table `invpurchaseord`
--

DROP TABLE IF EXISTS `invpurchaseord`;
CREATE TABLE `invpurchaseord` (
  `PurId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `SuppId` int(10) unsigned DEFAULT NULL,
  `TrDate` datetime DEFAULT NULL,
  `Descr` varchar(45) DEFAULT NULL,
  `Total` double DEFAULT NULL,
  `Paid` double DEFAULT NULL,
  `TransNo` varchar(45) DEFAULT NULL,
  `stats` varchar(5) NOT NULL DEFAULT 'P',
  `Initby` int(10) unsigned DEFAULT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  `AccId` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`PurId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `invpurchaseord`
--

/*!40000 ALTER TABLE `invpurchaseord` DISABLE KEYS */;
/*!40000 ALTER TABLE `invpurchaseord` ENABLE KEYS */;


--
-- Definition of table `invsalesord`
--

DROP TABLE IF EXISTS `invsalesord`;
CREATE TABLE `invsalesord` (
  `salId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `CustId` int(10) unsigned DEFAULT NULL,
  `TrDate` datetime DEFAULT NULL,
  `Descr` varchar(45) DEFAULT NULL,
  `Total` double DEFAULT NULL,
  `Paid` double DEFAULT NULL,
  `TransNo` varchar(45) DEFAULT NULL,
  `stats` varchar(5) NOT NULL DEFAULT 'P',
  `Initby` int(10) unsigned DEFAULT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  `AccId` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`salId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `invsalesord`
--

/*!40000 ALTER TABLE `invsalesord` DISABLE KEYS */;
/*!40000 ALTER TABLE `invsalesord` ENABLE KEYS */;


--
-- Definition of table `itemadjust`
--

DROP TABLE IF EXISTS `itemadjust`;
CREATE TABLE `itemadjust` (
  `adjid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ItemId` int(10) unsigned NOT NULL,
  `strId` int(10) unsigned NOT NULL,
  `QtyBf` double NOT NULL,
  `QtyAfter` double NOT NULL,
  `TrDate` datetime NOT NULL,
  `Descr` varchar(45) NOT NULL,
  PRIMARY KEY (`adjid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `itemadjust`
--

/*!40000 ALTER TABLE `itemadjust` DISABLE KEYS */;
/*!40000 ALTER TABLE `itemadjust` ENABLE KEYS */;


--
-- Definition of table `itemcategory`
--

DROP TABLE IF EXISTS `itemcategory`;
CREATE TABLE `itemcategory` (
  `CatId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Descr` varchar(45) NOT NULL,
  `Typ` varchar(5) NOT NULL DEFAULT 'P',
  PRIMARY KEY (`CatId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `itemcategory`
--

/*!40000 ALTER TABLE `itemcategory` DISABLE KEYS */;
/*!40000 ALTER TABLE `itemcategory` ENABLE KEYS */;


--
-- Definition of table `itemcomp`
--

DROP TABLE IF EXISTS `itemcomp`;
CREATE TABLE `itemcomp` (
  `cId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Descr` varchar(45) NOT NULL,
  PRIMARY KEY (`cId`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `itemcomp`
--

/*!40000 ALTER TABLE `itemcomp` DISABLE KEYS */;
INSERT INTO `itemcomp` (`cId`,`Descr`) VALUES 
 (1,'KITCHEN'),
 (2,'SCH BUS & VAN'),
 (3,'COMPUTER'),
 (4,'MUSIC');
/*!40000 ALTER TABLE `itemcomp` ENABLE KEYS */;


--
-- Definition of table `itemcomptrans`
--

DROP TABLE IF EXISTS `itemcomptrans`;
CREATE TABLE `itemcomptrans` (
  `cl` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `CId` int(10) unsigned DEFAULT NULL,
  `AccId` int(10) unsigned DEFAULT NULL,
  `TK` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`cl`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `itemcomptrans`
--

/*!40000 ALTER TABLE `itemcomptrans` DISABLE KEYS */;
INSERT INTO `itemcomptrans` (`cl`,`CId`,`AccId`,`TK`) VALUES 
 (1,1,1,'INC'),
 (2,1,18,'INC');
/*!40000 ALTER TABLE `itemcomptrans` ENABLE KEYS */;


--
-- Definition of table `itemissed`
--

DROP TABLE IF EXISTS `itemissed`;
CREATE TABLE `itemissed` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ItemId` int(10) unsigned NOT NULL,
  `strId` int(10) unsigned NOT NULL,
  `Qty` double NOT NULL,
  `TrDate` datetime NOT NULL,
  `TK` varchar(4) NOT NULL,
  `TRNO` int(10) unsigned NOT NULL,
  `stNo` int(10) unsigned NOT NULL,
  `Returned` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `itemissed`
--

/*!40000 ALTER TABLE `itemissed` DISABLE KEYS */;
/*!40000 ALTER TABLE `itemissed` ENABLE KEYS */;


--
-- Definition of table `itemreturn`
--

DROP TABLE IF EXISTS `itemreturn`;
CREATE TABLE `itemreturn` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ItemId` int(10) unsigned NOT NULL,
  `strId` int(10) unsigned NOT NULL,
  `Qty` double NOT NULL,
  `TrDate` datetime NOT NULL,
  `TK` varchar(4) NOT NULL,
  `TRNO` int(10) unsigned NOT NULL,
  `stNo` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `itemreturn`
--

/*!40000 ALTER TABLE `itemreturn` DISABLE KEYS */;
/*!40000 ALTER TABLE `itemreturn` ENABLE KEYS */;


--
-- Definition of table `items`
--

DROP TABLE IF EXISTS `items`;
CREATE TABLE `items` (
  `sid` int(10) unsigned DEFAULT NULL,
  `Descr` char(60) CHARACTER SET utf8 DEFAULT NULL,
  `ItType` char(2) CHARACTER SET utf8 NOT NULL DEFAULT 'C',
  `MaterialType` char(10) CHARACTER SET utf8 DEFAULT NULL,
  `State` char(1) CHARACTER SET utf8 DEFAULT NULL,
  `Supplr1` char(15) CHARACTER SET utf8 DEFAULT NULL,
  `ItemId` int(11) NOT NULL AUTO_INCREMENT,
  `Cost` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by` char(30) DEFAULT NULL,
  `ItemNo` varchar(45) NOT NULL,
  `Qty` double DEFAULT NULL,
  `QtyPOrd` double DEFAULT NULL,
  `QtySOrd` double DEFAULT NULL,
  `avgCost` double DEFAULT NULL,
  `Price` double DEFAULT NULL,
  `ReQty` double DEFAULT NULL,
  PRIMARY KEY (`ItemId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `items`
--

/*!40000 ALTER TABLE `items` DISABLE KEYS */;
/*!40000 ALTER TABLE `items` ENABLE KEYS */;


--
-- Definition of table `itemstrans`
--

DROP TABLE IF EXISTS `itemstrans`;
CREATE TABLE `itemstrans` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ItemId` int(10) unsigned NOT NULL,
  `DrQty` double DEFAULT NULL,
  `Cost` double DEFAULT NULL,
  `TK` varchar(45) DEFAULT NULL,
  `TRNO` int(10) unsigned DEFAULT NULL,
  `CrQty` double DEFAULT NULL,
  `QtyBf` double DEFAULT NULL,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  `Descrk` varchar(45) DEFAULT NULL,
  `ExpId` int(10) unsigned DEFAULT NULL,
  `TrDate` varchar(45) DEFAULT NULL,
  `TransNo` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `itemstrans`
--

/*!40000 ALTER TABLE `itemstrans` DISABLE KEYS */;
/*!40000 ALTER TABLE `itemstrans` ENABLE KEYS */;


--
-- Definition of table `journalappend`
--

DROP TABLE IF EXISTS `journalappend`;
CREATE TABLE `journalappend` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrId` int(10) unsigned DEFAULT NULL,
  `Descr` varchar(45) DEFAULT NULL,
  `DrAmount` double DEFAULT NULL,
  `CrAmount` double DEFAULT NULL,
  `TransNo` varchar(45) DEFAULT NULL,
  `SAcc` int(10) unsigned DEFAULT NULL,
  `SSAcc` int(10) unsigned DEFAULT NULL,
  `RefAcc` varchar(45) DEFAULT NULL,
  `TrSt` varchar(5) DEFAULT 'CHLD',
  `TK` varchar(45) DEFAULT NULL,
  `ref1` varchar(45) DEFAULT NULL,
  `ref2` text,
  `ref3` text,
  `ref4` text,
  `ref5` text,
  `ref6` text,
  `Qty` int(10) unsigned DEFAULT NULL,
  `TrType` text,
  `psid` int(10) unsigned DEFAULT NULL,
  `chno` varchar(45) DEFAULT NULL,
  `ContNo` varchar(100) DEFAULT NULL,
  `TDate` varchar(45) DEFAULT NULL,
  `BANK` varchar(45) DEFAULT NULL,
  `BRANCH` varchar(45) DEFAULT NULL,
  `CNAME` varchar(45) DEFAULT NULL,
  `KId` int(10) unsigned DEFAULT NULL,
  `PRID` int(10) unsigned DEFAULT NULL,
  `PTP` varchar(45) DEFAULT NULL,
  `RefId` double DEFAULT NULL,
  `prt` varchar(5) DEFAULT NULL,
  `stId` int(11) DEFAULT NULL,
  `checkno` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `journalappend`
--

/*!40000 ALTER TABLE `journalappend` DISABLE KEYS */;
/*!40000 ALTER TABLE `journalappend` ENABLE KEYS */;


--
-- Definition of table `journalappendold`
--

DROP TABLE IF EXISTS `journalappendold`;
CREATE TABLE `journalappendold` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `TrId` int(10) unsigned DEFAULT NULL,
  `Descr` varchar(45) DEFAULT NULL,
  `DrAmount` double DEFAULT NULL,
  `CrAmount` double DEFAULT NULL,
  `TransNo` varchar(45) DEFAULT NULL,
  `SAcc` int(10) unsigned DEFAULT NULL,
  `SSAcc` int(10) unsigned DEFAULT NULL,
  `RefAcc` varchar(45) DEFAULT NULL,
  `TrSt` varchar(5) DEFAULT 'CHLD',
  `TK` varchar(45) DEFAULT NULL,
  `ref1` varchar(45) DEFAULT NULL,
  `ref2` text,
  `ref3` text,
  `ref4` text,
  `ref5` text,
  `ref6` text,
  `Qty` int(10) unsigned DEFAULT NULL,
  `TrType` text,
  `psid` int(10) unsigned DEFAULT NULL,
  `chno` varchar(45) DEFAULT NULL,
  `ContNo` varchar(100) DEFAULT NULL,
  `TDate` varchar(45) DEFAULT NULL,
  `BANK` varchar(45) DEFAULT NULL,
  `BRANCH` varchar(45) DEFAULT NULL,
  `CNAME` varchar(45) DEFAULT NULL,
  `KId` int(10) unsigned DEFAULT NULL,
  `PRID` int(10) unsigned DEFAULT NULL,
  `PTP` varchar(45) DEFAULT NULL,
  `RefId` double DEFAULT NULL,
  `prt` varchar(5) DEFAULT NULL,
  `stId` int(11) DEFAULT NULL,
  `checkno` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=1458 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `journalappendold`
--

/*!40000 ALTER TABLE `journalappendold` DISABLE KEYS */;
INSERT INTO `journalappendold` (`Id`,`TrId`,`Descr`,`DrAmount`,`CrAmount`,`TransNo`,`SAcc`,`SSAcc`,`RefAcc`,`TrSt`,`TK`,`ref1`,`ref2`,`ref3`,`ref4`,`ref5`,`ref6`,`Qty`,`TrType`,`psid`,`chno`,`ContNo`,`TDate`,`BANK`,`BRANCH`,`CNAME`,`KId`,`PRID`,`PTP`,`RefId`,`prt`,`stId`,`checkno`) VALUES 
 (624,639,'TUITION FEE',6000,NULL,'20180502',10,186,'FBLL','13',NULL,'257',NULL,NULL,NULL,'1','R',NULL,NULL,198,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (625,639,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,624,NULL,NULL,NULL),
 (626,639,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,624,NULL,NULL,NULL),
 (627,640,'TUITION FEE',6000,NULL,'20180502',10,187,'FBLL','13',NULL,'374',NULL,NULL,NULL,'1','R',NULL,NULL,199,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (628,640,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,627,NULL,NULL,NULL),
 (629,640,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,627,NULL,NULL,NULL),
 (630,641,'TUITION FEE',6000,NULL,'20180502',10,188,'FBLL','13',NULL,'387',NULL,NULL,NULL,'1','R',NULL,NULL,200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (631,641,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,630,NULL,NULL,NULL),
 (632,641,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,630,NULL,NULL,NULL),
 (633,642,'TUITION FEE',6000,NULL,'20180502',10,189,'FBLL','13',NULL,'407',NULL,NULL,NULL,'1','R',NULL,NULL,201,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (634,642,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,633,NULL,NULL,NULL),
 (635,642,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,633,NULL,NULL,NULL),
 (636,643,'TUITION FEE',6000,NULL,'20180502',10,190,'FBLL','13',NULL,'408',NULL,NULL,NULL,'1','R',NULL,NULL,202,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (637,643,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,636,NULL,NULL,NULL),
 (638,643,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,636,NULL,NULL,NULL),
 (639,644,'TUITION FEE',6000,NULL,'20180502',10,191,'FBLL','13',NULL,'409',NULL,NULL,NULL,'1','R',NULL,NULL,203,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (640,644,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,639,NULL,NULL,NULL),
 (641,644,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,639,NULL,NULL,NULL),
 (642,645,'TUITION FEE',6000,NULL,'20180502',10,192,'FBLL','13',NULL,'410',NULL,NULL,NULL,'1','R',NULL,NULL,204,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (643,645,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,642,NULL,NULL,NULL),
 (644,645,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,642,NULL,NULL,NULL),
 (645,646,'TUITION FEE',6000,NULL,'20180502',10,193,'FBLL','13',NULL,'411',NULL,NULL,NULL,'1','R',NULL,NULL,205,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (646,646,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,645,NULL,NULL,NULL),
 (647,646,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,645,NULL,NULL,NULL),
 (648,647,'TUITION FEE',6000,NULL,'20180502',10,194,'FBLL','13',NULL,'412',NULL,NULL,NULL,'1','R',NULL,NULL,206,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (649,647,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,648,NULL,NULL,NULL),
 (650,647,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,648,NULL,NULL,NULL),
 (651,648,'TUITION FEE',6000,NULL,'20180502',10,195,'FBLL','13',NULL,'413',NULL,NULL,NULL,'1','R',NULL,NULL,207,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (652,648,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,651,NULL,NULL,NULL),
 (653,648,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,651,NULL,NULL,NULL),
 (654,649,'TUITION FEE',6000,NULL,'20180502',10,196,'FBLL','13',NULL,'414',NULL,NULL,NULL,'1','R',NULL,NULL,208,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (655,649,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,654,NULL,NULL,NULL),
 (656,649,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,654,NULL,NULL,NULL),
 (657,650,'TUITION FEE',6000,NULL,'20180502',10,197,'FBLL','13',NULL,'415',NULL,NULL,NULL,'1','R',NULL,NULL,209,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (658,650,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,657,NULL,NULL,NULL),
 (659,650,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,657,NULL,NULL,NULL),
 (660,651,'TUITION FEE',6000,NULL,'20180502',10,198,'FBLL','13',NULL,'416',NULL,NULL,NULL,'1','R',NULL,NULL,210,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (661,651,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,660,NULL,NULL,NULL),
 (662,651,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,660,NULL,NULL,NULL),
 (663,652,'TUITION FEE',6000,NULL,'20180502',10,199,'FBLL','13',NULL,'417',NULL,NULL,NULL,'1','R',NULL,NULL,211,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (664,652,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,663,NULL,NULL,NULL),
 (665,652,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,663,NULL,NULL,NULL),
 (666,653,'TUITION FEE',6000,NULL,'20180502',10,200,'FBLL','13',NULL,'418',NULL,NULL,NULL,'1','R',NULL,NULL,212,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (667,653,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,666,NULL,NULL,NULL),
 (668,653,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,666,NULL,NULL,NULL),
 (669,654,'TUITION FEE',6000,NULL,'20180502',10,201,'FBLL','13',NULL,'419',NULL,NULL,NULL,'1','R',NULL,NULL,213,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (670,654,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,669,NULL,NULL,NULL),
 (671,654,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,669,NULL,NULL,NULL),
 (672,655,'TUITION FEE',6000,NULL,'20180502',10,202,'FBLL','13',NULL,'420',NULL,NULL,NULL,'1','R',NULL,NULL,214,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (673,655,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,672,NULL,NULL,NULL),
 (674,655,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,672,NULL,NULL,NULL),
 (675,656,'TUITION FEE',6000,NULL,'20180502',10,203,'FBLL','13',NULL,'421',NULL,NULL,NULL,'1','R',NULL,NULL,215,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (676,656,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,675,NULL,NULL,NULL),
 (677,656,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,675,NULL,NULL,NULL),
 (678,657,'TUITION FEE',6000,NULL,'20180502',10,204,'FBLL','13',NULL,'422',NULL,NULL,NULL,'1','R',NULL,NULL,216,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (679,657,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,678,NULL,NULL,NULL),
 (680,657,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,678,NULL,NULL,NULL),
 (681,658,'TUITION FEE',6000,NULL,'20180502',10,205,'FBLL','13',NULL,'423',NULL,NULL,NULL,'1','R',NULL,NULL,217,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (682,658,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,681,NULL,NULL,NULL),
 (683,658,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,681,NULL,NULL,NULL),
 (684,659,'TUITION FEE',6000,NULL,'20180502',10,206,'FBLL','13',NULL,'424',NULL,NULL,NULL,'1','R',NULL,NULL,218,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (685,659,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,684,NULL,NULL,NULL),
 (686,659,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,684,NULL,NULL,NULL),
 (687,660,'TUITION FEE',6000,NULL,'20180502',10,207,'FBLL','13',NULL,'425',NULL,NULL,NULL,'1','R',NULL,NULL,219,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (688,660,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,687,NULL,NULL,NULL),
 (689,660,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,687,NULL,NULL,NULL),
 (690,661,'TUITION FEE',6000,NULL,'20180502',10,208,'FBLL','13',NULL,'426',NULL,NULL,NULL,'1','R',NULL,NULL,220,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (691,661,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,690,NULL,NULL,NULL),
 (692,661,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,690,NULL,NULL,NULL),
 (693,662,'TUITION FEE',6000,NULL,'20180502',10,209,'FBLL','13',NULL,'427',NULL,NULL,NULL,'1','R',NULL,NULL,221,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (694,662,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,693,NULL,NULL,NULL),
 (695,662,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,693,NULL,NULL,NULL),
 (696,663,'TUITION FEE',6000,NULL,'20180502',10,210,'FBLL','13',NULL,'428',NULL,NULL,NULL,'1','R',NULL,NULL,222,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (697,663,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,696,NULL,NULL,NULL),
 (698,663,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,696,NULL,NULL,NULL),
 (699,664,'TUITION FEE',6000,NULL,'20180502',10,211,'FBLL','13',NULL,'429',NULL,NULL,NULL,'1','R',NULL,NULL,223,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (700,664,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,699,NULL,NULL,NULL),
 (701,664,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,699,NULL,NULL,NULL),
 (702,665,'TUITION FEE',6000,NULL,'20180502',10,212,'FBLL','13',NULL,'430',NULL,NULL,NULL,'1','R',NULL,NULL,224,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (703,665,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,702,NULL,NULL,NULL),
 (704,665,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,702,NULL,NULL,NULL),
 (705,666,'TUITION FEE',6000,NULL,'20180502',10,213,'FBLL','13',NULL,'431',NULL,NULL,NULL,'1','R',NULL,NULL,225,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (706,666,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,705,NULL,NULL,NULL),
 (707,666,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,705,NULL,NULL,NULL),
 (708,667,'TUITION FEE',6000,NULL,'20180502',10,214,'FBLL','13',NULL,'432',NULL,NULL,NULL,'1','R',NULL,NULL,226,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (709,667,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,708,NULL,NULL,NULL),
 (710,667,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,708,NULL,NULL,NULL),
 (711,668,'TUITION FEE',6000,NULL,'20180502',10,215,'FBLL','13',NULL,'433',NULL,NULL,NULL,'1','R',NULL,NULL,227,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (712,668,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,711,NULL,NULL,NULL),
 (713,668,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,711,NULL,NULL,NULL),
 (714,669,'TUITION FEE',6000,NULL,'20180502',10,216,'FBLL','13',NULL,'434',NULL,NULL,NULL,'1','R',NULL,NULL,228,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (715,669,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,714,NULL,NULL,NULL),
 (716,669,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,714,NULL,NULL,NULL),
 (717,670,'TUITION FEE',6000,NULL,'20180502',10,217,'FBLL','13',NULL,'435',NULL,NULL,NULL,'1','R',NULL,NULL,229,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (718,670,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,717,NULL,NULL,NULL),
 (719,670,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,717,NULL,NULL,NULL),
 (720,671,'TUITION FEE',6000,NULL,'20180502',10,218,'FBLL','13',NULL,'436',NULL,NULL,NULL,'1','R',NULL,NULL,230,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (721,671,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,720,NULL,NULL,NULL),
 (722,671,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,720,NULL,NULL,NULL),
 (723,672,'TUITION FEE',6000,NULL,'20180502',10,219,'FBLL','13',NULL,'437',NULL,NULL,NULL,'1','R',NULL,NULL,231,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (724,672,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,723,NULL,NULL,NULL),
 (725,672,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,723,NULL,NULL,NULL),
 (726,673,'TUITION FEE',6000,NULL,'20180502',10,220,'FBLL','13',NULL,'438',NULL,NULL,NULL,'1','R',NULL,NULL,232,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (727,673,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,726,NULL,NULL,NULL),
 (728,673,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,726,NULL,NULL,NULL),
 (729,674,'TUITION FEE',6000,NULL,'20180502',10,221,'FBLL','13',NULL,'439',NULL,NULL,NULL,'1','R',NULL,NULL,233,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (730,674,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,729,NULL,NULL,NULL),
 (731,674,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,729,NULL,NULL,NULL),
 (732,675,'TUITION FEE',6000,NULL,'20180502',10,222,'FBLL','13',NULL,'440',NULL,NULL,NULL,'1','R',NULL,NULL,234,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (733,675,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,732,NULL,NULL,NULL),
 (734,675,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,732,NULL,NULL,NULL),
 (735,676,'TUITION FEE',6000,NULL,'20180502',10,223,'FBLL','13',NULL,'441',NULL,NULL,NULL,'1','R',NULL,NULL,235,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (736,676,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,735,NULL,NULL,NULL),
 (737,676,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,735,NULL,NULL,NULL),
 (738,677,'TUITION FEE',6000,NULL,'20180502',10,224,'FBLL','13',NULL,'442',NULL,NULL,NULL,'1','R',NULL,NULL,236,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (739,677,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,738,NULL,NULL,NULL),
 (740,677,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,738,NULL,NULL,NULL),
 (741,678,'TUITION FEE',6000,NULL,'20180502',10,225,'FBLL','13',NULL,'443',NULL,NULL,NULL,'1','R',NULL,NULL,237,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (742,678,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,741,NULL,NULL,NULL),
 (743,678,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,741,NULL,NULL,NULL),
 (744,679,'TUITION FEE',6000,NULL,'20180502',10,226,'FBLL','13',NULL,'444',NULL,NULL,NULL,'1','R',NULL,NULL,238,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (745,679,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,744,NULL,NULL,NULL),
 (746,679,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,744,NULL,NULL,NULL),
 (747,680,'TUITION FEE',6000,NULL,'20180502',10,227,'FBLL','13',NULL,'445',NULL,NULL,NULL,'1','R',NULL,NULL,239,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (748,680,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,747,NULL,NULL,NULL),
 (749,680,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,747,NULL,NULL,NULL),
 (750,681,'TUITION FEE',6000,NULL,'20180502',10,228,'FBLL','13',NULL,'446',NULL,NULL,NULL,'1','R',NULL,NULL,240,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (751,681,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,750,NULL,NULL,NULL),
 (752,681,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,750,NULL,NULL,NULL),
 (753,682,'TUITION FEE',6000,NULL,'20180502',10,229,'FBLL','13',NULL,'447',NULL,NULL,NULL,'1','R',NULL,NULL,241,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (754,682,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,753,NULL,NULL,NULL),
 (755,682,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,753,NULL,NULL,NULL),
 (756,683,'TUITION FEE',6000,NULL,'20180502',10,230,'FBLL','13',NULL,'448',NULL,NULL,NULL,'1','R',NULL,NULL,242,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (757,683,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,756,NULL,NULL,NULL),
 (758,683,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,756,NULL,NULL,NULL),
 (759,684,'TUITION FEE',6000,NULL,'20180502',10,231,'FBLL','13',NULL,'449',NULL,NULL,NULL,'1','R',NULL,NULL,243,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (760,684,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,759,NULL,NULL,NULL),
 (761,684,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,759,NULL,NULL,NULL),
 (762,685,'TUITION FEE',6000,NULL,'20180502',10,232,'FBLL','13',NULL,'450',NULL,NULL,NULL,'1','R',NULL,NULL,244,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (763,685,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,762,NULL,NULL,NULL),
 (764,685,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,762,NULL,NULL,NULL),
 (765,686,'TUITION FEE',6000,NULL,'20180502',10,233,'FBLL','13',NULL,'451',NULL,NULL,NULL,'1','R',NULL,NULL,245,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (766,686,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,765,NULL,NULL,NULL),
 (767,686,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,765,NULL,NULL,NULL),
 (768,687,'TUITION FEE',6000,NULL,'20180502',10,234,'FBLL','13',NULL,'452',NULL,NULL,NULL,'1','R',NULL,NULL,246,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (769,687,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,768,NULL,NULL,NULL),
 (770,687,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,768,NULL,NULL,NULL),
 (771,688,'TUITION FEE',6000,NULL,'20180502',10,235,'FBLL','13',NULL,'453',NULL,NULL,NULL,'1','R',NULL,NULL,247,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (772,688,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,771,NULL,NULL,NULL),
 (773,688,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,771,NULL,NULL,NULL),
 (774,689,'TUITION FEE',6000,NULL,'20180502',10,236,'FBLL','13',NULL,'454',NULL,NULL,NULL,'1','R',NULL,NULL,248,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (775,689,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,774,NULL,NULL,NULL),
 (776,689,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,774,NULL,NULL,NULL),
 (777,690,'TUITION FEE',6000,NULL,'20180502',10,237,'FBLL','13',NULL,'455',NULL,NULL,NULL,'1','R',NULL,NULL,249,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (778,690,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,777,NULL,NULL,NULL),
 (779,690,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,777,NULL,NULL,NULL),
 (780,691,'TUITION FEE',6000,NULL,'20180502',10,238,'FBLL','13',NULL,'456',NULL,NULL,NULL,'1','R',NULL,NULL,250,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (781,691,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,780,NULL,NULL,NULL),
 (782,691,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,780,NULL,NULL,NULL),
 (783,692,'TUITION FEE',6000,NULL,'20180502',10,239,'FBLL','13',NULL,'458',NULL,NULL,NULL,'1','R',NULL,NULL,251,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (784,692,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,783,NULL,NULL,NULL),
 (785,692,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,783,NULL,NULL,NULL),
 (786,693,'TUITION FEE',6000,NULL,'20180502',10,240,'FBLL','13',NULL,'459',NULL,NULL,NULL,'1','R',NULL,NULL,252,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (787,693,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,786,NULL,NULL,NULL),
 (788,693,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,786,NULL,NULL,NULL),
 (789,694,'TUITION FEE',6000,NULL,'20180502',10,241,'FBLL','13',NULL,'460',NULL,NULL,NULL,'1','R',NULL,NULL,253,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (790,694,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,789,NULL,NULL,NULL),
 (791,694,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,789,NULL,NULL,NULL),
 (792,695,'TUITION FEE',6000,NULL,'20180502',10,242,'FBLL','13',NULL,'461',NULL,NULL,NULL,'1','R',NULL,NULL,254,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (793,695,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,792,NULL,NULL,NULL),
 (794,695,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,792,NULL,NULL,NULL),
 (795,696,'TUITION FEE',6000,NULL,'20180502',10,243,'FBLL','13',NULL,'462',NULL,NULL,NULL,'1','R',NULL,NULL,255,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (796,696,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,795,NULL,NULL,NULL),
 (797,696,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,795,NULL,NULL,NULL),
 (798,697,'TUITION FEE',6000,NULL,'20180502',10,244,'FBLL','13',NULL,'463',NULL,NULL,NULL,'1','R',NULL,NULL,256,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (799,697,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,798,NULL,NULL,NULL),
 (800,697,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,798,NULL,NULL,NULL),
 (801,698,'TUITION FEE',6000,NULL,'20180502',10,245,'FBLL','13',NULL,'464',NULL,NULL,NULL,'1','R',NULL,NULL,257,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (802,698,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,801,NULL,NULL,NULL),
 (803,698,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,801,NULL,NULL,NULL),
 (804,699,'TUITION FEE',6000,NULL,'20180502',10,246,'FBLL','13',NULL,'465',NULL,NULL,NULL,'1','R',NULL,NULL,258,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (805,699,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,804,NULL,NULL,NULL),
 (806,699,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,804,NULL,NULL,NULL),
 (807,700,'TUITION FEE',6000,NULL,'20180502',10,247,'FBLL','13',NULL,'466',NULL,NULL,NULL,'1','R',NULL,NULL,259,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (808,700,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,807,NULL,NULL,NULL),
 (809,700,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,807,NULL,NULL,NULL),
 (810,701,'TUITION FEE',6000,NULL,'20180502',10,248,'FBLL','13',NULL,'467',NULL,NULL,NULL,'1','R',NULL,NULL,260,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (811,701,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,810,NULL,NULL,NULL),
 (812,701,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,810,NULL,NULL,NULL),
 (813,702,'TUITION FEE',6000,NULL,'20180502',10,249,'FBLL','13',NULL,'468',NULL,NULL,NULL,'1','R',NULL,NULL,261,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (814,702,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,813,NULL,NULL,NULL),
 (815,702,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,813,NULL,NULL,NULL),
 (816,703,'TUITION FEE',6000,NULL,'20180502',10,250,'FBLL','13',NULL,'469',NULL,NULL,NULL,'1','R',NULL,NULL,262,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (817,703,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,816,NULL,NULL,NULL),
 (818,703,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,816,NULL,NULL,NULL),
 (819,704,'TUITION FEE',6000,NULL,'20180502',10,251,'FBLL','13',NULL,'470',NULL,NULL,NULL,'1','R',NULL,NULL,263,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (820,704,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,819,NULL,NULL,NULL),
 (821,704,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,819,NULL,NULL,NULL),
 (822,705,'TUITION FEE',6000,NULL,'20180502',10,252,'FBLL','13',NULL,'471',NULL,NULL,NULL,'1','R',NULL,NULL,264,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (823,705,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,822,NULL,NULL,NULL),
 (824,705,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,822,NULL,NULL,NULL),
 (825,706,'TUITION FEE',6000,NULL,'20180502',10,253,'FBLL','13',NULL,'472',NULL,NULL,NULL,'1','R',NULL,NULL,265,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (826,706,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,825,NULL,NULL,NULL),
 (827,706,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,825,NULL,NULL,NULL),
 (828,707,'TUITION FEE',6000,NULL,'20180502',10,254,'FBLL','13',NULL,'473',NULL,NULL,NULL,'1','R',NULL,NULL,266,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (829,707,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,828,NULL,NULL,NULL),
 (830,707,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,828,NULL,NULL,NULL),
 (831,708,'TUITION FEE',6000,NULL,'20180502',10,255,'FBLL','13',NULL,'474',NULL,NULL,NULL,'1','R',NULL,NULL,267,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (832,708,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,831,NULL,NULL,NULL),
 (833,708,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,831,NULL,NULL,NULL),
 (834,709,'TUITION FEE',6000,NULL,'20180502',10,256,'FBLL','13',NULL,'475',NULL,NULL,NULL,'1','R',NULL,NULL,268,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (835,709,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,834,NULL,NULL,NULL),
 (836,709,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,834,NULL,NULL,NULL),
 (837,710,'TUITION FEE',6000,NULL,'20180502',10,257,'FBLL','13',NULL,'508',NULL,NULL,NULL,'1','R',NULL,NULL,269,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (838,710,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,837,NULL,NULL,NULL),
 (839,710,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,837,NULL,NULL,NULL),
 (840,711,'TUITION FEE',6000,NULL,'20180502',10,258,'FBLL','13',NULL,'566',NULL,NULL,NULL,'1','R',NULL,NULL,270,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (841,711,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,840,NULL,NULL,NULL),
 (842,711,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,840,NULL,NULL,NULL),
 (843,712,'TUITION FEE',6000,NULL,'20180502',10,259,'FBLL','13',NULL,'672',NULL,NULL,NULL,'1','R',NULL,NULL,271,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (844,712,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,843,NULL,NULL,NULL),
 (845,712,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,843,NULL,NULL,NULL),
 (846,713,'TUITION FEE',6000,NULL,'20180502',10,260,'FBLL','13',NULL,'673',NULL,NULL,NULL,'1','R',NULL,NULL,272,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (847,713,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,846,NULL,NULL,NULL),
 (848,713,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,846,NULL,NULL,NULL),
 (849,714,'TUITION FEE',6000,NULL,'20180502',10,261,'FBLL','13',NULL,'675',NULL,NULL,NULL,'1','R',NULL,NULL,273,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (850,714,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,849,NULL,NULL,NULL),
 (851,714,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,849,NULL,NULL,NULL),
 (852,715,'TUITION FEE',6000,NULL,'20180502',10,262,'FBLL','13',NULL,'681',NULL,NULL,NULL,'1','R',NULL,NULL,274,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (853,715,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,852,NULL,NULL,NULL),
 (854,715,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,852,NULL,NULL,NULL),
 (855,716,'TUITION FEE',6000,NULL,'20180502',10,263,'FBLL','13',NULL,'685',NULL,NULL,NULL,'1','R',NULL,NULL,275,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (856,716,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,855,NULL,NULL,NULL),
 (857,716,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,855,NULL,NULL,NULL),
 (858,717,'TUITION FEE',6000,NULL,'20180502',10,264,'FBLL','13',NULL,'694',NULL,NULL,NULL,'1','R',NULL,NULL,276,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (859,717,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,858,NULL,NULL,NULL),
 (860,717,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,858,NULL,NULL,NULL),
 (861,718,'TUITION FEE',6000,NULL,'20180502',10,265,'FBLL','13',NULL,'700',NULL,NULL,NULL,'1','R',NULL,NULL,277,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (862,718,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,861,NULL,NULL,NULL),
 (863,718,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,861,NULL,NULL,NULL),
 (864,719,'TUITION FEE',6000,NULL,'20180502',10,266,'FBLL','13',NULL,'703',NULL,NULL,NULL,'1','R',NULL,NULL,278,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (865,719,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,864,NULL,NULL,NULL),
 (866,719,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,864,NULL,NULL,NULL),
 (867,720,'TUITION FEE',6000,NULL,'20180502',10,267,'FBLL','13',NULL,'704',NULL,NULL,NULL,'1','R',NULL,NULL,279,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (868,720,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,867,NULL,NULL,NULL),
 (869,720,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,867,NULL,NULL,NULL),
 (870,721,'TUITION FEE',6000,NULL,'20180502',10,268,'FBLL','13',NULL,'705',NULL,NULL,NULL,'1','R',NULL,NULL,280,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (871,721,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,870,NULL,NULL,NULL),
 (872,721,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,870,NULL,NULL,NULL),
 (873,722,'TUITION FEE',6000,NULL,'20180502',10,269,'FBLL','13',NULL,'721',NULL,NULL,NULL,'1','R',NULL,NULL,281,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (874,722,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,873,NULL,NULL,NULL),
 (875,722,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,873,NULL,NULL,NULL),
 (876,723,'TUITION FEE',6000,NULL,'20180502',10,270,'FBLL','13',NULL,'722',NULL,NULL,NULL,'1','R',NULL,NULL,282,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (877,723,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,876,NULL,NULL,NULL),
 (878,723,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,876,NULL,NULL,NULL),
 (879,724,'TUITION FEE',6000,NULL,'20180502',10,271,'FBLL','13',NULL,'731',NULL,NULL,NULL,'1','R',NULL,NULL,283,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (880,724,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,879,NULL,NULL,NULL),
 (881,724,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,879,NULL,NULL,NULL),
 (882,725,'TUITION FEE',6000,NULL,'20180502',10,272,'FBLL','13',NULL,'736',NULL,NULL,NULL,'1','R',NULL,NULL,284,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (883,725,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,882,NULL,NULL,NULL),
 (884,725,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,882,NULL,NULL,NULL),
 (885,726,'TUITION FEE',6000,NULL,'20180502',10,273,'FBLL','13',NULL,'738',NULL,NULL,NULL,'1','R',NULL,NULL,285,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (886,726,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,885,NULL,NULL,NULL),
 (887,726,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,885,NULL,NULL,NULL),
 (888,727,'TUITION FEE',6000,NULL,'20180502',10,274,'FBLL','13',NULL,'739',NULL,NULL,NULL,'1','R',NULL,NULL,286,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (889,727,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,888,NULL,NULL,NULL),
 (890,727,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,888,NULL,NULL,NULL),
 (891,728,'TUITION FEE',6000,NULL,'20180502',10,275,'FBLL','13',NULL,'742',NULL,NULL,NULL,'1','R',NULL,NULL,287,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (892,728,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,891,NULL,NULL,NULL),
 (893,728,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,891,NULL,NULL,NULL),
 (894,729,'TUITION FEE',6000,NULL,'20180502',10,276,'FBLL','13',NULL,'749',NULL,NULL,NULL,'1','R',NULL,NULL,288,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (895,729,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,894,NULL,NULL,NULL),
 (896,729,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,894,NULL,NULL,NULL),
 (897,730,'TUITION FEE',6000,NULL,'20180502',10,277,'FBLL','13',NULL,'755',NULL,NULL,NULL,'1','R',NULL,NULL,289,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (898,730,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,897,NULL,NULL,NULL),
 (899,730,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,897,NULL,NULL,NULL),
 (900,731,'TUITION FEE',6000,NULL,'20180502',10,278,'FBLL','13',NULL,'764',NULL,NULL,NULL,'1','R',NULL,NULL,290,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (901,731,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,900,NULL,NULL,NULL),
 (902,731,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,900,NULL,NULL,NULL),
 (903,732,'TUITION FEE',6000,NULL,'20180502',10,1,'FBLL','13',NULL,'545',NULL,NULL,NULL,'1','R',NULL,NULL,291,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (904,732,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,903,NULL,NULL,NULL),
 (905,732,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,903,NULL,NULL,NULL),
 (906,733,'TUITION FEE',6000,NULL,'20180502',10,2,'FBLL','13',NULL,'554',NULL,NULL,NULL,'1','R',NULL,NULL,292,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (907,733,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,906,NULL,NULL,NULL),
 (908,733,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,906,NULL,NULL,NULL),
 (909,734,'TUITION FEE',6000,NULL,'20180502',10,3,'FBLL','13',NULL,'556',NULL,NULL,NULL,'1','R',NULL,NULL,293,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (910,734,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,909,NULL,NULL,NULL),
 (911,734,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,909,NULL,NULL,NULL),
 (912,735,'TUITION FEE',6000,NULL,'20180502',10,4,'FBLL','13',NULL,'558',NULL,NULL,NULL,'1','R',NULL,NULL,294,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (913,735,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,912,NULL,NULL,NULL),
 (914,735,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,912,NULL,NULL,NULL),
 (915,736,'TUITION FEE',6000,NULL,'20180502',10,5,'FBLL','13',NULL,'559',NULL,NULL,NULL,'1','R',NULL,NULL,295,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (916,736,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,915,NULL,NULL,NULL),
 (917,736,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,915,NULL,NULL,NULL),
 (918,737,'TUITION FEE',6000,NULL,'20180502',10,6,'FBLL','13',NULL,'560',NULL,NULL,NULL,'1','R',NULL,NULL,296,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (919,737,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,918,NULL,NULL,NULL),
 (920,737,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,918,NULL,NULL,NULL),
 (921,738,'TUITION FEE',6000,NULL,'20180502',10,7,'FBLL','13',NULL,'562',NULL,NULL,NULL,'1','R',NULL,NULL,297,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (922,738,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,921,NULL,NULL,NULL),
 (923,738,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,921,NULL,NULL,NULL),
 (924,739,'TUITION FEE',6000,NULL,'20180502',10,8,'FBLL','13',NULL,'563',NULL,NULL,NULL,'1','R',NULL,NULL,298,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (925,739,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,924,NULL,NULL,NULL),
 (926,739,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,924,NULL,NULL,NULL),
 (927,740,'TUITION FEE',6000,NULL,'20180502',10,9,'FBLL','13',NULL,'564',NULL,NULL,NULL,'1','R',NULL,NULL,299,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (928,740,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,927,NULL,NULL,NULL),
 (929,740,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,927,NULL,NULL,NULL),
 (930,741,'TUITION FEE',6000,NULL,'20180502',10,10,'FBLL','13',NULL,'565',NULL,NULL,NULL,'1','R',NULL,NULL,300,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (931,741,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,930,NULL,NULL,NULL),
 (932,741,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,930,NULL,NULL,NULL),
 (933,742,'TUITION FEE',6000,NULL,'20180502',10,11,'FBLL','13',NULL,'567',NULL,NULL,NULL,'1','R',NULL,NULL,301,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (934,742,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,933,NULL,NULL,NULL),
 (935,742,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,933,NULL,NULL,NULL),
 (936,743,'TUITION FEE',6000,NULL,'20180502',10,12,'FBLL','13',NULL,'569',NULL,NULL,NULL,'1','R',NULL,NULL,302,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (937,743,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,936,NULL,NULL,NULL),
 (938,743,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,936,NULL,NULL,NULL),
 (939,744,'TUITION FEE',6000,NULL,'20180502',10,13,'FBLL','13',NULL,'570',NULL,NULL,NULL,'1','R',NULL,NULL,303,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (940,744,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,939,NULL,NULL,NULL),
 (941,744,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,939,NULL,NULL,NULL),
 (942,745,'TUITION FEE',6000,NULL,'20180502',10,14,'FBLL','13',NULL,'572',NULL,NULL,NULL,'1','R',NULL,NULL,304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (943,745,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,942,NULL,NULL,NULL),
 (944,745,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,942,NULL,NULL,NULL),
 (945,746,'TUITION FEE',6000,NULL,'20180502',10,15,'FBLL','13',NULL,'573',NULL,NULL,NULL,'1','R',NULL,NULL,305,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (946,746,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,945,NULL,NULL,NULL),
 (947,746,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,945,NULL,NULL,NULL),
 (948,747,'TUITION FEE',6000,NULL,'20180502',10,16,'FBLL','13',NULL,'574',NULL,NULL,NULL,'1','R',NULL,NULL,306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (949,747,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,948,NULL,NULL,NULL),
 (950,747,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,948,NULL,NULL,NULL),
 (951,748,'TUITION FEE',6000,NULL,'20180502',10,17,'FBLL','13',NULL,'575',NULL,NULL,NULL,'1','R',NULL,NULL,307,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (952,748,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,951,NULL,NULL,NULL),
 (953,748,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,951,NULL,NULL,NULL),
 (954,749,'TUITION FEE',6000,NULL,'20180502',10,18,'FBLL','13',NULL,'576',NULL,NULL,NULL,'1','R',NULL,NULL,308,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (955,749,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,954,NULL,NULL,NULL),
 (956,749,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,954,NULL,NULL,NULL),
 (957,750,'TUITION FEE',6000,NULL,'20180502',10,19,'FBLL','13',NULL,'577',NULL,NULL,NULL,'1','R',NULL,NULL,309,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (958,750,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,957,NULL,NULL,NULL),
 (959,750,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,957,NULL,NULL,NULL),
 (960,751,'TUITION FEE',6000,NULL,'20180502',10,20,'FBLL','13',NULL,'581',NULL,NULL,NULL,'1','R',NULL,NULL,310,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (961,751,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,960,NULL,NULL,NULL),
 (962,751,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,960,NULL,NULL,NULL),
 (963,752,'TUITION FEE',6000,NULL,'20180502',10,21,'FBLL','13',NULL,'583',NULL,NULL,NULL,'1','R',NULL,NULL,311,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (964,752,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,963,NULL,NULL,NULL),
 (965,752,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,963,NULL,NULL,NULL),
 (966,753,'TUITION FEE',6000,NULL,'20180502',10,22,'FBLL','13',NULL,'584',NULL,NULL,NULL,'1','R',NULL,NULL,312,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (967,753,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,966,NULL,NULL,NULL),
 (968,753,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,966,NULL,NULL,NULL),
 (969,754,'TUITION FEE',6000,NULL,'20180502',10,23,'FBLL','13',NULL,'587',NULL,NULL,NULL,'1','R',NULL,NULL,313,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (970,754,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,969,NULL,NULL,NULL),
 (971,754,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,969,NULL,NULL,NULL),
 (972,755,'TUITION FEE',6000,NULL,'20180502',10,24,'FBLL','13',NULL,'593',NULL,NULL,NULL,'1','R',NULL,NULL,314,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (973,755,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,972,NULL,NULL,NULL),
 (974,755,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,972,NULL,NULL,NULL),
 (975,756,'TUITION FEE',6000,NULL,'20180502',10,25,'FBLL','13',NULL,'594',NULL,NULL,NULL,'1','R',NULL,NULL,315,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (976,756,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,975,NULL,NULL,NULL),
 (977,756,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,975,NULL,NULL,NULL);
INSERT INTO `journalappendold` (`Id`,`TrId`,`Descr`,`DrAmount`,`CrAmount`,`TransNo`,`SAcc`,`SSAcc`,`RefAcc`,`TrSt`,`TK`,`ref1`,`ref2`,`ref3`,`ref4`,`ref5`,`ref6`,`Qty`,`TrType`,`psid`,`chno`,`ContNo`,`TDate`,`BANK`,`BRANCH`,`CNAME`,`KId`,`PRID`,`PTP`,`RefId`,`prt`,`stId`,`checkno`) VALUES 
 (978,757,'TUITION FEE',6000,NULL,'20180502',10,26,'FBLL','13',NULL,'597',NULL,NULL,NULL,'1','R',NULL,NULL,316,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (979,757,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,978,NULL,NULL,NULL),
 (980,757,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,978,NULL,NULL,NULL),
 (981,758,'TUITION FEE',6000,NULL,'20180502',10,27,'FBLL','13',NULL,'598',NULL,NULL,NULL,'1','R',NULL,NULL,317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (982,758,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,981,NULL,NULL,NULL),
 (983,758,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,981,NULL,NULL,NULL),
 (984,759,'TUITION FEE',6000,NULL,'20180502',10,28,'FBLL','13',NULL,'599',NULL,NULL,NULL,'1','R',NULL,NULL,318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (985,759,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,984,NULL,NULL,NULL),
 (986,759,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,984,NULL,NULL,NULL),
 (987,760,'TUITION FEE',6000,NULL,'20180502',10,29,'FBLL','13',NULL,'600',NULL,NULL,NULL,'1','R',NULL,NULL,319,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (988,760,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,987,NULL,NULL,NULL),
 (989,760,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,987,NULL,NULL,NULL),
 (990,761,'TUITION FEE',6000,NULL,'20180502',10,30,'FBLL','13',NULL,'602',NULL,NULL,NULL,'1','R',NULL,NULL,320,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (991,761,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,990,NULL,NULL,NULL),
 (992,761,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,990,NULL,NULL,NULL),
 (993,762,'TUITION FEE',6000,NULL,'20180502',10,31,'FBLL','13',NULL,'603',NULL,NULL,NULL,'1','R',NULL,NULL,321,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (994,762,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,993,NULL,NULL,NULL),
 (995,762,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,993,NULL,NULL,NULL),
 (996,763,'TUITION FEE',6000,NULL,'20180502',10,32,'FBLL','13',NULL,'604',NULL,NULL,NULL,'1','R',NULL,NULL,322,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (997,763,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,996,NULL,NULL,NULL),
 (998,763,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,996,NULL,NULL,NULL),
 (999,764,'TUITION FEE',6000,NULL,'20180502',10,33,'FBLL','13',NULL,'606',NULL,NULL,NULL,'1','R',NULL,NULL,323,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1000,764,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,999,NULL,NULL,NULL),
 (1001,764,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,999,NULL,NULL,NULL),
 (1002,765,'TUITION FEE',6000,NULL,'20180502',10,34,'FBLL','13',NULL,'607',NULL,NULL,NULL,'1','R',NULL,NULL,324,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1003,765,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1002,NULL,NULL,NULL),
 (1004,765,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1002,NULL,NULL,NULL),
 (1005,766,'TUITION FEE',6000,NULL,'20180502',10,35,'FBLL','13',NULL,'608',NULL,NULL,NULL,'1','R',NULL,NULL,325,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1006,766,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1005,NULL,NULL,NULL),
 (1007,766,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1005,NULL,NULL,NULL),
 (1008,767,'TUITION FEE',6000,NULL,'20180502',10,36,'FBLL','13',NULL,'610',NULL,NULL,NULL,'1','R',NULL,NULL,326,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1009,767,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1008,NULL,NULL,NULL),
 (1010,767,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1008,NULL,NULL,NULL),
 (1011,768,'TUITION FEE',6000,NULL,'20180502',10,37,'FBLL','13',NULL,'611',NULL,NULL,NULL,'1','R',NULL,NULL,327,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1012,768,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1011,NULL,NULL,NULL),
 (1013,768,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1011,NULL,NULL,NULL),
 (1014,769,'TUITION FEE',6000,NULL,'20180502',10,38,'FBLL','13',NULL,'613',NULL,NULL,NULL,'1','R',NULL,NULL,328,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1015,769,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1014,NULL,NULL,NULL),
 (1016,769,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1014,NULL,NULL,NULL),
 (1017,770,'TUITION FEE',6000,NULL,'20180502',10,39,'FBLL','13',NULL,'614',NULL,NULL,NULL,'1','R',NULL,NULL,329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1018,770,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1017,NULL,NULL,NULL),
 (1019,770,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1017,NULL,NULL,NULL),
 (1020,771,'TUITION FEE',6000,NULL,'20180502',10,40,'FBLL','13',NULL,'616',NULL,NULL,NULL,'1','R',NULL,NULL,330,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1021,771,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1020,NULL,NULL,NULL),
 (1022,771,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1020,NULL,NULL,NULL),
 (1023,772,'TUITION FEE',6000,NULL,'20180502',10,41,'FBLL','13',NULL,'620',NULL,NULL,NULL,'1','R',NULL,NULL,331,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1024,772,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1023,NULL,NULL,NULL),
 (1025,772,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1023,NULL,NULL,NULL),
 (1026,773,'TUITION FEE',6000,NULL,'20180502',10,42,'FBLL','13',NULL,'622',NULL,NULL,NULL,'1','R',NULL,NULL,332,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1027,773,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1026,NULL,NULL,NULL),
 (1028,773,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1026,NULL,NULL,NULL),
 (1029,774,'TUITION FEE',6000,NULL,'20180502',10,43,'FBLL','13',NULL,'623',NULL,NULL,NULL,'1','R',NULL,NULL,333,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1030,774,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1029,NULL,NULL,NULL),
 (1031,774,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1029,NULL,NULL,NULL),
 (1032,775,'TUITION FEE',6000,NULL,'20180502',10,44,'FBLL','13',NULL,'624',NULL,NULL,NULL,'1','R',NULL,NULL,334,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1033,775,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1032,NULL,NULL,NULL),
 (1034,775,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1032,NULL,NULL,NULL),
 (1035,776,'TUITION FEE',6000,NULL,'20180502',10,45,'FBLL','13',NULL,'625',NULL,NULL,NULL,'1','R',NULL,NULL,335,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1036,776,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1035,NULL,NULL,NULL),
 (1037,776,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1035,NULL,NULL,NULL),
 (1038,777,'TUITION FEE',6000,NULL,'20180502',10,46,'FBLL','13',NULL,'626',NULL,NULL,NULL,'1','R',NULL,NULL,336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1039,777,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1038,NULL,NULL,NULL),
 (1040,777,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1038,NULL,NULL,NULL),
 (1041,778,'TUITION FEE',6000,NULL,'20180502',10,47,'FBLL','13',NULL,'628',NULL,NULL,NULL,'1','R',NULL,NULL,337,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1042,778,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1041,NULL,NULL,NULL),
 (1043,778,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1041,NULL,NULL,NULL),
 (1044,779,'TUITION FEE',6000,NULL,'20180502',10,48,'FBLL','13',NULL,'629',NULL,NULL,NULL,'1','R',NULL,NULL,338,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1045,779,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1044,NULL,NULL,NULL),
 (1046,779,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1044,NULL,NULL,NULL),
 (1047,780,'TUITION FEE',6000,NULL,'20180502',10,49,'FBLL','13',NULL,'630',NULL,NULL,NULL,'1','R',NULL,NULL,339,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1048,780,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1047,NULL,NULL,NULL),
 (1049,780,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1047,NULL,NULL,NULL),
 (1050,781,'TUITION FEE',6000,NULL,'20180502',10,50,'FBLL','13',NULL,'631',NULL,NULL,NULL,'1','R',NULL,NULL,340,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1051,781,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1050,NULL,NULL,NULL),
 (1052,781,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1050,NULL,NULL,NULL),
 (1053,782,'TUITION FEE',6000,NULL,'20180502',10,51,'FBLL','13',NULL,'632',NULL,NULL,NULL,'1','R',NULL,NULL,341,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1054,782,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1053,NULL,NULL,NULL),
 (1055,782,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1053,NULL,NULL,NULL),
 (1056,783,'TUITION FEE',6000,NULL,'20180502',10,52,'FBLL','13',NULL,'633',NULL,NULL,NULL,'1','R',NULL,NULL,342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1057,783,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1056,NULL,NULL,NULL),
 (1058,783,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1056,NULL,NULL,NULL),
 (1059,784,'TUITION FEE',6000,NULL,'20180502',10,53,'FBLL','13',NULL,'634',NULL,NULL,NULL,'1','R',NULL,NULL,343,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1060,784,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1059,NULL,NULL,NULL),
 (1061,784,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1059,NULL,NULL,NULL),
 (1062,785,'TUITION FEE',6000,NULL,'20180502',10,54,'FBLL','13',NULL,'635',NULL,NULL,NULL,'1','R',NULL,NULL,344,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1063,785,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1062,NULL,NULL,NULL),
 (1064,785,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1062,NULL,NULL,NULL),
 (1065,786,'TUITION FEE',6000,NULL,'20180502',10,55,'FBLL','13',NULL,'636',NULL,NULL,NULL,'1','R',NULL,NULL,345,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1066,786,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1065,NULL,NULL,NULL),
 (1067,786,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1065,NULL,NULL,NULL),
 (1068,787,'TUITION FEE',6000,NULL,'20180502',10,56,'FBLL','13',NULL,'637',NULL,NULL,NULL,'1','R',NULL,NULL,346,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1069,787,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1068,NULL,NULL,NULL),
 (1070,787,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1068,NULL,NULL,NULL),
 (1071,788,'TUITION FEE',6000,NULL,'20180502',10,57,'FBLL','13',NULL,'638',NULL,NULL,NULL,'1','R',NULL,NULL,347,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1072,788,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1071,NULL,NULL,NULL),
 (1073,788,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1071,NULL,NULL,NULL),
 (1074,789,'TUITION FEE',6000,NULL,'20180502',10,58,'FBLL','13',NULL,'639',NULL,NULL,NULL,'1','R',NULL,NULL,348,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1075,789,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1074,NULL,NULL,NULL),
 (1076,789,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1074,NULL,NULL,NULL),
 (1077,790,'TUITION FEE',6000,NULL,'20180502',10,59,'FBLL','13',NULL,'640',NULL,NULL,NULL,'1','R',NULL,NULL,349,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1078,790,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1077,NULL,NULL,NULL),
 (1079,790,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1077,NULL,NULL,NULL),
 (1080,791,'TUITION FEE',6000,NULL,'20180502',10,60,'FBLL','13',NULL,'641',NULL,NULL,NULL,'1','R',NULL,NULL,350,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1081,791,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1080,NULL,NULL,NULL),
 (1082,791,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1080,NULL,NULL,NULL),
 (1083,792,'TUITION FEE',6000,NULL,'20180502',10,61,'FBLL','13',NULL,'642',NULL,NULL,NULL,'1','R',NULL,NULL,351,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1084,792,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1083,NULL,NULL,NULL),
 (1085,792,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1083,NULL,NULL,NULL),
 (1086,793,'TUITION FEE',6000,NULL,'20180502',10,62,'FBLL','13',NULL,'643',NULL,NULL,NULL,'1','R',NULL,NULL,352,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1087,793,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1086,NULL,NULL,NULL),
 (1088,793,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1086,NULL,NULL,NULL),
 (1089,794,'TUITION FEE',6000,NULL,'20180502',10,63,'FBLL','13',NULL,'644',NULL,NULL,NULL,'1','R',NULL,NULL,353,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1090,794,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1089,NULL,NULL,NULL),
 (1091,794,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1089,NULL,NULL,NULL),
 (1092,795,'TUITION FEE',6000,NULL,'20180502',10,64,'FBLL','13',NULL,'645',NULL,NULL,NULL,'1','R',NULL,NULL,354,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1093,795,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1092,NULL,NULL,NULL),
 (1094,795,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1092,NULL,NULL,NULL),
 (1095,796,'TUITION FEE',6000,NULL,'20180502',10,65,'FBLL','13',NULL,'646',NULL,NULL,NULL,'1','R',NULL,NULL,355,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1096,796,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1095,NULL,NULL,NULL),
 (1097,796,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1095,NULL,NULL,NULL),
 (1098,797,'TUITION FEE',6000,NULL,'20180502',10,66,'FBLL','13',NULL,'647',NULL,NULL,NULL,'1','R',NULL,NULL,356,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1099,797,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1098,NULL,NULL,NULL),
 (1100,797,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1098,NULL,NULL,NULL),
 (1101,798,'TUITION FEE',6000,NULL,'20180502',10,67,'FBLL','13',NULL,'648',NULL,NULL,NULL,'1','R',NULL,NULL,357,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1102,798,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1101,NULL,NULL,NULL),
 (1103,798,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1101,NULL,NULL,NULL),
 (1104,799,'TUITION FEE',6000,NULL,'20180502',10,68,'FBLL','13',NULL,'649',NULL,NULL,NULL,'1','R',NULL,NULL,358,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1105,799,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1104,NULL,NULL,NULL),
 (1106,799,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1104,NULL,NULL,NULL),
 (1107,800,'TUITION FEE',6000,NULL,'20180502',10,69,'FBLL','13',NULL,'650',NULL,NULL,NULL,'1','R',NULL,NULL,359,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1108,800,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1107,NULL,NULL,NULL),
 (1109,800,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1107,NULL,NULL,NULL),
 (1110,801,'TUITION FEE',6000,NULL,'20180502',10,70,'FBLL','13',NULL,'651',NULL,NULL,NULL,'1','R',NULL,NULL,360,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1111,801,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1110,NULL,NULL,NULL),
 (1112,801,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1110,NULL,NULL,NULL),
 (1113,802,'TUITION FEE',6000,NULL,'20180502',10,71,'FBLL','13',NULL,'652',NULL,NULL,NULL,'1','R',NULL,NULL,361,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1114,802,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1113,NULL,NULL,NULL),
 (1115,802,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1113,NULL,NULL,NULL),
 (1116,803,'TUITION FEE',6000,NULL,'20180502',10,72,'FBLL','13',NULL,'653',NULL,NULL,NULL,'1','R',NULL,NULL,362,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1117,803,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1116,NULL,NULL,NULL),
 (1118,803,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1116,NULL,NULL,NULL),
 (1119,804,'TUITION FEE',6000,NULL,'20180502',10,73,'FBLL','13',NULL,'654',NULL,NULL,NULL,'1','R',NULL,NULL,363,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1120,804,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1119,NULL,NULL,NULL),
 (1121,804,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1119,NULL,NULL,NULL),
 (1122,805,'TUITION FEE',6000,NULL,'20180502',10,74,'FBLL','13',NULL,'655',NULL,NULL,NULL,'1','R',NULL,NULL,364,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1123,805,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1122,NULL,NULL,NULL),
 (1124,805,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1122,NULL,NULL,NULL),
 (1125,806,'TUITION FEE',6000,NULL,'20180502',10,75,'FBLL','13',NULL,'656',NULL,NULL,NULL,'1','R',NULL,NULL,365,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1126,806,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1125,NULL,NULL,NULL),
 (1127,806,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1125,NULL,NULL,NULL),
 (1128,807,'TUITION FEE',6000,NULL,'20180502',10,76,'FBLL','13',NULL,'657',NULL,NULL,NULL,'1','R',NULL,NULL,366,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1129,807,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1128,NULL,NULL,NULL),
 (1130,807,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1128,NULL,NULL,NULL),
 (1131,808,'TUITION FEE',6000,NULL,'20180502',10,77,'FBLL','13',NULL,'658',NULL,NULL,NULL,'1','R',NULL,NULL,367,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1132,808,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1131,NULL,NULL,NULL),
 (1133,808,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1131,NULL,NULL,NULL),
 (1134,809,'TUITION FEE',6000,NULL,'20180502',10,78,'FBLL','13',NULL,'659',NULL,NULL,NULL,'1','R',NULL,NULL,368,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1135,809,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1134,NULL,NULL,NULL),
 (1136,809,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1134,NULL,NULL,NULL),
 (1137,810,'TUITION FEE',6000,NULL,'20180502',10,79,'FBLL','13',NULL,'661',NULL,NULL,NULL,'1','R',NULL,NULL,369,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1138,810,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1137,NULL,NULL,NULL),
 (1139,810,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1137,NULL,NULL,NULL),
 (1140,811,'TUITION FEE',6000,NULL,'20180502',10,80,'FBLL','13',NULL,'664',NULL,NULL,NULL,'1','R',NULL,NULL,370,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1141,811,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1140,NULL,NULL,NULL),
 (1142,811,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1140,NULL,NULL,NULL),
 (1143,812,'TUITION FEE',6000,NULL,'20180502',10,81,'FBLL','13',NULL,'668',NULL,NULL,NULL,'1','R',NULL,NULL,371,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1144,812,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1143,NULL,NULL,NULL),
 (1145,812,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1143,NULL,NULL,NULL),
 (1146,813,'TUITION FEE',6000,NULL,'20180502',10,82,'FBLL','13',NULL,'674',NULL,NULL,NULL,'1','R',NULL,NULL,372,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1147,813,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1146,NULL,NULL,NULL),
 (1148,813,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1146,NULL,NULL,NULL),
 (1149,814,'TUITION FEE',6000,NULL,'20180502',10,83,'FBLL','13',NULL,'713',NULL,NULL,NULL,'1','R',NULL,NULL,373,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1150,814,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1149,NULL,NULL,NULL),
 (1151,814,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1149,NULL,NULL,NULL),
 (1152,815,'TUITION FEE',6000,NULL,'20180502',10,84,'FBLL','13',NULL,'714',NULL,NULL,NULL,'1','R',NULL,NULL,374,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1153,815,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1152,NULL,NULL,NULL),
 (1154,815,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1152,NULL,NULL,NULL),
 (1155,816,'TUITION FEE',6000,NULL,'20180502',10,85,'FBLL','13',NULL,'716',NULL,NULL,NULL,'1','R',NULL,NULL,375,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1156,816,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1155,NULL,NULL,NULL),
 (1157,816,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1155,NULL,NULL,NULL),
 (1158,817,'TUITION FEE',6000,NULL,'20180502',10,86,'FBLL','13',NULL,'718',NULL,NULL,NULL,'1','R',NULL,NULL,376,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1159,817,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1158,NULL,NULL,NULL),
 (1160,817,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1158,NULL,NULL,NULL),
 (1161,818,'TUITION FEE',6000,NULL,'20180502',10,87,'FBLL','13',NULL,'724',NULL,NULL,NULL,'1','R',NULL,NULL,377,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1162,818,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1161,NULL,NULL,NULL),
 (1163,818,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1161,NULL,NULL,NULL),
 (1164,819,'TUITION FEE',6000,NULL,'20180502',10,88,'FBLL','13',NULL,'748',NULL,NULL,NULL,'1','R',NULL,NULL,378,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1165,819,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1164,NULL,NULL,NULL),
 (1166,819,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1164,NULL,NULL,NULL),
 (1167,820,'TUITION FEE',6000,NULL,'20180502',10,89,'FBLL','13',NULL,'757',NULL,NULL,NULL,'1','R',NULL,NULL,379,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1168,820,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1167,NULL,NULL,NULL),
 (1169,820,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1167,NULL,NULL,NULL),
 (1170,821,'TUITION FEE',6000,NULL,'20180502',10,90,'FBLL','13',NULL,'758',NULL,NULL,NULL,'1','R',NULL,NULL,380,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1171,821,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1170,NULL,NULL,NULL),
 (1172,821,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1170,NULL,NULL,NULL),
 (1173,822,'TUITION FEE',6000,NULL,'20180502',10,91,'FBLL','13',NULL,'759',NULL,NULL,NULL,'1','R',NULL,NULL,381,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1174,822,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1173,NULL,NULL,NULL),
 (1175,822,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1173,NULL,NULL,NULL),
 (1176,823,'TUITION FEE',6000,NULL,'20180502',10,92,'FBLL','13',NULL,'769',NULL,NULL,NULL,'1','R',NULL,NULL,382,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1177,823,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1176,NULL,NULL,NULL),
 (1178,823,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1176,NULL,NULL,NULL),
 (1179,824,'TUITION FEE',6000,NULL,'20180502',10,93,'FBLL','13',NULL,'777',NULL,NULL,NULL,'1','R',NULL,NULL,383,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1180,824,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1179,NULL,NULL,NULL),
 (1181,824,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1179,NULL,NULL,NULL),
 (1182,825,'TUITION FEE',6000,NULL,'20180502',10,94,'FBLL','13',NULL,'363',NULL,NULL,NULL,'1','R',NULL,NULL,384,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1183,825,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1182,NULL,NULL,NULL),
 (1184,825,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1182,NULL,NULL,NULL),
 (1185,826,'TUITION FEE',6000,NULL,'20180502',10,95,'FBLL','13',NULL,'476',NULL,NULL,NULL,'1','R',NULL,NULL,385,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1186,826,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1185,NULL,NULL,NULL),
 (1187,826,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1185,NULL,NULL,NULL),
 (1188,827,'TUITION FEE',6000,NULL,'20180502',10,96,'FBLL','13',NULL,'477',NULL,NULL,NULL,'1','R',NULL,NULL,386,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1189,827,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1188,NULL,NULL,NULL),
 (1190,827,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1188,NULL,NULL,NULL),
 (1191,828,'TUITION FEE',6000,NULL,'20180502',10,97,'FBLL','13',NULL,'478',NULL,NULL,NULL,'1','R',NULL,NULL,387,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1192,828,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1191,NULL,NULL,NULL),
 (1193,828,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1191,NULL,NULL,NULL),
 (1194,829,'TUITION FEE',6000,NULL,'20180502',10,98,'FBLL','13',NULL,'479',NULL,NULL,NULL,'1','R',NULL,NULL,388,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1195,829,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1194,NULL,NULL,NULL),
 (1196,829,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1194,NULL,NULL,NULL),
 (1197,830,'TUITION FEE',6000,NULL,'20180502',10,99,'FBLL','13',NULL,'480',NULL,NULL,NULL,'1','R',NULL,NULL,389,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1198,830,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1197,NULL,NULL,NULL),
 (1199,830,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1197,NULL,NULL,NULL),
 (1200,831,'TUITION FEE',6000,NULL,'20180502',10,100,'FBLL','13',NULL,'481',NULL,NULL,NULL,'1','R',NULL,NULL,390,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1201,831,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1200,NULL,NULL,NULL),
 (1202,831,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1200,NULL,NULL,NULL),
 (1203,832,'TUITION FEE',6000,NULL,'20180502',10,101,'FBLL','13',NULL,'482',NULL,NULL,NULL,'1','R',NULL,NULL,391,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1204,832,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1203,NULL,NULL,NULL),
 (1205,832,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1203,NULL,NULL,NULL),
 (1206,833,'TUITION FEE',6000,NULL,'20180502',10,102,'FBLL','13',NULL,'483',NULL,NULL,NULL,'1','R',NULL,NULL,392,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1207,833,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1206,NULL,NULL,NULL),
 (1208,833,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1206,NULL,NULL,NULL),
 (1209,834,'TUITION FEE',6000,NULL,'20180502',10,103,'FBLL','13',NULL,'484',NULL,NULL,NULL,'1','R',NULL,NULL,393,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1210,834,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1209,NULL,NULL,NULL),
 (1211,834,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1209,NULL,NULL,NULL),
 (1212,835,'TUITION FEE',6000,NULL,'20180502',10,104,'FBLL','13',NULL,'485',NULL,NULL,NULL,'1','R',NULL,NULL,394,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1213,835,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1212,NULL,NULL,NULL),
 (1214,835,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1212,NULL,NULL,NULL),
 (1215,836,'TUITION FEE',6000,NULL,'20180502',10,105,'FBLL','13',NULL,'486',NULL,NULL,NULL,'1','R',NULL,NULL,395,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1216,836,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1215,NULL,NULL,NULL),
 (1217,836,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1215,NULL,NULL,NULL),
 (1218,837,'TUITION FEE',6000,NULL,'20180502',10,106,'FBLL','13',NULL,'487',NULL,NULL,NULL,'1','R',NULL,NULL,396,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1219,837,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1218,NULL,NULL,NULL),
 (1220,837,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1218,NULL,NULL,NULL),
 (1221,838,'TUITION FEE',6000,NULL,'20180502',10,107,'FBLL','13',NULL,'488',NULL,NULL,NULL,'1','R',NULL,NULL,397,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1222,838,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1221,NULL,NULL,NULL),
 (1223,838,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1221,NULL,NULL,NULL),
 (1224,839,'TUITION FEE',6000,NULL,'20180502',10,108,'FBLL','13',NULL,'489',NULL,NULL,NULL,'1','R',NULL,NULL,398,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1225,839,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1224,NULL,NULL,NULL),
 (1226,839,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1224,NULL,NULL,NULL),
 (1227,840,'TUITION FEE',6000,NULL,'20180502',10,109,'FBLL','13',NULL,'490',NULL,NULL,NULL,'1','R',NULL,NULL,399,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1228,840,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1227,NULL,NULL,NULL),
 (1229,840,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1227,NULL,NULL,NULL),
 (1230,841,'TUITION FEE',6000,NULL,'20180502',10,110,'FBLL','13',NULL,'491',NULL,NULL,NULL,'1','R',NULL,NULL,400,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1231,841,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1230,NULL,NULL,NULL),
 (1232,841,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1230,NULL,NULL,NULL),
 (1233,842,'TUITION FEE',6000,NULL,'20180502',10,111,'FBLL','13',NULL,'492',NULL,NULL,NULL,'1','R',NULL,NULL,401,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1234,842,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1233,NULL,NULL,NULL),
 (1235,842,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1233,NULL,NULL,NULL),
 (1236,843,'TUITION FEE',6000,NULL,'20180502',10,112,'FBLL','13',NULL,'493',NULL,NULL,NULL,'1','R',NULL,NULL,402,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1237,843,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1236,NULL,NULL,NULL),
 (1238,843,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1236,NULL,NULL,NULL),
 (1239,844,'TUITION FEE',6000,NULL,'20180502',10,113,'FBLL','13',NULL,'494',NULL,NULL,NULL,'1','R',NULL,NULL,403,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1240,844,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1239,NULL,NULL,NULL),
 (1241,844,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1239,NULL,NULL,NULL),
 (1242,845,'TUITION FEE',6000,NULL,'20180502',10,114,'FBLL','13',NULL,'495',NULL,NULL,NULL,'1','R',NULL,NULL,404,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1243,845,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1242,NULL,NULL,NULL),
 (1244,845,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1242,NULL,NULL,NULL),
 (1245,846,'TUITION FEE',6000,NULL,'20180502',10,115,'FBLL','13',NULL,'496',NULL,NULL,NULL,'1','R',NULL,NULL,405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1246,846,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1245,NULL,NULL,NULL),
 (1247,846,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1245,NULL,NULL,NULL),
 (1248,847,'TUITION FEE',6000,NULL,'20180502',10,116,'FBLL','13',NULL,'497',NULL,NULL,NULL,'1','R',NULL,NULL,406,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1249,847,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1248,NULL,NULL,NULL),
 (1250,847,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1248,NULL,NULL,NULL),
 (1251,848,'TUITION FEE',6000,NULL,'20180502',10,117,'FBLL','13',NULL,'498',NULL,NULL,NULL,'1','R',NULL,NULL,407,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1252,848,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1251,NULL,NULL,NULL),
 (1253,848,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1251,NULL,NULL,NULL),
 (1254,849,'TUITION FEE',6000,NULL,'20180502',10,118,'FBLL','13',NULL,'499',NULL,NULL,NULL,'1','R',NULL,NULL,408,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1255,849,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1254,NULL,NULL,NULL),
 (1256,849,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1254,NULL,NULL,NULL),
 (1257,850,'TUITION FEE',6000,NULL,'20180502',10,119,'FBLL','13',NULL,'501',NULL,NULL,NULL,'1','R',NULL,NULL,409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1258,850,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1257,NULL,NULL,NULL),
 (1259,850,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1257,NULL,NULL,NULL),
 (1260,851,'TUITION FEE',6000,NULL,'20180502',10,120,'FBLL','13',NULL,'503',NULL,NULL,NULL,'1','R',NULL,NULL,410,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1261,851,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1260,NULL,NULL,NULL),
 (1262,851,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1260,NULL,NULL,NULL),
 (1263,852,'TUITION FEE',6000,NULL,'20180502',10,121,'FBLL','13',NULL,'505',NULL,NULL,NULL,'1','R',NULL,NULL,411,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1264,852,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1263,NULL,NULL,NULL),
 (1265,852,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1263,NULL,NULL,NULL),
 (1266,853,'TUITION FEE',6000,NULL,'20180502',10,122,'FBLL','13',NULL,'506',NULL,NULL,NULL,'1','R',NULL,NULL,412,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1267,853,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1266,NULL,NULL,NULL),
 (1268,853,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1266,NULL,NULL,NULL),
 (1269,854,'TUITION FEE',6000,NULL,'20180502',10,123,'FBLL','13',NULL,'507',NULL,NULL,NULL,'1','R',NULL,NULL,413,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1270,854,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1269,NULL,NULL,NULL),
 (1271,854,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1269,NULL,NULL,NULL),
 (1272,855,'TUITION FEE',6000,NULL,'20180502',10,124,'FBLL','13',NULL,'509',NULL,NULL,NULL,'1','R',NULL,NULL,414,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1273,855,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1272,NULL,NULL,NULL),
 (1274,855,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1272,NULL,NULL,NULL),
 (1275,856,'TUITION FEE',6000,NULL,'20180502',10,125,'FBLL','13',NULL,'511',NULL,NULL,NULL,'1','R',NULL,NULL,415,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1276,856,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1275,NULL,NULL,NULL),
 (1277,856,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1275,NULL,NULL,NULL),
 (1278,857,'TUITION FEE',6000,NULL,'20180502',10,126,'FBLL','13',NULL,'512',NULL,NULL,NULL,'1','R',NULL,NULL,416,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1279,857,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1278,NULL,NULL,NULL),
 (1280,857,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1278,NULL,NULL,NULL),
 (1281,858,'TUITION FEE',6000,NULL,'20180502',10,127,'FBLL','13',NULL,'513',NULL,NULL,NULL,'1','R',NULL,NULL,417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1282,858,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1281,NULL,NULL,NULL),
 (1283,858,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1281,NULL,NULL,NULL),
 (1284,859,'TUITION FEE',6000,NULL,'20180502',10,128,'FBLL','13',NULL,'514',NULL,NULL,NULL,'1','R',NULL,NULL,418,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1285,859,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1284,NULL,NULL,NULL),
 (1286,859,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1284,NULL,NULL,NULL),
 (1287,860,'TUITION FEE',6000,NULL,'20180502',10,129,'FBLL','13',NULL,'515',NULL,NULL,NULL,'1','R',NULL,NULL,419,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1288,860,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1287,NULL,NULL,NULL),
 (1289,860,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1287,NULL,NULL,NULL),
 (1290,861,'TUITION FEE',6000,NULL,'20180502',10,130,'FBLL','13',NULL,'516',NULL,NULL,NULL,'1','R',NULL,NULL,420,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1291,861,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1290,NULL,NULL,NULL),
 (1292,861,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1290,NULL,NULL,NULL),
 (1293,862,'TUITION FEE',6000,NULL,'20180502',10,131,'FBLL','13',NULL,'518',NULL,NULL,NULL,'1','R',NULL,NULL,421,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1294,862,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1293,NULL,NULL,NULL),
 (1295,862,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1293,NULL,NULL,NULL),
 (1296,863,'TUITION FEE',6000,NULL,'20180502',10,132,'FBLL','13',NULL,'519',NULL,NULL,NULL,'1','R',NULL,NULL,422,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1297,863,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1296,NULL,NULL,NULL),
 (1298,863,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1296,NULL,NULL,NULL),
 (1299,864,'TUITION FEE',6000,NULL,'20180502',10,133,'FBLL','13',NULL,'521',NULL,NULL,NULL,'1','R',NULL,NULL,423,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1300,864,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1299,NULL,NULL,NULL),
 (1301,864,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1299,NULL,NULL,NULL),
 (1302,865,'TUITION FEE',6000,NULL,'20180502',10,134,'FBLL','13',NULL,'522',NULL,NULL,NULL,'1','R',NULL,NULL,424,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1303,865,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1302,NULL,NULL,NULL),
 (1304,865,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1302,NULL,NULL,NULL),
 (1305,866,'TUITION FEE',6000,NULL,'20180502',10,135,'FBLL','13',NULL,'523',NULL,NULL,NULL,'1','R',NULL,NULL,425,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1306,866,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1305,NULL,NULL,NULL),
 (1307,866,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1305,NULL,NULL,NULL),
 (1308,867,'TUITION FEE',6000,NULL,'20180502',10,136,'FBLL','13',NULL,'524',NULL,NULL,NULL,'1','R',NULL,NULL,426,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1309,867,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1308,NULL,NULL,NULL),
 (1310,867,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1308,NULL,NULL,NULL),
 (1311,868,'TUITION FEE',6000,NULL,'20180502',10,137,'FBLL','13',NULL,'525',NULL,NULL,NULL,'1','R',NULL,NULL,427,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1312,868,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1311,NULL,NULL,NULL),
 (1313,868,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1311,NULL,NULL,NULL),
 (1314,869,'TUITION FEE',6000,NULL,'20180502',10,138,'FBLL','13',NULL,'528',NULL,NULL,NULL,'1','R',NULL,NULL,428,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1315,869,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1314,NULL,NULL,NULL),
 (1316,869,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1314,NULL,NULL,NULL),
 (1317,870,'TUITION FEE',6000,NULL,'20180502',10,139,'FBLL','13',NULL,'529',NULL,NULL,NULL,'1','R',NULL,NULL,429,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1318,870,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1317,NULL,NULL,NULL),
 (1319,870,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1317,NULL,NULL,NULL),
 (1320,871,'TUITION FEE',6000,NULL,'20180502',10,140,'FBLL','13',NULL,'530',NULL,NULL,NULL,'1','R',NULL,NULL,430,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1321,871,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1320,NULL,NULL,NULL),
 (1322,871,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1320,NULL,NULL,NULL),
 (1323,872,'TUITION FEE',6000,NULL,'20180502',10,141,'FBLL','13',NULL,'532',NULL,NULL,NULL,'1','R',NULL,NULL,431,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1324,872,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1323,NULL,NULL,NULL),
 (1325,872,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1323,NULL,NULL,NULL),
 (1326,873,'TUITION FEE',6000,NULL,'20180502',10,142,'FBLL','13',NULL,'533',NULL,NULL,NULL,'1','R',NULL,NULL,432,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1327,873,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1326,NULL,NULL,NULL),
 (1328,873,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1326,NULL,NULL,NULL),
 (1329,874,'TUITION FEE',6000,NULL,'20180502',10,143,'FBLL','13',NULL,'534',NULL,NULL,NULL,'1','R',NULL,NULL,433,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `journalappendold` (`Id`,`TrId`,`Descr`,`DrAmount`,`CrAmount`,`TransNo`,`SAcc`,`SSAcc`,`RefAcc`,`TrSt`,`TK`,`ref1`,`ref2`,`ref3`,`ref4`,`ref5`,`ref6`,`Qty`,`TrType`,`psid`,`chno`,`ContNo`,`TDate`,`BANK`,`BRANCH`,`CNAME`,`KId`,`PRID`,`PTP`,`RefId`,`prt`,`stId`,`checkno`) VALUES 
 (1330,874,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1329,NULL,NULL,NULL),
 (1331,874,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1329,NULL,NULL,NULL),
 (1332,875,'TUITION FEE',6000,NULL,'20180502',10,144,'FBLL','13',NULL,'535',NULL,NULL,NULL,'1','R',NULL,NULL,434,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1333,875,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1332,NULL,NULL,NULL),
 (1334,875,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1332,NULL,NULL,NULL),
 (1335,876,'TUITION FEE',6000,NULL,'20180502',10,145,'FBLL','13',NULL,'536',NULL,NULL,NULL,'1','R',NULL,NULL,435,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1336,876,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1335,NULL,NULL,NULL),
 (1337,876,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1335,NULL,NULL,NULL),
 (1338,877,'TUITION FEE',6000,NULL,'20180502',10,146,'FBLL','13',NULL,'537',NULL,NULL,NULL,'1','R',NULL,NULL,436,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1339,877,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1338,NULL,NULL,NULL),
 (1340,877,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1338,NULL,NULL,NULL),
 (1341,878,'TUITION FEE',6000,NULL,'20180502',10,147,'FBLL','13',NULL,'538',NULL,NULL,NULL,'1','R',NULL,NULL,437,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1342,878,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1341,NULL,NULL,NULL),
 (1343,878,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1341,NULL,NULL,NULL),
 (1344,879,'TUITION FEE',6000,NULL,'20180502',10,148,'FBLL','13',NULL,'539',NULL,NULL,NULL,'1','R',NULL,NULL,438,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1345,879,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1344,NULL,NULL,NULL),
 (1346,879,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1344,NULL,NULL,NULL),
 (1347,880,'TUITION FEE',6000,NULL,'20180502',10,149,'FBLL','13',NULL,'540',NULL,NULL,NULL,'1','R',NULL,NULL,439,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1348,880,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1347,NULL,NULL,NULL),
 (1349,880,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1347,NULL,NULL,NULL),
 (1350,881,'TUITION FEE',6000,NULL,'20180502',10,150,'FBLL','13',NULL,'541',NULL,NULL,NULL,'1','R',NULL,NULL,440,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1351,881,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1350,NULL,NULL,NULL),
 (1352,881,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1350,NULL,NULL,NULL),
 (1353,882,'TUITION FEE',6000,NULL,'20180502',10,151,'FBLL','13',NULL,'542',NULL,NULL,NULL,'1','R',NULL,NULL,441,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1354,882,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1353,NULL,NULL,NULL),
 (1355,882,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1353,NULL,NULL,NULL),
 (1356,883,'TUITION FEE',6000,NULL,'20180502',10,152,'FBLL','13',NULL,'546',NULL,NULL,NULL,'1','R',NULL,NULL,442,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1357,883,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1356,NULL,NULL,NULL),
 (1358,883,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1356,NULL,NULL,NULL),
 (1359,884,'TUITION FEE',6000,NULL,'20180502',10,153,'FBLL','13',NULL,'547',NULL,NULL,NULL,'1','R',NULL,NULL,443,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1360,884,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1359,NULL,NULL,NULL),
 (1361,884,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1359,NULL,NULL,NULL),
 (1362,885,'TUITION FEE',6000,NULL,'20180502',10,154,'FBLL','13',NULL,'548',NULL,NULL,NULL,'1','R',NULL,NULL,444,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1363,885,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1362,NULL,NULL,NULL),
 (1364,885,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1362,NULL,NULL,NULL),
 (1365,886,'TUITION FEE',6000,NULL,'20180502',10,155,'FBLL','13',NULL,'549',NULL,NULL,NULL,'1','R',NULL,NULL,445,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1366,886,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1365,NULL,NULL,NULL),
 (1367,886,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1365,NULL,NULL,NULL),
 (1368,887,'TUITION FEE',6000,NULL,'20180502',10,156,'FBLL','13',NULL,'550',NULL,NULL,NULL,'1','R',NULL,NULL,446,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1369,887,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1368,NULL,NULL,NULL),
 (1370,887,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1368,NULL,NULL,NULL),
 (1371,888,'TUITION FEE',6000,NULL,'20180502',10,157,'FBLL','13',NULL,'551',NULL,NULL,NULL,'1','R',NULL,NULL,447,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1372,888,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1371,NULL,NULL,NULL),
 (1373,888,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1371,NULL,NULL,NULL),
 (1374,889,'TUITION FEE',6000,NULL,'20180502',10,158,'FBLL','13',NULL,'552',NULL,NULL,NULL,'1','R',NULL,NULL,448,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1375,889,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1374,NULL,NULL,NULL),
 (1376,889,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1374,NULL,NULL,NULL),
 (1377,890,'TUITION FEE',6000,NULL,'20180502',10,159,'FBLL','13',NULL,'553',NULL,NULL,NULL,'1','R',NULL,NULL,449,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1378,890,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1377,NULL,NULL,NULL),
 (1379,890,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1377,NULL,NULL,NULL),
 (1380,891,'TUITION FEE',6000,NULL,'20180502',10,160,'FBLL','13',NULL,'612',NULL,NULL,NULL,'1','R',NULL,NULL,450,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1381,891,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1380,NULL,NULL,NULL),
 (1382,891,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1380,NULL,NULL,NULL),
 (1383,892,'TUITION FEE',6000,NULL,'20180502',10,161,'FBLL','13',NULL,'627',NULL,NULL,NULL,'1','R',NULL,NULL,451,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1384,892,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1383,NULL,NULL,NULL),
 (1385,892,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1383,NULL,NULL,NULL),
 (1386,893,'TUITION FEE',6000,NULL,'20180502',10,162,'FBLL','13',NULL,'660',NULL,NULL,NULL,'1','R',NULL,NULL,452,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1387,893,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1386,NULL,NULL,NULL),
 (1388,893,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1386,NULL,NULL,NULL),
 (1389,894,'TUITION FEE',6000,NULL,'20180502',10,163,'FBLL','13',NULL,'666',NULL,NULL,NULL,'1','R',NULL,NULL,453,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1390,894,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1389,NULL,NULL,NULL),
 (1391,894,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1389,NULL,NULL,NULL),
 (1392,895,'TUITION FEE',6000,NULL,'20180502',10,164,'FBLL','13',NULL,'669',NULL,NULL,NULL,'1','R',NULL,NULL,454,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1393,895,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1392,NULL,NULL,NULL),
 (1394,895,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1392,NULL,NULL,NULL),
 (1395,896,'TUITION FEE',6000,NULL,'20180502',10,165,'FBLL','13',NULL,'671',NULL,NULL,NULL,'1','R',NULL,NULL,455,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1396,896,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1395,NULL,NULL,NULL),
 (1397,896,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1395,NULL,NULL,NULL),
 (1398,897,'TUITION FEE',6000,NULL,'20180502',10,166,'FBLL','13',NULL,'679',NULL,NULL,NULL,'1','R',NULL,NULL,456,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1399,897,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1398,NULL,NULL,NULL),
 (1400,897,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1398,NULL,NULL,NULL),
 (1401,898,'TUITION FEE',6000,NULL,'20180502',10,167,'FBLL','13',NULL,'684',NULL,NULL,NULL,'1','R',NULL,NULL,457,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1402,898,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1401,NULL,NULL,NULL),
 (1403,898,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1401,NULL,NULL,NULL),
 (1404,899,'TUITION FEE',6000,NULL,'20180502',10,168,'FBLL','13',NULL,'689',NULL,NULL,NULL,'1','R',NULL,NULL,458,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1405,899,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1404,NULL,NULL,NULL),
 (1406,899,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1404,NULL,NULL,NULL),
 (1407,900,'TUITION FEE',6000,NULL,'20180502',10,169,'FBLL','13',NULL,'691',NULL,NULL,NULL,'1','R',NULL,NULL,459,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1408,900,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1407,NULL,NULL,NULL),
 (1409,900,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1407,NULL,NULL,NULL),
 (1410,901,'TUITION FEE',6000,NULL,'20180502',10,170,'FBLL','13',NULL,'693',NULL,NULL,NULL,'1','R',NULL,NULL,460,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1411,901,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1410,NULL,NULL,NULL),
 (1412,901,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1410,NULL,NULL,NULL),
 (1413,902,'TUITION FEE',6000,NULL,'20180502',10,171,'FBLL','13',NULL,'701',NULL,NULL,NULL,'1','R',NULL,NULL,461,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1414,902,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1413,NULL,NULL,NULL),
 (1415,902,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1413,NULL,NULL,NULL),
 (1416,903,'TUITION FEE',6000,NULL,'20180502',10,172,'FBLL','13',NULL,'706',NULL,NULL,NULL,'1','R',NULL,NULL,462,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1417,903,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1416,NULL,NULL,NULL),
 (1418,903,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1416,NULL,NULL,NULL),
 (1419,904,'TUITION FEE',6000,NULL,'20180502',10,173,'FBLL','13',NULL,'707',NULL,NULL,NULL,'1','R',NULL,NULL,463,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1420,904,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1419,NULL,NULL,NULL),
 (1421,904,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1419,NULL,NULL,NULL),
 (1422,905,'TUITION FEE',6000,NULL,'20180502',10,174,'FBLL','13',NULL,'708',NULL,NULL,NULL,'1','R',NULL,NULL,464,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1423,905,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1422,NULL,NULL,NULL),
 (1424,905,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1422,NULL,NULL,NULL),
 (1425,906,'TUITION FEE',6000,NULL,'20180502',10,175,'FBLL','13',NULL,'709',NULL,NULL,NULL,'1','R',NULL,NULL,465,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1426,906,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1425,NULL,NULL,NULL),
 (1427,906,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1425,NULL,NULL,NULL),
 (1428,907,'TUITION FEE',6000,NULL,'20180502',10,176,'FBLL','13',NULL,'710',NULL,NULL,NULL,'1','R',NULL,NULL,466,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1429,907,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1428,NULL,NULL,NULL),
 (1430,907,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1428,NULL,NULL,NULL),
 (1431,908,'TUITION FEE',6000,NULL,'20180502',10,177,'FBLL','13',NULL,'711',NULL,NULL,NULL,'1','R',NULL,NULL,467,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1432,908,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1431,NULL,NULL,NULL),
 (1433,908,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1431,NULL,NULL,NULL),
 (1434,909,'TUITION FEE',6000,NULL,'20180502',10,178,'FBLL','13',NULL,'720',NULL,NULL,NULL,'1','R',NULL,NULL,468,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1435,909,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1434,NULL,NULL,NULL),
 (1436,909,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1434,NULL,NULL,NULL),
 (1437,910,'TUITION FEE',6000,NULL,'20180502',10,179,'FBLL','13',NULL,'723',NULL,NULL,NULL,'1','R',NULL,NULL,469,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1438,910,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1437,NULL,NULL,NULL),
 (1439,910,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1437,NULL,NULL,NULL),
 (1440,911,'TUITION FEE',6000,NULL,'20180502',10,180,'FBLL','13',NULL,'725',NULL,NULL,NULL,'1','R',NULL,NULL,470,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1441,911,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1440,NULL,NULL,NULL),
 (1442,911,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1440,NULL,NULL,NULL),
 (1443,912,'TUITION FEE',6000,NULL,'20180502',10,181,'FBLL','13',NULL,'727',NULL,NULL,NULL,'1','R',NULL,NULL,471,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1444,912,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1443,NULL,NULL,NULL),
 (1445,912,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1443,NULL,NULL,NULL),
 (1446,913,'TUITION FEE',6000,NULL,'20180502',10,182,'FBLL','13',NULL,'733',NULL,NULL,NULL,'1','R',NULL,NULL,472,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1447,913,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1446,NULL,NULL,NULL),
 (1448,913,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1446,NULL,NULL,NULL),
 (1449,914,'TUITION FEE',6000,NULL,'20180502',10,183,'FBLL','13',NULL,'735',NULL,NULL,NULL,'1','R',NULL,NULL,473,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1450,914,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1449,NULL,NULL,NULL),
 (1451,914,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1449,NULL,NULL,NULL),
 (1452,915,'TUITION FEE',6000,NULL,'20180502',10,184,'FBLL','13',NULL,'763',NULL,NULL,NULL,'1','R',NULL,NULL,474,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1453,915,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1452,NULL,NULL,NULL),
 (1454,915,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1452,NULL,NULL,NULL),
 (1455,916,'TUITION FEE',6000,NULL,'20180502',10,185,'FBLL','13',NULL,'788',NULL,NULL,NULL,'1','R',NULL,NULL,475,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1456,916,'TUITION FEE',6000,NULL,'20180502',0,NULL,'CUST','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1455,NULL,NULL,NULL),
 (1457,916,'TUITION FEE',NULL,6000,'20180502',0,NULL,'INC','13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'Income',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1455,NULL,NULL,NULL);
/*!40000 ALTER TABLE `journalappendold` ENABLE KEYS */;


--
-- Definition of table `journalentry`
--

DROP TABLE IF EXISTS `journalentry`;
CREATE TABLE `journalentry` (
  `TrId` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` datetime DEFAULT NULL,
  `Descr` text,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  `Amount` double DEFAULT NULL,
  `TransNo` varchar(45) DEFAULT NULL,
  `DrAmount` double DEFAULT NULL,
  `CrAmount` double DEFAULT NULL,
  `TK` varchar(10) DEFAULT NULL,
  `TR` varchar(5) DEFAULT NULL,
  `AccId` int(10) unsigned DEFAULT NULL,
  `stats` varchar(45) DEFAULT NULL,
  `Paid` double DEFAULT NULL,
  `telltm` datetime DEFAULT NULL,
  `Transby` varchar(45) DEFAULT NULL,
  `Vehicle` varchar(45) DEFAULT NULL,
  `comments` text,
  `DepId` int(11) DEFAULT NULL,
  `TRAcc` int(11) DEFAULT NULL,
  `stId` int(11) DEFAULT NULL,
  `totpr` double DEFAULT NULL,
  PRIMARY KEY (`TrId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `journalentry`
--

/*!40000 ALTER TABLE `journalentry` DISABLE KEYS */;
/*!40000 ALTER TABLE `journalentry` ENABLE KEYS */;


--
-- Definition of table `journalentryold`
--

DROP TABLE IF EXISTS `journalentryold`;
CREATE TABLE `journalentryold` (
  `TrId` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `TrDate` datetime DEFAULT NULL,
  `Descr` text,
  `Initby` int(10) unsigned DEFAULT NULL,
  `Conby` int(10) unsigned DEFAULT NULL,
  `Rvsby` int(10) unsigned DEFAULT NULL,
  `Amount` double DEFAULT NULL,
  `TransNo` varchar(45) DEFAULT NULL,
  `DrAmount` double DEFAULT NULL,
  `CrAmount` double DEFAULT NULL,
  `TK` varchar(10) DEFAULT NULL,
  `TR` varchar(5) DEFAULT NULL,
  `AccId` int(10) unsigned DEFAULT NULL,
  `stats` varchar(45) DEFAULT NULL,
  `Paid` double DEFAULT NULL,
  `telltm` datetime DEFAULT NULL,
  `Transby` varchar(45) DEFAULT NULL,
  `Vehicle` varchar(45) DEFAULT NULL,
  `comments` text,
  `DepId` int(11) DEFAULT NULL,
  `TRAcc` int(11) DEFAULT NULL,
  `stId` int(11) DEFAULT NULL,
  `totpr` double DEFAULT NULL,
  PRIMARY KEY (`TrId`)
) ENGINE=InnoDB AUTO_INCREMENT=5243 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `journalentryold`
--

/*!40000 ALTER TABLE `journalentryold` DISABLE KEYS */;
INSERT INTO `journalentryold` (`TrId`,`TrDate`,`Descr`,`Initby`,`Conby`,`Rvsby`,`Amount`,`TransNo`,`DrAmount`,`CrAmount`,`TK`,`TR`,`AccId`,`stats`,`Paid`,`telltm`,`Transby`,`Vehicle`,`comments`,`DepId`,`TRAcc`,`stId`,`totpr`) VALUES 
 (639,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (640,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (641,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (642,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (643,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (644,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (645,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (646,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (647,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (648,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (649,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (650,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (651,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (652,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (653,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (654,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (655,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (656,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (657,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (658,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (659,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (660,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (661,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (662,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (663,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (664,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (665,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (666,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (667,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (668,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (669,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (670,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (671,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (672,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (673,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (674,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (675,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (676,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (677,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (678,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (679,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (680,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (681,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (682,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (683,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (684,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (685,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (686,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (687,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (688,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (689,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (690,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (691,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (692,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (693,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (694,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (695,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (696,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (697,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (698,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (699,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (700,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (701,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (702,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (703,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (704,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (705,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (706,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (707,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (708,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (709,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (710,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (711,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (712,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (713,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (714,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (715,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (716,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (717,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (718,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (719,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (720,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (721,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (722,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (723,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (724,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (725,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (726,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (727,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (728,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (729,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (730,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (731,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:37',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (732,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (733,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (734,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (735,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (736,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (737,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (738,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (739,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (740,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (741,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (742,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (743,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (744,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (745,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (746,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (747,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (748,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (749,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (750,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (751,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (752,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (753,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (754,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (755,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (756,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (757,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (758,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (759,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (760,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (761,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (762,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (763,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (764,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (765,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (766,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (767,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (768,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (769,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (770,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (771,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (772,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (773,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (774,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (775,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (776,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (777,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (778,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (779,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (780,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (781,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (782,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (783,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (784,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (785,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (786,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (787,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (788,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (789,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (790,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (791,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (792,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (793,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (794,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (795,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (796,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (797,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (798,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (799,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (800,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (801,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (802,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (803,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (804,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (805,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (806,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (807,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (808,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (809,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (810,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (811,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (812,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (813,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (814,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (815,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (816,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (817,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (818,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (819,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (820,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (821,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (822,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (823,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (824,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (825,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (826,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (827,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (828,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (829,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (830,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (831,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (832,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (833,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (834,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (835,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (836,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (837,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (838,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (839,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (840,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (841,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (842,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (843,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (844,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (845,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (846,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (847,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (848,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (849,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (850,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (851,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (852,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (853,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (854,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (855,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (856,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (857,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (858,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (859,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (860,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (861,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (862,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (863,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (864,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (865,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (866,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (867,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (868,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (869,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (870,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (871,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (872,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (873,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (874,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (875,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (876,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (877,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (878,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (879,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (880,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (881,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (882,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (883,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (884,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (885,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (886,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (887,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (888,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (889,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (890,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (891,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (892,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (893,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (894,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (895,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (896,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (897,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (898,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (899,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (900,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (901,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (902,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (903,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (904,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (905,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (906,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (907,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (908,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (909,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (910,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (911,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (912,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (913,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (914,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (915,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (916,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 1',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:23:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (917,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (918,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (919,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (920,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (921,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (922,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (923,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (924,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (925,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (926,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (927,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (928,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (929,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (930,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (931,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (932,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (933,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (934,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (935,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (936,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (937,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (938,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (939,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (940,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (941,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (942,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (943,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (944,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (945,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (946,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (947,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (948,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (949,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (950,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (951,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (952,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (953,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (954,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (955,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (956,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (957,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (958,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `journalentryold` (`TrId`,`TrDate`,`Descr`,`Initby`,`Conby`,`Rvsby`,`Amount`,`TransNo`,`DrAmount`,`CrAmount`,`TK`,`TR`,`AccId`,`stats`,`Paid`,`telltm`,`Transby`,`Vehicle`,`comments`,`DepId`,`TRAcc`,`stId`,`totpr`) VALUES 
 (959,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (960,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (961,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (962,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (963,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (964,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (965,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (966,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (967,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (968,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (969,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (970,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (971,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (972,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (973,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (974,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (975,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (976,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (977,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (978,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (979,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (980,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (981,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (982,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (983,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (984,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (985,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (986,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (987,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (988,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (989,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (990,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (991,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (992,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (993,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (994,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (995,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (996,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (997,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (998,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (999,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1000,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1001,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1002,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1003,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1004,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1005,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1006,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1007,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1008,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1009,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1010,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1011,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1012,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1013,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1014,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1015,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1016,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1017,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1018,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1019,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1020,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1021,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1022,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1023,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1024,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1025,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1026,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1027,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1028,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1029,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1030,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1031,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1032,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1033,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1034,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1035,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1036,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1037,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1038,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1039,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1040,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1041,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1042,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1043,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1044,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1045,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1046,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1047,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1048,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1049,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1050,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1051,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1052,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1053,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1054,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1055,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1056,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1057,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1058,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1059,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1060,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1061,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1062,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1063,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1064,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1065,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1066,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1067,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1068,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1069,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1070,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1071,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1072,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1073,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1074,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1075,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1076,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1077,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1078,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1079,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1080,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1081,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1082,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1083,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1084,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1085,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1086,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1087,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1088,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1089,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:24:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1090,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1091,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1092,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1093,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1094,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1095,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1096,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1097,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1098,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1099,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1100,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1101,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1102,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1103,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1104,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1105,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1106,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1107,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1108,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1109,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1110,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1111,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1112,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1113,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1114,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1115,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1116,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1117,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1118,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1119,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1120,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1121,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1122,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1123,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1124,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1125,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1126,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1127,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1128,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1129,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1130,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1131,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1132,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1133,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1134,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1135,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1136,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1137,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1138,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1139,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1140,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1141,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1142,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1143,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1144,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1145,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1146,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1147,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1148,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1149,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1150,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1151,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1152,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1153,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1154,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1155,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1156,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1157,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1158,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1159,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1160,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1161,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1162,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1163,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1164,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1165,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1166,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1167,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1168,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1169,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1170,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1171,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1172,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1173,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1174,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1175,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1176,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1177,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1178,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1179,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1180,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1181,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1182,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1183,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1184,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1185,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1186,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1187,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1188,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1189,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1190,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1191,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1192,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1193,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1194,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1195,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1196,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1197,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1198,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1199,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1200,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1201,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1202,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1203,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1204,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1205,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1206,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1207,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1208,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1209,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1210,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1211,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1212,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1213,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1214,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1215,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1216,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1217,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1218,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1219,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1220,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1221,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1222,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1223,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1224,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1225,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1226,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1227,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1228,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1229,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1230,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1231,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1232,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1233,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1234,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1235,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1236,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1237,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1238,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1239,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1240,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1241,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1242,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1243,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1244,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1245,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1246,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1247,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1248,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1249,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1250,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1251,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1252,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1253,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1254,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1255,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1256,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1257,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1258,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1259,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1260,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1261,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1262,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1263,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1264,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1265,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1266,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1267,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1268,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1269,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1270,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1271,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1272,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1273,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1274,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1275,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1276,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1277,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `journalentryold` (`TrId`,`TrDate`,`Descr`,`Initby`,`Conby`,`Rvsby`,`Amount`,`TransNo`,`DrAmount`,`CrAmount`,`TK`,`TR`,`AccId`,`stats`,`Paid`,`telltm`,`Transby`,`Vehicle`,`comments`,`DepId`,`TRAcc`,`stId`,`totpr`) VALUES 
 (1278,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1279,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:09',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1280,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:31:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1281,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1282,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1283,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1284,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1285,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1286,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1287,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1288,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1289,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1290,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1291,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1292,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1293,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1294,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1295,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1296,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1297,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1298,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1299,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1300,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1301,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1302,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1303,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1304,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1305,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1306,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1307,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1308,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1309,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1310,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1311,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1312,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1313,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1314,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1315,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1316,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1317,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1318,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1319,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1320,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1321,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1322,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1323,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1324,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1325,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1326,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1327,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1328,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1329,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1330,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1331,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1332,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1333,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1334,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1335,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1336,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1337,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1338,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1339,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1340,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1341,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1342,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1343,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1344,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1345,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1346,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1347,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1348,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1349,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1350,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1351,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1352,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1353,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1354,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1355,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1356,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1357,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1358,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1359,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1360,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1361,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1362,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1363,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1364,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1365,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1366,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1367,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1368,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1369,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1370,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 4',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-07-30 15:33:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1371,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 3',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-08-01 22:29:51',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1372,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-08-01 23:20:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1373,'2018-05-02 00:00:00','Fee Billing for Term   TERM II class   FORM 2',1,NULL,NULL,NULL,'20180502',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-08-01 23:20:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1374,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1375,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1376,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1377,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1378,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1379,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1380,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1381,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1382,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1383,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1384,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1385,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1386,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1387,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1388,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1389,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1390,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1391,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1392,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1393,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1394,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1395,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1396,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1397,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1398,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1399,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1400,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1401,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1402,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1403,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1404,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1405,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1406,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1407,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1408,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1409,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1410,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1411,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1412,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1413,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1414,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1415,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1416,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1417,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1418,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1419,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1420,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1421,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1422,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1423,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1424,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1425,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1426,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1427,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1428,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1429,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1430,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1431,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1432,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1433,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1434,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1435,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1436,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1437,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1438,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1439,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1440,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1441,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1442,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1443,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1444,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1445,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1446,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1447,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1448,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1449,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1450,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1451,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1452,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1453,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1454,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1455,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1456,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1457,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1458,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1459,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1460,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1461,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1462,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:53',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1463,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:54',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1464,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:54',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1465,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:54',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1466,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:27:54',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1467,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1468,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1469,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1470,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1471,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1472,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1473,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1474,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1475,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1476,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1477,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1478,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1479,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1480,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1481,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1482,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1483,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1484,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1485,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1486,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1487,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1488,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1489,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1490,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1491,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1492,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1493,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1494,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1495,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1496,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1497,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1498,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1499,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1500,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1501,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1502,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1503,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1504,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1505,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1506,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1507,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1508,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1509,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1510,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1511,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1512,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1513,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1514,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1515,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1516,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1517,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1518,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1519,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1520,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1521,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1522,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1523,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1524,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1525,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1526,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1527,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1528,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1529,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1530,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1531,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1532,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1533,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1534,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1535,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1536,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1537,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1538,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1539,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1540,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1541,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1542,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1543,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1544,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1545,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1546,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1547,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1548,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1549,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1550,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1551,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1552,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1553,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1554,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1555,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1556,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1557,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1558,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1559,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1560,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1561,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1562,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1563,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1564,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1565,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1566,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1567,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1568,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1569,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1570,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1571,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1572,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1573,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1574,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1575,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1576,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1577,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1578,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1579,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1580,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1581,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1582,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1583,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1584,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1585,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1586,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1587,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1588,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1589,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1590,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1591,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1592,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1593,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1594,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `journalentryold` (`TrId`,`TrDate`,`Descr`,`Initby`,`Conby`,`Rvsby`,`Amount`,`TransNo`,`DrAmount`,`CrAmount`,`TK`,`TR`,`AccId`,`stats`,`Paid`,`telltm`,`Transby`,`Vehicle`,`comments`,`DepId`,`TRAcc`,`stId`,`totpr`) VALUES 
 (1595,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1596,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1597,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1598,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1599,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1600,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1601,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1602,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1603,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1604,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1605,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1606,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1607,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1608,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1609,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1610,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1611,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1612,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1613,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1614,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1615,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1616,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1617,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1618,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1619,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1620,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1621,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1622,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1623,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1624,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1625,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1626,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1627,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1628,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1629,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1630,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1631,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1632,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1633,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1634,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1635,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1636,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1637,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1638,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1639,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1640,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1641,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1642,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1643,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1644,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1645,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1646,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1647,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1648,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1649,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1650,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1651,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1652,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1653,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1654,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1655,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1656,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1657,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1658,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1659,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1660,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1661,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1662,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1663,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1664,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1665,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1666,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1667,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1668,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1669,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1670,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1671,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1672,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1673,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1674,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1675,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1676,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1677,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1678,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1679,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1680,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1681,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1682,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1683,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1684,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1685,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1686,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1687,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1688,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1689,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1690,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1691,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1692,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1693,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1694,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1695,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1696,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1697,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1698,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1699,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1700,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1701,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1702,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1703,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1704,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1705,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1706,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1707,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1708,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1709,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1710,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1711,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1712,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1713,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1714,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1715,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1716,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1717,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1718,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1719,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1720,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1721,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1722,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1723,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1724,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1725,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1726,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1727,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1728,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1729,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1730,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1731,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1732,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1733,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1734,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1735,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1736,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1737,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1738,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1739,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1740,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1741,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1742,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1743,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1744,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1745,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1746,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1747,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1748,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1749,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1750,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1751,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1752,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1753,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1754,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1755,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1756,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1757,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1758,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1759,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1760,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1761,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1762,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1763,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1764,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1765,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1766,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1767,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1768,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1769,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1770,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1771,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1772,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1773,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1774,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1775,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1776,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1777,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1778,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1779,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1780,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1781,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1782,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1783,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1784,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1785,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1786,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1787,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1788,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1789,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1790,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1791,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1792,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1793,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1794,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1795,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1796,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1797,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1798,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1799,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1800,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1801,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1802,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1803,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1804,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1805,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1806,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1807,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1808,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1809,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1810,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1811,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1812,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1813,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1814,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1815,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1816,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1817,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1818,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1819,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1820,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1821,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1822,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1823,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1824,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1825,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1826,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1827,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1828,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1829,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1830,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1831,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:29:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1832,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:29',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1833,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1834,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1835,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1836,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1837,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1838,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1839,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1840,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1841,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1842,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1843,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1844,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1845,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1846,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1847,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1848,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1849,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1850,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1851,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1852,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1853,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1854,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1855,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1856,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1857,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1858,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1859,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1860,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1861,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1862,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1863,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1864,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1865,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1866,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1867,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1868,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1869,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1870,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1871,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1872,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1873,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1874,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1875,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1876,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1877,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1878,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1879,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1880,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1881,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1882,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1883,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1884,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1885,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1886,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1887,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1888,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1889,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1890,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1891,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1892,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1893,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1894,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1895,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1896,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1897,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1898,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1899,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1900,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1901,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1902,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1903,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1904,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1905,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1906,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1907,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1908,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1909,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1910,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `journalentryold` (`TrId`,`TrDate`,`Descr`,`Initby`,`Conby`,`Rvsby`,`Amount`,`TransNo`,`DrAmount`,`CrAmount`,`TK`,`TR`,`AccId`,`stats`,`Paid`,`telltm`,`Transby`,`Vehicle`,`comments`,`DepId`,`TRAcc`,`stId`,`totpr`) VALUES 
 (1911,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1912,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1913,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1914,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1915,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1916,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1917,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1918,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1919,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1920,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1921,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1922,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1923,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1924,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1925,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1926,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1927,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1928,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1929,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1930,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1931,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1932,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1933,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1934,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1935,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1936,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1937,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1938,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1939,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1940,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1941,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1942,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1943,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1944,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1945,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1946,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1947,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1948,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1949,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1950,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1951,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1952,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1953,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1954,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1955,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1956,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1957,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1958,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1959,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1960,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1961,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1962,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1963,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1964,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1965,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1966,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1967,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1968,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1969,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1970,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1971,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1972,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1973,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1974,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1975,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1976,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1977,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1978,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1979,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1980,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1981,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1982,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1983,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1984,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1985,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1986,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1987,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1988,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1989,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1990,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1991,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1992,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1993,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1994,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1995,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1996,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1997,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1998,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (1999,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2000,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2001,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2002,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2003,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2004,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2005,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2006,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2007,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2008,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2009,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2010,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2011,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2012,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2013,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2014,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2015,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2016,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2017,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2018,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2019,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2020,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2021,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2022,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2023,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:30',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2024,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2025,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2026,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2027,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2028,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2029,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2030,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2031,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2032,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2033,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2034,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2035,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2036,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2037,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2038,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2039,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2040,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2041,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2042,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2043,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2044,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2045,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2046,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2047,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2048,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2049,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2050,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2051,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2052,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2053,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2054,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2055,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2056,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2057,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2058,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2059,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2060,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2061,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2062,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2063,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2064,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2065,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2066,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2067,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2068,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2069,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2070,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2071,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2072,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2073,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2074,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2075,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2076,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2077,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2078,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2079,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2080,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2081,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2082,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2083,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2084,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2085,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2086,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2087,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2088,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2089,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2090,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2091,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2092,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2093,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2094,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2095,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2096,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2097,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2098,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2099,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2100,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2101,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2102,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2103,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2104,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2105,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2106,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2107,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2108,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2109,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2110,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2111,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2112,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2113,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 4',17,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-09-20 23:30:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2114,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 1',1,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-10-02 22:36:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2115,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',1,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-10-02 22:37:06',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2116,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',1,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-10-02 22:37:35',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2117,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',1,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-10-02 22:37:47',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2118,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',1,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-10-23 19:47:27',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2119,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',1,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-10-23 19:57:05',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2120,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',1,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-10-23 21:18:45',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2121,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 3',1,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-10-23 21:20:20',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2122,'2018-08-28 00:00:00','Fee Billing for Term   TERM III class   FORM 2',1,NULL,NULL,NULL,'20180828',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2018-10-23 23:38:25',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2123,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2124,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2125,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2126,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2127,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2128,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2129,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2130,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2131,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2132,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2133,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2134,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2135,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2136,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2137,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2138,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2139,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2140,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2141,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2142,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2143,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2144,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2145,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2146,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2147,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2148,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2149,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2150,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2151,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2152,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2153,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2154,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2155,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2156,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2157,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2158,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2159,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2160,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2161,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2162,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2163,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2164,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2165,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2166,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2167,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2168,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2169,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2170,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2171,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2172,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2173,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2174,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2175,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2176,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2177,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2178,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2179,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2180,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:10',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2181,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2182,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2183,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2184,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2185,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2186,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2187,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2188,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2189,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2190,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2191,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2192,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2193,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2194,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2195,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2196,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2197,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2198,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2199,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2200,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2201,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2202,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2203,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2204,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2205,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2206,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2207,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2208,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2209,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2210,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2211,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2212,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2213,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2214,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2215,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2216,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2217,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2218,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2219,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2220,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2221,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2222,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2223,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2224,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2225,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2226,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2227,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `journalentryold` (`TrId`,`TrDate`,`Descr`,`Initby`,`Conby`,`Rvsby`,`Amount`,`TransNo`,`DrAmount`,`CrAmount`,`TK`,`TR`,`AccId`,`stats`,`Paid`,`telltm`,`Transby`,`Vehicle`,`comments`,`DepId`,`TRAcc`,`stId`,`totpr`) VALUES 
 (2228,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2229,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2230,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2231,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2232,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2233,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2234,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2235,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2236,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2237,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2238,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2239,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2240,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2241,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2242,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2243,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2244,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2245,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2246,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2247,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2248,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2249,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2250,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2251,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2252,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2253,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2254,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2255,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2256,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2257,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2258,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2259,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2260,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2261,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2262,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2263,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2264,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2265,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2266,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2267,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2268,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2269,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2270,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2271,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2272,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2273,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2274,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2275,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2276,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2277,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2278,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2279,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2280,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2281,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2282,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2283,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2284,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2285,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2286,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2287,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2288,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2289,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2290,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2291,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2292,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2293,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2294,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2295,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2296,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2297,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2298,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2299,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2300,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2301,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2302,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2303,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2304,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2305,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2306,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2307,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2308,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2309,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2310,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2311,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2312,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2313,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2314,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2315,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2316,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2317,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2318,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2319,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2320,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2321,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2322,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2323,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2324,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2325,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2326,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2327,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2328,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2329,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2330,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2331,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2332,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2333,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2334,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2335,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2336,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2337,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2338,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2339,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2340,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2341,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2342,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2343,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2344,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2345,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2346,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2347,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2348,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2349,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2350,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2351,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2352,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2353,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2354,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2355,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2356,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2357,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2358,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2359,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2360,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2361,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2362,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2363,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2364,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2365,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2366,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2367,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2368,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2369,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2370,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2371,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2372,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2373,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2374,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2375,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2376,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2377,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2378,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2379,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2380,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2381,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2382,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2383,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2384,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2385,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2386,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2387,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2388,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2389,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2390,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2391,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2392,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2393,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2394,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2395,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2396,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2397,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2398,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2399,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2400,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2401,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2402,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 2',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-19 10:10:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2403,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2404,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2405,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2406,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2407,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2408,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2409,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2410,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2411,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2412,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2413,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2414,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2415,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2416,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2417,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2418,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2419,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2420,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2421,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2422,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2423,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2424,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2425,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2426,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2427,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2428,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2429,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2430,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2431,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2432,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2433,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2434,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2435,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2436,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2437,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2438,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2439,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2440,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2441,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2442,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2443,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2444,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2445,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2446,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2447,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2448,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2449,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2450,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2451,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2452,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2453,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2454,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2455,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2456,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2457,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2458,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2459,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2460,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2461,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2462,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2463,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2464,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2465,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2466,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2467,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2468,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2469,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2470,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2471,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2472,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2473,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2474,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2475,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2476,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2477,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2478,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2479,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2480,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2481,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2482,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2483,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2484,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2485,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2486,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2487,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2488,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2489,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2490,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2491,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2492,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2493,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2494,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2495,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2496,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2497,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2498,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2499,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2500,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2501,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2502,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2503,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2504,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2505,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2506,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2507,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2508,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2509,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2510,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2511,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2512,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2513,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2514,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2515,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2516,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2517,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2518,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2519,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2520,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2521,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2522,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2523,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2524,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2525,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20190319',NULL,NULL,'FBLL',NULL,NULL,NULL,NULL,'2019-03-28 11:15:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL),
 (2526,'2019-03-19 00:00:00','Fee Billing for Term   TERM I class   FORM 3',17,NULL,NULL,NULL,'20